/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ArrayAccess
extends Variable {
    public static final int VARIABLE_ARRAY = 1;
    public static final int VARIABLE_HASHTABLE = 2;
    private final Expression index;
    private final int arrayType;

    public ArrayAccess(int start, int end, VariableBase variableName, Expression index, int arrayType) {
        super(start, end, variableName);
        this.index = index;
        this.arrayType = arrayType;
        variableName.setParent(this);
        if (index != null) {
            index.setParent(this);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.getVariableName().accept(visitor);
        if (this.index != null) {
            this.index.accept(visitor);
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getVariableName().traverseTopDown(visitor);
        if (this.index != null) {
            this.index.traverseTopDown(visitor);
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        this.getVariableName().traverseBottomUp(visitor);
        if (this.index != null) {
            this.index.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ArrayAccess");
        this.appendInterval(buffer);
        buffer.append(" type='").append(ArrayAccess.getArrayType(this.arrayType)).append("'>\n");
        this.getVariableName().toString(buffer, "\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("<Index>\n");
        if (this.index != null) {
            this.index.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Index>\n");
        buffer.append(tab).append("</ArrayAccess>");
    }

    public static String getArrayType(int type) {
        switch (type) {
            case 1: {
                return "array";
            }
            case 2: {
                return "hashtable";
            }
        }
        throw new IllegalArgumentException();
    }

    public int getType() {
        return 0;
    }

    public Expression getIndex() {
        return this.index;
    }

    public int getArrayType() {
        return this.arrayType;
    }
}

