/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class Block
extends Statement {
    private final Statement[] statements;
    private final boolean isCurly;

    private Block(int start, int end, Statement[] statements, boolean isCurly) {
        super(start, end);
        assert (statements != null);
        this.statements = statements;
        this.isCurly = isCurly;
        int i = 0;
        while (i < statements.length) {
            statements[i].setParent(this);
            ++i;
        }
    }

    public Block(int start, int end, List statements, boolean isCurly) {
        this(start, end, statements == null ? null : statements.toArray(new Statement[statements.size()]), isCurly);
    }

    public Block(int start, int end, List statements) {
        this(start, end, statements, true);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int i = 0;
        while (i < this.statements.length) {
            this.statements[i].accept(visitor);
            ++i;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int i = 0;
        while (i < this.statements.length) {
            this.statements[i].traverseTopDown(visitor);
            ++i;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        int i = 0;
        while (i < this.statements.length) {
            this.statements[i].traverseBottomUp(visitor);
            ++i;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<Block");
        this.appendInterval(buffer);
        buffer.append(" isCurly='").append(this.isCurly).append("'>\n");
        int i = 0;
        while (i < this.statements.length) {
            this.statements[i].toString(buffer, "\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append(tab).append("</Block>");
    }

    public int getType() {
        return 6;
    }

    public boolean isCurly() {
        return this.isCurly;
    }

    public Statement[] getStatements() {
        return this.statements;
    }
}

