/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ClassConstantDeclaration
extends Statement {
    private final Identifier[] variableNames;
    private final Expression[] constantValues;

    public ClassConstantDeclaration(int start, int end, List variablesAndDefaults) {
        super(start, end);
        assert (variablesAndDefaults != null && variablesAndDefaults.size() > 0);
        this.variableNames = new Identifier[variablesAndDefaults.size()];
        this.constantValues = new Expression[variablesAndDefaults.size()];
        int i = 0;
        for (ASTNode[] element : variablesAndDefaults) {
            this.variableNames[i] = (Identifier)element[0];
            this.constantValues[i] = (Expression)element[1];
            element[0].setParent(this);
            element[1].setParent(this);
            ++i;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int i = 0;
        while (i < this.variableNames.length) {
            this.variableNames[i].accept(visitor);
            this.constantValues[i].accept(visitor);
            ++i;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int i = 0;
        while (i < this.variableNames.length) {
            this.variableNames[i].traverseTopDown(visitor);
            this.constantValues[i].traverseTopDown(visitor);
            ++i;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        int i = 0;
        while (i < this.variableNames.length) {
            this.variableNames[i].traverseBottomUp(visitor);
            this.constantValues[i].traverseBottomUp(visitor);
            ++i;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ClassConstantDeclaration");
        this.appendInterval(buffer);
        buffer.append(">\n");
        int i = 0;
        while (i < this.variableNames.length) {
            buffer.append(tab).append("\t").append("<VariableName>\n");
            this.variableNames[i].toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            buffer.append(tab).append("\t").append("</VariableName>\n");
            buffer.append(tab).append("\t").append("<InitialValue>\n");
            Expression expr = this.constantValues[i];
            if (expr != null) {
                expr.toString(buffer, "\t\t" + tab);
                buffer.append("\n");
            }
            buffer.append(tab).append("\t").append("</InitialValue>\n");
            ++i;
        }
        buffer.append(tab).append("</ClassConstantDeclaration>");
    }

    public int getType() {
        return 11;
    }

    public Expression[] getConstantValues() {
        return this.constantValues;
    }

    public Identifier[] getVariableNames() {
        return this.variableNames;
    }
}

