/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ConditionalExpression
extends Expression {
    private final Expression condition;
    private final Expression ifTrue;
    private final Expression ifFalse;

    public ConditionalExpression(int start, int end, Expression condition, Expression ifTrue, Expression ifFalse) {
        super(start, end);
        assert (condition != null && ifTrue != null && ifFalse != null);
        this.condition = condition;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
        condition.setParent(this);
        ifTrue.setParent(this);
        ifFalse.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.condition.accept(visitor);
        this.ifTrue.accept(visitor);
        this.ifFalse.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.condition.traverseTopDown(visitor);
        this.ifTrue.traverseTopDown(visitor);
        this.ifFalse.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.condition.traverseBottomUp(visitor);
        this.ifTrue.traverseBottomUp(visitor);
        this.ifFalse.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ConditionalExpression");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Condition>\n");
        this.condition.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Condition>\n");
        buffer.append("\t").append(tab).append("<IfTrue>\n");
        this.ifTrue.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</IfTrue>\n");
        buffer.append("\t").append(tab).append("<IfFalse>\n");
        this.ifFalse.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</IfFalse>\n");
        buffer.append(tab).append("</ConditionalExpression>");
    }

    public int getType() {
        return 17;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getIfFalse() {
        return this.ifFalse;
    }

    public Expression getIfTrue() {
        return this.ifTrue;
    }
}

