/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class DoStatement
extends Statement {
    private final Expression condition;
    private final Statement action;

    public DoStatement(int start, int end, Expression condition, Statement action) {
        super(start, end);
        assert (condition != null && action != null);
        this.condition = condition;
        this.action = action;
        condition.setParent(this);
        action.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.condition.accept(visitor);
        this.action.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.condition.traverseTopDown(visitor);
        this.action.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.condition.traverseBottomUp(visitor);
        this.action.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<DoStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.action.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("<Condition>\n");
        this.condition.toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("</Condition>\n");
        buffer.append(tab).append("</DoStatement>");
    }

    public int getType() {
        return 20;
    }

    public Statement getAction() {
        return this.action;
    }

    public Expression getCondition() {
        return this.condition;
    }
}

