/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Dispatch;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class FieldAccess
extends Dispatch {
    private final Variable field;

    public FieldAccess(int start, int end, VariableBase dispatcher, Variable field) {
        super(start, end, dispatcher);
        assert (field != null);
        this.field = field;
        field.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.getDispatcher().accept(visitor);
        this.field.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getDispatcher().accept(visitor);
        this.field.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.getDispatcher().traverseBottomUp(visitor);
        this.field.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<FieldAccess");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Dispatcher>\n");
        this.getDispatcher().toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Dispatcher>\n");
        buffer.append("\t").append(tab).append("<Property>\n");
        this.field.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Property>\n");
        buffer.append(tab).append("</FieldAccess>");
    }

    public int getType() {
        return 24;
    }

    public Variable getField() {
        return this.field;
    }

    public VariableBase getMember() {
        return this.getField();
    }
}

