/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ForStatement
extends Statement {
    private final Expression[] initializations;
    private final Expression[] conditions;
    private final Expression[] increasements;
    private final Statement action;

    private ForStatement(int start, int end, Expression[] initializations, Expression[] conditions, Expression[] increasements, Statement action) {
        super(start, end);
        assert (initializations != null && conditions != null && increasements != null && action != null);
        this.initializations = initializations;
        this.conditions = conditions;
        this.increasements = increasements;
        this.action = action;
        int i = 0;
        while (i < initializations.length) {
            initializations[i].setParent(this);
            ++i;
        }
        i = 0;
        while (i < conditions.length) {
            conditions[i].setParent(this);
            ++i;
        }
        i = 0;
        while (i < increasements.length) {
            increasements[i].setParent(this);
            ++i;
        }
        action.setParent(this);
    }

    public ForStatement(int start, int end, List initializations, List conditions, List increasements, Statement action) {
        this(start, end, initializations == null ? null : initializations.toArray(new Expression[initializations.size()]), conditions == null ? null : conditions.toArray(new Expression[conditions.size()]), increasements == null ? null : increasements.toArray(new Expression[increasements.size()]), action);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int i = 0;
        while (i < this.initializations.length) {
            this.initializations[i].accept(visitor);
            ++i;
        }
        i = 0;
        while (i < this.conditions.length) {
            this.conditions[i].accept(visitor);
            ++i;
        }
        i = 0;
        while (i < this.increasements.length) {
            this.increasements[i].accept(visitor);
            ++i;
        }
        this.action.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int i = 0;
        while (i < this.initializations.length) {
            this.initializations[i].traverseTopDown(visitor);
            ++i;
        }
        i = 0;
        while (i < this.conditions.length) {
            this.conditions[i].traverseTopDown(visitor);
            ++i;
        }
        i = 0;
        while (i < this.increasements.length) {
            this.increasements[i].traverseTopDown(visitor);
            ++i;
        }
        this.action.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        int i = 0;
        while (i < this.initializations.length) {
            this.initializations[i].traverseBottomUp(visitor);
            ++i;
        }
        i = 0;
        while (i < this.conditions.length) {
            this.conditions[i].traverseBottomUp(visitor);
            ++i;
        }
        i = 0;
        while (i < this.increasements.length) {
            this.increasements[i].traverseBottomUp(visitor);
            ++i;
        }
        this.action.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ForStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Initializations>\n");
        int i = 0;
        while (i < this.initializations.length) {
            this.initializations[i].toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append("\t").append(tab).append("</Initializations>\n");
        buffer.append("\t").append(tab).append("<Conditions>\n");
        i = 0;
        while (i < this.conditions.length) {
            this.conditions[i].toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append("\t").append(tab).append("</Conditions>\n");
        buffer.append("\t").append(tab).append("<Increasements>\n");
        i = 0;
        while (i < this.increasements.length) {
            this.increasements[i].toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append("\t").append(tab).append("</Increasements>\n");
        this.action.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</ForStatement>");
    }

    public int getType() {
        return 28;
    }

    public Statement getAction() {
        return this.action;
    }

    public Expression[] getConditions() {
        return this.conditions;
    }

    public Expression[] getIncreasements() {
        return this.increasements;
    }

    public Expression[] getInitializations() {
        return this.initializations;
    }
}

