/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Reference;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class FormalParameter
extends ASTNode {
    private final Identifier parameterType;
    private final Expression parameterName;
    private final Expression defaultValue;
    private final boolean isMandatory;

    private FormalParameter(int start, int end, Identifier type, Expression parameterName, Expression defaultValue, boolean isMandatory) {
        super(start, end);
        assert (parameterName != null);
        this.parameterType = type;
        this.parameterName = parameterName;
        this.defaultValue = defaultValue;
        this.isMandatory = isMandatory;
        if (type != null) {
            type.setParent(this);
        }
        parameterName.setParent(this);
        if (defaultValue != null) {
            defaultValue.setParent(this);
        }
    }

    public FormalParameter(int start, int end, Identifier type, Variable parameterName, Expression defaultValue) {
        this(start, end, type, parameterName, defaultValue, false);
    }

    public FormalParameter(int start, int end, Identifier type, Reference parameterName, Expression defaultValue) {
        this(start, end, type, parameterName, defaultValue, false);
    }

    public FormalParameter(int start, int end, Identifier type, Variable parameterName) {
        this(start, end, type, parameterName, null, false);
    }

    public FormalParameter(int start, int end, Identifier type, Variable parameterName, boolean isMandatory) {
        this(start, end, type, parameterName, null, isMandatory);
    }

    public FormalParameter(int start, int end, Identifier type, Reference parameterName) {
        this(start, end, type, parameterName, null, false);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        if (this.parameterType != null) {
            this.parameterType.accept(visitor);
        }
        this.parameterName.accept(visitor);
        if (this.defaultValue != null) {
            this.defaultValue.accept(visitor);
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        if (this.parameterType != null) {
            this.parameterType.traverseTopDown(visitor);
        }
        this.parameterName.traverseTopDown(visitor);
        if (this.defaultValue != null) {
            this.defaultValue.traverseTopDown(visitor);
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        if (this.parameterType != null) {
            this.parameterType.traverseBottomUp(visitor);
        }
        this.parameterName.traverseBottomUp(visitor);
        if (this.defaultValue != null) {
            this.defaultValue.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<FormalParameter");
        this.appendInterval(buffer);
        buffer.append(" isMandatory='").append(this.isMandatory).append("'>\n");
        buffer.append("\t").append(tab).append("<Type>\n");
        if (this.parameterType != null) {
            this.parameterType.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Type>\n");
        buffer.append("\t").append(tab).append("<ParameterName>\n");
        this.parameterName.toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("</ParameterName>\n");
        buffer.append("\t").append(tab).append("<DefaultValue>\n");
        if (this.defaultValue != null) {
            this.defaultValue.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</DefaultValue>\n");
        buffer.append(tab).append("</FormalParameter>");
    }

    public int getType() {
        return 27;
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public Expression getParameterName() {
        return this.parameterName;
    }

    public Identifier getParameterType() {
        return this.parameterType;
    }

    public Identifier getParameterNameIdentifier() {
        Expression expression = this.parameterName;
        switch (this.parameterName.getType()) {
            case 48: {
                expression = ((Reference)expression).getExpression();
                if (expression.getType() != 60) {
                    throw new IllegalStateException();
                }
            }
            case 60: {
                Identifier variableName = (Identifier)((Variable)expression).getVariableName();
                return variableName;
            }
        }
        throw new IllegalStateException();
    }
}

