/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Dispatch;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class MethodInvocation
extends Dispatch {
    private final FunctionInvocation method;

    public MethodInvocation(int start, int end, VariableBase dispatcher, FunctionInvocation method) {
        super(start, end, dispatcher);
        assert (method != null);
        this.method = method;
        method.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.getDispatcher().accept(visitor);
        this.method.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getDispatcher().accept(visitor);
        this.method.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.getDispatcher().traverseBottomUp(visitor);
        this.method.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<MethodInvocation");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Dispatcher>\n");
        this.getDispatcher().toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Dispatcher>\n");
        buffer.append("\t").append(tab).append("<Property>\n");
        this.method.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Property>\n");
        buffer.append(tab).append("</MethodInvocation>");
    }

    public int getType() {
        return 43;
    }

    public FunctionInvocation getMethod() {
        return this.method;
    }

    public VariableBase getMember() {
        return this.getMethod();
    }
}

