/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class Quote
extends Expression {
    public static final int QT_QUOTE = 0;
    public static final int QT_SINGLE = 1;
    public static final int QT_HEREDOC = 2;
    private final Expression[] expressions;
    private final int quoteType;

    public Quote(int start, int end, Expression[] expressions, int type) {
        super(start, end);
        this.expressions = expressions;
        this.quoteType = type;
        int i = 0;
        while (i < expressions.length) {
            expressions[i].setParent(this);
            ++i;
        }
    }

    public Quote(int start, int end, List expressions, int type) {
        this(start, end, expressions == null ? null : expressions.toArray(new Expression[expressions.size()]), type);
    }

    public static String getType(int type) {
        switch (type) {
            case 0: {
                return "quote";
            }
            case 1: {
                return "single";
            }
            case 2: {
                return "heredoc";
            }
        }
        throw new IllegalArgumentException();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i].accept(visitor);
            ++i;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i].traverseTopDown(visitor);
            ++i;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i].traverseBottomUp(visitor);
            ++i;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<Quote");
        this.appendInterval(buffer);
        buffer.append(" type='").append(Quote.getType(this.quoteType)).append("'>\n");
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i].toString(buffer, "\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append(tab).append("</Quote>");
    }

    public int getType() {
        return 47;
    }

    public Expression[] getExpressions() {
        return this.expressions;
    }

    public int getQuoteType() {
        return this.quoteType;
    }
}

