/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class Reference
extends Expression {
    private final Expression expression;

    private Reference(int start, int end, Expression expression) {
        super(start, end);
        assert (expression != null);
        this.expression = expression;
        expression.setParent(this);
    }

    public Reference(int start, int end, VariableBase variable) {
        this(start, end, (Expression)variable);
    }

    public Reference(int start, int end, ClassInstanceCreation classInstanciation) {
        this(start, end, (Expression)classInstanciation);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.expression.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.expression.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.expression.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<Reference");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.expression.toString(buffer, "\t" + tab);
        buffer.append("\n").append(tab).append("</Reference>");
    }

    public int getType() {
        return 48;
    }

    public Expression getExpression() {
        return this.expression;
    }
}

