/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.StaticDispatch;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class StaticFieldAccess
extends StaticDispatch {
    private final Variable field;

    public StaticFieldAccess(int start, int end, Identifier className, Variable field) {
        super(start, end, className);
        assert (field != null);
        this.field = field;
        field.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.getClassName().accept(visitor);
        this.field.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getClassName().traverseTopDown(visitor);
        this.field.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.getClassName().traverseBottomUp(visitor);
        this.field.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<StaticFieldAccess");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<ClassName>\n");
        this.getClassName().toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</ClassName>\n");
        this.field.toString(buffer, "\t" + tab);
        buffer.append("\n").append(tab).append("</StaticFieldAccess>");
    }

    public int getType() {
        return 52;
    }

    public Variable getField() {
        return this.field;
    }

    public ASTNode getMember() {
        return this.getField();
    }
}

