/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class TryStatement
extends Statement {
    private final Block tryStatement;
    private final CatchClause[] catchClauses;

    private TryStatement(int start, int end, Block tryStatement, CatchClause[] catchClauses) {
        super(start, end);
        assert (tryStatement != null && catchClauses != null);
        this.tryStatement = tryStatement;
        this.catchClauses = catchClauses;
        tryStatement.setParent(this);
        int i = 0;
        while (i < catchClauses.length) {
            catchClauses[i].setParent(this);
            ++i;
        }
    }

    public TryStatement(int start, int end, Block tryStatement, List catchClauses) {
        this(start, end, tryStatement, catchClauses == null ? null : catchClauses.toArray(new CatchClause[catchClauses.size()]));
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.tryStatement.accept(visitor);
        int i = 0;
        while (i < this.catchClauses.length) {
            this.catchClauses[i].accept(visitor);
            ++i;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.tryStatement.traverseTopDown(visitor);
        int i = 0;
        while (i < this.catchClauses.length) {
            this.catchClauses[i].traverseTopDown(visitor);
            ++i;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        this.tryStatement.traverseBottomUp(visitor);
        int i = 0;
        while (i < this.catchClauses.length) {
            this.catchClauses[i].traverseBottomUp(visitor);
            ++i;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<TryStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.tryStatement.toString(buffer, "\t" + tab);
        buffer.append("\n");
        int i = 0;
        while (i < this.catchClauses.length) {
            this.catchClauses[i].toString(buffer, "\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append(tab).append("</TryStatement>");
    }

    public int getType() {
        return 58;
    }

    public CatchClause[] getCatchClauses() {
        return this.catchClauses;
    }

    public Block getTryStatement() {
        return this.tryStatement;
    }
}

