/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class UnaryOperation
extends Expression {
    public static final int OP_PLUS = 0;
    public static final int OP_MINUS = 1;
    public static final int OP_NOT = 2;
    public static final int OP_TILDA = 3;
    private final Expression expr;
    private final int operator;

    public UnaryOperation(int start, int end, Expression expr, int operator) {
        super(start, end);
        assert (expr != null);
        this.expr = expr;
        this.operator = operator;
        expr.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.expr.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.expr.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.expr.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<UnaryOperation");
        this.appendInterval(buffer);
        buffer.append(" operator='").append(UnaryOperation.getOperator(this.operator)).append("'>\n");
        this.expr.toString(buffer, "\t" + tab);
        buffer.append("\n").append(tab).append("</UnaryOperation>");
    }

    public static String getOperator(int operator) {
        switch (operator) {
            case 0: {
                return "+";
            }
            case 1: {
                return "-";
            }
            case 2: {
                return "!";
            }
            case 3: {
                return "~";
            }
        }
        throw new IllegalArgumentException();
    }

    public int getType() {
        return 59;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public int getOperator() {
        return this.operator;
    }
}

