/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class Variable
extends VariableBase {
    private final Expression variableName;
    private final boolean isDollared;

    protected Variable(int start, int end, Expression variableName, boolean isDollared) {
        super(start, end);
        assert (variableName != null);
        this.variableName = variableName;
        this.isDollared = isDollared;
        variableName.setParent(this);
    }

    protected Variable(int start, int end, Expression variableName) {
        this(start, end, variableName, false);
    }

    public Variable(int start, int end, String variableName) {
        this(start, end, Variable.createIdentifier(start, end, variableName), Variable.checkIsDollared(variableName));
    }

    private static boolean checkIsDollared(String variableName) {
        return variableName.indexOf(36) == 0;
    }

    private static Identifier createIdentifier(int start, int end, String idName) {
        if (Variable.checkIsDollared(idName)) {
            idName = idName.substring(1);
            ++start;
        }
        return new Identifier(start, end, idName);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.variableName.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.variableName.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.variableName.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<Variable");
        this.appendInterval(buffer);
        buffer.append(" isDollared='").append(this.isDollared).append("'>\n");
        this.variableName.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</Variable>");
    }

    public int getType() {
        return 60;
    }

    public boolean isDollared() {
        return this.isDollared;
    }

    public Expression getVariableName() {
        return this.variableName;
    }
}

