/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.parser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import java_cup.runtime.lr_parser;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.parser.DocumentReader;
import org.eclipse.php.internal.core.ast.parser.PhpAstLexer4;
import org.eclipse.php.internal.core.ast.parser.PhpAstLexer5;
import org.eclipse.php.internal.core.ast.parser.PhpAstParser4;
import org.eclipse.php.internal.core.ast.parser.PhpAstParser5;

public class ASTParser {
    public static final String VERSION_PHP4 = "php4";
    public static final String VERSION_PHP5 = "php5";
    private static final PhpAstParser5 PHP_AST_PARSER5 = new PhpAstParser5();
    private static final PhpAstLexer5 PHP_AST_LEXER5 = new PhpAstLexer5(EMPTY_STRING_READER);
    private static final PhpAstParser4 PHP_AST_PARSER4 = new PhpAstParser4();
    private static final PhpAstLexer4 PHP_AST_LEXER4 = new PhpAstLexer4(EMPTY_STRING_READER);
    private static final StringReader EMPTY_STRING_READER = new StringReader("");

    public static final Program parse(String phpCode, boolean aspTagsAsPhp) throws Exception {
        StringReader reader = new StringReader(phpCode);
        return ASTParser.parse(reader, aspTagsAsPhp, VERSION_PHP5);
    }

    public static final Program parse(File phpFile, boolean aspTagsAsPhp) throws Exception {
        FileReader reader = new FileReader(phpFile);
        return ASTParser.parse(reader, aspTagsAsPhp, VERSION_PHP5);
    }

    public static final Program parse(IDocument phpDocument, boolean aspTagsAsPhp, String phpVersion) throws Exception {
        return ASTParser.parse(phpDocument, aspTagsAsPhp, phpVersion, 0, phpDocument.getLength());
    }

    public static final Program parse(IDocument phpDocument, boolean aspTagsAsPhp, String phpVersion, int offset, int length) throws Exception {
        DocumentReader reader = new DocumentReader(phpDocument, offset, length);
        return ASTParser.parse(reader, aspTagsAsPhp, phpVersion);
    }

    public static final Program parse(IDocument phpDocument, boolean aspTagsAsPhp) throws Exception {
        return ASTParser.parse(phpDocument, aspTagsAsPhp, VERSION_PHP5);
    }

    public static final Program parse(String phpCode) throws Exception {
        return ASTParser.parse(phpCode, true);
    }

    public static final Program parse(File phpFile) throws Exception {
        return ASTParser.parse(phpFile, true);
    }

    public static final Program parse(Reader reader) throws Exception {
        return ASTParser.parse(reader, true, VERSION_PHP5);
    }

    public static Program parse(Reader reader, boolean aspTagsAsPhp, String phpVersion) throws Exception {
        Scanner lexer = ASTParser.getLexer(reader, phpVersion, aspTagsAsPhp);
        lr_parser phpParser = ASTParser.getParser(phpVersion);
        phpParser.setScanner(lexer);
        Symbol symbol = phpParser.parse();
        return symbol == null ? null : (Program)symbol.value;
    }

    private static Scanner getLexer(Reader reader, String phpVersion, boolean aspTagsAsPhp) throws IOException {
        if (VERSION_PHP4.equals(phpVersion)) {
            PhpAstLexer4 lexer4 = ASTParser.getLexer4(reader);
            lexer4.setUseAspTagsAsPhp(aspTagsAsPhp);
            return lexer4;
        }
        if (VERSION_PHP5.equals(phpVersion)) {
            PhpAstLexer5 lexer5 = ASTParser.getLexer5(reader);
            lexer5.setUseAspTagsAsPhp(aspTagsAsPhp);
            return lexer5;
        }
        throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("ASTParser_1")) + phpVersion);
    }

    private static lr_parser getParser(String phpVersion) {
        if (VERSION_PHP4.equals(phpVersion)) {
            return PHP_AST_PARSER4;
        }
        if (VERSION_PHP5.equals(phpVersion)) {
            return PHP_AST_PARSER5;
        }
        throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("ASTParser_1")) + phpVersion);
    }

    private static PhpAstLexer5 getLexer5(Reader reader) throws IOException {
        PhpAstLexer5 phpAstLexer5 = PHP_AST_LEXER5;
        phpAstLexer5.yyreset(reader);
        phpAstLexer5.resetCommentList();
        return phpAstLexer5;
    }

    private static PhpAstLexer4 getLexer4(Reader reader) throws IOException {
        PhpAstLexer4 phpAstLexer4 = PHP_AST_LEXER4;
        phpAstLexer4.yyreset(reader);
        phpAstLexer4.resetCommentList();
        return phpAstLexer4;
    }
}

