/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.markers;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPTask;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.preferences.TaskTagsProvider;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;
import org.eclipse.wst.validation.internal.TaskListUtility;

public class MarkerContributor {
    private static MarkerContributor instance;
    private static String ID;
    private static String PHP_PROBLEM_MARKER_TYPE;
    private static String[] owners;
    private final TaskTagsProvider taskTagsProvider = TaskTagsProvider.getInstance();

    static {
        ID = "org.eclipse.php.core.documentModel.validate.PHPProblemsMarker";
        PHP_PROBLEM_MARKER_TYPE = "org.eclipse.php.core.phpproblemmarker";
        owners = new String[]{ID};
    }

    public static MarkerContributor getInstance() {
        if (instance == null) {
            instance = new MarkerContributor();
        }
        return instance;
    }

    private MarkerContributor() {
    }

    public void markFileProblems(IFile phpFile, boolean markTasks) {
        PHPFileData fileData = this.getFileModel(phpFile);
        if (fileData == null) {
            return;
        }
        IPHPMarker[] markers = fileData.getMarkers();
        try {
            phpFile.deleteMarkers(PHP_PROBLEM_MARKER_TYPE, false, 2);
        }
        catch (CoreException coreException) {}
        if (markTasks) {
            this.markTasks(phpFile, markers);
        }
        this.markErrors(phpFile, markers);
    }

    private void markErrors(IFile phpFile, IPHPMarker[] markers) {
        if (markers != null) {
            try {
                int i = 0;
                while (markers.length > i) {
                    String type = markers[i].getType();
                    if (type.equals("ERROR") || type.equals("WARNING") || type.equals("INFO")) {
                        String descr = markers[i].getDescription();
                        UserData userData = markers[i].getUserData();
                        int prio = 2;
                        this.createMarker(phpFile, userData, PHP_PROBLEM_MARKER_TYPE, descr, prio);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    private void markTasks(IFile phpFile, IPHPMarker[] markers) {
        if (phpFile == null || !phpFile.exists()) {
            return;
        }
        IMarker[] rullerAddedMarkers = null;
        Map[] rullerMarkersAttributes = null;
        try {
            TaskListUtility.removeAllTasks((IResource)phpFile, (String[])owners, null);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        try {
            rullerAddedMarkers = phpFile.findMarkers("org.eclipse.core.resources.taskmarker", false, 2);
            rullerMarkersAttributes = new Map[rullerAddedMarkers.length];
            int i = 0;
            while (i < rullerMarkersAttributes.length) {
                rullerMarkersAttributes[i] = rullerAddedMarkers[i].getAttributes();
                ++i;
            }
            phpFile.deleteMarkers("org.eclipse.core.resources.taskmarker", false, 2);
        }
        catch (CoreException coreException) {}
        if (markers != null) {
            TaskTag[] tags = this.taskTagsProvider.getProjectTaskTags(phpFile.getProject());
            if (tags == null) {
                tags = this.taskTagsProvider.getWorkspaceTaskTags();
            }
            boolean caseSensitive = this.taskTagsProvider.getProjectTagsCaseSensitive(phpFile.getProject());
            int i = 0;
            while (markers.length > i) {
                String type = markers[i].getType();
                if (type.equals("TASK")) {
                    PHPTask task = (PHPTask)markers[i];
                    String descr = String.valueOf(task.getTaskName()) + " " + task.getDescription();
                    UserData userData = task.getUserData();
                    int prio = this.getPriority(task.getTaskName(), tags, caseSensitive);
                    try {
                        this.createMarker(phpFile, userData, "org.eclipse.core.resources.taskmarker", descr, prio);
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
            if (rullerAddedMarkers != null) {
                i = 0;
                while (i < rullerAddedMarkers.length) {
                    try {
                        boolean exists = rullerAddedMarkers[i].exists();
                        if (!exists && rullerMarkersAttributes[i].get("rulerPHPTask") != null) {
                            IMarker marker = phpFile.createMarker("org.eclipse.core.resources.taskmarker");
                            marker.setAttributes(rullerMarkersAttributes[i]);
                        }
                    }
                    catch (CoreException coreException) {}
                    ++i;
                }
            }
        }
    }

    public void markFile(IFile phpFile) {
        this.markFileProblems(phpFile, true);
    }

    private PHPFileData getFileModel(IFile phpFile) {
        return PHPWorkspaceModelManager.getInstance().getModelForFile(phpFile.getFullPath().toString(), false);
    }

    private void createMarker(IFile phpFile, UserData userData, String markerType, String descr, int prio) throws CoreException {
        IMarker marker = phpFile.createMarker(markerType);
        marker.setAttribute("lineNumber", userData.getStopLine() + 1);
        marker.setAttribute("message", (Object)descr);
        marker.setAttribute("priority", prio);
        if (markerType == PHP_PROBLEM_MARKER_TYPE) {
            marker.setAttribute("severity", 2);
        }
    }

    private int getPriority(String tagName, TaskTag[] tags, boolean caseSensitive) {
        int i = 0;
        while (i < tags.length) {
            boolean tagFound = caseSensitive ? tags[i].getTag().equals(tagName) : tags[i].getTag().equalsIgnoreCase(tagName);
            if (tagFound) {
                return tags[i].getPriority();
            }
            ++i;
        }
        return 1;
    }
}

