/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.core.util.text.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPModelUtil {
    public static final String PHPDOC_CLASS_NAME_SEPARATOR = "\\|";

    public static PHPFunctionData getRealConstructor(PHPProjectModel projectModel, String fileName, PHPClassData classData) {
        if (classData.hasConstructor()) {
            return classData.getConstructor();
        }
        CodeData parentConstructor = projectModel.getClassFunctionData(fileName, classData.getName(), "__construct");
        if (parentConstructor != null) {
            return (PHPFunctionData)parentConstructor;
        }
        return classData.getConstructor();
    }

    public static PHPFunctionData getRealDestructor(PHPProjectModel projectModel, String fileName, PHPClassData classData) {
        CodeData parentDestructor = projectModel.getClassFunctionData(fileName, classData.getName(), "__destruct");
        if (parentDestructor != null) {
            return (PHPFunctionData)parentDestructor;
        }
        return null;
    }

    public static String getFunctionReturnType(PHPProjectModel projectModel, String fileName, String className, String functionName) {
        if (className == null) {
            CodeData[] functions;
            PHPFunctionData function = projectModel.getFunction(fileName, functionName);
            if (function != null) {
                return function.getReturnType();
            }
            CodeData[] codeDataArray = functions = projectModel.getFunctions();
            int n = functions.length;
            int n2 = 0;
            while (n2 < n) {
                CodeData projectFunction = codeDataArray[n2];
                if (projectFunction.getName().equals(functionName) && projectFunction instanceof PHPFunctionData) {
                    return ((PHPFunctionData)projectFunction).getReturnType();
                }
                ++n2;
            }
            return null;
        }
        String[] realClassNames = className.split(PHPDOC_CLASS_NAME_SEPARATOR);
        LinkedHashSet<String> functionReturnClassNames = new LinkedHashSet<String>();
        String[] stringArray = realClassNames;
        int n = realClassNames.length;
        int n3 = 0;
        while (n3 < n) {
            String realClassName = stringArray[n3];
            CodeData classFunction = projectModel.getClassFunctionData(fileName, realClassName = realClassName.trim(), functionName);
            if (classFunction != null) {
                if (classFunction instanceof PHPFunctionData) {
                    functionReturnClassNames.add(((PHPFunctionData)classFunction).getReturnType());
                }
            } else {
                PHPClassData classData = projectModel.getClass(fileName, realClassName);
                if (classData != null) {
                    String superClassName;
                    String functionReturnClassName = null;
                    PHPClassData.PHPSuperClassNameData superClassNameData = classData.getSuperClassData();
                    if (superClassNameData != null && (superClassName = superClassNameData.getName()) != null) {
                        functionReturnClassName = PHPModelUtil.getFunctionReturnType(projectModel, fileName, superClassName, functionName);
                    }
                    if (functionReturnClassName != null) {
                        functionReturnClassNames.add(functionReturnClassName);
                    }
                }
            }
            ++n3;
        }
        return StringUtils.implodeStrings(functionReturnClassNames, "|");
    }

    public static String getVarType(PHPProjectModel projectModel, String fileName, String className, String varName, int statementStart, int line, boolean determineObjectTypeFromOtherFile) {
        String tempType = PHPFileDataUtilities.getVariableType(fileName, "this;*" + varName, statementStart, line, (IPhpModel)projectModel.getPHPUserModel(), determineObjectTypeFromOtherFile);
        if (tempType != null) {
            return tempType;
        }
        String[] realClassNames = className.split(PHPDOC_CLASS_NAME_SEPARATOR);
        LinkedHashSet<String> varClassNames = new LinkedHashSet<String>();
        String[] stringArray = realClassNames;
        int n = realClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String realClassName = stringArray[n2];
            CodeData classVar = projectModel.getClassVariablesData(fileName, realClassName = realClassName.trim(), varName);
            if (classVar != null) {
                if (classVar instanceof PHPClassVarData) {
                    varClassNames.add(((PHPClassVarData)classVar).getClassType());
                }
            } else {
                String classVarClassName;
                PHPClassData.PHPSuperClassNameData superClassNameData;
                PHPClassData classData = projectModel.getClass(fileName, realClassName);
                if (classData != null && (superClassNameData = classData.getSuperClassData()) != null && superClassNameData.getName() != null && (classVarClassName = PHPModelUtil.getVarType(projectModel, fileName, superClassNameData.getName(), varName, statementStart, line, determineObjectTypeFromOtherFile)) != null) {
                    varClassNames.add(classVarClassName);
                }
            }
            ++n2;
        }
        return StringUtils.implodeStrings(varClassNames, "|");
    }

    public static PHPCodeData getElementAt(PHPCodeData elementData, int offset) {
        throw new RuntimeException("test me");
    }

    public static Object getExternalResource(Object element, IProject project) {
        if (!(element instanceof PHPCodeData)) {
            return null;
        }
        PHPCodeData codeData = (PHPCodeData)element;
        PHPFileData fileData = PHPModelUtil.getPHPFileContainer(codeData);
        if (fileData == null) {
            return null;
        }
        String fileName = fileData.getName();
        File file = new File(fileName);
        if (file != null && file.exists()) {
            return file;
        }
        PHPProjectModel projectModel = null;
        if (project == null) {
            PHPProjectModel[] projectModels;
            fileName = fileData.getName();
            PHPProjectModel[] pHPProjectModelArray = projectModels = PHPWorkspaceModelManager.getInstance().listModels();
            int n = projectModels.length;
            int n2 = 0;
            while (n2 < n) {
                PHPProjectModel otherProjectModel = pHPProjectModelArray[n2];
                if (otherProjectModel.getFileData(fileName) == fileData) {
                    projectModel = otherProjectModel;
                    break;
                }
                ++n2;
            }
        } else {
            projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
        }
        if (projectModel == null) {
            return null;
        }
        return projectModel.getExternalResource(fileData);
    }

    public static CodeData[] getMatchingClasses(IPhpModel model, String className) {
        return model.getClass(className.toLowerCase());
    }

    public static PHPCodeData[] getMatchingElements(IPhpModel model, String elementName) {
        PHPFunctionData[] matchingFunctions;
        int nMatchingFunctions;
        CodeData[] matchingClasses = PHPModelUtil.getMatchingClasses(model, elementName);
        int nMatchingClasses = matchingClasses.length;
        if (nMatchingClasses + (nMatchingFunctions = (matchingFunctions = PHPModelUtil.getMatchingFunctions(model, elementName)).length) == 0) {
            return new PHPCodeData[0];
        }
        ArrayList matchingElements = new ArrayList(nMatchingClasses + nMatchingFunctions);
        if (nMatchingClasses > 0) {
            matchingElements.addAll(Arrays.asList(matchingClasses));
        }
        if (nMatchingFunctions > 0) {
            matchingElements.addAll(Arrays.asList(matchingFunctions));
        }
        return matchingElements.toArray(new PHPCodeData[0]);
    }

    public static PHPFunctionData[] getMatchingFunctions(IPhpModel model, String functionName) {
        CodeData[] functions = model.getFunctions(functionName);
        ArrayList<PHPFunctionData> matchingFunctions = new ArrayList<PHPFunctionData>(1);
        int i = 0;
        while (i < functions.length) {
            PHPFunctionData aFunction = (PHPFunctionData)functions[i];
            if (functionName.equalsIgnoreCase(aFunction.getName())) {
                matchingFunctions.add(aFunction);
            }
            ++i;
        }
        return matchingFunctions.toArray(new PHPFunctionData[0]);
    }

    public static int getModifier(PHPCodeData member) {
        if (member instanceof PHPClassData) {
            PHPClassData cls = (PHPClassData)member;
            return cls.getModifiers();
        }
        if (member instanceof PHPFunctionData) {
            PHPFunctionData func = (PHPFunctionData)member;
            return func.getModifiers();
        }
        if (member instanceof PHPClassVarData) {
            PHPClassVarData var = (PHPClassVarData)member;
            return var.getModifiers();
        }
        return 0;
    }

    public static Object getParent(Object element) {
        if (element instanceof IResource) {
            if (element instanceof IProject) {
                return PHPWorkspaceModelManager.getInstance();
            }
            IContainer parent = ((IResource)element).getParent();
            boolean cfr_ignored_0 = parent instanceof IProject;
            return parent;
        }
        if (element instanceof PHPCodeData) {
            PHPCodeData parent = ((PHPCodeData)element).getContainer();
            if (parent == null && element instanceof PHPFileData) {
                IResource resource = PHPModelUtil.getResource(element);
                if (resource == null) {
                    return parent;
                }
                IContainer parentResource = resource.getParent();
                if (parentResource.exists()) {
                    return parentResource;
                }
            }
            return parent;
        }
        if (element instanceof PHPProjectModel) {
            return PHPWorkspaceModelManager.getInstance();
        }
        return null;
    }

    public static PHPFileData getPHPFile(IFile file) {
        PHPFileData fileData;
        PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(file.getProject());
        if (projectModel != null && (fileData = projectModel.getFileData(file.getFullPath().toString())) != null) {
            return fileData;
        }
        return null;
    }

    public static PHPFileData getPHPFileContainer(PHPCodeData element) {
        UserData userData;
        if (element instanceof PHPFileData) {
            return (PHPFileData)element;
        }
        PHPCodeData parent = element.getContainer();
        while (parent != null && !(parent instanceof PHPFileData)) {
            parent = parent.getContainer();
        }
        if (parent == null && (userData = element.getUserData()) != null) {
            Path path = new Path(userData.getFileName());
            parent = PHPWorkspaceModelManager.getInstance().getModelForFile(path.toString());
        }
        return (PHPFileData)parent;
    }

    public static IContainer getPHPFolderRoot(PHPCodeData element) {
        IResource resource = PHPModelUtil.getResource(element);
        return resource != null ? resource.getProject() : null;
    }

    public static IResource getResource(Object element) {
        if (element instanceof PHPCodeData) {
            PHPFileData parent = null;
            if (!(element instanceof PHPFileData)) {
                parent = PHPModelUtil.getPHPFileContainer((PHPCodeData)element);
            }
            PHPFileData fileData = parent;
            String filename = null;
            PHPCodeData codeData = (PHPCodeData)element;
            if (fileData != null) {
                filename = fileData.getName();
            } else if (codeData.getUserData() != null) {
                UserData userData = codeData.getUserData();
                filename = userData.getFileName();
            } else {
                return null;
            }
            Path path = new Path(filename);
            if (path.segmentCount() < 2) {
                return null;
            }
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (resource == null && ExternalFilesRegistry.getInstance().isEntryExist(new Path(filename).toOSString())) {
                resource = ExternalFilesRegistry.getInstance().getFileEntry(new Path(filename).toOSString());
            }
            return resource;
        }
        if (element instanceof PHPProjectModel) {
            PHPProjectModel projectModel = (PHPProjectModel)element;
            IProject project = projectModel.getProject();
            if (project == null) {
                project = PHPWorkspaceModelManager.getInstance().getProjectForModel(projectModel);
            }
            return project;
        }
        if (element instanceof IResource) {
            return (IResource)element;
        }
        return null;
    }

    public static PHPClassData getSuperClass(PHPClassData classData) {
        PHPProjectModel projectModel;
        PHPProjectModel[] projectModels;
        PHPClassData.PHPSuperClassNameData superClassNameData = classData.getSuperClassData();
        if (superClassNameData == null) {
            return null;
        }
        String superClassName = superClassNameData.getName();
        if (superClassName == null) {
            return null;
        }
        PHPFileData fileData = PHPModelUtil.getPHPFileContainer(classData);
        String fileName = null;
        if (fileData != null) {
            fileName = fileData.getName();
        }
        if (fileName != null && fileName.equals("")) {
            fileName = null;
        }
        PHPClassData superClassData = null;
        PHPProjectModel model = null;
        IProject project = null;
        IResource resource = PHPModelUtil.getResource(classData);
        if (resource != null) {
            project = resource.getProject();
            model = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
            if (model != null && (superClassData = model.getClass(resource.getName(), superClassName)) != null) {
                return superClassData;
            }
        }
        PHPProjectModel[] pHPProjectModelArray = projectModels = PHPWorkspaceModelManager.getInstance().listModels();
        int n = projectModels.length;
        int n2 = 0;
        while (n2 < n) {
            projectModel = pHPProjectModelArray[n2];
            if (projectModel.getFileData(fileName) == fileData && (superClassData = projectModel.getClass(fileName, superClassName)) != null) {
                return superClassData;
            }
            ++n2;
        }
        pHPProjectModelArray = projectModels;
        n = projectModels.length;
        n2 = 0;
        while (n2 < n) {
            projectModel = pHPProjectModelArray[n2];
            superClassData = projectModel.getClass(fileName, superClassName);
            if (superClassData != null) {
                return superClassData;
            }
            ++n2;
        }
        return null;
    }

    public static PHPClassData[] getInterfaces(PHPClassData classData) {
        PHPClassData.PHPInterfaceNameData[] interfaceNameDatas = classData.getInterfacesNamesData();
        int numOfInterfaces = interfaceNameDatas.length;
        ArrayList<PHPClassData> interfacesList = new ArrayList<PHPClassData>();
        int i = 0;
        while (i < numOfInterfaces) {
            String interfaceName;
            if (interfaceNameDatas[i] != null && (interfaceName = interfaceNameDatas[i].getName()) != null) {
                PHPFileData fileData = PHPModelUtil.getPHPFileContainer(classData);
                String fileName = null;
                if (fileData != null) {
                    fileName = fileData.getName();
                }
                if ("".equals(fileName)) {
                    fileName = null;
                }
                PHPClassData interfaceClassData = null;
                IResource resource = PHPModelUtil.getResource(classData);
                if (resource != null) {
                    IProject project = resource.getProject();
                    PHPProjectModel model = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
                    if (model != null && (interfaceClassData = model.getClass(resource.getName(), interfaceName)) != null) {
                        interfacesList.add(interfaceClassData);
                    }
                } else {
                    PHPProjectModel projectModel;
                    PHPProjectModel[] projectModels = PHPWorkspaceModelManager.getInstance().listModels();
                    boolean foundInModeByFile = false;
                    PHPProjectModel[] pHPProjectModelArray = projectModels;
                    int n = projectModels.length;
                    int n2 = 0;
                    while (n2 < n) {
                        projectModel = pHPProjectModelArray[n2];
                        if (projectModel.getFileData(fileName) == fileData && (interfaceClassData = projectModel.getClass(fileName, interfaceName)) != null) {
                            interfacesList.add(interfaceClassData);
                            foundInModeByFile = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!foundInModeByFile) {
                        pHPProjectModelArray = projectModels;
                        n = projectModels.length;
                        n2 = 0;
                        while (n2 < n) {
                            projectModel = pHPProjectModelArray[n2];
                            interfaceClassData = projectModel.getClass(fileName, interfaceName);
                            if (interfaceClassData != null) {
                                interfacesList.add(interfaceClassData);
                            }
                            ++n2;
                        }
                    }
                }
            }
            ++i;
        }
        PHPClassData[] interfacesResult = new PHPClassData[interfacesList.size()];
        interfacesList.toArray(interfacesResult);
        return interfacesResult;
    }

    public static PHPProjectModel getProjectModelForFile(PHPFileData fileData) {
        PHPProjectModel model = null;
        IProject project = (IProject)PHPModelUtil.getPHPFolderRoot(fileData);
        if (project != null) {
            model = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
        }
        if (model == null) {
            PHPProjectModel[] models = PHPWorkspaceModelManager.getInstance().listModels();
            int i = 0;
            while (i < models.length) {
                if (models[i].getFileData(fileData.getName()) == fileData) {
                    model = models[i];
                    break;
                }
                ++i;
            }
        }
        return model;
    }

    public static IPhpModel getIncludeModelForFile(PHPProjectModel model, PHPFileData fileData) {
        PHPIncludePathModelManager includeManager = (PHPIncludePathModelManager)model.getModel("CompositeIncludePathModel");
        if (includeManager == null) {
            return null;
        }
        IPhpModel[] includeModels = includeManager.listModels();
        int j = 0;
        while (j < includeModels.length) {
            if (includeModels[j].getFileData(fileData.getName()) == fileData) {
                return includeModels[j];
            }
            ++j;
        }
        return null;
    }

    public static boolean hasChildren(PHPCodeData element) {
        if (element instanceof PHPFunctionData) {
            return false;
        }
        if (element instanceof PHPClassData) {
            PHPClassData classData = (PHPClassData)element;
            return classData.getFunctions().length > 0 || classData.getVars().length > 0 || classData.getConsts().length > 0;
        }
        return !(element instanceof PHPVariableData) && !(element instanceof PHPKeywordData) && !(element instanceof PHPConstantData) && !(element instanceof PHPClassConstData) && !(element instanceof PHPIncludeFileData);
    }

    public static boolean hasPhpExtention(IFile file) {
        String[] validExtensions;
        String fileName = file.getName();
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return false;
        }
        String extension = fileName.substring(index + 1);
        if (file instanceof ExternalFileWrapper) {
            int position = extension.indexOf(58);
            extension = position > 0 ? extension.substring(0, position) : extension;
        }
        IContentType type = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        String[] stringArray = validExtensions = type.getFileSpecs(8);
        int n = validExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String validExtension = stringArray[n2];
            if (extension.equalsIgnoreCase(validExtension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasSuperClass(PHPClassData classData, PHPClassData superClassData) {
        PHPClassData.PHPSuperClassNameData currentSuperClassNameData = classData.getSuperClassData();
        if (currentSuperClassNameData == null) {
            return false;
        }
        String currentSuperClassName = currentSuperClassNameData.getName();
        if (currentSuperClassName == null) {
            return false;
        }
        PHPClassData currentSuperClassData = classData;
        while ((currentSuperClassData = PHPModelUtil.getSuperClass(currentSuperClassData)) != null) {
            if (currentSuperClassData != superClassData) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSuperClass(PHPClassData classData, String superClassName) {
        return PHPModelUtil.discoverSuperClass(classData, superClassName) != null || superClassName.equalsIgnoreCase(PHPModelUtil.getSuperClassName(classData));
    }

    public static String getSuperClassName(PHPClassData classData) {
        PHPClassData.PHPSuperClassNameData currentSuperClassNameData = classData.getSuperClassData();
        if (currentSuperClassNameData != null) {
            return currentSuperClassNameData.getName();
        }
        return null;
    }

    public static PHPClassData discoverSuperClass(PHPClassData classData, String superClassName) {
        String currentSuperClassName = PHPModelUtil.getSuperClassName(classData);
        if (currentSuperClassName == null) {
            return null;
        }
        PHPClassData currentSuperClassData = classData;
        HashSet<PHPClassData> visitedClasses = new HashSet<PHPClassData>();
        visitedClasses.add(currentSuperClassData);
        while ((currentSuperClassData = PHPModelUtil.getSuperClass(currentSuperClassData)) != null) {
            if (visitedClasses.contains(currentSuperClassData)) {
                return null;
            }
            currentSuperClassName = currentSuperClassData.getName();
            if (currentSuperClassName == null) {
                return null;
            }
            if (currentSuperClassName.compareToIgnoreCase(superClassName) == 0) {
                return currentSuperClassData;
            }
            visitedClasses.add(currentSuperClassData);
        }
        return null;
    }

    public static PHPClassData discoverInterface(PHPClassData classData, String interfaceName) {
        PHPClassData[] interfaces = PHPModelUtil.getInterfaces(classData);
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].getName() != null && interfaces[i].getName().equalsIgnoreCase(interfaceName)) {
                return interfaces[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean isExternal(Object target) {
        return false;
    }

    public static boolean isPhpFile(IFile file) {
        IContentDescription contentDescription = null;
        if (!file.exists()) {
            return PHPModelUtil.hasPhpExtention(file);
        }
        try {
            contentDescription = file.getContentDescription();
        }
        catch (CoreException coreException) {
            return PHPModelUtil.hasPhpExtention(file);
        }
        if (contentDescription == null) {
            return PHPModelUtil.hasPhpExtention(file);
        }
        return ContentTypeIdForPHP.ContentTypeID_PHP.equals(contentDescription.getContentType().getId());
    }

    public static boolean isReadOnly(Object target) {
        return false;
    }

    public static String getRelativeLocation(IPhpModel model, String location) {
        PHPFileData fileData = model.getFileData(location);
        if (fileData != null) {
            IResource resource = PHPModelUtil.getResource(fileData);
            if (resource != null && resource.exists()) {
                IProject fileProject = resource.getProject();
                if (fileProject.isAccessible()) {
                    return new Path(location).removeFirstSegments(1).toString();
                }
            } else if (model instanceof PHPProjectModel) {
                IPhpModel includeModel = PHPModelUtil.getIncludeModelForFile((PHPProjectModel)model, fileData);
                IPath path = PHPModelUtil.getIncludeModelLocation(includeModel);
                if (includeModel.getFileData(location) == fileData) {
                    return new Path(location).setDevice("").removeFirstSegments(path.segmentCount()).toString();
                }
            }
        } else {
            Path pathLocation = new Path(location);
            if (model instanceof PHPProjectModel) {
                String projectName = pathLocation.segment(0);
                if (projectName.equals(((PHPProjectModel)model).getProject().getName())) {
                    return pathLocation.removeFirstSegments(1).makeRelative().toString();
                }
                PHPIncludePathModelManager includeManager = (PHPIncludePathModelManager)((PHPProjectModel)model).getModel("CompositeIncludePathModel");
                if (includeManager.getModel(projectName) != null) {
                    return pathLocation.removeFirstSegments(1).makeRelative().toString();
                }
                if (ResourcesPlugin.getWorkspace().getRoot().getProject(projectName) != null) {
                    return pathLocation.removeFirstSegments(1).makeRelative().toString();
                }
            }
        }
        return location;
    }

    public static String getRelativeLocation(IProject project, String location) {
        PHPProjectModel model = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
        if (model == null) {
            return location;
        }
        return PHPModelUtil.getRelativeLocation(model, location);
    }

    public static PHPFileData getFileData(Object element) {
        PHPFileData fileData = null;
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            if (!PHPModelUtil.isPhpFile(file)) {
                return null;
            }
            fileData = PHPWorkspaceModelManager.getInstance().getModelForFile(file.getFullPath().toString());
        }
        if (element instanceof PHPFileData) {
            fileData = (PHPFileData)element;
        }
        return fileData;
    }

    public static ArrayList<PHPFunctionData> getFunctionsToOverride(IProject project, PHPClassData classData, ArrayList<String> overridenMethodsNamesList, ArrayList<String> existingRequiredNamesList, ArrayList<String> requiredToAdd) {
        ArrayList<PHPFunctionData> temp = new ArrayList<PHPFunctionData>();
        if (classData != null) {
            int i;
            PHPFunctionData[] functions = classData.getFunctions();
            if (classData.getUserData() != null) {
                String phpFileName = classData.getUserData().getFileName();
                if (!existingRequiredNamesList.contains(phpFileName = PHPModelUtil.getRelativeLocation(project, phpFileName))) {
                    existingRequiredNamesList.add(phpFileName);
                    requiredToAdd.add(phpFileName);
                }
            }
            int numOfFunctions = functions.length;
            if (PHPModifier.isInterface(classData.getModifiers())) {
                i = 0;
                while (i < numOfFunctions) {
                    if (!overridenMethodsNamesList.contains(functions[i].getName())) {
                        temp.add(functions[i]);
                        overridenMethodsNamesList.add(functions[i].getName());
                    }
                    ++i;
                }
            } else if (PHPModifier.isAbstract(classData.getModifiers())) {
                i = 0;
                while (i < numOfFunctions) {
                    if (!PHPModifier.isAbstract(functions[i].getModifiers())) {
                        overridenMethodsNamesList.add(functions[i].getName());
                    } else if (!overridenMethodsNamesList.contains(functions[i].getName())) {
                        temp.add(functions[i]);
                        overridenMethodsNamesList.add(functions[i].getName());
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < numOfFunctions) {
                    if (!overridenMethodsNamesList.contains(functions[i].getName())) {
                        overridenMethodsNamesList.add(functions[i].getName());
                    }
                    ++i;
                }
            }
            if (classData.getSuperClassData() != null && classData.getSuperClassData().getName() != null) {
                PHPClassData superClass = PHPModelUtil.getSuperClass(classData);
                ArrayList<PHPFunctionData> superClassMethodsList = PHPModelUtil.getFunctionsToOverride(project, superClass, overridenMethodsNamesList, existingRequiredNamesList, requiredToAdd);
                temp.addAll(superClassMethodsList);
                Iterator<PHPFunctionData> iter = superClassMethodsList.iterator();
                while (iter.hasNext()) {
                    temp.add(iter.next());
                }
            }
            if (classData.getInterfacesNamesData() != null && classData.getInterfacesNamesData().length > 0) {
                PHPClassData[] interfaces = PHPModelUtil.getInterfaces(classData);
                int numOfInterfaces = interfaces.length;
                int i2 = 0;
                while (i2 < numOfInterfaces) {
                    ArrayList<PHPFunctionData> interfaceMethodsList = PHPModelUtil.getFunctionsToOverride(project, interfaces[i2], overridenMethodsNamesList, existingRequiredNamesList, requiredToAdd);
                    temp.addAll(interfaceMethodsList);
                    ++i2;
                }
            }
        }
        return temp;
    }

    public static IPath getIncludeModelLocation(IPhpModel model) {
        PHPIncludePathModel includeModel;
        if (model instanceof PHPIncludePathModel && (includeModel = (PHPIncludePathModel)model).getType() == PHPIncludePathModel.IncludePathModelType.VARIABLE) {
            return IncludePathVariableManager.instance().getIncludePathVariable(model.getID());
        }
        String id = model.getID();
        if (id != null) {
            return new Path(id);
        }
        return null;
    }

    public static IPath getFileDataShortPath(PHPProjectModel model, PHPFileData fileData) {
        Path shortPath;
        IPhpModel includeModel = PHPModelUtil.getIncludeModelForFile(model, fileData);
        if (includeModel != null) {
            IPath path = PHPModelUtil.getIncludeModelLocation(includeModel);
            shortPath = new Path(includeModel.getID()).append(new Path(fileData.getName()).removeFirstSegments(path.segmentCount()));
        } else {
            shortPath = new Path(fileData.getName());
        }
        return shortPath;
    }

    public static class PHPContainerStringConverter {
        public static Object toContainer(String sPath) {
            PHPFileData fileData;
            IPath path = Path.fromPortableString((String)sPath);
            if (path == null) {
                return null;
            }
            IFile file = null;
            try {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (file != null && (fileData = PHPWorkspaceModelManager.getInstance().getModelForFile(file, false)) != null) {
                return fileData;
            }
            IFolder folder = null;
            try {
                folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (folder != null) {
                return folder;
            }
            IProject project = null;
            try {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segments()[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            return project;
        }

        public static String toString(Object phpElement) {
            IPath path;
            if (phpElement instanceof PHPCodeData) {
                while (phpElement != null && !(phpElement instanceof PHPFileData)) {
                    phpElement = ((PHPCodeData)phpElement).getContainer();
                }
            }
            if (phpElement == null) {
                return "";
            }
            IResource res = PHPModelUtil.getResource(phpElement);
            if (res != null && (path = res.getFullPath()) != null) {
                return path.toPortableString();
            }
            return "";
        }
    }
}

