/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.core.project.build.ITypeResolver;
import org.eclipse.php.internal.core.phpModel.parser.ContextParserClient;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.parser.VariableContextBuilder;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPTask;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableTypeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariablesTypeManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultParserClient
extends ContextParserClient {
    protected PHPUserModel userModel = null;
    protected PHPProjectModel projectModel;
    protected String workingFileName;
    protected List functions;
    protected List classVars;
    protected List classConsts;
    protected List classFunctions;
    protected List classes;
    protected List includeFiles;
    protected List markers;
    protected List functionParameters;
    protected List phpTags;
    protected List constants;
    protected PHPDocBlock firstPHPDocBlock;
    protected Stack functionsStack;
    protected Stack classesStack;
    protected Stack classVarsStack;
    protected Stack classConstsStack;
    protected Stack classFunctionsStack;
    protected VariableContextBuilder variableContextBuilder;
    private boolean hadReturnStatement;
    private ITypeResolver[] typeResolvers;

    public DefaultParserClient(PHPUserModel userModel, IProject project) {
        this.loadTypeResolvers(project);
        this.functions = new ArrayList();
        this.classVars = new ArrayList();
        this.classConsts = new ArrayList();
        this.classFunctions = new ArrayList();
        this.classes = new ArrayList();
        this.includeFiles = new ArrayList();
        this.markers = new ArrayList();
        this.functionParameters = new ArrayList();
        this.phpTags = new ArrayList();
        this.constants = new ArrayList();
        this.functionsStack = new Stack();
        this.classesStack = new Stack();
        this.classVarsStack = new Stack();
        this.classConstsStack = new Stack();
        this.classFunctionsStack = new Stack();
        this.hadReturnStatement = false;
        this.variableContextBuilder = new VariableContextBuilder();
        this.workingFileName = null;
        this.projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
        if (this.projectModel == null) {
            this.projectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel();
        }
        this.userModel = userModel;
    }

    private void loadTypeResolvers(IProject project) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.php.core.typeResolver");
        IConfigurationElement[] points = extensionPoint.getConfigurationElements();
        if (points.length > 0) {
            this.typeResolvers = new ITypeResolver[points.length];
            int i = 0;
            while (i < points.length) {
                try {
                    this.typeResolvers[i] = (ITypeResolver)points[i].createExecutableExtension("class");
                    this.typeResolvers[i].setProject(project);
                }
                catch (CoreException coreException) {
                    throw new IllegalStateException("Error loading extension point - org.eclipse.php.core.typeResolver");
                }
                ++i;
            }
        } else {
            this.typeResolvers = null;
        }
    }

    @Override
    public void handleFunctionParameter(String classType, String variableName, boolean isReference, boolean isConst, String defaultValue, int startPosition, int endPosition, int stopPosition, int lineNumber) {
        variableName = variableName.substring(1);
        UserData userData = PHPCodeDataFactory.createUserData(this.workingFileName, startPosition, stopPosition, stopPosition, lineNumber);
        PHPFunctionData.PHPFunctionParameter parameter = PHPCodeDataFactory.createPHPFunctionParameter(variableName, userData, isReference, isConst, classType, defaultValue);
        this.functionParameters.add(parameter);
    }

    private static PHPFunctionData.PHPFunctionParameter getParameter(PHPFunctionData.PHPFunctionParameter[] parameters, String parameterName) {
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        if (parameterName.charAt(0) == '&') {
            parameterName = parameterName.substring(1);
        }
        if (parameterName.charAt(0) == '$') {
            parameterName = parameterName.substring(1);
        }
        PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            PHPFunctionData.PHPFunctionParameter element = pHPFunctionParameterArray[n2];
            if (parameterName.equalsIgnoreCase(element.getName())) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void handleFunctionDeclaration(String functionName, boolean isClassFunction, int modifier, PHPDocBlock docInfo, int startPosition, int stopPosition, int lineNumber) {
        PHPFunctionData lastFunction;
        if (!this.functionsStack.isEmpty() && functionName.equals((lastFunction = (PHPFunctionData)this.functionsStack.peek()).getName()) && startPosition == lastFunction.getUserData().getStartPosition()) {
            return;
        }
        PHPFunctionData.PHPFunctionParameter[] parameters = new PHPFunctionData.PHPFunctionParameter[this.functionParameters.size()];
        this.functionParameters.toArray(parameters);
        this.functionParameters.clear();
        String returnType = null;
        if (docInfo != null) {
            Iterator<PHPDocTag> it = docInfo.getTags(7);
            while (it.hasNext()) {
                String originalClassType;
                PHPFunctionData.PHPFunctionParameter parameter;
                PHPDocTag param = it.next();
                String arg = param.getValue().trim();
                String[] values = arg.split(" ");
                String name = null;
                String type = null;
                int length = values.length > 2 ? 2 : values.length;
                int i = 0;
                while (i < length) {
                    if (values[i].equals("") && length < values.length) {
                        ++length;
                    }
                    if (values[i].startsWith("$")) {
                        name = values[i];
                    } else if (type == null) {
                        type = values[i];
                    }
                    ++i;
                }
                if (name == null) {
                    name = values[0];
                }
                if ((parameter = DefaultParserClient.getParameter(parameters, name)) == null) {
                    type = values[0];
                    name = values.length > 1 ? values[1] : null;
                    parameter = DefaultParserClient.getParameter(parameters, type);
                }
                if (parameter == null || type == null || type.length() <= 0 || (originalClassType = parameter.getClassType()) != null && originalClassType.length() != 0) continue;
                parameter.setClassType(type);
            }
            Iterator<PHPDocTag> returnIt = docInfo.getTags(6);
            String string = returnType = returnIt.hasNext() ? returnIt.next().getValue() : null;
        }
        returnType = returnType == null ? (isClassFunction && functionName.equals(this.getCurrentClassName()) ? this.getCurrentClassName() : "void") : returnType.split("\\s")[0];
        UserData userData = PHPCodeDataFactory.createUserData(this.workingFileName, startPosition, stopPosition, stopPosition, lineNumber);
        PHPFunctionData functionData = PHPCodeDataFactory.createPHPFuctionData(functionName, modifier, docInfo, userData, parameters, returnType);
        if (isClassFunction) {
            this.classFunctions.add(functionData);
        } else {
            this.functions.add(functionData);
        }
        this.functionsStack.push(functionData);
        PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            PHPFunctionData.PHPFunctionParameter element = pHPFunctionParameterArray[n2];
            ((PHPCodeDataFactory.PHPFunctionParameterImp)element).setContainer(functionData);
            this.variableContextBuilder.addVariable(this.getContext(), element);
            this.variableContextBuilder.addObjectInstantiation(this.getContext(), element.getName(), element.getClassType(), false, 0, startPosition);
            ++n2;
        }
    }

    @Override
    public void handleFunctionDeclarationEnds(boolean isClassFunction, int endPosition) {
        PHPFunctionData lastFunction;
        String functionName = null;
        if (!this.functionsStack.isEmpty() && (lastFunction = (PHPFunctionData)this.functionsStack.peek()) != null) {
            functionName = lastFunction.getName();
        }
        this.handleFunctionDeclarationEnds(functionName, isClassFunction, endPosition);
    }

    private void handleFunctionDeclarationEnds(String functionName, boolean isClassFunction, int endPosition) {
        CodeData lastFunction = null;
        boolean wasEmpty = this.functionsStack.isEmpty();
        if (!wasEmpty) {
            lastFunction = (PHPFunctionData)this.functionsStack.pop();
        }
        if (lastFunction != null && lastFunction.getName().equals(functionName)) {
            if (this.hadReturnStatement && lastFunction.getReturnType().equals("void")) {
                ((PHPCodeDataFactory.PHPFunctionDataImp)lastFunction).setReturnType("unknown");
            }
            ((PHPCodeDataFactory.UserDataImp)lastFunction.getUserData()).setEndPosition(endPosition);
        }
        this.hadReturnStatement = false;
        super.handleFunctionDeclarationEnds(isClassFunction, endPosition);
    }

    @Override
    public void handleClassDeclaration(String className, int modifier, String superClassName, String interfacesNames, PHPDocBlock docInfo, int startPosition, int stopPosition, int lineNumber) {
        PHPClassData.PHPInterfaceNameData[] interfaces;
        PHPClassData.PHPSuperClassNameData superClassData;
        if (superClassName != null) {
            int index = superClassName.indexOf(93);
            String locationStr = superClassName.substring(1, index);
            superClassName = superClassName.substring(index + 1);
            int superClassStartPosition = Integer.parseInt(locationStr.substring(0, locationStr.indexOf(".")));
            int superClassEndPosition = Integer.parseInt(locationStr.substring(locationStr.indexOf(".") + 1, locationStr.length()));
            UserData userData = PHPCodeDataFactory.createUserData(this.workingFileName, superClassStartPosition, superClassEndPosition, superClassStartPosition, 0);
            superClassData = PHPCodeDataFactory.createPHPSuperClassNameData(superClassName, userData);
        } else {
            superClassData = PHPCodeDataFactory.createPHPSuperClassNameData(superClassName, null);
        }
        if (interfacesNames != null) {
            String[] interfacesNamesArray = interfacesNames.split(",");
            interfaces = new PHPClassData.PHPInterfaceNameData[interfacesNamesArray.length];
            int i = 0;
            while (i < interfacesNamesArray.length) {
                String interfaceName = interfacesNamesArray[i];
                int index = interfaceName.indexOf(93);
                String locationStr = interfaceName.substring(1, index);
                interfaceName = interfaceName.substring(index + 1);
                int interfaceNameStartPosition = Integer.parseInt(locationStr.substring(0, locationStr.indexOf(".")));
                int interfaceNameEndPosition = Integer.parseInt(locationStr.substring(locationStr.indexOf(".") + 1, locationStr.length()));
                UserData userData = PHPCodeDataFactory.createUserData(this.workingFileName, interfaceNameStartPosition, interfaceNameEndPosition, interfaceNameStartPosition, 0);
                interfaces[i] = PHPCodeDataFactory.createPHPInterfaceNameData(interfaceName, userData);
                ++i;
            }
        } else {
            interfaces = PHPCodeDataFactory.EMPTY_INTERFACES_DATA_ARRAY;
        }
        UserData userData = PHPCodeDataFactory.createUserData(this.workingFileName, startPosition, stopPosition, stopPosition, lineNumber);
        PHPClassData classData = PHPCodeDataFactory.createPHPClassData(className, modifier, docInfo, userData, superClassData, interfaces, PHPCodeDataFactory.EMPTY_CLASS_VAR_DATA_ARRAY, PHPCodeDataFactory.EMPTY_CLASS_CONST_DATA_ARRAY, PHPCodeDataFactory.EMPTY_FUNCTIONS_DATA_ARRAY);
        this.classes.add(classData);
        this.classesStack.push(classData);
    }

    @Override
    public void hadleClassDeclarationStarts(String className, int startPosition) {
        if (this.getCurrentClassName() != null && this.getCurrentClassName().length() != 0) {
            this.classVarsStack.push(this.classVars);
            this.classConstsStack.push(this.classConsts);
            this.classFunctionsStack.push(this.classFunctions);
            this.classVars = new ArrayList();
            this.classConsts = new ArrayList();
            this.classFunctions = new ArrayList();
        }
        super.hadleClassDeclarationStarts(className, startPosition);
    }

    @Override
    public void handleClassDeclarationEnds(String className, int endPosition) {
        PHPCodeDataFactory.PHPClassDataImp classData;
        if (!this.classesStack.isEmpty() && (classData = (PHPCodeDataFactory.PHPClassDataImp)this.classesStack.pop()).getName().equals(className)) {
            Object element;
            Object[] vars = new PHPClassVarData[this.classVars.size()];
            this.classVars.toArray(vars);
            Arrays.sort(vars);
            Object[] consts = new PHPClassConstData[this.classConsts.size()];
            this.classConsts.toArray(consts);
            Arrays.sort(consts);
            Object[] func = new PHPFunctionData[this.classFunctions.size()];
            this.classFunctions.toArray(func);
            Arrays.sort(func);
            Object[] objectArray = vars;
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                element = objectArray[n2];
                ((PHPCodeDataFactory.PHPClassVarDataImp)element).setContainer(classData);
                ++n2;
            }
            objectArray = consts;
            n = consts.length;
            n2 = 0;
            while (n2 < n) {
                element = objectArray[n2];
                ((PHPCodeDataFactory.PHPClassConstDataImp)element).setContainer(classData);
                ++n2;
            }
            objectArray = func;
            n = func.length;
            n2 = 0;
            while (n2 < n) {
                element = objectArray[n2];
                ((PHPCodeDataFactory.PHPFunctionDataImp)element).setContainer(classData);
                ++n2;
            }
            classData.setFunctions((PHPFunctionData[])func);
            classData.setVars((PHPClassVarData[])vars);
            classData.setConsts((PHPClassConstData[])consts);
            ((PHPCodeDataFactory.UserDataImp)classData.getUserData()).setEndPosition(endPosition);
        }
        if (!this.classVarsStack.isEmpty()) {
            this.classVars = (List)this.classVarsStack.pop();
            this.classConsts = (List)this.classConstsStack.pop();
            this.classFunctions = (List)this.classFunctionsStack.pop();
        } else {
            this.classVars.clear();
            this.classConsts.clear();
            this.classFunctions.clear();
        }
        super.handleClassDeclarationEnds(className, endPosition);
    }

    @Override
    public void handleClassVariablesDeclaration(String variables, int modifier, PHPDocBlock docInfo, int startPosition, int endPosition, int stopPosition) {
        UserData userData = PHPCodeDataFactory.createUserData(this.workingFileName, startPosition, endPosition, stopPosition, 0);
        String classType = null;
        if (docInfo != null) {
            Iterator<PHPDocTag> it = docInfo.getTags(12);
            while (it.hasNext()) {
                PHPDocTag varTag = it.next();
                String value = varTag.getValue().trim();
                String[] values = value.split(" ");
                classType = values[0];
            }
        }
        StringTokenizer t = new StringTokenizer(variables, ",", false);
        while (t.hasMoreTokens()) {
            String var = t.nextToken().substring(1);
            PHPClassVarData classVarData = PHPCodeDataFactory.createPHPClassVarData(var, modifier, classType, docInfo, userData);
            this.handleObjectInstansiation(var, classType, null, 0, 0, false);
            this.classVars.add(classVarData);
        }
    }

    @Override
    public void handleClassConstDeclaration(String constName, String value, PHPDocBlock docInfo, int startPosition, int endPosition, int stopPosition) {
        UserData userData = PHPCodeDataFactory.createUserData(this.workingFileName, startPosition, endPosition, stopPosition, 0);
        PHPClassConstData classConstData = PHPCodeDataFactory.createPHPClassConstData(constName, value, docInfo, userData);
        this.classConsts.add(classConstData);
    }

    @Override
    public void handleIncludedFile(String includingType, String includeFileName, PHPDocBlock docInfo, int startPosition, int endPosition, int stopPosition, int lineNumber) {
        if (includeFileName == null || includeFileName.length() == 0) {
            return;
        }
        if (includeFileName.charAt(0) != '\'' && includeFileName.charAt(0) != '\"') {
            return;
        }
        includeFileName = includeFileName.substring(1, includeFileName.length() - 1);
        UserData userData = PHPCodeDataFactory.createUserData(this.workingFileName, startPosition, endPosition, stopPosition, lineNumber);
        PHPIncludeFileData include = PHPCodeDataFactory.createPHPIncludeFileData(includingType, includeFileName, docInfo, userData);
        this.includeFiles.add(include);
    }

    @Override
    public void handleError(String description, int startPosition, int endPosition, int lineNumber) {
    }

    @Override
    public void haveReturnValue() {
        this.hadReturnStatement = true;
    }

    @Override
    public void handleObjectInstansiation(String variableName, String className, String ctorArrguments, int line, int startPosition, boolean isUserDocumentation) {
        if (variableName == null) {
            return;
        }
        this.variableContextBuilder.addObjectInstantiation(this.getContext(), variableName, className, isUserDocumentation, line, startPosition);
    }

    @Override
    public void handleVariableName(String variableName, int line) {
        this.variableContextBuilder.addVariable(this.getContext(), variableName);
    }

    @Override
    public void handleGlobalVar(String variableName) {
        PHPVariableData variable = PHPCodeDataFactory.createPHPVariableData(variableName.substring(1), true, null, null);
        this.variableContextBuilder.addVariable(this.getContext(), variable);
    }

    @Override
    public void startParsing(String fileName) {
        super.startParsing(fileName);
        this.workingFileName = fileName;
        this.variableContextBuilder = new VariableContextBuilder();
        this.functions.clear();
        this.classes.clear();
        this.classVars.clear();
        this.classConsts.clear();
        this.classFunctions.clear();
        this.includeFiles.clear();
        this.markers.clear();
        this.phpTags.clear();
        this.constants.clear();
        this.functionParameters.clear();
        this.functionsStack.clear();
        this.classesStack.clear();
        this.classVarsStack.clear();
        this.classConstsStack.clear();
        this.classFunctionsStack.clear();
    }

    private void restoreToDefaultContext(int endPosition) {
        String currentClassName = this.getCurrentClassName();
        boolean isInsideClass = currentClassName.length() > 0;
        String currentFunctionName = this.getCurrentFunctionName();
        if (currentFunctionName.length() > 0) {
            endPosition = this.getEndPosition(endPosition, currentFunctionName, isInsideClass ? this.classFunctions : this.functions);
            this.handleFunctionDeclarationEnds(currentFunctionName, isInsideClass, endPosition);
            this.restoreToDefaultContext(endPosition);
        }
        if (isInsideClass) {
            endPosition = this.getEndPosition(endPosition, currentClassName, this.classes);
            this.handleClassDeclarationEnds(currentClassName, endPosition);
            this.restoreToDefaultContext(endPosition);
        }
    }

    private int getEndPosition(int endPosition, String currentElementName, Collection repository) {
        for (PHPCodeData element : repository) {
            if (!currentElementName.equals(element.getName())) continue;
            UserData elementUserData = element.getUserData();
            int elementStartPosition = elementUserData.getStartPosition();
            int phpStartPosition = 0;
            for (UserData phpUserData : this.phpTags) {
                phpStartPosition = phpUserData.getStartPosition();
                if (phpStartPosition <= elementStartPosition) continue;
                return phpStartPosition;
            }
        }
        return endPosition;
    }

    @Override
    public void finishParsing(int lastPosition, int lastLine, long lastModified) {
        PHPCodeData element;
        this.restoreToDefaultContext(lastPosition);
        PHPClassData[] allClasses = PHPCodeDataFactory.EMPTY_CLASS_DATA_ARRAY;
        if (!this.classes.isEmpty()) {
            allClasses = new PHPClassData[this.classes.size()];
            this.classes.toArray(allClasses);
        }
        PHPFunctionData[] allFunctions = PHPCodeDataFactory.EMPTY_FUNCTIONS_DATA_ARRAY;
        if (!this.functions.isEmpty()) {
            allFunctions = new PHPFunctionData[this.functions.size()];
            this.functions.toArray(allFunctions);
        }
        PHPIncludeFileData[] allIncludes = PHPCodeDataFactory.EMPTY_INCLUDE_DATA_ARRAY;
        if (!this.includeFiles.isEmpty()) {
            allIncludes = new PHPIncludeFileData[this.includeFiles.size()];
            this.includeFiles.toArray(allIncludes);
        }
        PHPConstantData[] allConstants = PHPCodeDataFactory.EMPTY_CONSTANT_DATA_ARRAY;
        if (!this.constants.isEmpty()) {
            allConstants = new PHPConstantData[this.constants.size()];
            this.constants.toArray(allConstants);
        }
        IPHPMarker[] allMarkers = PHPCodeDataFactory.EMPTY_MARKERS_DATA_ARRAY;
        if (!this.markers.isEmpty()) {
            allMarkers = new IPHPMarker[this.markers.size()];
            this.markers.toArray(allMarkers);
        }
        if (this.phpTags.size() % 2 == 1) {
            this.phpTags.add(PHPCodeDataFactory.createUserData(this.workingFileName, lastPosition, lastPosition, lastPosition, 0));
        }
        PHPBlock[] phpBlocks = new PHPBlock[this.phpTags.size() + 1 >> 1];
        int i = 0;
        while (i < phpBlocks.length) {
            int p = i << 1;
            UserData startTag = (UserData)this.phpTags.get(p);
            UserData endTag = p + 1 < this.phpTags.size() ? (UserData)this.phpTags.get(p + 1) : (UserData)this.phpTags.get(p);
            phpBlocks[i] = new PHPBlock(startTag, endTag);
            ++i;
        }
        this.fixObjectInstantiation(allClasses, allFunctions);
        PHPVariablesTypeManager variablesTypeManager = this.variableContextBuilder.getPHPVariablesTypeManager();
        UserData userData = PHPCodeDataFactory.createUserData(this.workingFileName, 0, 0, 0, lastLine);
        PHPFileData fileData = PHPCodeDataFactory.createPHPFileData(this.workingFileName, userData, allClasses, allFunctions, variablesTypeManager, allIncludes, allConstants, allMarkers, phpBlocks, this.firstPHPDocBlock, lastModified);
        PHPCodeData[] pHPCodeDataArray = allClasses;
        int n = allClasses.length;
        int n2 = 0;
        while (n2 < n) {
            element = pHPCodeDataArray[n2];
            element.setContainer(fileData);
            ++n2;
        }
        pHPCodeDataArray = allFunctions;
        n = allFunctions.length;
        n2 = 0;
        while (n2 < n) {
            element = pHPCodeDataArray[n2];
            element.setContainer(fileData);
            ++n2;
        }
        pHPCodeDataArray = allConstants;
        n = allConstants.length;
        n2 = 0;
        while (n2 < n) {
            element = pHPCodeDataArray[n2];
            element.setContainer(fileData);
            ++n2;
        }
        pHPCodeDataArray = allIncludes;
        n = allIncludes.length;
        n2 = 0;
        while (n2 < n) {
            element = pHPCodeDataArray[n2];
            element.setContainer(fileData);
            ++n2;
        }
        this.userModel.insert(fileData);
    }

    protected void fixObjectInstantiation(PHPClassData[] cls, PHPFunctionData[] func) {
        CodeData[] projectClasses = this.projectModel.getClasses();
        CodeData[] projectFunctions = this.projectModel.getFunctions();
        PHPVariablesTypeManager variablesTypeManager = this.variableContextBuilder.getPHPVariablesTypeManager();
        Map variablesInstansiations = variablesTypeManager.getVariablesInstansiation();
        LinkedList<String> variablesNames = new LinkedList<String>();
        LinkedList<PHPCodeContext> contextes = new LinkedList<PHPCodeContext>();
        LinkedList<String> classNames = new LinkedList<String>();
        LinkedList<Integer> lines = new LinkedList<Integer>();
        LinkedList<Integer> positions = new LinkedList<Integer>();
        LinkedList<Boolean> userDocumentations = new LinkedList<Boolean>();
        Set keys = variablesInstansiations.keySet();
        for (String key : keys) {
            String[] variableContext = key.split(";");
            String variableName = null;
            String contextClassName = null;
            String contextFunctionName = null;
            if (variableContext[0].equals("this") && variableContext.length > 3) {
                int length = variableContext.length;
                contextFunctionName = variableContext[length - 1];
                contextClassName = variableContext[length - 2];
                int i = length - 3;
                while (i >= 0) {
                    if (!variableContext[i].equals("null")) {
                        variableName = variableName == null ? variableContext[i] : String.valueOf(variableContext[i]) + ";" + variableName;
                    }
                    --i;
                }
            } else {
                if (variableContext.length >= 3) {
                    contextFunctionName = variableContext[2];
                }
                if (variableContext.length >= 2) {
                    contextClassName = variableContext[1];
                }
                if (variableContext.length >= 1) {
                    variableName = variableContext[0];
                }
            }
            PHPCodeContext codeContext = ModelSupport.createContext(contextClassName, contextFunctionName);
            List list = (List)variablesInstansiations.get(key);
            for (PHPVariableTypeData variableTypeData : list) {
                String className = variableTypeData.getType();
                int lineNumber = variableTypeData.getLine();
                int position = variableTypeData.getPosition();
                boolean isUserDocumentation = variableTypeData.isUserDocumentation();
                if (className != null && className.startsWith("r_variable")) {
                    String resolverType = this.getClassName(className, position, lineNumber, cls, func, projectClasses, projectFunctions);
                    if (resolverType == null && this.typeResolvers != null) {
                        ITypeResolver[] iTypeResolverArray = this.typeResolvers;
                        int n = this.typeResolvers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITypeResolver resolver = iTypeResolverArray[n2];
                            String resolve = resolver.resolve(className, position, lineNumber, cls, func, projectClasses, projectFunctions);
                            if (resolve != null) {
                                resolverType = resolve;
                            }
                            ++n2;
                        }
                    }
                    className = resolverType;
                }
                if ("self".equalsIgnoreCase(className)) {
                    className = codeContext.getContainerClassName();
                }
                variablesNames.add(variableName);
                contextes.add(codeContext);
                classNames.add(className);
                lines.add(new Integer(lineNumber));
                positions.add(new Integer(position));
                userDocumentations.add(isUserDocumentation);
            }
        }
        variablesInstansiations.clear();
        Iterator contextesIterator = contextes.iterator();
        Iterator variablesNamesIterator = variablesNames.iterator();
        Iterator classNamesIterator = classNames.iterator();
        Iterator linesIterator = lines.iterator();
        Iterator positionsIterator = positions.iterator();
        Iterator userDocumentationsIterator = userDocumentations.iterator();
        while (contextesIterator.hasNext()) {
            String next = (String)variablesNamesIterator.next();
            this.variableContextBuilder.addObjectInstantiation((PHPCodeContext)contextesIterator.next(), next, (String)classNamesIterator.next(), (Boolean)userDocumentationsIterator.next(), (Integer)linesIterator.next(), (Integer)positionsIterator.next());
        }
    }

    private String getClassName(String className, int position, int lineNumber, PHPClassData[] cls, PHPFunctionData[] func, CodeData[] projectClasses, CodeData[] projectFunctions) {
        String[] classNameParts = className.split(";");
        String sourceClassName = null;
        int propertyNamePosition = 1;
        if (classNameParts.length < 2) {
            return null;
        }
        if (classNameParts.length == 2) {
            return PHPFileDataUtilities.getVariableType(this.workingFileName, classNameParts[1], position, lineNumber, (IPhpModel)this.userModel, true);
        }
        if (classNameParts[1].equals("function_call")) {
            sourceClassName = this.getFunctionReturnType(classNameParts[2], position, cls, func, projectClasses, projectFunctions);
            propertyNamePosition = 3;
        } else {
            propertyNamePosition = 2;
            sourceClassName = classNameParts[1];
            if (sourceClassName.charAt(0) == '$') {
                sourceClassName = PHPFileDataUtilities.getVariableType(this.workingFileName, sourceClassName, position, lineNumber, (IPhpModel)this.userModel, true);
            }
        }
        while (propertyNamePosition < classNameParts.length) {
            if (!classNameParts[propertyNamePosition].equals("null") && (sourceClassName = this.getPropertyType(sourceClassName, classNameParts[propertyNamePosition], cls, func, projectClasses, projectFunctions)) != null && sourceClassName.equals("-")) {
                sourceClassName = null;
                break;
            }
            ++propertyNamePosition;
        }
        return sourceClassName;
    }

    private String getFunctionReturnType(String functionName, int position, PHPClassData[] classes, PHPFunctionData[] functions, CodeData[] projectClasses, CodeData[] projectFunctions) {
        PHPClassData[] pHPClassDataArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            PHPClassData cl = pHPClassDataArray[n2];
            UserData userData = cl.getUserData();
            if (position > userData.getStartPosition() && position <= userData.getEndPosition()) {
                return this.getPropertyType(cl.getName(), functionName, classes, functions, projectClasses, projectFunctions);
            }
            ++n2;
        }
        return this.getPropertyType(null, functionName, classes, functions, projectClasses, projectFunctions);
    }

    private String getPropertyType(String className, String propertyName, CodeData[] classes, CodeData[] functions, CodeData[] projectClasses, CodeData[] projectFunctions) {
        if (className == null && this.projectModel != null) {
            String rv = this.getFunctionReturnType(propertyName, functions);
            if (rv == null) {
                rv = this.getFunctionReturnType(propertyName, projectFunctions);
            }
            return rv;
        }
        String rv = this.innerGetPropertyType(className, propertyName, classes, functions);
        if (rv == null && this.projectModel != null) {
            rv = this.innerGetPropertyType(className, propertyName, projectClasses, projectFunctions);
        }
        return rv;
    }

    private String innerGetPropertyType(String className, String propertyName, CodeData[] classes, CodeData[] functions) {
        return this.innerGetPropertyType(className, propertyName, classes, functions, new HashMap<String, String>());
    }

    private String innerGetPropertyType(String className, String propertyName, CodeData[] classes, CodeData[] functions, Map<String, String> subClasses) {
        CodeData[] codeDataArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            CodeData element = codeDataArray[n2];
            PHPClassData currClass = (PHPClassData)element;
            if (currClass.getName().equals(className)) {
                String rv;
                if (propertyName.charAt(0) == '*') {
                    CodeData[] classVars = currClass.getVars();
                    rv = this.getVariableType(propertyName.substring(1), classVars);
                } else {
                    CodeData[] classFunctions = currClass.getFunctions();
                    rv = this.getFunctionReturnType(propertyName, classFunctions);
                }
                if (rv == null && currClass.getSuperClassData() != null) {
                    String superClassName = currClass.getSuperClassData().getName();
                    if (subClasses.containsKey(superClassName)) {
                        return null;
                    }
                    subClasses.put(className, className);
                    rv = this.innerGetPropertyType(superClassName, propertyName, classes, functions, subClasses);
                }
                return rv;
            }
            ++n2;
        }
        return null;
    }

    private String getFunctionReturnType(String functionName, CodeData[] functions) {
        CodeData[] codeDataArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            CodeData element = codeDataArray[n2];
            PHPFunctionData phpFunctionData = (PHPFunctionData)element;
            if (functionName.equals(phpFunctionData.getName())) {
                String returnType = phpFunctionData.getReturnType();
                if (returnType.equals("void") || returnType.equals("unknown")) {
                    return "-";
                }
                return returnType;
            }
            ++n2;
        }
        return null;
    }

    private String getVariableType(String variableName, CodeData[] variables) {
        CodeData[] codeDataArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            CodeData element = codeDataArray[n2];
            PHPClassVarData classVarData = (PHPClassVarData)element;
            if (variableName.equals(classVarData.getName())) {
                String returnType = classVarData.getClassType();
                if (returnType != null && returnType.equals("unknown")) {
                    return "-";
                }
                return returnType;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void handlePHPStart(int startOffset, int endOffset) {
        this.phpTags.add(PHPCodeDataFactory.createUserData(this.workingFileName, startOffset, endOffset, endOffset, 0));
    }

    @Override
    public void handlePHPEnd(int startOffset, int endOffset) {
        this.phpTags.add(PHPCodeDataFactory.createUserData(this.workingFileName, startOffset, endOffset, startOffset, 0));
    }

    @Override
    public void setFirstDocBlock(PHPDocBlock docBlock) {
        this.firstPHPDocBlock = docBlock;
    }

    public PHPDocBlock getFirstDocBlock() {
        return this.firstPHPDocBlock;
    }

    @Override
    public void handleDefine(String name, String value, PHPDocBlock docInfo, int startPosition, int endPosition, int stopPosition) {
        char chr = name.charAt(0);
        if (chr == '\"' || chr == '\'') {
            name = name.substring(1);
        }
        if ((chr = name.charAt(name.length() - 1)) == '\"' || chr == '\'') {
            name = name.substring(0, name.length() - 1);
        }
        UserData userData = PHPCodeDataFactory.createUserData(this.workingFileName, startPosition, endPosition, stopPosition, 0);
        this.constants.add(PHPCodeDataFactory.createPHPConstantData(name, value, userData, docInfo));
    }

    @Override
    public void handleSyntaxError(int currToken, String currText, short[] rowOfProbe, int startPosition, int endPosition, int lineNumber) {
        boolean addUnexpected;
        String unexpectedString = "";
        if (currToken == this.getEOFTag()) {
            addUnexpected = true;
            unexpectedString = "End of File";
            startPosition = --endPosition;
        } else if (currToken == this.getCONSTANT_ENCAPSED_STRINGTag()) {
            addUnexpected = true;
            endPosition = startPosition + currText.trim().length();
            unexpectedString = "String";
        } else {
            boolean bl = addUnexpected = currText != null && currText.trim().length() > 0;
            if (addUnexpected) {
                unexpectedString = currText.trim();
                endPosition = startPosition + unexpectedString.length();
                unexpectedString = String.valueOf('\'') + unexpectedString + '\'';
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        int probe = 0;
        while (probe < rowOfProbe.length) {
            short curr = rowOfProbe[probe];
            String value = this.getConstantValue(curr);
            if (value != null && !value.equals("")) {
                list.add(value);
            }
            probe += 2;
        }
        int listSize = list.size();
        if (listSize > 3) {
            listSize = 0;
        }
        String description = "";
        if (!addUnexpected) {
            switch (listSize) {
                case 0: {
                    description = "Syntax Error";
                    break;
                }
                case 1: {
                    description = "Syntax Error: expecting: " + list.get(0);
                    break;
                }
                case 2: {
                    description = "Syntax Error: expecting: " + list.get(0) + " or " + list.get(1);
                    break;
                }
                case 3: {
                    description = "Syntax Error: expecting: " + list.get(0) + " or " + list.get(1) + " or " + list.get(2);
                }
            }
        } else {
            switch (listSize) {
                case 0: {
                    description = "Syntax Error: unexpected " + unexpectedString;
                    break;
                }
                case 1: {
                    description = "Syntax Error: unexpected " + unexpectedString + ", expecting: " + list.get(0);
                    break;
                }
                case 2: {
                    description = "Syntax Error: unexpected " + unexpectedString + ", expecting: " + list.get(0) + " or " + list.get(1);
                    break;
                }
                case 3: {
                    description = "Syntax Error: unexpected " + unexpectedString + ", expecting: " + list.get(0) + " or " + list.get(1) + " or " + list.get(2);
                }
            }
        }
        UserData userData = PHPCodeDataFactory.createUserData(this.workingFileName, startPosition, endPosition, startPosition, lineNumber);
        this.markers.add(new PHPMarker("ERROR", description, userData));
    }

    @Override
    public void handleTask(String taskName, String description, int startPosition, int endPosition, int lineNumber) {
        UserData userData = PHPCodeDataFactory.createUserData(this.workingFileName, startPosition, endPosition, startPosition, lineNumber);
        this.markers.add(new PHPTask(taskName, description, userData));
    }

    private String getConstantValue(int tag) {
        String rv = this.getError(tag);
        if (rv != null) {
            return String.valueOf('\'') + rv + '\'';
        }
        if (tag == this.getStringTag()) {
            return "Identifier";
        }
        if (tag == this.getVariableTag()) {
            return "Variable";
        }
        return null;
    }

    protected abstract String getError(int var1);

    protected abstract int getStringTag();

    protected abstract int getVariableTag();

    protected abstract int getEOFTag();

    protected abstract int getCONSTANT_ENCAPSED_STRINGTag();
}

