/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.util.ArrayList;
import org.eclipse.php.internal.core.phpModel.parser.CompositePhpModel;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModelFilterable;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;

public abstract class FilterableCompositePhpModel
extends CompositePhpModel
implements IPhpModelFilterable {
    private static final CodeData[] EMPTY = new CodeData[0];
    IPhpModelFilterable.IPhpModelFilter filter;

    public void addModel(IPhpModel newModel) {
        super.addModel(newModel);
    }

    public PHPClassData getClass(String fileName, String className) {
        PHPClassData exactElement = super.getClass(fileName, className);
        if (exactElement != null) {
            return exactElement;
        }
        CodeData[] allElements = this.getClass(className);
        if (allElements.length == 0 || allElements == null) {
            return null;
        }
        if (this.filter != null) {
            int j = 0;
            while (j < allElements.length) {
                if (this.filter.select(this, allElements[j], fileName)) {
                    return (PHPClassData)allElements[j];
                }
                ++j;
            }
        }
        return (PHPClassData)allElements[0];
    }

    public PHPConstantData getConstant(String fileName, String constantName) {
        PHPConstantData exactElement = super.getConstant(fileName, constantName);
        if (exactElement != null) {
            return exactElement;
        }
        CodeData[] allElements = this.getConstant(constantName);
        if (allElements.length == 0 || allElements == null) {
            return null;
        }
        if (this.filter != null) {
            int j = 0;
            while (j < allElements.length) {
                if (this.filter.select(this, allElements[j], fileName)) {
                    return (PHPConstantData)allElements[j];
                }
                ++j;
            }
        }
        return (PHPConstantData)allElements[0];
    }

    public PHPFunctionData getFunction(String fileName, String functionName) {
        PHPFunctionData exactElement = super.getFunction(fileName, functionName);
        if (exactElement != null) {
            return exactElement;
        }
        CodeData[] allElements = this.getFunction(functionName);
        if (allElements.length == 0 || allElements == null) {
            return null;
        }
        if (this.filter != null) {
            int j = 0;
            while (j < allElements.length) {
                if (this.filter.select(this, allElements[j], fileName)) {
                    return (PHPFunctionData)allElements[j];
                }
                ++j;
            }
        }
        return (PHPFunctionData)allElements[0];
    }

    public void setFilter(IPhpModelFilterable.IPhpModelFilter filter) {
        this.filter = filter;
    }

    public CodeData[] getFilteredClasses(String fileName, String className) {
        CodeData[] allElements = this.getClass(className);
        return this.selectElements(fileName, allElements);
    }

    public CodeData[] getFilteredConstants(String fileName, String constantName) {
        CodeData[] allElements = this.getConstant(constantName);
        return this.selectElements(fileName, allElements);
    }

    public CodeData[] getFilteredFunctions(String fileName, String functionName) {
        CodeData[] allElements = this.getFunction(functionName);
        return this.selectElements(fileName, allElements);
    }

    private CodeData[] selectElements(String fileName, CodeData[] allElements) {
        if (allElements == null || allElements.length == 0) {
            return EMPTY;
        }
        if (this.filter == null) {
            return allElements;
        }
        ArrayList<CodeData> filteredElements = new ArrayList<CodeData>();
        if (allElements != null && this.filter != null) {
            int j = 0;
            while (j < allElements.length) {
                if (this.filter.select(this, allElements[j], fileName)) {
                    filteredElements.add(allElements[j]);
                }
                ++j;
            }
        }
        if (filteredElements.size() != 0) {
            return filteredElements.toArray(new CodeData[filteredElements.size()]);
        }
        return allElements;
    }
}

