/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.php.core.documentModel.IWorkspaceModelListener;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.phpModel.parser.CompositePhpModel;
import org.eclipse.php.internal.core.phpModel.parser.ExternalFilesModel;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.IncludePathModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManagerProvider;
import org.eclipse.php.internal.core.phpModel.parser.PHPParserManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.parser.ParserClient;
import org.eclipse.php.internal.core.phpModel.parser.PhpModelProxy;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.IPhpProjectOptionChangeListener;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionChangedHandler;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.internal.core.project.properties.handlers.UseAspTagsHandler;
import org.eclipse.php.internal.core.util.DefaultCacheManager;
import org.eclipse.php.internal.core.util.IncludeCacheManager;

public class PHPIncludePathModelManager
extends PhpModelProxy
implements ExternalFilesModel {
    public static final String COMPOSITE_INCLUDE_PATH_MODEL_ID = "CompositeIncludePathModel";
    CompositePhpModel compositePhpModel = new CompositePhpModel(){

        public String getID() {
            return PHPIncludePathModelManager.COMPOSITE_INCLUDE_PATH_MODEL_ID;
        }

        public void initialize(IProject project) {
        }
    };
    private PHPParserManager parserManager;
    private String phpVersion;
    private ArrayList libraries;
    private ArrayList projects;
    private ArrayList variables;
    private String[] validExtensions;
    private IncludePathListener includePathListener;
    private PhpVersionListener phpVersionListener;
    private IProject project;
    private HashMap modelsToCache;
    private IncludeCacheManager includeCacheManager;
    private boolean initialized;
    private IResourceChangeListener projectResourcesListener;
    private List<IncludePathModelListener> modelListeners;

    public PHPIncludePathModelManager() {
        this.model = this.compositePhpModel;
        this.libraries = new ArrayList();
        this.projects = new ArrayList();
        this.variables = new ArrayList();
        this.modelsToCache = new HashMap();
    }

    public void addIncludePathModelListener(IncludePathModelListener listener) {
        if (this.modelListeners == null) {
            this.modelListeners = new ArrayList<IncludePathModelListener>(1);
            this.modelListeners.add(listener);
        } else if (!this.modelListeners.contains(listener)) {
            this.modelListeners.add(listener);
        }
    }

    public void removeIncludePathModelListener(IncludePathModelListener listener) {
        if (this.modelListeners == null) {
            return;
        }
        this.modelListeners.remove(listener);
    }

    public IPhpModel getModel(String id) {
        return this.compositePhpModel.getModel(id);
    }

    public void initialize(IProject project) {
        if (this.initialized) {
            if (project != this.project) {
                PHPCorePlugin.logErrorMessage("PHPIncludePathModelManager in already initialized with a different project.");
            }
            return;
        }
        this.includeCacheManager = DefaultCacheManager.instance().getIncludeCacheManager();
        this.project = project;
        this.initListeners();
        this.setPHPVersion(PhpVersionProjectPropertyHandler.getVersion(project));
        PHPProjectOptions options = PHPProjectOptions.forProject(project);
        if (options == null) {
            return;
        }
        IIncludePathEntry[] entries = options.readRawIncludePath();
        this.loadChanges(entries);
        ArrayList list = new ArrayList(this.variables);
        list.addAll(this.libraries);
        this.includeCacheManager.includePathChanged(project, this.getAsCachedNames(list));
        this.initialized = true;
    }

    public IPhpModel[] listModels() {
        return this.compositePhpModel.getModels();
    }

    private void addLibrary(File library) {
        if (this.getIndexOf(library) != -1) {
            return;
        }
        this.libraries.add(library);
        this.innerAddLibrary(library);
    }

    private void fireModelAdded(IPhpModel model) {
        if (this.modelListeners == null) {
            return;
        }
        for (IncludePathModelListener listener : this.modelListeners) {
            listener.includeModelAdded(model);
        }
    }

    private void innerAddLibrary(File library) {
        PHPIncludePathModel model = new PHPIncludePathModel(library.getPath(), PHPIncludePathModel.IncludePathModelType.LIBRARY);
        PHPLanguageManager languageManager = PHPLanguageManagerProvider.instance().getPHPLanguageManager(this.phpVersion);
        ParserClient client = languageManager.createParserClient(model, this.project);
        this.updateExtentionList();
        if (library.exists()) {
            PHPIncludePathModel cacheModel = new PHPIncludePathModel(library.getPath(), PHPIncludePathModel.IncludePathModelType.LIBRARY);
            DefaultCacheManager.instance().load(this.project, cacheModel, true);
            this.recursiveParse(library, client, model, cacheModel);
        }
        this.compositePhpModel.addModel(model);
        this.fireModelAdded(model);
    }

    private void recursiveParse(File folder, ParserClient client, PHPIncludePathModel model, PHPIncludePathModel cachedModel) {
        if (folder == null) {
            return;
        }
        File[] children = folder.listFiles();
        if (children == null) {
            return;
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.recursiveParse(file, client, model, cachedModel);
            } else if (file.isFile() && this.isPhpFile(file.getName())) {
                String fileName = file.getPath();
                PHPFileData fileData = cachedModel.getFileData(fileName);
                if (this.isValid(fileData, file)) {
                    model.insert(fileData);
                    cachedModel.delete(fileName);
                } else {
                    this.modelsToCache.put(model, model);
                    this.parse(file, client);
                }
            }
            ++n2;
        }
    }

    private boolean isValid(PHPFileData fileData, File file) {
        if (fileData != null && file != null) {
            return fileData.getCreationTimeLastModified() - file.lastModified() >= 0L;
        }
        return false;
    }

    private void parse(File file, ParserClient client) {
        try {
            FileReader fileReader = new FileReader(file);
            this.parserManager.parseNow(fileReader, file.getPath(), file.lastModified(), client, new Pattern[0], UseAspTagsHandler.useAspTagsAsPhp(this.project));
        }
        catch (FileNotFoundException e) {
            PHPCorePlugin.log(e);
            return;
        }
    }

    private boolean isPhpFile(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return false;
        }
        String ext = fileName.substring(index + 1);
        String[] stringArray = this.validExtensions;
        int n = this.validExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (ext.equals(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void removeLibrary(File library) {
        int index = this.getIndexOf(library);
        if (index == -1) {
            return;
        }
        this.libraries.remove(index);
        this.innerRemoveLibrary(library);
    }

    private void innerRemoveLibrary(File library) {
        IPhpModel removed = this.compositePhpModel.remove(library.getPath());
        if (removed != null) {
            this.modelsToCache.remove(removed);
            this.fireModelRemoved(removed);
        }
    }

    private void fireModelRemoved(IPhpModel removed) {
        if (this.modelListeners == null) {
            return;
        }
        for (IncludePathModelListener listener : this.modelListeners) {
            listener.includeModelRemoved(this.model);
        }
    }

    private void updatePHPVersion(String oldVersion, String newVersion) {
        IPhpModel[] models;
        this.setPHPVersion(newVersion);
        this.includeCacheManager.phpVersionChanged(this.project, oldVersion, newVersion);
        DefaultCacheManager cacheManager = DefaultCacheManager.instance();
        IPhpModel[] iPhpModelArray = models = this.compositePhpModel.getModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPhpModel element = iPhpModelArray[n2];
            File cacheFile = cacheManager.getSharedCacheFile(newVersion, element.getID());
            if (!cacheFile.exists()) {
                this.modelsToCache.put(element, element);
            } else {
                this.modelsToCache.remove(element);
            }
            ++n2;
        }
    }

    private void setPHPVersion(String phpVersion) {
        this.phpVersion = phpVersion;
        PHPLanguageManager languageManager = PHPLanguageManagerProvider.instance().getPHPLanguageManager(this.phpVersion);
        this.parserManager = languageManager.createPHPParserManager();
    }

    private int getIndexOf(File library) {
        int index = 0;
        String libraryName = library.getPath();
        for (File tmp : this.libraries) {
            if (tmp.getPath().equals(libraryName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void includePathChanged(IPath[] paths) {
        File[] newLibrariesList = new File[paths.length];
        int i = 0;
        while (i < paths.length) {
            newLibrariesList[i] = new File(paths[i].toString());
            this.addLibrary(newLibrariesList[i]);
            ++i;
        }
        ArrayList olds = this.libraries;
        File[] oldLibrariesList = new File[olds.size()];
        olds.toArray(oldLibrariesList);
        File[] fileArray = oldLibrariesList;
        int n = oldLibrariesList.length;
        int n2 = 0;
        while (n2 < n) {
            File element = fileArray[n2];
            String currPath = element.getPath();
            boolean found = false;
            File[] fileArray2 = newLibrariesList;
            int n3 = newLibrariesList.length;
            int n4 = 0;
            while (n4 < n3) {
                File element2 = fileArray2[n4];
                if (element2.getPath().equals(currPath)) {
                    found = true;
                    break;
                }
                ++n4;
            }
            if (!found) {
                this.removeLibrary(element);
            }
            ++n2;
        }
    }

    private void projectListChanged(IResource[] projects) {
        IResource[] iResourceArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            this.addProject(element);
            ++n2;
        }
        IResource[] oldProjectsList = new IResource[this.projects.size()];
        this.projects.toArray(oldProjectsList);
        IResource[] iResourceArray2 = oldProjectsList;
        int n3 = oldProjectsList.length;
        n = 0;
        while (n < n3) {
            IResource element = iResourceArray2[n];
            String currName = element.getName();
            boolean found = false;
            IResource[] iResourceArray3 = projects;
            int n4 = projects.length;
            int n5 = 0;
            while (n5 < n4) {
                IResource element2 = iResourceArray3[n5];
                if (element2.getName().equals(currName)) {
                    found = true;
                    break;
                }
                ++n5;
            }
            if (!found) {
                this.removeProject(element);
            }
            ++n;
        }
    }

    private void addProject(IResource project) {
        if (this.getIndexOf(project) != -1) {
            return;
        }
        this.projects.add(project);
        this.innerAddProject((IProject)project);
    }

    private void innerAddProject(IProject project) {
        PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
        IPhpModel userModel = null;
        userModel = projectModel == null ? new PHPUserModel() : projectModel.getModel(PHPUserModel.ID);
        ModelWrapper modelWrapper = new ModelWrapper(userModel);
        modelWrapper.initialize(project);
        this.compositePhpModel.addModel(modelWrapper);
    }

    public boolean removeProject(IResource project) {
        int index = this.getIndexOf(project);
        if (index == -1) {
            return false;
        }
        this.projects.remove(index);
        this.innerRemoveProject(project);
        return true;
    }

    private void innerRemoveProject(IResource project) {
        IPhpModel removed = this.compositePhpModel.remove(project.getName());
        ((ModelWrapper)removed).dispose();
    }

    private int getIndexOf(IResource project) {
        int index = 0;
        String projectName = project.getName();
        for (IResource tmp : this.projects) {
            if (tmp.getName().equals(projectName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void updateExtentionList() {
        IContentType type = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        this.validExtensions = type.getFileSpecs(8);
    }

    private void initListeners() {
        PHPProjectOptions options = PHPProjectOptions.forProject(this.project);
        if (options == null) {
            return;
        }
        this.includePathListener = new IncludePathListener();
        options.addOptionChangeListener("org.eclipse.php.core.includePath", this.includePathListener);
        this.phpVersionListener = new PhpVersionListener();
        PhpVersionChangedHandler.getInstance().addPhpVersionChangedListener(this.phpVersionListener);
        if (this.projectResourcesListener == null) {
            this.projectResourcesListener = new ProjectResourceChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.projectResourcesListener, 1);
        }
    }

    public void dispose() {
        IPath location;
        super.dispose();
        PHPProjectOptions options = PHPProjectOptions.forProject(this.project);
        if (options != null) {
            options.removeOptionChangeListener("org.eclipse.php.core.includePath", this.includePathListener);
        }
        PhpVersionChangedHandler.getInstance().removePhpVersionChangedListener(this.phpVersionListener);
        if (this.projectResourcesListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.projectResourcesListener);
            this.projectResourcesListener = null;
        }
        if ((location = this.project.getLocation()) != null) {
            for (IPhpModel model : this.modelsToCache.keySet()) {
                DefaultCacheManager.instance().save(this.project, model, true);
            }
        }
    }

    public void clear() {
        this.rebuild();
    }

    private void rebuild() {
        this.rebuildList(this.libraries);
        this.rebuildVariablesList();
    }

    private void rebuildList(ArrayList list) {
        for (File library : list) {
            this.innerRemoveLibrary(library);
            this.innerAddLibrary(library);
        }
    }

    private void rebuildVariablesList() {
        for (IPath variable : this.variables) {
            this.innerRemoveVariable(variable);
            this.innerAddVariable(variable);
        }
    }

    private void loadChanges(IIncludePathEntry[] entries) {
        ArrayList<IIncludePathEntry> liberaries = new ArrayList<IIncludePathEntry>();
        ArrayList<IIncludePathEntry> projectsList = new ArrayList<IIncludePathEntry>();
        ArrayList<IIncludePathEntry> variablesList = new ArrayList<IIncludePathEntry>();
        IIncludePathEntry[] iIncludePathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IIncludePathEntry element = iIncludePathEntryArray[n2];
            if (element.getEntryKind() == 1) {
                if (element.getContentKind() != 2) {
                    liberaries.add(element);
                }
            } else if (element.getEntryKind() == 2) {
                if (element.getResource() != null) {
                    projectsList.add(element);
                }
            } else if (element.getEntryKind() == 4) {
                variablesList.add(element);
            }
            ++n2;
        }
        IPath[] paths = new IPath[liberaries.size()];
        int i = 0;
        while (i < liberaries.size()) {
            paths[i] = ((IIncludePathEntry)liberaries.get(i)).getPath();
            ++i;
        }
        this.includePathChanged(paths);
        IResource[] projects = new IResource[projectsList.size()];
        int i2 = 0;
        while (i2 < projectsList.size()) {
            projects[i2] = ((IIncludePathEntry)projectsList.get(i2)).getResource();
            ++i2;
        }
        this.projectListChanged(projects);
        IPath[] variablespaths = new IPath[variablesList.size()];
        int i3 = 0;
        while (i3 < variablesList.size()) {
            variablespaths[i3] = ((IIncludePathEntry)variablesList.get(i3)).getPath();
            ++i3;
        }
        this.variablesListChanged(variablespaths);
    }

    private void variablesListChanged(IPath[] paths) {
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath element = iPathArray[n2];
            this.addVariable(element);
            ++n2;
        }
        IPath[] oldVariablesList = new IPath[this.variables.size()];
        this.variables.toArray(oldVariablesList);
        IPath[] iPathArray2 = oldVariablesList;
        int n3 = oldVariablesList.length;
        n = 0;
        while (n < n3) {
            IPath currVar = iPathArray2[n];
            boolean found = false;
            IPath[] iPathArray3 = paths;
            int n4 = paths.length;
            int n5 = 0;
            while (n5 < n4) {
                IPath element = iPathArray3[n5];
                if (element.equals((Object)currVar)) {
                    found = true;
                    break;
                }
                ++n5;
            }
            if (!found) {
                this.removeVariable(currVar);
            }
            ++n;
        }
        if (this.initialized) {
            ArrayList list = new ArrayList(this.variables);
            list.addAll(this.libraries);
            this.includeCacheManager.includePathChanged(this.project, this.getAsCachedNames(list));
        }
    }

    private List getAsCachedNames(List list) {
        ArrayList<String> newList = new ArrayList<String>(list.size());
        DefaultCacheManager cacheManager = DefaultCacheManager.instance();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof File) {
                newList.add(cacheManager.getSharedCacheFile(this.project, ((File)obj).getPath()).getName());
            } else if (obj instanceof IPath) {
                newList.add(cacheManager.getSharedCacheFile(this.project, ((IPath)obj).toFile().getPath()).getName());
            }
            ++i;
        }
        return newList;
    }

    private void addVariable(IPath variable) {
        if (this.variables.indexOf(variable) != -1) {
            return;
        }
        this.variables.add(variable);
        this.innerAddVariable(variable);
    }

    private void innerAddVariable(IPath variable) {
        this.updateExtentionList();
        String variableName = variable.toString();
        PHPIncludePathModel model = new PHPIncludePathModel(variableName, PHPIncludePathModel.IncludePathModelType.VARIABLE);
        PHPLanguageManager languageManager = PHPLanguageManagerProvider.instance().getPHPLanguageManager(this.phpVersion);
        ParserClient client = languageManager.createParserClient(model, this.project);
        File file = this.getVriableFile(variableName);
        if (file != null) {
            if (file.isDirectory()) {
                PHPIncludePathModel cachedModel = new PHPIncludePathModel(variableName, PHPIncludePathModel.IncludePathModelType.VARIABLE);
                DefaultCacheManager.instance().load(this.project, cachedModel, true);
                this.recursiveParse(file, client, model, cachedModel);
            } else {
                String fileName = file.getName();
                if (this.isPhpFile(fileName)) {
                    PHPIncludePathModel cachedModel = new PHPIncludePathModel(variableName, PHPIncludePathModel.IncludePathModelType.VARIABLE);
                    DefaultCacheManager.instance().load(this.project, cachedModel, true);
                    PHPFileData fileData = cachedModel.getFileData(fileName);
                    if (this.isValid(fileData, file)) {
                        model.insert(fileData);
                        cachedModel.delete(fileName);
                    } else {
                        this.modelsToCache.put(model, model);
                        this.parse(file, client);
                    }
                }
            }
        }
        this.compositePhpModel.addModel(model);
        this.fireModelAdded(model);
    }

    private File getVriableFile(String variableName) {
        IPath path;
        int index = variableName.indexOf(47);
        String extention = "";
        if (index != -1) {
            if (index + 1 < variableName.length()) {
                extention = variableName.substring(index + 1);
            }
            variableName = variableName.substring(0, index);
        }
        if ((path = PHPProjectOptions.getIncludePathVariable(variableName)) == null) {
            return null;
        }
        path = path.append(extention);
        return path.toFile();
    }

    private void removeVariable(IPath variable) {
        if (this.variables.remove(variable)) {
            this.innerRemoveVariable(variable);
        }
    }

    private void innerRemoveVariable(IPath variable) {
        IPhpModel model = this.compositePhpModel.remove(variable.toString());
        if (model != null) {
            this.fireModelRemoved(model);
        }
    }

    public Object getExternalResource(PHPFileData fileData) {
        IPhpModel[] models;
        IPhpModel[] iPhpModelArray = models = this.compositePhpModel.getModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPhpModel element = iPhpModelArray[n2];
            if (this.contains(element, fileData)) {
                File file;
                String resourceName = element.getID();
                Path path = new Path(resourceName);
                if (this.variables.indexOf(path) != -1) {
                    File variableFile = this.getVriableFile(resourceName);
                    if (variableFile == null) {
                        return null;
                    }
                    File file2 = new File(fileData.getName());
                    if (variableFile.isDirectory()) {
                        return file2;
                    }
                }
                if (this.getIndexOf(file = new File(resourceName)) != -1) {
                    return new File(fileData.getName());
                }
                return null;
            }
            ++n2;
        }
        return null;
    }

    private boolean contains(IPhpModel model, PHPFileData fileData) {
        return model.getFileData(fileData.getName()) != null;
    }

    public static PHPUserModel getUserModelForIncludeEntry(IIncludePathEntry entry, PHPProjectModel projectModel) {
        PHPProjectModel modelForProject;
        PHPUserModel userModel = null;
        PHPIncludePathModelManager includeManager = (PHPIncludePathModelManager)projectModel.getModel(COMPOSITE_INCLUDE_PATH_MODEL_ID);
        if (includeManager == null) {
            return null;
        }
        if (entry.getEntryKind() == 4) {
            userModel = (PHPUserModel)includeManager.getModel(entry.getPath().toString());
        } else if (entry.getEntryKind() == 1) {
            userModel = (PHPUserModel)includeManager.getModel(entry.getPath().toOSString());
        } else if (entry.getEntryKind() == 2 && (modelForProject = PHPWorkspaceModelManager.getInstance().getModelForProject((IProject)entry.getResource())) != null) {
            userModel = modelForProject.getPHPUserModel();
        }
        return userModel;
    }

    private class IncludePathListener
    implements IPhpProjectOptionChangeListener {
        private IncludePathListener() {
        }

        public void notifyOptionChanged(Object oldOption, Object newOption) {
            IIncludePathEntry[] entries = (IIncludePathEntry[])newOption;
            PHPIncludePathModelManager.this.loadChanges(entries);
        }
    }

    private class ModelWrapper
    extends PhpModelProxy {
        String id;
        IWorkspaceModelListener listener;

        ModelWrapper(IPhpModel model) {
            this.model = model;
        }

        public String getID() {
            return this.id;
        }

        public void initialize(IProject project) {
            this.id = project.getName();
            this.initListeners(project);
        }

        public void dispose() {
            PHPWorkspaceModelManager.getInstance().removeWorkspaceModelListener(this.id, this.listener);
        }

        private void initListeners(IProject project) {
            this.listener = new WorkspaceModelListener();
            PHPWorkspaceModelManager.getInstance().addWorkspaceModelListener(project.getName(), this.listener);
        }

        private void updateModelWrapper(IPhpModel model) {
            this.model = model;
        }

        private class WorkspaceModelListener
        implements IWorkspaceModelListener {
            private WorkspaceModelListener() {
            }

            public void projectModelAdded(IProject project) {
                this.updateModel(project);
            }

            public void projectModelRemoved(IProject project) {
                PHPUserModel model = new PHPUserModel();
                ModelWrapper.this.updateModelWrapper(model);
            }

            public void projectModelChanged(IProject project) {
            }

            private void updateModel(IProject project) {
                PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
                IPhpModel userModel = projectModel == null ? new PHPUserModel() : projectModel.getModel(PHPUserModel.ID);
                ModelWrapper.this.updateModelWrapper(userModel);
            }
        }
    }

    private class PhpVersionListener
    implements IPreferencesPropagatorListener {
        private PhpVersionListener() {
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            String newVersion = (String)event.getNewValue();
            String oldVersion = (String)event.getOldValue();
            if (oldVersion == null) {
                oldVersion = PreferencesSupport.getWorkspacePreferencesValue("phpVersion", PHPCorePlugin.getDefault().getPreferenceStore());
            }
            PHPIncludePathModelManager.this.updatePHPVersion(oldVersion, newVersion);
        }

        public IProject getProject() {
            return PHPIncludePathModelManager.this.project;
        }
    }

    private class ProjectResourceChangeListener
    implements IResourceChangeListener {
        private ProjectResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 1 && event.getSource() instanceof IWorkspace) {
                IResourceDelta[] affectedChildren;
                IResourceDelta[] iResourceDeltaArray = affectedChildren = event.getDelta().getAffectedChildren();
                int n = affectedChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta element = iResourceDeltaArray[n2];
                    if ((element.getFlags() & 0x2000) != 0) {
                        IProject projectMovedFrom = (IProject)element.getResource();
                        IProject projectMovedTo = ResourcesPlugin.getWorkspace().getRoot().getProject(element.getMovedToPath().lastSegment());
                        this.handleProjectRename(projectMovedFrom, projectMovedTo);
                    } else if (element.getKind() == 2) {
                        IProject removedProject = (IProject)element.getResource();
                        this.handleProjectDeletion((IResource)removedProject);
                    }
                    ++n2;
                }
            }
        }

        private void handleProjectRename(IProject from, IProject to) {
            if (from == PHPIncludePathModelManager.this.project) {
                this.handleProjectDeletion((IResource)from);
            } else {
                PHPProjectOptions options;
                boolean removed = PHPIncludePathModelManager.this.removeProject((IResource)from);
                if (removed) {
                    PHPIncludePathModelManager.this.addProject((IResource)to);
                }
                if ((options = PHPProjectOptions.forProject(PHPIncludePathModelManager.this.project)) == null) {
                    return;
                }
                options.renameResourceAtIncludePath((IResource)from, (IResource)to);
            }
        }

        private void handleProjectDeletion(IResource resource) {
            if (resource == PHPIncludePathModelManager.this.project) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(PHPIncludePathModelManager.this.projectResourcesListener);
                PHPIncludePathModelManager.this.projectResourcesListener = null;
                PHPIncludePathModelManager.this.includeCacheManager.projectRemoved((IProject)resource);
            } else {
                PHPIncludePathModelManager.this.removeProject(resource);
                PHPProjectOptions options = PHPProjectOptions.forProject(PHPIncludePathModelManager.this.project);
                if (options == null) {
                    return;
                }
                options.removeResourceFromIncludePath(resource);
            }
        }
    }
}

