/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.IPHPLanguageModel;
import org.eclipse.php.internal.core.phpModel.IPHPModelExtension;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPParserManager;
import org.eclipse.php.internal.core.phpModel.parser.ParserClient;
import org.eclipse.php.internal.core.phpModel.parser.ParserExecuter;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.osgi.framework.Bundle;

public abstract class PHPLanguageModel
implements IPHPLanguageModel {
    protected PHPFunctionData[] functions = PHPCodeDataFactory.EMPTY_FUNCTIONS_DATA_ARRAY;
    protected Map<String, PHPFunctionData> functionsHash = new HashMap<String, PHPFunctionData>(3000);
    protected PHPClassData[] classes = PHPCodeDataFactory.EMPTY_CLASS_DATA_ARRAY;
    protected Map<String, PHPClassData> classesHash = new HashMap<String, PHPClassData>(10);
    protected PHPConstantData[] constants = PHPCodeDataFactory.EMPTY_CONSTANT_DATA_ARRAY;
    protected IPHPMarker[] markers = PHPCodeDataFactory.EMPTY_MARKERS_DATA_ARRAY;
    protected PHPVariableData[] phpVariables;
    protected PHPVariableData[] serverVariables;
    protected PHPVariableData[] sessionVariables;
    protected PHPVariableData[] classVariables;
    private static final String TYPE_STRING = "string";
    private static final String TYPE_INT = "int";
    private static final String TYPE_BOOL = "bool";
    private static final String TYPE_OBJECT = "object";
    private static final String TYPE_MIXED = "mixed";
    private static final String TYPE_ARRAY = "array";
    private static final String TYPE_RESOURCE = "resource";
    private static final String TYPE_VOID = "void";

    public PHPLanguageModel(PHPLanguageManager languageManager) {
        this.loadFiles(languageManager);
        this.initVariables();
    }

    public PHPVariableData[] getPHPVariables() {
        return this.phpVariables;
    }

    public PHPVariableData[] getServerVariables() {
        return this.serverVariables;
    }

    public PHPVariableData[] getSessionVariables() {
        return this.sessionVariables;
    }

    public PHPVariableData[] getClassVariables() {
        return this.classVariables;
    }

    public CodeData[] getFunctions() {
        return this.functions;
    }

    public CodeData[] getFunction(String functionName) {
        PHPFunctionData function = this.getFunction(null, functionName);
        if (function == null) {
            return PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
        }
        return new PHPFunctionData[]{function};
    }

    public PHPFunctionData getFunction(String fileName, String functionName) {
        return this.functionsHash.get(functionName);
    }

    public CodeData[] getFunctions(String startsWith) {
        return ModelSupport.getCodeDataStartingWith(this.getFunctions(), startsWith);
    }

    public CodeData[] getClasses() {
        return this.classes;
    }

    public CodeData[] getClasses(String startsWith) {
        return ModelSupport.getCodeDataStartingWith(this.classes, startsWith);
    }

    public CodeData[] getConstants() {
        return this.constants;
    }

    public CodeData[] getConstants(String startsWith, boolean caseSensitive) {
        return caseSensitive ? ModelSupport.getCodeDataStartingWithCS(this.getConstants(), startsWith) : ModelSupport.getCodeDataStartingWith(this.getConstants(), startsWith);
    }

    public PHPConstantData getConstant(String fileName, String constantName) {
        return null;
    }

    public CodeData[] getFileDatas() {
        return null;
    }

    public CodeData[] getNonPHPFiles(String startsWith) {
        return null;
    }

    public PHPFileData getFileData(String fileName) {
        return null;
    }

    public PHPClassData getClass(String fileName, String className) {
        return this.classesHash.get(this.getNormalizedString(className));
    }

    public CodeData[] getClass(String className) {
        PHPClassData classs = this.getClass(null, className);
        if (classs == null) {
            return PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
        }
        return new CodeData[]{classs};
    }

    public CodeData[] getGlobalVariables(String fileName, String startsWith, boolean showVariablesFromOtherFiles) {
        return this.phpVariables;
    }

    public CodeData[] getVariables(String fileName, PHPCodeContext context, String startsWith, boolean showVariablesFromOtherFiles) {
        String className = context.getContainerClassName();
        if (className == null || className.equals("")) {
            return this.phpVariables;
        }
        return ModelSupport.merge(this.phpVariables, this.classVariables);
    }

    public String getVariableType(String fileName, PHPCodeContext context, String variableName, int line, boolean showObjectsFromOtherFiles) {
        return null;
    }

    public CodeData[] getConstant(String constantName) {
        return null;
    }

    public IPHPMarker[] getMarkers() {
        return this.markers;
    }

    public void clear() {
    }

    public void dispose() {
    }

    public void initialize(IProject project) {
    }

    private final String getNormalizedString(String name) {
        return name == null ? null : name.trim().toLowerCase();
    }

    private void initVariables() {
        this.phpVariables = new PHPVariableData[]{PHPCodeDataFactory.createPHPVariableData("_GET", null, null), PHPCodeDataFactory.createPHPVariableData("_POST", null, null), PHPCodeDataFactory.createPHPVariableData("_COOKIE", null, null), PHPCodeDataFactory.createPHPVariableData("_SESSION", null, null), PHPCodeDataFactory.createPHPVariableData("_SERVER", null, null), PHPCodeDataFactory.createPHPVariableData("_ENV", null, null), PHPCodeDataFactory.createPHPVariableData("_REQUEST", null, null), PHPCodeDataFactory.createPHPVariableData("_FILES", null, null), PHPCodeDataFactory.createPHPVariableData("GLOBALS", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_GET_VARS", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_POST_VARS", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_COOKIE_VARS", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_SESSION_VARS", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_SERVER_VARS", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_ENV_VARS", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_POST_FILES", null, null)};
        Arrays.sort(this.phpVariables);
        this.serverVariables = new PHPVariableData[]{PHPCodeDataFactory.createPHPVariableData("DOCUMENT_ROOT", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_ACCEPT", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_ACCEPT_ENCODING", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_ACCEPT_LANGUAGE", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_CONNECTION", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_HOST", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_USER_AGENT", null, null), PHPCodeDataFactory.createPHPVariableData("REMOTE_ADDR", null, null), PHPCodeDataFactory.createPHPVariableData("SCRIPT_FILENAME", null, null), PHPCodeDataFactory.createPHPVariableData("SERVER_NAME", null, null), PHPCodeDataFactory.createPHPVariableData("GATEWAY_INTERFACE", null, null), PHPCodeDataFactory.createPHPVariableData("REQUEST_METHOD", null, null), PHPCodeDataFactory.createPHPVariableData("QUERY_STRING", null, null), PHPCodeDataFactory.createPHPVariableData("REQUEST_URI", null, null), PHPCodeDataFactory.createPHPVariableData("SCRIPT_NAME", null, null), PHPCodeDataFactory.createPHPVariableData("PHP_SELF", null, null), PHPCodeDataFactory.createPHPVariableData("PATH", null, null), PHPCodeDataFactory.createPHPVariableData("REMOTE_PORT", null, null), PHPCodeDataFactory.createPHPVariableData("SERVER_ADDR", null, null), PHPCodeDataFactory.createPHPVariableData("SERVER_ADMIN", null, null), PHPCodeDataFactory.createPHPVariableData("SERVER_PORT", null, null), PHPCodeDataFactory.createPHPVariableData("SERVER_SIGNATURE", null, null), PHPCodeDataFactory.createPHPVariableData("SERVER_SOFTWARE", null, null), PHPCodeDataFactory.createPHPVariableData("SERVER_PROTOCOL", null, null), PHPCodeDataFactory.createPHPVariableData("PATH_TRANSLATED", null, null)};
        Arrays.sort(this.serverVariables);
        this.classVariables = new PHPVariableData[]{PHPCodeDataFactory.createPHPVariableData("this", null, null)};
        Arrays.sort(this.classVariables);
        this.sessionVariables = new PHPVariableData[]{PHPCodeDataFactory.createPHPVariableData("SID", null, null)};
    }

    protected void loadFiles(PHPLanguageManager languageManager) {
        try {
            IConfigurationElement[] elements;
            PHPParserManager phpParserManager = languageManager.createPHPParserManager();
            String phpFunctionPath = languageManager.getPHPFunctionPath();
            InputStreamReader reader = new InputStreamReader(FileLocator.openStream((Bundle)PHPCorePlugin.getDefault().getBundle(), (IPath)new Path(phpFunctionPath), (boolean)false));
            InnerParserClient innerParserClient = new InnerParserClient();
            ParserExecuter executer = new ParserExecuter(phpParserManager, null, innerParserClient, phpFunctionPath, reader, new Pattern[0], 0L, false);
            executer.run();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.php.core", "phpModelExtensions");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if ("model".equals(element.getName())) {
                    String id = element.getAttribute("id");
                    try {
                        String enabledAttr = element.getAttribute("enabled");
                        boolean enabled = enabledAttr == null ? true : Boolean.parseBoolean(enabledAttr);
                        String file = element.getAttribute("file");
                        String phpVersion = element.getAttribute("phpVersion");
                        if (element.getAttribute("class") != null) {
                            IPHPModelExtension extension = (IPHPModelExtension)element.createExecutableExtension("class");
                            enabled = extension.isEnabled();
                            if (extension.getFile() != null) {
                                file = extension.getFile();
                            }
                            if (extension.getPHPVersion() != null) {
                                phpVersion = extension.getPHPVersion();
                            }
                        }
                        if (enabled && this.getPHPVersion().equals(phpVersion)) {
                            reader = new InputStreamReader(FileLocator.openStream((Bundle)Platform.getBundle((String)element.getNamespaceIdentifier()), (IPath)new Path(file), (boolean)false));
                            innerParserClient = new InnerParserClient();
                            executer = new ParserExecuter(phpParserManager, null, innerParserClient, file, reader, new Pattern[0], 0L, false);
                            executer.run();
                        }
                    }
                    catch (CoreException coreException) {
                        PHPCorePlugin.logErrorMessage(NLS.bind((String)"Error loading PHP model extension ID {0}", (Object)id));
                    }
                }
                ++n2;
            }
            Arrays.sort(this.functions);
            Arrays.sort(this.classes);
            Arrays.sort(this.constants);
        }
        catch (IOException e) {
            PHPCorePlugin.log(e);
        }
    }

    protected class InnerParserClient
    implements ParserClient {
        private String className = "";
        private List<PHPFunctionData> functionsList = new ArrayList<PHPFunctionData>(3000);
        private List<PHPClassConstData> classConstsList = new ArrayList<PHPClassConstData>();
        private List<PHPClassVarData> classVarsList = new ArrayList<PHPClassVarData>();
        private List<PHPFunctionData> classFunctionsList = new ArrayList<PHPFunctionData>();
        private List<PHPClassData> classesList = new ArrayList<PHPClassData>();
        private List<PHPConstantData> constansList = new ArrayList<PHPConstantData>(2000);
        private List<PHPFunctionData.PHPFunctionParameter> functionParametersList = new ArrayList<PHPFunctionData.PHPFunctionParameter>();

        protected InnerParserClient() {
        }

        public void dispose() {
            this.functionsList.clear();
            this.classConstsList.clear();
            this.classVarsList.clear();
            this.classFunctionsList.clear();
            this.classesList.clear();
            this.constansList.clear();
            this.functionParametersList.clear();
        }

        public void handleFunctionParameter(String classType, String variableName, boolean isReference, boolean isConst, String defaultValue, int startPosition, int endPosition, int stopPosition, int lineNumber) {
            variableName = variableName.substring(1);
            this.functionParametersList.add(PHPCodeDataFactory.createPHPFunctionParameter(variableName, null, isReference, isConst, classType, defaultValue));
        }

        public void hadleClassDeclarationStarts(String className, int startPosition) {
            this.className = className;
        }

        private PHPFunctionData.PHPFunctionParameter getParameter(PHPFunctionData.PHPFunctionParameter[] parameters, String parameterName) {
            if (parameterName == null || parameterName.length() == 0) {
                return null;
            }
            if (parameterName.charAt(0) == '&') {
                parameterName = parameterName.substring(1);
            }
            if (parameterName.charAt(0) == '$') {
                parameterName = parameterName.substring(1);
            }
            PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                PHPFunctionData.PHPFunctionParameter element = pHPFunctionParameterArray[n2];
                if (parameterName.equalsIgnoreCase(element.getName())) {
                    return element;
                }
                ++n2;
            }
            return null;
        }

        public void handleFunctionDeclarationStarts(String functionName) {
        }

        public void handleFunctionDeclaration(String functionName, boolean isClassFunction, int modifier, PHPDocBlock docInfo, int startPosition, int stopPosition, int lineNumber) {
            PHPFunctionData.PHPFunctionParameter[] parameters = new PHPFunctionData.PHPFunctionParameter[this.functionParametersList.size()];
            this.functionParametersList.toArray(parameters);
            this.functionParametersList.clear();
            String returnType = null;
            if (docInfo != null) {
                Iterator<PHPDocTag> it = docInfo.getTags(7);
                while (it.hasNext()) {
                    PHPFunctionData.PHPFunctionParameter parameter;
                    PHPDocTag param = it.next();
                    String arg = param.getValue().trim();
                    String[] values = arg.split(" ");
                    String name = null;
                    String type = null;
                    int length = values.length > 2 ? 2 : values.length;
                    int i = 0;
                    while (i < length) {
                        if (values[i].startsWith("$")) {
                            name = values[i];
                        } else {
                            type = values[i];
                        }
                        ++i;
                    }
                    if (name == null) {
                        name = values[0];
                    }
                    if ((parameter = this.getParameter(parameters, name)) == null) {
                        type = values[0];
                        name = values.length > 1 ? values[1] : null;
                        parameter = this.getParameter(parameters, type);
                    }
                    if (parameter == null || type == null || type.length() <= 0) continue;
                    type = this.getType(type);
                    String originalClassType = parameter.getClassType();
                    if (originalClassType != null && originalClassType.length() != 0) continue;
                    parameter.setClassType(type);
                }
                Iterator<PHPDocTag> returnIt = docInfo.getTags(6);
                String string = returnType = returnIt.hasNext() ? returnIt.next().getValue() : null;
            }
            returnType = returnType == null ? (isClassFunction && functionName.equals(this.className) ? this.className : PHPLanguageModel.TYPE_VOID) : this.getType(returnType);
            PHPFunctionData functionData = PHPCodeDataFactory.createPHPFuctionData(functionName, modifier, docInfo, null, parameters, returnType);
            if (isClassFunction) {
                this.classFunctionsList.add(functionData);
            } else {
                this.functionsList.add(functionData);
            }
        }

        private String getType(String type) {
            if (PHPLanguageModel.TYPE_STRING.equals(type)) {
                return PHPLanguageModel.TYPE_STRING;
            }
            if (PHPLanguageModel.TYPE_INT.equals(type)) {
                return PHPLanguageModel.TYPE_INT;
            }
            if (PHPLanguageModel.TYPE_BOOL.equals(type)) {
                return PHPLanguageModel.TYPE_BOOL;
            }
            if (PHPLanguageModel.TYPE_RESOURCE.equals(type)) {
                return PHPLanguageModel.TYPE_RESOURCE;
            }
            if (PHPLanguageModel.TYPE_ARRAY.equals(type)) {
                return PHPLanguageModel.TYPE_ARRAY;
            }
            if (PHPLanguageModel.TYPE_MIXED.equals(type)) {
                return PHPLanguageModel.TYPE_MIXED;
            }
            if (PHPLanguageModel.TYPE_OBJECT.equals(type)) {
                return PHPLanguageModel.TYPE_OBJECT;
            }
            if (PHPLanguageModel.TYPE_VOID.equals(type)) {
                return PHPLanguageModel.TYPE_VOID;
            }
            return type;
        }

        public void handleFunctionDeclarationEnds(boolean isClassFunction, int endPosition) {
        }

        public void handleClassDeclaration(String className, int modifier, String superClassName, String interfacesNames, PHPDocBlock docInfo, int startPosition, int stopPosition, int lineNumber) {
            PHPClassData.PHPInterfaceNameData[] interfaces;
            PHPClassData.PHPSuperClassNameData superClassData;
            if (superClassName != null) {
                int index = superClassName.indexOf(93);
                superClassName = superClassName.substring(index + 1);
                superClassData = PHPCodeDataFactory.createPHPSuperClassNameData(superClassName, null);
            } else {
                superClassData = PHPCodeDataFactory.createPHPSuperClassNameData(superClassName, null);
            }
            if (interfacesNames != null) {
                String[] interfacesNamesArray = interfacesNames.split(",");
                interfaces = new PHPClassData.PHPInterfaceNameData[interfacesNamesArray.length];
                int i = 0;
                while (i < interfacesNamesArray.length) {
                    String interfaceName = interfacesNamesArray[i];
                    int index = interfaceName.indexOf(93);
                    interfaceName = interfaceName.substring(index + 1);
                    interfaces[i] = PHPCodeDataFactory.createPHPInterfaceNameData(interfaceName, null);
                    ++i;
                }
            } else {
                interfaces = PHPCodeDataFactory.EMPTY_INTERFACES_DATA_ARRAY;
            }
            PHPClassData classData = PHPCodeDataFactory.createPHPClassData(className, modifier, docInfo, null, superClassData, interfaces, PHPCodeDataFactory.EMPTY_CLASS_VAR_DATA_ARRAY, PHPCodeDataFactory.EMPTY_CLASS_CONST_DATA_ARRAY, PHPCodeDataFactory.EMPTY_FUNCTIONS_DATA_ARRAY);
            this.classesList.add(classData);
        }

        public void handleClassDeclarationEnds(String className, int endPosition) {
            PHPCodeDataFactory.PHPClassDataImp classData;
            if (this.classesList.size() > 0 && (classData = (PHPCodeDataFactory.PHPClassDataImp)this.classesList.get(this.classesList.size() - 1)).getName().equals(className)) {
                Object[] consts = new PHPClassConstData[this.classConstsList.size()];
                this.classConstsList.toArray(consts);
                Arrays.sort(consts);
                Object[] vars = new PHPClassVarData[this.classVarsList.size()];
                this.classVarsList.toArray(vars);
                Arrays.sort(vars);
                Object[] func = new PHPFunctionData[this.classFunctionsList.size()];
                this.classFunctionsList.toArray(func);
                Arrays.sort(func);
                int i = 0;
                while (i < consts.length) {
                    ((PHPCodeDataFactory.PHPClassConstDataImp)consts[i]).setContainer(classData);
                    ++i;
                }
                Object[] objectArray = vars;
                int n = vars.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    ((PHPCodeDataFactory.PHPClassVarDataImp)element).setContainer(classData);
                    ++n2;
                }
                objectArray = func;
                n = func.length;
                n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    ((PHPCodeDataFactory.PHPFunctionDataImp)element).setContainer(classData);
                    ++n2;
                }
                classData.setConsts((PHPClassConstData[])consts);
                classData.setFunctions((PHPFunctionData[])func);
                classData.setVars((PHPClassVarData[])vars);
            }
            this.classConstsList.clear();
            this.classVarsList.clear();
            this.classFunctionsList.clear();
            this.className = "";
        }

        public void handleClassVariablesDeclaration(String variables, int modifier, PHPDocBlock docInfo, int startPosition, int endPosition, int stopPosition) {
            String classType = null;
            if (docInfo != null) {
                Iterator<PHPDocTag> it = docInfo.getTags(12);
                while (it.hasNext()) {
                    PHPDocTag varTag = it.next();
                    String value = varTag.getValue().trim();
                    String[] values = value.split(" ");
                    classType = values[0];
                }
            }
            StringTokenizer t = new StringTokenizer(variables, ",", false);
            while (t.hasMoreTokens()) {
                String var = t.nextToken().substring(1);
                PHPClassVarData classVarData = PHPCodeDataFactory.createPHPClassVarData(var, modifier, classType, docInfo, null);
                this.handleObjectInstansiation(var, classType, null, 0, 0, false);
                this.classVarsList.add(classVarData);
            }
        }

        public void handleClassConstDeclaration(String constName, String value, PHPDocBlock docInfo, int startPosition, int endPosition, int stopPosition) {
            PHPClassConstData classConstData = PHPCodeDataFactory.createPHPClassConstData(constName, value, docInfo, null);
            this.classConstsList.add(classConstData);
        }

        public void handleIncludedFile(String includingType, String includeFileName, PHPDocBlock docInfo, int startPosition, int endPosition, int stopPosition, int lineNumber) {
        }

        public void haveReturnValue() {
        }

        public void handleObjectInstansiation(String variableName, String className, String ctorArrguments, int line, int startPosition, boolean isUserDocumentation) {
        }

        public void handleVariableName(String variableName, int line) {
        }

        public void handleGlobalVar(String variableName) {
        }

        public void handleStaticVar(String variableName) {
        }

        public void startParsing(String fileName) {
        }

        public void finishParsing(int lastPosition, int lastLine, long lastModified) {
            PHPFunctionData[] arrayFunctions = new PHPFunctionData[this.functionsList.size() + PHPLanguageModel.this.functions.length];
            this.functionsList.toArray(arrayFunctions);
            System.arraycopy(PHPLanguageModel.this.functions, 0, arrayFunctions, this.functionsList.size(), PHPLanguageModel.this.functions.length);
            PHPLanguageModel.this.functions = arrayFunctions;
            for (PHPFunctionData element : this.functionsList) {
                PHPLanguageModel.this.functionsHash.put(element.getName(), element);
            }
            PHPClassData[] arrayClasses = new PHPClassData[this.classesList.size() + PHPLanguageModel.this.classes.length];
            this.classesList.toArray(arrayClasses);
            System.arraycopy(PHPLanguageModel.this.classes, 0, arrayClasses, this.classesList.size(), PHPLanguageModel.this.classes.length);
            PHPLanguageModel.this.classes = arrayClasses;
            for (PHPClassData element : this.classesList) {
                PHPLanguageModel.this.classesHash.put(PHPLanguageModel.this.getNormalizedString(element.getName()), element);
            }
            PHPConstantData[] arrayConstants = new PHPConstantData[this.constansList.size() + PHPLanguageModel.this.constants.length];
            this.constansList.toArray(arrayConstants);
            System.arraycopy(PHPLanguageModel.this.constants, 0, arrayConstants, this.constansList.size(), PHPLanguageModel.this.constants.length);
            PHPLanguageModel.this.constants = arrayConstants;
        }

        public void handleDefine(String name, String value, PHPDocBlock docInfo, int startPosition, int endPosition, int stopPosition) {
            if (name.startsWith("\"") || name.startsWith("'")) {
                name = name.substring(1);
            }
            if (name.endsWith("\"") || name.endsWith("'")) {
                name = name.substring(0, name.length() - 1);
            }
            this.constansList.add(PHPCodeDataFactory.createPHPConstantData(name, value, null, docInfo));
        }

        public void handleError(String description, int startPosition, int endPosition, int lineNumber) {
        }

        public void handleSyntaxError(int currToken, String currText, short[] rowOfProbe, int startPosition, int endPosition, int lineNumber) {
        }

        public void handleTask(String taskName, String description, int startPosition, int endPosition, int lineNumber) {
        }

        public void handlePHPStart(int startOffset, int endOffset) {
        }

        public void handlePHPEnd(int startOffset, int endOffset) {
        }

        public void setFirstDocBlock(PHPDocBlock docBlock) {
        }
    }
}

