/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.phpModel.IPHPLanguageModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManagerProvider;
import org.eclipse.php.internal.core.phpModel.parser.PhpModelProxy;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionChangedHandler;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;

public class PHPLanguageModelManager
extends PhpModelProxy
implements IPHPLanguageModel {
    private IPHPLanguageModel languageModel;
    private IProject project;
    private PhpVersionListener phpVersionListener;

    public void initialize(IProject project) {
        this.project = project;
        String phpVersion = PhpVersionProjectPropertyHandler.getVersion(project);
        this.setVersion(phpVersion);
        this.phpVersionListener = new PhpVersionListener();
        PhpVersionChangedHandler.getInstance().addPhpVersionChangedListener(this.phpVersionListener);
    }

    private void setVersion(String phpVersion) {
        this.languageModel = (IPHPLanguageModel)PHPLanguageManagerProvider.instance().getPHPLanguageManager(phpVersion).getModel();
        this.model = this.languageModel;
    }

    public String getPHPVersion() {
        return this.languageModel.getPHPVersion();
    }

    public PHPKeywordData[] getKeywordData() {
        return this.languageModel.getKeywordData();
    }

    public PHPVariableData[] getServerVariables() {
        return this.languageModel.getServerVariables();
    }

    public PHPVariableData[] getSessionVariables() {
        return this.languageModel.getSessionVariables();
    }

    public PHPVariableData[] getPHPVariables() {
        return this.languageModel.getPHPVariables();
    }

    public void dispose() {
        super.dispose();
        PhpVersionChangedHandler.getInstance().removePhpVersionChangedListener(this.phpVersionListener);
        this.phpVersionListener = null;
    }

    public IPHPLanguageModel setDefaultLanguageModel() {
        this.setVersion(PhpVersionProjectPropertyHandler.getVersion());
        return this;
    }

    public CodeData[] getClass(String className) {
        return this.languageModel.getClass(className);
    }

    private class PhpVersionListener
    implements IPreferencesPropagatorListener {
        private PhpVersionListener() {
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            String newVersion = (String)event.getNewValue();
            PHPLanguageModelManager.this.setVersion(newVersion);
        }

        public IProject getProject() {
            return PHPLanguageModelManager.this.project;
        }
    }
}

