/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.phpModel.IPHPLanguageModel;
import org.eclipse.php.internal.core.phpModel.parser.ExternalFilesModel;
import org.eclipse.php.internal.core.phpModel.parser.FilterableCompositePhpModel;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.IPhpProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.IProjectModelListener;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;

public class PHPProjectModel
extends FilterableCompositePhpModel
implements IPhpProjectModel,
IAdaptable {
    private static String ID = "PHPProjectModel";
    private PHPUserModel userModel;
    private IPHPLanguageModel languageModel;
    private final Set<IProjectModelListener> listeners = new HashSet<IProjectModelListener>(2);
    private IProject currentProject;

    public void initialize() {
        this.languageModel = new PHPLanguageModelManager().setDefaultLanguageModel();
        this.addModel(this.languageModel);
    }

    public void initialize(IProject project) {
        this.currentProject = project;
        this.userModel = new PHPUserModel();
        this.userModel.initialize(project);
        this.addModel(this.userModel);
        this.languageModel = new PHPLanguageModelManager();
        this.languageModel.initialize(project);
        this.addModel(this.languageModel);
        if (project != null && project.isAccessible()) {
            PHPIncludePathModelManager includePathModel = new PHPIncludePathModelManager();
            includePathModel.initialize(project);
            this.addModel(includePathModel);
        }
        this.addModelListenrs();
    }

    public IProject getProject() {
        return this.currentProject;
    }

    public String getID() {
        return ID;
    }

    private void addModelListenrs() {
        IPhpModel[] models;
        IPhpModel[] iPhpModelArray = models = this.getModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPhpModel phpModel = iPhpModelArray[n2];
            if (phpModel instanceof IProjectModelListener) {
                this.addProjectModelListener((IProjectModelListener)((Object)phpModel));
            }
            ++n2;
        }
    }

    public PHPUserModel getPHPUserModel() {
        return this.userModel;
    }

    public IPHPLanguageModel getPHPLanguageModel() {
        return this.languageModel;
    }

    public Object getExternalResource(PHPFileData fileData) {
        IPhpModel[] models;
        IPhpModel[] iPhpModelArray = models = this.getModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            Object rv;
            IPhpModel element = iPhpModelArray[n2];
            if (element instanceof ExternalFilesModel && (rv = ((ExternalFilesModel)element).getExternalResource(fileData)) != null) {
                return rv;
            }
            ++n2;
        }
        return null;
    }

    public CodeData getActiveConstructor(String className, String fileName) {
        PHPClassData classData = this.getClass(fileName, className);
        CodeData constructorData = null;
        if (classData != null && (constructorData = this.getUserActiveConstructor(classData)) == null) {
            constructorData = classData.getConstructor();
        }
        return constructorData;
    }

    private CodeData getUserActiveConstructor(PHPClassData classData) {
        return this.getUserActiveConstructor(classData, new HashSet());
    }

    private CodeData getUserActiveConstructor(PHPClassData classData, HashSet subClasses) {
        if (classData == null) {
            return null;
        }
        if (classData.hasConstructor()) {
            return classData.getConstructor();
        }
        String superClass = classData.getSuperClassData().getName();
        if (superClass != null && !subClasses.contains(superClass)) {
            subClasses.add(classData.getName());
            String fileName = classData.isUserCode() ? classData.getUserData().getFileName() : "";
            return this.getUserActiveConstructor(this.getClass(fileName, superClass), subClasses);
        }
        return null;
    }

    public CodeData getClassFunctionData(String fileName, String className, String functionName) {
        return this.getClassFunctionData(fileName, className, functionName, new HashSet());
    }

    private CodeData getClassFunctionData(String fileName, String className, String functionName, HashSet subClasses) {
        PHPClassData classData = this.getClass(fileName, className);
        if (classData == null) {
            return null;
        }
        CodeData[] functions = classData.getFunctions();
        int index = ModelSupport.getFirstMatch(functions, functionName, true);
        if (index >= 0) {
            return functions[index];
        }
        String superClass = classData.getSuperClassData().getName();
        if (superClass != null && !subClasses.contains(superClass)) {
            subClasses.add(className);
            fileName = classData.isUserCode() ? classData.getUserData().getFileName() : "";
            return this.getClassFunctionData(fileName, superClass, functionName, subClasses);
        }
        return null;
    }

    public CodeData[] getClassFunctions(String fileName, String className, String startsWith) {
        return this.getClassFunctions(fileName, className, startsWith, new HashSet());
    }

    private CodeData[] getClassFunctions(String fileName, String className, String startsWith, HashSet subClasses) {
        PHPClassData classData = this.getClass(fileName, className);
        if (classData == null) {
            return null;
        }
        CodeData[] functions = ModelSupport.getCodeDataStartingWith(classData.getFunctions(), startsWith);
        CodeData[] superFunctions = new CodeData[]{};
        String superClass = classData.getSuperClassData().getName();
        if (superClass != null && !subClasses.contains(superClass)) {
            subClasses.add(className);
            fileName = classData.isUserCode() ? classData.getUserData().getFileName() : "";
            superFunctions = ModelSupport.getFilteredCodeData(this.getClassFunctions(fileName, superClass, startsWith, subClasses), ModelSupport.PROTECTED_ACCESS_LEVEL_FILTER);
        }
        return ModelSupport.removeRepeatedNames(ModelSupport.mergeNoDuplicates(functions, superFunctions));
    }

    public CodeData getClassVariablesData(String fileName, String className, String startsWith) {
        PHPClassVarData[] variables;
        PHPClassData classData = this.getClass(fileName, className);
        if (classData == null) {
            return null;
        }
        if (startsWith.startsWith("$")) {
            startsWith = startsWith.substring(1);
        }
        PHPClassVarData[] pHPClassVarDataArray = variables = classData.getVars();
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            PHPClassVarData element = pHPClassVarDataArray[n2];
            if (element.getName().equals(startsWith)) {
                return element;
            }
            ++n2;
        }
        String superClass = classData.getSuperClassData().getName();
        if (superClass != null) {
            fileName = classData.isUserCode() ? classData.getUserData().getFileName() : "";
            return this.getClassVariablesData(fileName, superClass, startsWith);
        }
        return null;
    }

    public CodeData[] getClassVariables(String fileName, String className, String startsWith) {
        return this.getClassVariables(fileName, className, startsWith, new HashSet());
    }

    private CodeData[] getClassVariables(String fileName, String className, String startsWith, HashSet subClasses) {
        PHPClassData classData = this.getClass(fileName, className);
        if (classData == null) {
            return null;
        }
        if (startsWith.startsWith("$")) {
            startsWith = startsWith.substring(1);
        }
        CodeData[] variables = ModelSupport.getCodeDataStartingWith(classData.getVars(), startsWith);
        CodeData[] superVariables = null;
        String superClass = classData.getSuperClassData().getName();
        if (superClass != null && !subClasses.contains(superClass)) {
            subClasses.add(className);
            fileName = classData.isUserCode() ? classData.getUserData().getFileName() : "";
            superVariables = ModelSupport.getFilteredCodeData(this.getClassVariables(fileName, superClass, startsWith, subClasses), ModelSupport.PROTECTED_ACCESS_LEVEL_FILTER);
        }
        return ModelSupport.merge(variables, superVariables);
    }

    public CodeData getClassConstsData(String fileName, String className, String constName) {
        return this.getClassConstsData(fileName, className, constName, new HashSet());
    }

    private CodeData getClassConstsData(String fileName, String className, String constName, HashSet subClasses) {
        PHPClassData.PHPInterfaceNameData[] interfacesNamesData;
        PHPClassConstData[] consts;
        PHPClassData classData = this.getClass(fileName, className);
        if (classData == null) {
            return null;
        }
        PHPClassConstData[] pHPClassConstDataArray = consts = classData.getConsts();
        int n = consts.length;
        int n2 = 0;
        while (n2 < n) {
            PHPClassConstData element = pHPClassConstDataArray[n2];
            if (element.getName().equals(constName)) {
                return element;
            }
            ++n2;
        }
        String superClass = classData.getSuperClassData().getName();
        if (superClass != null && !subClasses.contains(superClass)) {
            subClasses.add(className);
            fileName = classData.isUserCode() ? classData.getUserData().getFileName() : "";
            CodeData classConstsData = this.getClassConstsData(fileName, superClass, constName, subClasses);
            if (classConstsData != null) {
                return classConstsData;
            }
        }
        PHPClassData.PHPInterfaceNameData[] pHPInterfaceNameDataArray = interfacesNamesData = classData.getInterfacesNamesData();
        int n3 = interfacesNamesData.length;
        int n4 = 0;
        while (n4 < n3) {
            PHPClassData.PHPInterfaceNameData interfaceNameData = pHPInterfaceNameDataArray[n4];
            fileName = classData.isUserCode() ? classData.getUserData().getFileName() : "";
            CodeData classConstsData = this.getClassConstsData(fileName, interfaceNameData.getName(), constName);
            if (classConstsData != null) {
                return classConstsData;
            }
            ++n4;
        }
        return null;
    }

    public CodeData[] getClassConsts(String fileName, String className, String startsWith) {
        return this.getClassConsts(fileName, className, startsWith, new HashSet());
    }

    private CodeData[] getClassConsts(String fileName, String className, String startsWith, HashSet subClasses) {
        PHPClassData.PHPInterfaceNameData[] interfacesNamesData;
        PHPClassData classData = this.getClass(fileName, className);
        if (classData == null) {
            return new CodeData[0];
        }
        CodeData[] variables = ModelSupport.getCodeDataStartingWith(classData.getConsts(), startsWith);
        ArrayList superConsts = new ArrayList();
        String superClass = classData.getSuperClassData().getName();
        if (superClass != null && !subClasses.contains(superClass)) {
            subClasses.add(className);
            fileName = classData.isUserCode() ? classData.getUserData().getFileName() : "";
            superConsts.addAll(Arrays.asList(this.getClassConsts(fileName, superClass, startsWith, subClasses)));
        }
        PHPClassData.PHPInterfaceNameData[] pHPInterfaceNameDataArray = interfacesNamesData = classData.getInterfacesNamesData();
        int n = interfacesNamesData.length;
        int n2 = 0;
        while (n2 < n) {
            PHPClassData.PHPInterfaceNameData interfaceNameData = pHPInterfaceNameDataArray[n2];
            String interfaceName = interfaceNameData.getName();
            fileName = classData.isUserCode() ? classData.getUserData().getFileName() : "";
            superConsts.addAll(Arrays.asList(this.getClassConsts(fileName, interfaceName, startsWith)));
            ++n2;
        }
        return ModelSupport.merge(variables, superConsts.toArray(new CodeData[superConsts.size()]));
    }

    public String getSuperClassName(String fileName, String className) {
        PHPClassData classData = this.getClass(fileName, className);
        if (classData != null) {
            return classData.getSuperClassData().getName();
        }
        return null;
    }

    public CodeData[] getKeywordData() {
        return this.languageModel.getKeywordData();
    }

    public CodeData[] getKeywordData(String startsWith) {
        return ModelSupport.getCodeDataStartingWith(this.getKeywordData(), startsWith);
    }

    public CodeData[] getVariables(String fileName, PHPCodeContext context, String startsWith, boolean showVariablesFromOtherFiles) {
        return ModelSupport.removeRepeatedNames(super.getVariables(fileName, context, startsWith, showVariablesFromOtherFiles));
    }

    public CodeData[] getArrayVariables(String fileName, String arrayName, String startsWith, boolean showObjectsFromOtherFiles) {
        if (arrayName.equals("_SERVER") || arrayName.equals("HTTP_SERVER_VARS")) {
            return ModelSupport.getCodeDataStartingWith(this.languageModel.getServerVariables(), startsWith);
        }
        if (arrayName.equals("_SESSION") || arrayName.equals("HTTP_SESSION_VARS")) {
            return ModelSupport.getCodeDataStartingWith(this.languageModel.getSessionVariables(), startsWith);
        }
        if (arrayName.equals("GLOBALS")) {
            CodeData[] defaultArrayVariables = ModelSupport.getCodeDataStartingWith(this.languageModel.getPHPVariables(), startsWith);
            CodeData[] userArrayVariables = this.userModel.getGlobalVariables(fileName, startsWith, showObjectsFromOtherFiles);
            return ModelSupport.removeRepeatedNames(ModelSupport.merge(defaultArrayVariables, userArrayVariables));
        }
        return PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void addFileToModel(IFile file) {
        this.fireFileDataAdded(file);
    }

    public void removeFileFromModel(IFile file) {
        this.fireFileDataRemoved(file);
    }

    public void fileWasChanged(IFile file, IDocument sDocument) {
        this.fireFileChanged(file, sDocument);
    }

    public synchronized void addProjectModelListener(IProjectModelListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeProjectModelListener(IProjectModelListener l) {
        this.listeners.remove(l);
    }

    public synchronized IProjectModelListener[] getProjectModelListeners() {
        return this.listeners.toArray(new IProjectModelListener[this.listeners.size()]);
    }

    private void fireFileChanged(IFile file, IDocument sDocument) {
        IProjectModelListener[] projectModelListeners;
        IProjectModelListener[] iProjectModelListenerArray = projectModelListeners = this.getProjectModelListeners();
        int n = projectModelListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectModelListener projectModelListener = iProjectModelListenerArray[n2];
            projectModelListener.fileChanged(file, sDocument);
            ++n2;
        }
    }

    private void fireFileDataRemoved(IFile file) {
        IProjectModelListener[] projectModelListeners;
        IProjectModelListener[] iProjectModelListenerArray = projectModelListeners = this.getProjectModelListeners();
        int n = projectModelListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectModelListener projectModelListener = iProjectModelListenerArray[n2];
            projectModelListener.fileRemoved(file);
            ++n2;
        }
    }

    private void fireFileDataAdded(IFile file) {
        IProjectModelListener[] projectModelListeners;
        IProjectModelListener[] iProjectModelListenerArray = projectModelListeners = this.getProjectModelListeners();
        int n = projectModelListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectModelListener projectModelListener = iProjectModelListenerArray[n2];
            projectModelListener.fileAdded(file);
            ++n2;
        }
    }

    public boolean isBuildNeeded() {
        return this.userModel.isBuildNeeded();
    }
}

