/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.IProjectModelListener;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModelManager;
import org.eclipse.php.internal.core.phpModel.parser.codeDataDB.CodeDataDB;
import org.eclipse.php.internal.core.phpModel.parser.codeDataDB.FilesCodeDataDB;
import org.eclipse.php.internal.core.phpModel.parser.codeDataDB.GlobalVariablesCodeDataDB;
import org.eclipse.php.internal.core.phpModel.parser.codeDataDB.TreeCodeDataDB;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableTypeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariablesTypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPUserModel
implements IPhpModel,
IProjectModelListener {
    private static final CodeData[] EMPTY = new CodeData[0];
    public static String ID = "PHPUserModel";
    private FilesCodeDataDB phpFileDataDB;
    private CodeDataDB classesDB;
    private CodeDataDB functionsDB;
    private CodeDataDB constantsDB;
    private CodeDataDB globalsVariablesDB;
    private ILock lock;
    private List listeners = Collections.synchronizedList(new ArrayList(2));
    private PHPUserModelManager manager;

    public PHPUserModel() {
        this.phpFileDataDB = new FilesCodeDataDB();
        this.classesDB = new TreeCodeDataDB();
        this.functionsDB = new TreeCodeDataDB();
        this.constantsDB = new TreeCodeDataDB();
        this.globalsVariablesDB = new GlobalVariablesCodeDataDB();
        this.lock = Job.getJobManager().newLock();
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public void clear() {
        try {
            this.lock.acquire();
            this.phpFileDataDB.clear();
            this.classesDB.clear();
            this.functionsDB.clear();
            this.constantsDB.clear();
            this.globalsVariablesDB.clear();
            this.fireDataCleared();
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public CodeData[] getFileDatas() {
        List list = this.phpFileDataDB.asList();
        CodeData[] allFileData = new PHPFileData[list.size()];
        list.toArray(allFileData);
        return allFileData;
    }

    @Override
    public PHPFileData getFileData(String fileName) {
        return (PHPFileData)this.phpFileDataDB.getUniqCodeData(fileName);
    }

    public void insert(PHPFileData fileData) {
        try {
            boolean oldExists;
            this.lock.acquire();
            String fileName = fileData.getName();
            PHPFileData oldData = (PHPFileData)this.phpFileDataDB.getUniqCodeData(fileName);
            boolean bl = oldExists = oldData != null;
            if (oldExists) {
                this.delete(oldData);
            }
            this.phpFileDataDB.addCodeData(fileData);
            PHPClassData[] classes = fileData.getClasses();
            int i = 0;
            while (i < classes.length) {
                this.classesDB.addCodeData(classes[i]);
                ++i;
            }
            PHPFunctionData[] functions = fileData.getFunctions();
            int i2 = 0;
            while (i2 < functions.length) {
                this.functionsDB.addCodeData(functions[i2]);
                ++i2;
            }
            PHPConstantData[] constans = fileData.getConstants();
            int i3 = 0;
            while (i3 < constans.length) {
                this.constantsDB.addCodeData(constans[i3]);
                ++i3;
            }
            PHPVariableData[] globalsVariables = fileData.getVariableTypeManager().getVariables(ModelSupport.EMPTY_CONTEXT);
            if (globalsVariables != null) {
                int i4 = 0;
                while (i4 < globalsVariables.length) {
                    this.globalsVariablesDB.addCodeData(globalsVariables[i4]);
                    ++i4;
                }
            }
            if (oldExists) {
                this.fireFileDataChanged(fileData);
            } else {
                this.fireFileDataAdded(fileData);
            }
        }
        finally {
            this.lock.release();
        }
    }

    public void delete(String fileName) {
        try {
            this.lock.acquire();
            PHPFileData fileData = (PHPFileData)this.phpFileDataDB.getUniqCodeData(fileName);
            if (fileData != null) {
                this.delete(fileData);
                this.fireFileDataRemoved(fileData);
            }
        }
        finally {
            this.lock.release();
        }
    }

    protected void delete(PHPFileData fileData) {
        try {
            this.lock.acquire();
            PHPClassData[] classData = fileData.getClasses();
            int i = 0;
            while (i < classData.length) {
                this.classesDB.removeCodeData(classData[i]);
                ++i;
            }
            PHPFunctionData[] functionData = fileData.getFunctions();
            int i2 = 0;
            while (i2 < functionData.length) {
                this.functionsDB.removeCodeData(functionData[i2]);
                ++i2;
            }
            PHPConstantData[] constans = fileData.getConstants();
            int i3 = 0;
            while (i3 < constans.length) {
                this.constantsDB.removeCodeData(constans[i3]);
                ++i3;
            }
            PHPVariableData[] globalsVariables = fileData.getVariableTypeManager().getVariables(ModelSupport.EMPTY_CONTEXT);
            if (globalsVariables != null) {
                int i4 = 0;
                while (i4 < globalsVariables.length) {
                    this.globalsVariablesDB.removeCodeData(globalsVariables[i4]);
                    ++i4;
                }
            }
            this.phpFileDataDB.removeCodeData(fileData);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public CodeData[] getFunctions() {
        List list = this.functionsDB.asList();
        CodeData[] rv = new PHPFunctionData[list.size()];
        list.toArray(rv);
        return rv;
    }

    @Override
    public CodeData[] getFunction(String functionName) {
        Collection functions = this.functionsDB.getCodeData(functionName);
        if (functions == null || functions.size() == 0) {
            return PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
        }
        CodeData[] rv = new PHPFunctionData[functions.size()];
        functions.toArray(rv);
        return rv;
    }

    @Override
    public PHPFunctionData getFunction(String fileName, String functionName) {
        Collection functions = this.functionsDB.getCodeData(functionName);
        if (functions == null || functions.size() == 0) {
            return null;
        }
        for (PHPFunctionData curr : functions) {
            if (!curr.getUserData().getFileName().equals(fileName)) continue;
            return curr;
        }
        return (PHPFunctionData)functions.iterator().next();
    }

    @Override
    public CodeData[] getFunctions(String startsWith) {
        return ModelSupport.getCodeDataStartingWith(this.getFunctions(), startsWith);
    }

    @Override
    public CodeData[] getClasses() {
        List list = this.classesDB.asList();
        CodeData[] rv = new PHPClassData[list.size()];
        list.toArray(rv);
        return rv;
    }

    @Override
    public PHPClassData getClass(String fileName, String className) {
        Collection classes = this.classesDB.getCodeData(className);
        if (classes == null || classes.size() == 0) {
            return null;
        }
        for (PHPClassData curr : classes) {
            if (!curr.getUserData().getFileName().equals(fileName)) continue;
            return curr;
        }
        return (PHPClassData)classes.iterator().next();
    }

    @Override
    public CodeData[] getClass(String className) {
        Collection classes = this.classesDB.getCodeData(className);
        if (classes == null) {
            return PHPCodeDataFactory.EMPTY_CLASS_DATA_ARRAY;
        }
        return classes.toArray(new CodeData[classes.size()]);
    }

    @Override
    public CodeData[] getClasses(String startsWith) {
        return ModelSupport.getCodeDataStartingWith(this.getClasses(), startsWith);
    }

    @Override
    public CodeData[] getGlobalVariables(String fileName, String startsWith, boolean showVariablesFromOtherFiles) {
        if (!showVariablesFromOtherFiles) {
            PHPFileData fileData = this.getFileData(fileName);
            CodeData[] rv = null;
            if (fileData != null) {
                rv = fileData.getVariableTypeManager().getVariables(ModelSupport.EMPTY_CONTEXT);
            }
            if (rv == null) {
                rv = PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
            }
            return ModelSupport.getCodeDataStartingWith(rv, startsWith);
        }
        List list = this.globalsVariablesDB.asList();
        CodeData[] rv = new CodeData[list.size()];
        list.toArray(rv);
        return ModelSupport.getCodeDataStartingWith(rv, startsWith);
    }

    @Override
    public CodeData[] getVariables(String fileName, PHPCodeContext context, String startsWith, boolean showVariablesFromOtherFiles) {
        if (context.equals(ModelSupport.EMPTY_CONTEXT)) {
            return this.getGlobalVariables(fileName, startsWith, showVariablesFromOtherFiles);
        }
        PHPFileData fileData = this.getFileData(fileName);
        CodeData[] rv = null;
        if (fileData != null) {
            rv = fileData.getVariableTypeManager().getVariables(context);
        }
        if (rv == null) {
            rv = PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
        }
        return ModelSupport.getCodeDataStartingWith(rv, startsWith);
    }

    private String getClassVariableType(PHPClassData classData, String variableName, int line) {
        return this.innerGetClassVariableType(classData, variableName, line, new LinkedList<String>());
    }

    private String innerGetClassVariableType(PHPClassData classData, String variableName, int line, List<String> checkedClasses) {
        String superClassName;
        PHPCodeContext context;
        if (classData == null) {
            return null;
        }
        String fileName = classData.getUserData().getFileName();
        PHPFileData fileData = (PHPFileData)this.phpFileDataDB.getUniqCodeData(fileName);
        if (fileData == null) {
            return null;
        }
        PHPVariablesTypeManager variablesTypeManager = fileData.getVariableTypeManager();
        PHPVariableTypeData typeData = variablesTypeManager.getVariableTypeData(context = ModelSupport.createContext(classData.getName(), ""), variableName, line);
        if (typeData != null) {
            return typeData.getType();
        }
        checkedClasses.add(classData.getName());
        String string = superClassName = classData.getSuperClassData() != null ? classData.getSuperClassData().getName() : null;
        if (superClassName != null && !checkedClasses.contains(superClassName)) {
            String rv = this.innerGetClassVariableType(this.getClass(fileName, superClassName), variableName, line, checkedClasses);
            return rv;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVariableType(String fileName, PHPCodeContext context, String variableName, int line, boolean showObjectsFromOtherFiles) {
        List<PHPFileData> list;
        String classVariableType;
        PHPVariablesTypeManager variablesTypeManager;
        PHPVariableTypeData typeData;
        PHPFileData fileData22 = (PHPFileData)this.phpFileDataDB.getUniqCodeData(fileName);
        if (fileData22 == null) {
            return null;
        }
        if (variableName.length() > 0 && variableName.charAt(0) == '$') {
            variableName = variableName.substring(1);
        }
        if ((typeData = (variablesTypeManager = fileData22.getVariableTypeManager()).getVariableTypeData(context, variableName, line)) != null) {
            return typeData.getType();
        }
        String className = context.getContainerClassName();
        if (className != null && !className.equals("") && (classVariableType = this.getClassVariableType(this.getClass(fileName, className), variableName, line)) != null && classVariableType.length() > 0) {
            return classVariableType;
        }
        if (!context.equals(ModelSupport.EMPTY_CONTEXT)) {
            PHPVariableData variable = variablesTypeManager.getVariable(context, variableName);
            if (variable == null || !variable.isGlobal()) {
                return null;
            }
            context = ModelSupport.EMPTY_CONTEXT;
            typeData = variablesTypeManager.getVariableTypeData(context, variableName, fileData22.getUserData().getStopLine());
            if (typeData != null) {
                return typeData.getType();
            }
        }
        if (!showObjectsFromOtherFiles) {
            return null;
        }
        List<PHPFileData> list2 = list = Collections.synchronizedList(this.phpFileDataDB.asList());
        synchronized (list2) {
            for (PHPFileData fileData22 : list) {
                if (fileData22.getName().equals(fileName) || (typeData = (variablesTypeManager = fileData22.getVariableTypeManager()).getVariableTypeData(context, variableName, fileData22.getUserData().getStopLine())) == null) continue;
                return typeData.getType();
            }
        }
        return null;
    }

    @Override
    public CodeData[] getConstant(String constantName) {
        Collection constants = this.constantsDB.getCodeData(constantName);
        if (constants != null && constants.size() > 0) {
            return constants.toArray(new CodeData[constants.size()]);
        }
        return null;
    }

    @Override
    public PHPConstantData getConstant(String fileName, String constantName) {
        Collection constants = this.constantsDB.getCodeData(constantName);
        if (constants == null || constants.size() == 0) {
            return null;
        }
        for (PHPConstantData curr : constants) {
            if (!curr.getUserData().getFileName().equals(fileName)) continue;
            return curr;
        }
        return (PHPConstantData)constants.iterator().next();
    }

    @Override
    public CodeData[] getConstants() {
        List list = this.constantsDB.asList();
        CodeData[] rv = new PHPConstantData[list.size()];
        list.toArray(rv);
        return rv;
    }

    @Override
    public CodeData[] getConstants(String startsWith, boolean caseSensitive) {
        return caseSensitive ? ModelSupport.getCodeDataStartingWithCS(this.getConstants(), startsWith) : ModelSupport.getCodeDataStartingWith(this.getConstants(), startsWith);
    }

    @Override
    public IPHPMarker[] getMarkers() {
        return null;
    }

    public void addModelListener(ModelListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public List getModelListenerList() {
        return this.listeners;
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireFileDataChanged(PHPFileData fileData) {
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            ModelListener curr = (ModelListener)this.listeners.get(i);
            curr.fileDataChanged(fileData);
            ++i;
        }
    }

    private void fireFileDataRemoved(PHPFileData fileData) {
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            ModelListener curr = (ModelListener)this.listeners.get(i);
            curr.fileDataRemoved(fileData);
            ++i;
        }
    }

    private void fireFileDataAdded(PHPFileData fileData) {
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            ModelListener curr = (ModelListener)this.listeners.get(i);
            curr.fileDataAdded(fileData);
            ++i;
        }
    }

    private void fireDataCleared() {
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            ModelListener curr = (ModelListener)this.listeners.get(i);
            curr.dataCleared();
            ++i;
        }
    }

    @Override
    public void dispose() {
        if (this.manager != null) {
            this.manager.dispose();
            this.manager = null;
        }
    }

    @Override
    public void initialize(IProject project) {
        this.manager = new PHPUserModelManager(project, this);
    }

    @Override
    public void fileAdded(IFile file) {
    }

    @Override
    public void fileRemoved(IFile file) {
        this.manager.fileRemoved(file);
    }

    @Override
    public void fileChanged(IFile file, IDocument sDocument) {
    }

    public boolean isBuildNeeded() {
        return this.manager.isBuildNeeded();
    }
}

