/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.php.internal.core.phpModel.parser.IParserClientFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.parser.management.GlobalParsingManager;
import org.eclipse.php.internal.core.phpModel.parser.management.UserModelParserClientFactoryVersionDependent;
import org.eclipse.php.internal.core.util.DefaultCacheManager;

public class PHPUserModelManager {
    private final PHPUserModel userModel;
    private final IProject project;
    private IParserClientFactory parserClientFactory;
    private boolean buildNeeded = false;

    PHPUserModelManager(IProject project, PHPUserModel userModel) {
        boolean modelLoaded;
        this.project = project;
        this.userModel = userModel;
        this.parserClientFactory = new UserModelParserClientFactoryVersionDependent(this);
        GlobalParsingManager.getInstance().addParserClient(this.parserClientFactory, project);
        if (project.exists() && !(modelLoaded = DefaultCacheManager.instance().load(project, this.userModel, false))) {
            this.buildNeeded = true;
        }
    }

    public void dispose() {
        IPath location = this.project.getLocation();
        if (location == null) {
            return;
        }
        File file = location.toFile();
        if (file.exists()) {
            DefaultCacheManager.instance().save(this.project, this.userModel, false);
        }
        GlobalParsingManager.getInstance().removeParserClient(this.parserClientFactory, this.project);
        this.parserClientFactory.dispose();
        this.parserClientFactory = null;
    }

    public void fileRemoved(IFile file) {
        this.userModel.delete(file.getFullPath().toString());
    }

    public synchronized void clean() {
        this.userModel.clear();
    }

    public IProject getProject() {
        return this.project;
    }

    public PHPUserModel getUserModel() {
        return this.userModel;
    }

    public boolean isBuildNeeded() {
        if (this.buildNeeded) {
            this.buildNeeded = false;
            return true;
        }
        return false;
    }
}

