/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.core.documentModel.IWorkspaceModelListener;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.project.build.FullPhpProjectBuildVisitor;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.core.util.project.observer.IProjectClosedObserver;
import org.eclipse.php.internal.core.util.project.observer.ProjectRemovedObserversAttacher;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class PHPWorkspaceModelManager
implements ModelListener {
    protected static final PHPWorkspaceModelManager instance = new PHPWorkspaceModelManager();
    protected static final HashMap models = new HashMap();
    protected static PHPProjectModel defaultModel = new PHPProjectModel();
    private static final Set<ModelListener> modelListeners = new HashSet<ModelListener>(3);
    private static final Map workspaceModelListeners = Collections.synchronizedMap(new HashMap(2));
    private static final Set<IWorkspaceModelListener> globalWorkspaceModelListeners = new HashSet<IWorkspaceModelListener>(2);

    private PHPWorkspaceModelManager() {
    }

    public static PHPWorkspaceModelManager getInstance() {
        return instance;
    }

    public void startup() {
        this.initGlobalModelListeners();
        this.attachProjectOpenObserver();
        this.runBuild();
    }

    private void initGlobalModelListeners() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.core.workspaceModelListener");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("workspaceModelListener")) {
                WorkspaceModelListenerProxy modelListenerProxy = new WorkspaceModelListenerProxy(element);
                IWorkspaceModelListener listener = modelListenerProxy.getListener();
                this.addWorkspaceModelListener(listener);
            }
            ++n2;
        }
    }

    private void attachProjectOpenObserver() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta[] affectedChildren;
                IResourceDelta resourceDelta = event.getDelta();
                if (resourceDelta == null) {
                    return;
                }
                IResourceDelta[] iResourceDeltaArray = affectedChildren = resourceDelta.getAffectedChildren(4);
                int n = affectedChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta element;
                    resourceDelta = element = iResourceDeltaArray[n2];
                    IResource resource = resourceDelta.getResource();
                    IProject project = (IProject)resource;
                    int eventFlags = resourceDelta.getFlags();
                    if ((eventFlags & 0x4000) != 0 && project.isOpen()) {
                        try {
                            if (project.hasNature("org.eclipse.php.core.PHPNature")) {
                                PHPWorkspaceModelManager.this.runBuild(project);
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n2;
                }
            }
        });
    }

    public void runBuild(final IProject project) {
        WorkspaceJob cleanJob = new WorkspaceJob(NLS.bind((String)CoreMessages.getString("PHPWorkspaceModelManager_4"), (Object)project.getName())){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    PHPWorkspaceModelManager.getInstance().getModelForProject(project, true, false);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        cleanJob.setPriority(30);
        cleanJob.setUser(false);
        cleanJob.schedule();
    }

    private void runBuild() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        final ArrayList<IProject> phpProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                try {
                    if (project.hasNature("org.eclipse.php.core.PHPNature")) {
                        phpProjects.add(project);
                    }
                }
                catch (CoreException e) {
                    PHPCorePlugin.log(e);
                }
            }
            ++n2;
        }
        WorkspaceJob cleanJob = new WorkspaceJob(CoreMessages.getString("PHPWorkspaceModelManager_5")){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(CoreMessages.getString("PHPWorkspaceModelManager_5"), phpProjects.size());
                    for (IProject project : phpProjects) {
                        monitor.subTask(project.getName());
                        if (project.isOpen()) {
                            PHPWorkspaceModelManager.getInstance().getModelForProject(project, true, false);
                            if (monitor.isCanceled()) break;
                        }
                        monitor.worked(1);
                    }
                    instance.putModel(ExternalFilesRegistry.getInstance().getExternalFilesProject(), defaultModel, false);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        cleanJob.setPriority(30);
        cleanJob.setUser(false);
        cleanJob.schedule();
    }

    public void shutdown() {
        IProject[] projects;
        IProject[] iProjectArray = projects = this.listProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject element = iProjectArray[n2];
            this.removeModel(element);
            ++n2;
        }
    }

    public static final PHPProjectModel getDefaultPHPProjectModel() {
        return defaultModel;
    }

    public IProject getProjectForFileData(PHPFileData fileData, IProject defaultProject) {
        if (fileData == null) {
            return null;
        }
        IResource res = PHPModelUtil.getResource(fileData);
        if (res != null) {
            if (res instanceof ExternalFileWrapper) {
                return PHPWorkspaceModelManager.getDefaultPHPProjectModel().getProject();
            }
            IProject project = res.getProject();
            if (project.isAccessible()) {
                return project;
            }
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IProject> projects = new ArrayList<IProject>((Collection)Arrays.asList(root.getProjects()));
        if (defaultProject != null) {
            projects.remove(defaultProject);
            projects.add(0, defaultProject);
        }
        String filenameOS = new Path(fileData.getName()).toOSString();
        for (IProject project : projects) {
            PHPProjectModel model = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
            if (model == null || (fileData = model.getFileData(filenameOS)) == null) continue;
            return project;
        }
        return null;
    }

    public PHPFileData getModelForFile(String filename, boolean forceCreation) {
        IFile file;
        PHPProjectModel projModel;
        Path path = new Path(filename);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(path.segment(0));
        if (!project.isAccessible()) {
            project = null;
            projModel = null;
        } else {
            projModel = this.getModelForProject(project, forceCreation);
        }
        PHPFileData fileData = null;
        if (projModel == null) {
            IProject[] projects = root.getProjects();
            String filenameOS = new Path(filename).toOSString();
            int i = 0;
            while (i < projects.length) {
                PHPProjectModel model;
                project = projects[i];
                if (project.exists() && project.isAccessible() && (model = PHPWorkspaceModelManager.getInstance().getModelForProject(projects[i])) != null) {
                    String projectPath = "";
                    IPath location = projects[i].getLocation();
                    projectPath = location == null ? projects[i].getLocationURI().toString() : projects[i].getLocation().toOSString();
                    String modelFilename = filenameOS.startsWith(projectPath) ? new Path(StringUtils.replace((String)filenameOS, (String)projectPath, (String)"")).toPortableString() : filenameOS;
                    fileData = model.getFileData(modelFilename);
                    if (fileData != null) break;
                }
                ++i;
            }
        } else {
            fileData = projModel.getFileData(filename);
        }
        if (fileData == null && forceCreation && projModel != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path)).exists()) {
            this.addFileToModel(file);
            fileData = projModel.getFileData(filename);
        }
        return fileData;
    }

    private PHPFileData getModelForExternalFile(IFile externalFile) {
        if (!PHPModelUtil.isPhpFile(externalFile)) {
            return null;
        }
        PHPFileData fileData = null;
        PHPProjectModel externalProjectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel();
        fileData = externalProjectModel.getFileData(externalFile.getFullPath().toOSString());
        if (fileData == null) {
            externalProjectModel.addFileToModel(externalFile);
            fileData = externalProjectModel.getFileData(externalFile.getFullPath().toOSString());
        }
        return fileData;
    }

    public PHPFileData getModelForFile(IFile file, boolean forceCreation) {
        PHPProjectModel projModel = this.getModelForProject(file.getProject(), forceCreation);
        if (projModel == null) {
            if (file instanceof ExternalFileWrapper && ExternalFilesRegistry.getInstance().isEntryExist(file.getFullPath().toOSString())) {
                return this.getModelForExternalFile(file);
            }
            return null;
        }
        String filename = file.getFullPath().toString();
        PHPFileData fileData = projModel.getFileData(filename);
        if (fileData == null && forceCreation) {
            this.addFileToModel(file);
            fileData = projModel.getFileData(filename);
        }
        return fileData;
    }

    public PHPFileData getModelForFile(String filename) {
        IPath path = Path.fromOSString((String)filename);
        IFile file = ExternalFilesRegistry.getInstance().isEntryExist(path.toOSString()) ? ExternalFilesRegistry.getInstance().getFileEntry(path.toOSString()) : ExternalFileWrapper.createFile(path.toOSString());
        PHPFileData result = null;
        result = this.getModelForFile(filename, false);
        if (result == null && file != null && ExternalFilesRegistry.getInstance().isEntryExist(file)) {
            result = this.getModelForExternalFile(file);
        }
        return result;
    }

    public PHPProjectModel getModelForProject(IProject project, boolean forceCreation) {
        return this.getModelForProject(project, forceCreation, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PHPProjectModel getModelForProject(IProject project, boolean forceCreation, boolean fork) {
        PHPProjectModel projectModel = (PHPProjectModel)models.get(project);
        if (projectModel != null) return projectModel;
        if (!forceCreation) return projectModel;
        IProject iProject = project;
        synchronized (iProject) {
            projectModel = (PHPProjectModel)models.get(project);
            if (projectModel != null) return projectModel;
            if (project.isOpen() && project.exists() && project.isAccessible()) {
                boolean hasNature;
                try {
                    hasNature = project.hasNature("org.eclipse.rse.ui.remoteSystemsTempNature") || project.hasNature("org.eclipse.php.core.PHPNature");
                }
                catch (CoreException e) {
                    PHPCorePlugin.log(e);
                    return null;
                }
                if (!hasNature) return projectModel;
                projectModel = new PHPProjectModel();
                this.putModel(project, projectModel, fork);
                this.attachProjectCloseObserver(project);
            } else {
                if (project.exists()) return projectModel;
                if (!project.equals((Object)ExternalFilesRegistry.getInstance().getExternalFilesProject())) return projectModel;
                projectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel();
                this.putModel(project, projectModel, fork);
                this.attachProjectCloseObserver(project);
            }
            return projectModel;
        }
    }

    private void attachProjectCloseObserver(final IProject project) {
        ProjectRemovedObserversAttacher.getInstance().addProjectClosedObserver(project, new IProjectClosedObserver(){

            public void closed() {
                PHPWorkspaceModelManager.this.removeModel(project);
            }
        });
    }

    public PHPProjectModel getModelForProject(IProject project) {
        return this.getModelForProject(project, false);
    }

    public IProject getProjectForModel(PHPProjectModel model) {
        if (model.equals(PHPWorkspaceModelManager.getDefaultPHPProjectModel())) {
            return ExternalFilesRegistry.getInstance().getExternalFilesProject();
        }
        for (IProject project : models.keySet()) {
            PHPProjectModel projectModel = this.getModelForProject(project);
            if (!model.equals(projectModel)) continue;
            return project;
        }
        return null;
    }

    public IProject[] listProjects() {
        ArrayList<IProject> list = new ArrayList<IProject>();
        for (IProject project : models.keySet()) {
            if (!project.exists() || !project.isOpen()) continue;
            list.add(project);
        }
        IProject[] projects = list.toArray(new IProject[list.size()]);
        return projects;
    }

    public PHPProjectModel[] listModels() {
        int i = 0;
        PHPProjectModel[] projects = new PHPProjectModel[models.size()];
        Iterator iter = models.values().iterator();
        while (iter.hasNext()) {
            projects[i++] = (PHPProjectModel)iter.next();
        }
        return projects;
    }

    public void removeModel(IProject removedProject) {
        PHPProjectModel model = this.getModelForProject(removedProject);
        if (model != null) {
            model.getPHPUserModel().removeModelListener(this);
            model.dispose();
        }
        models.remove(removedProject);
        this.fireProjectModelRemoved(removedProject);
    }

    private void putModel(final IProject project, PHPProjectModel projectModel, boolean fork) {
        PHPProjectModel oldPhpProjectModel = (PHPProjectModel)models.get(project);
        models.put(project, projectModel);
        projectModel.initialize(project);
        if (oldPhpProjectModel == null) {
            projectModel.getPHPUserModel().addModelListener(this);
        } else {
            this.copyUserModelListeners(projectModel.getPHPUserModel(), oldPhpProjectModel.getPHPUserModel().getModelListenerList());
        }
        this.fireProjectModelAdded(project);
        if (projectModel.isBuildNeeded()) {
            if (fork) {
                WorkspaceJob buildJob = new WorkspaceJob(NLS.bind((String)CoreMessages.getString("PHPWorkspaceModelManager_4"), (Object)project.getName())){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        PHPWorkspaceModelManager.this.buildModel(monitor, project);
                        return Status.OK_STATUS;
                    }
                };
                buildJob.setUser(false);
                buildJob.schedule();
            } else {
                ProgressManager.JobMonitor monitor = ProgressManager.getInstance().progressFor(Job.getJobManager().currentJob());
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                this.buildModel((IProgressMonitor)monitor, project);
            }
        } else if (project.exists()) {
            this.fireProjectModelChanged(project);
        }
    }

    private void buildModel(IProgressMonitor monitor, IProject project) {
        try {
            try {
                FileCounter fc = new FileCounter();
                project.accept((IResourceVisitor)fc);
                monitor.beginTask(NLS.bind((String)CoreMessages.getString("PHPWorkspaceModelManager_4"), (Object)project.getName()), fc.numOfFiles);
                project.accept((IResourceVisitor)new FullPhpProjectBuildVisitor(monitor));
                this.fireProjectModelChanged(project);
            }
            catch (CoreException e) {
                Logger.logException(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void copyUserModelListeners(PHPUserModel newUserModel, List modelListenerList) {
        for (ModelListener modelListener : modelListenerList) {
            newUserModel.addModelListener(modelListener);
        }
    }

    public synchronized void addModelListener(ModelListener l) {
        modelListeners.add(l);
    }

    public synchronized void removeModelListener(ModelListener l) {
        modelListeners.remove(l);
    }

    private synchronized ModelListener[] getModelListenersIteratorCopy() {
        ModelListener[] iterator = new ModelListener[modelListeners.size()];
        modelListeners.toArray(iterator);
        return iterator;
    }

    public void fileDataChanged(PHPFileData fileData) {
        ModelListener[] iterator;
        ModelListener[] modelListenerArray = iterator = this.getModelListenersIteratorCopy();
        int n = iterator.length;
        int n2 = 0;
        while (n2 < n) {
            ModelListener element = modelListenerArray[n2];
            element.fileDataChanged(fileData);
            ++n2;
        }
    }

    public void fileDataAdded(PHPFileData fileData) {
        ModelListener[] iterator;
        ModelListener[] modelListenerArray = iterator = this.getModelListenersIteratorCopy();
        int n = iterator.length;
        int n2 = 0;
        while (n2 < n) {
            ModelListener element = modelListenerArray[n2];
            element.fileDataAdded(fileData);
            ++n2;
        }
    }

    public void fileDataRemoved(PHPFileData fileData) {
        ModelListener[] iterator;
        ModelListener[] modelListenerArray = iterator = this.getModelListenersIteratorCopy();
        int n = iterator.length;
        int n2 = 0;
        while (n2 < n) {
            ModelListener element = modelListenerArray[n2];
            element.fileDataRemoved(fileData);
            ++n2;
        }
    }

    public void dataCleared() {
        ModelListener[] iterator;
        ModelListener[] modelListenerArray = iterator = this.getModelListenersIteratorCopy();
        int n = iterator.length;
        int n2 = 0;
        while (n2 < n) {
            ModelListener element = modelListenerArray[n2];
            element.dataCleared();
            ++n2;
        }
    }

    public void addWorkspaceModelListener(String projectName, IWorkspaceModelListener l) {
        List<IWorkspaceModelListener> wlisteners = (List<IWorkspaceModelListener>)workspaceModelListeners.get(projectName);
        if (wlisteners == null) {
            wlisteners = Collections.synchronizedList(new ArrayList(2));
            workspaceModelListeners.put(projectName, wlisteners);
        }
        if (!wlisteners.contains(l)) {
            wlisteners.add(l);
        }
    }

    public void removeWorkspaceModelListener(String projectName, IWorkspaceModelListener l) {
        List wlisteners = (List)workspaceModelListeners.get(projectName);
        if (wlisteners == null) {
            return;
        }
        wlisteners.remove(l);
    }

    public void addFileToModel(IFile file) {
        if (!PHPModelUtil.isPhpFile(file)) {
            return;
        }
        PHPProjectModel projectModel = this.getModelForProject(file.getProject());
        if (projectModel != null) {
            projectModel.addFileToModel(file);
        }
    }

    public void removeFileFromModel(IFile file) {
        if (file == null) {
            return;
        }
        PHPProjectModel projectModel = this.getModelForProject(file.getProject());
        if (projectModel == null && !file.exists() && (projectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel()).getFileData(file.getFullPath().toOSString()) == null) {
            return;
        }
        if (projectModel == null) {
            return;
        }
        projectModel.removeFileFromModel(file);
    }

    public synchronized void addWorkspaceModelListener(IWorkspaceModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Error registering IWorkspaceModelListener");
        }
        globalWorkspaceModelListeners.add(listener);
    }

    public synchronized void removeWorkspaceModelListener(IWorkspaceModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Error registering IWorkspaceModelListener");
        }
        globalWorkspaceModelListeners.remove(listener);
    }

    private synchronized IWorkspaceModelListener[] getGlobalWorkspaceModelListeners() {
        return globalWorkspaceModelListeners.toArray(new IWorkspaceModelListener[globalWorkspaceModelListeners.size()]);
    }

    public void fireProjectModelAdded(IProject project) {
        IWorkspaceModelListener[] globalListeners;
        IWorkspaceModelListener[] iWorkspaceModelListenerArray = globalListeners = this.getGlobalWorkspaceModelListeners();
        int n = globalListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkspaceModelListener workspaceModelListener = iWorkspaceModelListenerArray[n2];
            workspaceModelListener.projectModelAdded(project);
            ++n2;
        }
        List listenersList = (List)workspaceModelListeners.get(project.getName());
        if (listenersList == null) {
            return;
        }
        Object[] listeners = listenersList.toArray();
        int i = 0;
        while (i < listeners.length) {
            IWorkspaceModelListener listener = (IWorkspaceModelListener)listeners[i];
            listener.projectModelAdded(project);
            ++i;
        }
    }

    public void fireProjectModelRemoved(IProject project) {
        IWorkspaceModelListener[] globalListeners;
        IWorkspaceModelListener[] iWorkspaceModelListenerArray = globalListeners = this.getGlobalWorkspaceModelListeners();
        int n = globalListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkspaceModelListener workspaceModelListener = iWorkspaceModelListenerArray[n2];
            workspaceModelListener.projectModelRemoved(project);
            ++n2;
        }
        List listenersList = (List)workspaceModelListeners.get(project.getName());
        if (listenersList == null) {
            return;
        }
        Object[] listeners = listenersList.toArray();
        int i = 0;
        while (i < listeners.length) {
            IWorkspaceModelListener listener = (IWorkspaceModelListener)listeners[i];
            listener.projectModelRemoved(project);
            ++i;
        }
    }

    public void fireProjectModelChanged(IProject project) {
        IWorkspaceModelListener[] globalListeners;
        IWorkspaceModelListener[] iWorkspaceModelListenerArray = globalListeners = this.getGlobalWorkspaceModelListeners();
        int n = globalListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkspaceModelListener workspaceModelListener = iWorkspaceModelListenerArray[n2];
            workspaceModelListener.projectModelChanged(project);
            ++n2;
        }
        List listenersList = (List)workspaceModelListeners.get(project.getName());
        if (listenersList == null) {
            return;
        }
        Object[] listeners = listenersList.toArray();
        int i = 0;
        while (i < listeners.length) {
            IWorkspaceModelListener listener = (IWorkspaceModelListener)listeners[i];
            listener.projectModelChanged(project);
            ++i;
        }
    }

    class FileCounter
    implements IResourceVisitor {
        public int numOfFiles = 0;

        FileCounter() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1) {
                ++this.numOfFiles;
                return false;
            }
            return true;
        }
    }

    private class WorkspaceModelListenerProxy {
        private final IConfigurationElement element;
        private IWorkspaceModelListener listener;

        public WorkspaceModelListenerProxy(IConfigurationElement element) {
            this.element = element;
        }

        public IWorkspaceModelListener getListener() {
            if (this.listener == null) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable("Error creation PhpModel for extension-point org.eclipse.php.internal.core.workspaceModelListener"){

                    public void run() throws Exception {
                        WorkspaceModelListenerProxy.this.listener = (IWorkspaceModelListener)WorkspaceModelListenerProxy.this.element.createExecutableExtension("class");
                    }
                });
            }
            return this.listener;
        }
    }
}

