/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.phpElementData;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocTag;

public class PHPDocBlockImp
implements PHPDocBlock {
    private static final String EMPTY = "";
    private static final String DEFAULT_DESCRIPTION_TEXT = "Enter description here...";
    private String shortDescription;
    private String longDescription;
    private PHPDocTag[] tags;
    private int type;
    private int startPosition;
    private int endPosition;

    public PHPDocBlockImp(String shortDescription, String longDescription, PHPDocTag[] tags, int type) {
        this.shortDescription = shortDescription;
        this.longDescription = longDescription;
        this.tags = tags;
        this.type = type;
    }

    public String getShortDescription() {
        if (this.shortDescription == null) {
            return DEFAULT_DESCRIPTION_TEXT;
        }
        return this.shortDescription;
    }

    public String getLongDescription() {
        if (this.longDescription == null) {
            return EMPTY;
        }
        return this.longDescription;
    }

    public PHPDocTag[] getTagsAsArray() {
        return this.tags;
    }

    public Iterator getTags() {
        return this.tags != null ? Arrays.asList(this.tags).iterator() : null;
    }

    public Iterator getTags(int id) {
        if (this.tags == null) {
            return null;
        }
        ArrayList<PHPDocTag> rv = new ArrayList<PHPDocTag>(this.tags.length);
        int i = 0;
        while (i < this.tags.length) {
            PHPDocTag tag = this.tags[i];
            if (tag.getID() == id) {
                rv.add(tag);
            }
            ++i;
        }
        return rv.iterator();
    }

    public int getType() {
        return this.type;
    }

    public void setStartPosition(int value) {
        this.startPosition = value;
    }

    public void setEndPosition(int value) {
        this.endPosition = value;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public boolean containsPosition(int position) {
        return position > this.getStartPosition() && position <= this.getEndPosition();
    }

    public boolean hasTagOf(int id) {
        Iterator tagsOf = this.getTags(id);
        return tagsOf != null && tagsOf.hasNext();
    }
}

