/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.phpElementData;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.parser.CompletionLexer;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.parser.ParserClient;
import org.eclipse.php.internal.core.phpModel.parser.PhpParser;
import org.eclipse.php.internal.core.phpModel.parser.php4.CompletionLexer4;
import org.eclipse.php.internal.core.phpModel.parser.php4.PHP4DefaultParserClient;
import org.eclipse.php.internal.core.phpModel.parser.php4.PhpParser4;
import org.eclipse.php.internal.core.phpModel.parser.php5.CompletionLexer5;
import org.eclipse.php.internal.core.phpModel.parser.php5.PHP5DefaultParserClient;
import org.eclipse.php.internal.core.phpModel.parser.php5.PhpParser5;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.preferences.TaskPatternsProvider;
import org.eclipse.php.internal.core.project.properties.handlers.UseAspTagsHandler;

public final class PHPFileDataUtilities {
    private static final IPreferenceStore store = PHPCorePlugin.getDefault().getPreferenceStore();
    private static final PreferencesSupport preferencesSupport = new PreferencesSupport("org.eclipse.php.core", store);

    private PHPFileDataUtilities() {
    }

    public static CodeData getCodeData(PHPFileData fileData, int position) {
        if (position < 0 || fileData == null) {
            return null;
        }
        PHPClassData[] classes = fileData.getClasses();
        CodeData classRv = null;
        CodeData functionRv = null;
        int i = 0;
        while (i < classes.length) {
            block17: {
                block19: {
                    block18: {
                        if (!PHPFileDataUtilities.contains(classes[i].getUserData(), position)) break block17;
                        if (classRv != null) break block18;
                        classRv = classes[i];
                        break block19;
                    }
                    if (!PHPFileDataUtilities.contains(classRv.getUserData(), classes[i].getUserData().getStartPosition())) break block17;
                    classRv = classes[i];
                    functionRv = null;
                }
                PHPFunctionData[] functions = classes[i].getFunctions();
                int j = 0;
                while (j < functions.length) {
                    if (PHPFileDataUtilities.contains(functions[j].getUserData(), position)) {
                        if (functionRv == null) {
                            functionRv = functions[j];
                        } else if (PHPFileDataUtilities.contains(functionRv.getUserData(), functions[j].getUserData().getStartPosition())) {
                            functionRv = functions[j];
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        PHPFunctionData[] functions = fileData.getFunctions();
        int j = 0;
        while (j < functions.length) {
            if (PHPFileDataUtilities.contains(functions[j].getUserData(), position)) {
                if (functionRv == null) {
                    functionRv = functions[j];
                } else if (PHPFileDataUtilities.contains(functionRv.getUserData(), functions[j].getUserData().getStartPosition())) {
                    functionRv = functions[j];
                }
            }
            ++j;
        }
        if (functionRv != null) {
            return functionRv;
        }
        if (classRv != null) {
            return classRv;
        }
        return null;
    }

    public static PHPClassData getContainerClassData(PHPFileData fileData, int position) {
        if (position < 0 || fileData == null) {
            return null;
        }
        PHPClassData[] classes = fileData.getClasses();
        int i = 0;
        while (i < classes.length) {
            if (PHPFileDataUtilities.contains(classes[i].getUserData(), position)) {
                return classes[i];
            }
            ++i;
        }
        return null;
    }

    private static boolean contains(UserData userData, int position) {
        return position > userData.getStartPosition() && position <= userData.getEndPosition();
    }

    public static int getPHPStart(int offset, PHPFileData fileData) {
        PHPBlock[] phpBlocks = fileData.getPHPBlocks();
        int i = phpBlocks.length - 1;
        while (i >= 0) {
            if (phpBlocks[i].getPHPStartTag().getStartPosition() < offset) {
                return phpBlocks[i].getPHPStartTag().getStartPosition();
            }
            --i;
        }
        return 0;
    }

    public static final String getVariableType(String fileName, String variableName, int position, int line, IPhpModel model, boolean showObjectsFromOtherFiles) {
        PHPFileData fileData = model.getFileData(fileName);
        if (fileData == null) {
            return null;
        }
        return PHPFileDataUtilities.getVariableType(fileData, variableName, position, line, model, showObjectsFromOtherFiles);
    }

    public static String getVariableType(PHPFileData fileData, String variableName, int position, int line, IPhpModel model, boolean showObjectsFromOtherFiles) {
        String className;
        if ("$this".equals(variableName)) {
            PHPClassData classData = PHPFileDataUtilities.getContainerClassData(fileData, position);
            if (classData != null) {
                className = classData.getName();
            } else {
                PHPCodeContext context = ModelSupport.createContext(fileData, position);
                className = model.getVariableType(fileData.getName(), context, variableName, line, false);
                if (className == null) {
                    className = "";
                }
            }
        } else {
            int currentLine = line + 1;
            PHPCodeContext context = ModelSupport.createContext(fileData, position);
            className = model.getVariableType(fileData.getName(), context, variableName, currentLine, showObjectsFromOtherFiles);
        }
        return className;
    }

    public static PHPFileData getFileData(Reader reader) {
        return PHPFileDataUtilities.getFileData(reader, null);
    }

    public static PHPFileData getFileData(Reader reader, IProject project) {
        Pattern[] tasksPatterns = TaskPatternsProvider.getInstance().getPetternsForWorkspace();
        boolean useAspTags = UseAspTagsHandler.useAspTagsAsPhp(project);
        String phpVersion = preferencesSupport.getPreferencesValue("phpVersion", "php5", project);
        return PHPFileDataUtilities.getFileData(reader, "tmp", 0L, phpVersion, tasksPatterns, useAspTags);
    }

    public static PHPFileData getFileData(Reader reader, String fileName, long lastModified, String phpVersion, Pattern[] tasksPatterns, boolean useAspTagsAsPhp) {
        PHPUserModel model;
        block41: {
            PhpParser phpParser = null;
            ParserClient client = null;
            model = new PHPUserModel();
            try {
                try {
                    CompletionLexer lexer = null;
                    if (phpVersion == "php5") {
                        lexer = new CompletionLexer5(reader);
                        phpParser = new PhpParser5();
                        client = new PHP5DefaultParserClient(model, null);
                    } else {
                        lexer = new CompletionLexer4(reader);
                        phpParser = new PhpParser4();
                        client = new PHP4DefaultParserClient(model, null);
                    }
                    lexer.setUseAspTagsAsPhp(useAspTagsAsPhp);
                    lexer.setParserClient(client);
                    lexer.setTasksPatterns(tasksPatterns);
                    phpParser.setScanner(lexer);
                    phpParser.setParserClient(client);
                    client.startParsing(fileName);
                    phpParser.parse();
                }
                catch (Exception e) {
                    Logger.logException(e);
                    try {
                        try {
                            if (client != null && phpParser != null) {
                                client.finishParsing(phpParser.getLength(), phpParser.getCurrentLine(), lastModified);
                            }
                        }
                        catch (Exception ex) {
                            Logger.logException(ex);
                            try {
                                reader.close();
                            }
                            catch (IOException exception) {
                                Logger.logException(exception);
                            }
                            break block41;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (IOException exception) {
                            Logger.logException(exception);
                        }
                        throw throwable;
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException exception) {
                        Logger.logException(exception);
                    }
                    break block41;
                }
            }
            catch (Throwable throwable) {
                block43: {
                    try {
                        try {
                            if (client != null && phpParser != null) {
                                client.finishParsing(phpParser.getLength(), phpParser.getCurrentLine(), lastModified);
                            }
                        }
                        catch (Exception ex) {
                            Logger.logException(ex);
                            try {
                                reader.close();
                            }
                            catch (IOException exception) {
                                Logger.logException(exception);
                            }
                            break block43;
                        }
                    }
                    catch (Throwable throwable2) {
                        try {
                            reader.close();
                        }
                        catch (IOException exception) {
                            Logger.logException(exception);
                        }
                        throw throwable2;
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException exception) {
                        Logger.logException(exception);
                    }
                }
                throw throwable;
            }
            try {
                try {
                    if (client != null && phpParser != null) {
                        client.finishParsing(phpParser.getLength(), phpParser.getCurrentLine(), lastModified);
                    }
                }
                catch (Exception ex) {
                    Logger.logException(ex);
                    try {
                        reader.close();
                    }
                    catch (IOException exception) {
                        Logger.logException(exception);
                    }
                    break block41;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (IOException exception) {
                    Logger.logException(exception);
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException exception) {
                Logger.logException(exception);
            }
        }
        PHPFileData fileData = model.getFileData(fileName);
        return fileData;
    }
}

