/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.preferences;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.preferences.AbstractPreferencesPropagator;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.ProjectPreferencesPropagator;
import org.osgi.service.prefs.Preferences;

public class PreferencesPropagator
extends AbstractPreferencesPropagator {
    private HashMap projectToPropagator;
    private HashMap projectToScope;
    private HashMap projectToNodeListener;
    private HashMap preferenceChangeListeners;
    private String nodeQualifier;
    private IPropertyChangeListener propertyChangeListener;
    private IPreferenceStore preferenceStore;

    protected PreferencesPropagator(String nodeQualifier, IPreferenceStore preferenceStore) {
        this.nodeQualifier = nodeQualifier;
        this.preferenceStore = preferenceStore;
        this.install();
    }

    public void addPropagatorListener(IPreferencesPropagatorListener listener, String preferencesKey) {
        this.addNodeListener(listener.getProject(), this.getProjectScope(listener.getProject()));
        if (this.isProjectSpecific(listener.getProject(), preferencesKey)) {
            this.addToProjectPropagator(listener, preferencesKey);
        } else {
            super.addPropagatorListener(listener, preferencesKey);
        }
    }

    public void removePropagatorListener(IPreferencesPropagatorListener listener, String preferencesKey) {
        if (this.isProjectSpecific(listener.getProject(), preferencesKey)) {
            this.removeFromProjectPropagator(listener, preferencesKey);
        } else {
            super.removePropagatorListener(listener, preferencesKey);
        }
    }

    public void setPropagatorListeners(List listeners, String preferencesKey) {
        super.setPropagatorListeners(listeners, preferencesKey);
    }

    protected synchronized void install() {
        if (this.isInstalled) {
            return;
        }
        this.projectToPropagator = new HashMap();
        this.projectToScope = new HashMap();
        this.projectToNodeListener = new HashMap();
        this.preferenceChangeListeners = new HashMap();
        this.propertyChangeListener = new InnerPropertyChangeListener();
        this.preferenceStore.addPropertyChangeListener(this.propertyChangeListener);
        super.install();
    }

    protected synchronized void uninstall() {
        if (!this.isInstalled) {
            return;
        }
        Iterator projects = this.projectToNodeListener.keySet().iterator();
        try {
            while (projects.hasNext()) {
                Object project = projects.next();
                ProjectScope scope = (ProjectScope)this.projectToScope.get(project);
                IEclipsePreferences node = scope.getNode(this.nodeQualifier);
                if (node == null) continue;
                node.removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this.projectToNodeListener.get(project));
            }
        }
        catch (Exception exception) {}
        Iterator propagators = this.projectToPropagator.values().iterator();
        while (propagators.hasNext()) {
            ((ProjectPreferencesPropagator)propagators.next()).uninstall();
        }
        this.preferenceChangeListeners = null;
        this.projectToScope = null;
        this.projectToPropagator = null;
        this.projectToNodeListener = null;
        super.uninstall();
    }

    private void addToProjectPropagator(IPreferencesPropagatorListener listener, String preferencesKey) {
        ProjectPreferencesPropagator propagator = (ProjectPreferencesPropagator)this.projectToPropagator.get(listener.getProject());
        if (propagator == null) {
            propagator = new ProjectPreferencesPropagator(listener.getProject(), this.nodeQualifier);
            this.projectToPropagator.put(listener.getProject(), propagator);
        }
        propagator.addPropagatorListener(listener, preferencesKey);
    }

    private void removeFromProjectPropagator(IPreferencesPropagatorListener listener, String preferencesKey) {
        ProjectPreferencesPropagator propagator = (ProjectPreferencesPropagator)this.projectToPropagator.get(listener.getProject());
        if (propagator != null) {
            propagator.removePropagatorListener(listener, preferencesKey);
        }
    }

    private boolean isProjectSpecific(IProject project, String preferencesKey) {
        ProjectScope projectScope = this.getProjectScope(project);
        return projectScope.getNode(this.nodeQualifier).get(preferencesKey, null) != null;
    }

    private ProjectScope getProjectScope(IProject project) {
        ProjectScope scope = (ProjectScope)this.projectToScope.get(project);
        if (scope == null) {
            scope = new ProjectScope(project);
            this.projectToScope.put(project, scope);
        }
        return scope;
    }

    private void addNodeListener(IProject project, ProjectScope projectScope) {
        if (this.projectToNodeListener.get(project) != null) {
            return;
        }
        IEclipsePreferences node = projectScope.getNode(this.nodeQualifier);
        if (node != null) {
            InnerNodeChangeListener nodeListener = new InnerNodeChangeListener(project);
            ((IEclipsePreferences)node.parent()).addNodeChangeListener((IEclipsePreferences.INodeChangeListener)nodeListener);
            this.projectToNodeListener.put(project, nodeListener);
            if (!this.preferenceChangeListeners.containsValue(node)) {
                NodePreferenceChangeListener changeListener = new NodePreferenceChangeListener(project);
                node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)changeListener);
                this.preferenceChangeListeners.put(changeListener, node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(PreferencesPropagatorEvent event, String propertyKey, IProject project) {
        Object object = this.lock;
        synchronized (object) {
            if (project != null) {
                ProjectPreferencesPropagator ppp = (ProjectPreferencesPropagator)this.projectToPropagator.get(project);
                if (ppp == null) {
                    ppp = new ProjectPreferencesPropagator(project, this.nodeQualifier);
                    this.projectToPropagator.put(project, ppp);
                }
                ppp.notifyPropagatorEvent(event);
            } else {
                List list = this.getPropagatorListeners(propertyKey);
                if (list == null) {
                    return;
                }
                IPreferencesPropagatorListener[] listeners = new IPreferencesPropagatorListener[list.size()];
                list.toArray(listeners);
                int i = 0;
                while (i < listeners.length) {
                    listeners[i].preferencesEventOccured(event);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveToProjectPropagator(String key, IProject project) {
        List list = null;
        IPreferencesPropagatorListener[] listeners = null;
        Object object = this.lock;
        synchronized (object) {
            list = this.getPropagatorListeners(key);
            if (list == null) {
                return;
            }
            listeners = new IPreferencesPropagatorListener[list.size()];
            list.toArray(listeners);
        }
        int i = 0;
        while (i < listeners.length) {
            IPreferencesPropagatorListener listener = listeners[i];
            if (project.equals((Object)listener.getProject())) {
                super.removePropagatorListener(listener, key);
                this.addToProjectPropagator(listener, key);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromProjectPropagator(String key, IProject project) {
        Object object = this.lock;
        synchronized (object) {
            List listeners;
            ProjectPreferencesPropagator propagator = (ProjectPreferencesPropagator)this.projectToPropagator.get(project);
            if (propagator != null && (listeners = propagator.removePropagatorListeners(key)) != null && listeners.size() > 0) {
                Iterator iter = listeners.iterator();
                while (iter.hasNext()) {
                    this.addPropagatorListener((IPreferencesPropagatorListener)iter.next(), key);
                }
            }
        }
    }

    private class InnerNodeChangeListener
    implements IEclipsePreferences.INodeChangeListener {
        private IProject project;

        public InnerNodeChangeListener(IProject project) {
            this.project = project;
        }

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            IEclipsePreferences pNode = null;
            if (!(event.getChild() instanceof IEclipsePreferences)) {
                return;
            }
            pNode = (IEclipsePreferences)event.getChild();
            if (!PreferencesPropagator.this.preferenceChangeListeners.containsValue(pNode)) {
                NodePreferenceChangeListener changeListener = new NodePreferenceChangeListener(this.project);
                pNode.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)changeListener);
                PreferencesPropagator.this.preferenceChangeListeners.put(changeListener, pNode);
            }
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            Preferences childNode = event.getChild();
            if (PreferencesPropagator.this.preferenceChangeListeners.containsValue(childNode)) {
                for (Object key : PreferencesPropagator.this.preferenceChangeListeners.keySet()) {
                    IEclipsePreferences aNode = (IEclipsePreferences)PreferencesPropagator.this.preferenceChangeListeners.get(key);
                    if (aNode != childNode) continue;
                    PreferencesPropagator.this.preferenceChangeListeners.remove(key);
                    return;
                }
            }
        }
    }

    private class InnerPropertyChangeListener
    implements IPropertyChangeListener {
        private InnerPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            PreferencesPropagatorEvent e = new PreferencesPropagatorEvent(event.getSource(), event.getOldValue(), event.getNewValue(), event.getProperty());
            PreferencesPropagator.this.notifyEvent(e, event.getProperty(), null);
        }
    }

    public class NodePreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private IProject project;

        public NodePreferenceChangeListener(IProject project) {
            this.project = project;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            String key = event.getKey();
            String newValue = (String)event.getNewValue();
            if (newValue == null) {
                PreferencesPropagator.this.removeFromProjectPropagator(key, this.project);
            } else {
                PreferencesPropagator.this.moveToProjectPropagator(key, this.project);
            }
            PreferencesPropagatorEvent e = new PreferencesPropagatorEvent(event.getSource(), event.getOldValue(), event.getNewValue(), event.getKey());
            PreferencesPropagator.this.notifyEvent(e, key, newValue == null ? null : this.project);
        }
    }
}

