/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.preferences;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.preferences.ITaskTagsListener;
import org.eclipse.php.internal.core.preferences.TaskTagsEvent;
import org.eclipse.php.internal.core.preferences.TaskTagsProvider;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;

public class TaskPatternsProvider {
    private static TaskPatternsProvider instance;
    private TaskTagsProvider provider = TaskTagsProvider.getInstance();
    private Pattern[] workspacePatterns;
    private HashMap projectsPatterns = new HashMap();
    private HashMap projectToListener = new HashMap();

    private TaskPatternsProvider() {
        this.initPatternsDB();
    }

    public static TaskPatternsProvider getInstance() {
        if (instance == null) {
            instance = new TaskPatternsProvider();
        }
        return instance;
    }

    public Pattern[] getPatternsForProject(IProject project) {
        this.registerProject(project);
        Pattern[] patterns = (Pattern[])this.projectsPatterns.get(project);
        if (patterns != null) {
            return patterns;
        }
        patterns = this.workspacePatterns;
        return patterns;
    }

    public Pattern[] getPetternsForWorkspace() {
        return this.workspacePatterns;
    }

    private void registerProject(IProject project) {
        if (this.projectToListener.get(project) == null) {
            TaskTag[] tags = this.provider.getProjectTaskTags(project);
            boolean caseSensitive = this.provider.getProjectTagsCaseSensitive(project);
            if (tags != null) {
                Pattern[] patterns = this.createPatterns(tags, caseSensitive);
                this.projectsPatterns.put(project, patterns);
            }
            TaskTagsListener tagsListener = new TaskTagsListener();
            this.provider.addTaskTagsListener(tagsListener, project);
            this.projectToListener.put(project, tagsListener);
        }
    }

    private void initPatternsDB() {
        this.workspacePatterns = this.createPatterns(this.provider.getWorkspaceTaskTags(), this.provider.isWorkspaceTagsCaseSensitive());
        IProject[] projects = PHPWorkspaceModelManager.getInstance().listProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            this.registerProject(project);
            ++i;
        }
    }

    private Pattern[] createPatterns(TaskTag[] workspaceTaskTags, boolean caseSensitive) {
        Pattern[] patterns = new Pattern[workspaceTaskTags.length];
        int i = 0;
        while (i < workspaceTaskTags.length) {
            TaskTag tag = workspaceTaskTags[i];
            String tagString = tag.getTag();
            patterns[i] = caseSensitive ? Pattern.compile(tagString) : Pattern.compile(tagString, 2);
            ++i;
        }
        return patterns;
    }

    private void taskTagsChanged(IProject project, TaskTag[] tags, boolean caseSensitive) {
        if (project == null) {
            this.workspacePatterns = this.createPatterns(tags, caseSensitive);
            return;
        }
        if (tags == null) {
            this.projectsPatterns.remove(project);
            return;
        }
        Pattern[] patterns = this.createPatterns(tags, caseSensitive);
        this.projectsPatterns.put(project, patterns);
    }

    private class TaskTagsListener
    implements ITaskTagsListener {
        private TaskTagsListener() {
        }

        public void taskTagsChanged(TaskTagsEvent event) {
            TaskPatternsProvider.this.taskTagsChanged(event.getProject(), event.getTaskTags(), event.isCaseSensitive());
        }

        public void taskPrioritiesChanged(TaskTagsEvent event) {
        }

        public void taskCaseChanged(TaskTagsEvent event) {
            TaskPatternsProvider.this.taskTagsChanged(event.getProject(), event.getTaskTags(), event.isCaseSensitive());
        }
    }
}

