/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;

public class PHPNature
implements IProjectNature {
    public static final String ID = "org.eclipse.php.core.PHPNature";
    public static final String PROJECTTYPE_VALUE = "PHP";
    public static final String VALIDATION_BUILDER_ID = "org.eclipse.php.core.ValidationManagerWrapper";
    protected IProject project;
    private ILock optionsLock = Job.getJobManager().newLock();
    protected PHPProjectOptions options;

    protected ICommand addToFrontOfBuildSpec(String builderID) throws CoreException {
        ICommand command = null;
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                found = true;
                command = commands[i];
                break;
            }
            ++i;
        }
        if (!found) {
            command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            IProjectDescription desc = this.getProject().getDescription();
            desc.setBuildSpec(newCommands);
            this.getProject().setDescription(desc, null);
        }
        return command;
    }

    public void createFile(IPath newFilePath, String newFileContents) throws CoreException {
        IPath projectPath = this.project.getFullPath();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.createFolder(newFilePath.removeLastSegments(1).toString());
        IFile outputFile = workspace.getRoot().getFile(projectPath.append(newFilePath));
        outputFile.refreshLocal(2, null);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(newFileContents.getBytes());
        if (!outputFile.exists()) {
            outputFile.create((InputStream)inputStream, true, null);
        }
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec("org.eclipse.php.core.PhpIncrementalProjectBuilder");
        this.removeFromBuildSpec(VALIDATION_BUILDER_ID);
        this.clean();
    }

    private void clean() {
        this.options = null;
        this.project = null;
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            IProjectDescription desc = this.getProject().getDescription();
            desc.setBuildSpec(newCommands);
            this.getProject().setDescription(desc, null);
        }
    }

    public void configure() throws CoreException {
        this.addToFrontOfBuildSpec(VALIDATION_BUILDER_ID);
        this.addToFrontOfBuildSpec("org.eclipse.php.core.PhpIncrementalProjectBuilder");
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject newProject) {
        this.clean();
        this.project = newProject;
    }

    public IFolder createFolder(String aProjectRelativePathString) throws CoreException {
        if (aProjectRelativePathString != null && aProjectRelativePathString.length() > 0) {
            return this.createFolder((IPath)new Path(aProjectRelativePathString));
        }
        return null;
    }

    public IFolder createFolder(IPath aProjectRelativePath) throws CoreException {
        if (aProjectRelativePath != null && !aProjectRelativePath.isEmpty()) {
            IFolder folder = this.getWorkspace().getRoot().getFolder(this.getProjectPath().append(aProjectRelativePath));
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            return folder;
        }
        return null;
    }

    protected IPath getProjectPath() {
        return this.getProject().getFullPath();
    }

    public IWorkspace getWorkspace() {
        return this.getProject().getWorkspace();
    }

    public PHPProjectOptions getOptions() {
        this.optionsLock.acquire();
        try {
            if (this.options == null) {
                this.options = new PHPProjectOptions(this.project);
            }
        }
        finally {
            this.optionsLock.release();
        }
        return this.options;
    }
}

