/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.core.project.build.IPHPBuilderExtension;
import org.eclipse.php.internal.core.PHPCorePlugin;

public class PHPBuilderExtensionsRegistry {
    private static final String DEFAULT_EXTENSION_ID = "org.eclipse.php.core.project.build.DefaultPHPBuilderExtension";
    private static final String EXTENSION_NAME = "phpBuilderExtensions";
    private static final String BUILDER_ELEMENT = "builder";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private Map<String, Object> extensions;
    private static PHPBuilderExtensionsRegistry instance;

    private PHPBuilderExtensionsRegistry() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.core", EXTENSION_NAME);
        Object defaultExtension = null;
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (BUILDER_ELEMENT.equals(element.getName()) && DEFAULT_EXTENSION_ID.equals(element.getAttribute(ID_ATTRIBUTE))) {
                try {
                    defaultExtension = element.createExecutableExtension(CLASS_ATTRIBUTE);
                }
                catch (CoreException e) {
                    PHPCorePlugin.log(e);
                }
                break;
            }
            ++n2;
        }
        if (defaultExtension == null) {
            PHPCorePlugin.log(new IllegalStateException("no default project builder extension"));
            return;
        }
        this.extensions = new LinkedHashMap<String, Object>();
        this.extensions.put(DEFAULT_EXTENSION_ID, defaultExtension);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (BUILDER_ELEMENT.equals(element.getName()) && !DEFAULT_EXTENSION_ID.equals(element.getAttribute(ID_ATTRIBUTE))) {
                try {
                    this.extensions.put(element.getAttribute(ID_ATTRIBUTE), element.createExecutableExtension(CLASS_ATTRIBUTE));
                }
                catch (CoreException e) {
                    PHPCorePlugin.log(e);
                }
            }
            ++i;
        }
    }

    public static synchronized PHPBuilderExtensionsRegistry getInstance() {
        if (instance == null) {
            instance = new PHPBuilderExtensionsRegistry();
        }
        return instance;
    }

    public IPHPBuilderExtension[] getExtensions() {
        Collection<Object> extensions = PHPBuilderExtensionsRegistry.instance.extensions.values();
        return extensions.toArray(new IPHPBuilderExtension[extensions.size()]);
    }

    public IPHPBuilderExtension getExtension(String id) {
        return (IPHPBuilderExtension)PHPBuilderExtensionsRegistry.instance.extensions.get(id);
    }
}

