/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.markers.MarkerContributor;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;

public class PhpResourceDeltaBuildVisitor
implements IResourceDeltaVisitor {
    private static final IContentTypeManager CONTENT_TYPE_MANAGER = Platform.getContentTypeManager();
    private MarkerContributor validator = MarkerContributor.getInstance();
    private IProgressMonitor monitor;

    public PhpResourceDeltaBuildVisitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public boolean visit(IResourceDelta delta) {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 1: {
                this.monitor.subTask(NLS.bind((String)CoreMessages.getString("FullPhpProjectBuildVisitor_0"), (Object)resource.getFullPath().toPortableString()));
                this.processFileDelta(delta);
                this.monitor.worked(1);
                return false;
            }
            case 4: {
                return this.processProjectDelta(delta);
            }
        }
        return true;
    }

    private void processFileDelta(IResourceDelta fileDelta) {
        IFile file = (IFile)fileDelta.getResource();
        int numSegments = fileDelta.getFullPath().segmentCount();
        String filename = fileDelta.getFullPath().segment(numSegments - 1);
        IContentType contentType = CONTENT_TYPE_MANAGER.getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        if (!contentType.isAssociatedWith(filename)) {
            return;
        }
        switch (fileDelta.getKind()) {
            case 1: 
            case 4: {
                PHPWorkspaceModelManager.getInstance().addFileToModel(file);
                this.validator.markFile(file);
                break;
            }
            case 2: {
                PHPWorkspaceModelManager.getInstance().removeFileFromModel(file);
            }
        }
    }

    private boolean processProjectDelta(IResourceDelta projectDelta) {
        IProject project = (IProject)projectDelta.getResource();
        try {
            return project.hasNature("org.eclipse.php.core.PHPNature");
        }
        catch (CoreException e) {
            PHPCorePlugin.log(e);
            return false;
        }
    }
}

