/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.VariableContextBuilder;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableTypeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.util.ProjectResolver;
import org.eclipse.wst.sse.core.internal.util.URIResolver;

public class CodeDataResolver {
    private static final String PHPDOC_CLASS_NAME_SEPARATOR = "\\|";
    private static final CodeData[] EMPTY = new CodeData[0];
    private static CodeDataResolver instance;

    private CodeDataResolver() {
    }

    public static CodeDataResolver getInstance() {
        if (instance == null) {
            instance = new CodeDataResolver();
        }
        return instance;
    }

    public CodeData[] resolve(IFile file, int offset) throws IOException, CoreException {
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getModelForRead(file);
            if (model instanceof DOMModelForPHP) {
                DOMModelForPHP phpModel = (DOMModelForPHP)model;
                CodeData[] codeDataArray = this.resolve(model.getStructuredDocument(), offset, phpModel);
                return codeDataArray;
            }
            CodeData[] codeDataArray = EMPTY;
            return codeDataArray;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public CodeData[] resolve(IProject project, File file, int offset) throws IOException {
        IStructuredDocument document = StructuredModelManager.getModelManager().createStructuredDocumentFor(file.getAbsolutePath(), (InputStream)new FileInputStream(file), (URIResolver)new ProjectResolver(project));
        return this.resolve(document, offset);
    }

    public CodeData[] resolve(IStructuredDocument sDoc, int offset) {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)sDoc);
        try {
            if (sModel instanceof DOMModelForPHP) {
                DOMModelForPHP phpModel = (DOMModelForPHP)sModel;
                CodeData[] codeDataArray = this.resolve(sDoc, offset, phpModel);
                return codeDataArray;
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return EMPTY;
    }

    public CodeData[] resolve(IStructuredDocument sDoc, int offset, DOMModelForPHP phpModel) {
        PHPProjectModel projectModel = phpModel.getProjectModel();
        PHPFileData fileData = phpModel.getFileData(true);
        if (projectModel == null || fileData == null) {
            return EMPTY;
        }
        return this.resolve(sDoc, offset, projectModel, fileData);
    }

    public CodeData[] resolve(IStructuredDocument sDoc, int offset, PHPProjectModel projectModel, PHPFileData fileData) {
        block42: {
            try {
                Object currentClassData;
                CodeData[] result;
                int n;
                int n2;
                Object[] objectArray;
                PHPClassData classData;
                IStructuredDocumentRegion sRegion = sDoc.getRegionAtCharacterOffset(offset);
                if (sRegion == null) break block42;
                ITextRegion tRegion = sRegion.getRegionAtCharacterOffset(offset);
                IStructuredDocumentRegion container = sRegion;
                if (tRegion instanceof ITextRegionContainer) {
                    container = (ITextRegionContainer)tRegion;
                    tRegion = container.getRegionAtCharacterOffset(offset);
                }
                if (tRegion.getType() != "PHP_CONTENT") break block42;
                IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)tRegion;
                tRegion = phpScriptRegion.getPhpToken(offset - container.getStartOffset() - phpScriptRegion.getStart());
                int elementStart = container.getStartOffset() + phpScriptRegion.getStart() + tRegion.getStart();
                TextSequence statement = PHPTextSequenceUtilities.getStatement(elementStart + tRegion.getLength(), sRegion, true);
                int endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statement, statement.length());
                int startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(statement, endPosition, true);
                String elementName = statement.subSequence(startPosition, endPosition).toString();
                int prevWordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statement, startPosition);
                int prevWordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statement, prevWordEnd, false);
                String prevWord = statement.subSequence(prevWordStart, prevWordEnd).toString();
                ITextRegion nextRegion = tRegion;
                while ((PHPPartitionTypes.isPHPCommentState((nextRegion = phpScriptRegion.getPhpToken(nextRegion.getEnd())).getType()) || nextRegion.getType() == "WHITESPACE") && nextRegion.getEnd() < phpScriptRegion.getLength()) {
                }
                String nextWord = sDoc.get(container.getStartOffset() + phpScriptRegion.getStart() + nextRegion.getStart(), nextRegion.getTextLength());
                if (elementName.length() <= 0) break block42;
                String fileName = fileData != null ? fileData.getName() : null;
                PHPClassData pHPClassData = classData = fileData != null ? PHPFileDataUtilities.getContainerClassData(fileData, offset) : null;
                if ("function".equalsIgnoreCase(prevWord)) {
                    if (classData != null) {
                        return this.toArray(projectModel.getClassFunctionData(fileName, classData.getName(), elementName));
                    }
                    return this.toArray(projectModel.getFunction(fileName, elementName));
                }
                if ("class".equalsIgnoreCase(prevWord) || "interface".equalsIgnoreCase(prevWord)) {
                    return this.toArray(projectModel.getClass(fileName, elementName));
                }
                CodeData[] matchingClasses = this.getMatchingClasses(elementName, projectModel, fileName);
                if ("new".equalsIgnoreCase(prevWord)) {
                    return matchingClasses;
                }
                if (statement.length() > 6 && ("class".equals(statement.subSequence(0, 5).toString()) || statement.length() > 10 && "interface".equals(statement.subSequence(0, 9).toString()))) {
                    if ("extends".equalsIgnoreCase(prevWord) || "implements".equalsIgnoreCase(prevWord)) {
                        return matchingClasses;
                    }
                    int listStartPosition = PHPTextSequenceUtilities.readIdentifierListStartIndex(statement, endPosition);
                    int preListWordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statement, listStartPosition);
                    int preListWordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statement, preListWordEnd, false);
                    String preListWord = statement.subSequence(preListWordStart, preListWordEnd).toString();
                    if ("extends".equalsIgnoreCase(preListWord) || "implements".equalsIgnoreCase(preListWord)) {
                        return matchingClasses;
                    }
                }
                String trigger = null;
                if (startPosition > 2) {
                    trigger = statement.subSequence(startPosition - 2, startPosition).toString();
                }
                if (elementName.charAt(0) == '$' && !"::".equals(trigger)) {
                    PHPCodeContext context;
                    CodeData[] res;
                    if (PHPPartitionTypes.isPHPQuotesState(tRegion.getType())) {
                        try {
                            char charBefore = sDoc.get(elementStart - 2, 1).charAt(0);
                            if (charBefore == '\\') {
                                return EMPTY;
                            }
                        }
                        catch (BadLocationException e) {
                            PHPCorePlugin.log(e);
                        }
                    }
                    elementName = elementName.substring(1);
                    if (classData != null) {
                        if ("var".equalsIgnoreCase(prevWord) || "private".equalsIgnoreCase(prevWord) || "static".equalsIgnoreCase(prevWord) || "public".equalsIgnoreCase(prevWord) || "protected".equalsIgnoreCase(prevWord)) {
                            return this.filterExact(classData.getVars(), elementName);
                        }
                        if ("this".equalsIgnoreCase(elementName)) {
                            return this.toArray(classData);
                        }
                    }
                    if ((res = this.filterExact(projectModel.getVariables(fileName, context = ModelSupport.createContext(fileData, elementStart), elementName, true), elementName)).length == 1 && res[0].getUserData() == null && res[0] instanceof PHPVariableData) {
                        PHPVariableTypeData typeData;
                        int varStartPosition;
                        PHPVariableData v = (PHPVariableData)res[0];
                        String variableContext = VariableContextBuilder.createVariableContext(elementName, context);
                        List instantiations = (List)fileData.getVariableTypeManager().getVariablesInstansiation().get(variableContext);
                        if (instantiations != null && instantiations.size() > 0 && (sRegion = sDoc.getRegionAtCharacterOffset(varStartPosition = (typeData = (PHPVariableTypeData)instantiations.get(instantiations.size() - 1)).getPosition())) != null) {
                            tRegion = sRegion.getRegionAtCharacterOffset(varStartPosition);
                            container = sRegion;
                            if (tRegion instanceof ITextRegionContainer) {
                                container = (ITextRegionContainer)tRegion;
                                tRegion = container.getRegionAtCharacterOffset(varStartPosition);
                            }
                            if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
                                phpScriptRegion = (IPhpScriptRegion)tRegion;
                                ITextRegion prevRegion = tRegion = phpScriptRegion.getPhpToken(varStartPosition - container.getStartOffset() - phpScriptRegion.getStart());
                                while ((prevRegion = phpScriptRegion.getPhpToken(prevRegion.getStart() - 1)).getType() != "PHP_VARIABLE" && prevRegion.getStart() > 0) {
                                }
                                if (prevRegion.getType() == "PHP_VARIABLE") {
                                    varStartPosition = container.getStartOffset() + phpScriptRegion.getStart() + prevRegion.getStart();
                                    int varEndPosition = varStartPosition + elementName.length();
                                    UserData userData = PHPCodeDataFactory.createUserData(fileName, varStartPosition, varEndPosition, varEndPosition, typeData.getLine());
                                    res[0] = PHPCodeDataFactory.createPHPVariableData(v.getName(), v.getDocBlock(), userData);
                                }
                            }
                        }
                    }
                    return res;
                }
                if (classData != null && "const".equalsIgnoreCase(prevWord)) {
                    return this.filterExact(classData.getConsts(), elementName);
                }
                if ("::".equals(nextWord)) {
                    return matchingClasses;
                }
                String className = this.getClassName(projectModel, fileData, statement, startPosition, offset, sDoc.getLineOfOffset(offset));
                CodeData[] allClassDatas = EMPTY;
                if (className != null) {
                    String[] classNames = className.split(PHPDOC_CLASS_NAME_SEPARATOR);
                    objectArray = classNames;
                    n2 = classNames.length;
                    n = 0;
                    while (n < n2) {
                        Object realClassName = objectArray[n];
                        realClassName = ((String)realClassName).trim();
                        CodeData[] classDatas = this.getMatchingClasses((String)realClassName, projectModel, fileName);
                        allClassDatas = ModelSupport.merge(allClassDatas, classDatas);
                        ++n;
                    }
                }
                if ("(".equals(nextWord) || PHPPartitionTypes.isPHPDocState(tRegion.getType())) {
                    result = null;
                    if (allClassDatas.length > 0) {
                        objectArray = allClassDatas;
                        n2 = allClassDatas.length;
                        n = 0;
                        while (n < n2) {
                            currentClassData = objectArray[n];
                            result = ModelSupport.merge(result, this.toArray(projectModel.getClassFunctionData(fileName, currentClassData.getName(), elementName)));
                            ++n;
                        }
                    } else {
                        result = projectModel.getFilteredFunctions(fileName, elementName);
                        if (result == null || result.length == 0) {
                            result = projectModel.getFunction(elementName);
                        }
                    }
                    return result == null ? EMPTY : result;
                }
                if (allClassDatas.length > 0) {
                    if (startPosition > 0 && "::".equals(trigger) && elementName.charAt(0) != '$') {
                        result = null;
                        int i = 0;
                        while (i < allClassDatas.length) {
                            result = ModelSupport.merge(result, this.toArray(projectModel.getClassConstsData(fileName, className, elementName)));
                            ++i;
                        }
                        return result == null ? EMPTY : result;
                    }
                    result = null;
                    if (elementName.charAt(0) == '$') {
                        elementName = elementName.substring(1);
                    }
                    objectArray = allClassDatas;
                    n2 = allClassDatas.length;
                    n = 0;
                    while (n < n2) {
                        currentClassData = objectArray[n];
                        result = ModelSupport.merge(result, this.toArray(projectModel.getClassVariablesData(fileName, currentClassData.getName(), elementName)));
                        ++n;
                    }
                    return result == null ? EMPTY : result;
                }
                result = projectModel.getFilteredConstants(fileName, elementName);
                if (result == null || result.length == 0) {
                    result = projectModel.getConstant(elementName);
                }
                if (result == null || result.length == 0) {
                    result = matchingClasses;
                }
                return result == null ? EMPTY : result;
            }
            catch (Exception e) {
                PHPCorePlugin.log(e);
            }
        }
        return EMPTY;
    }

    private CodeData[] getMatchingClasses(String className, PHPProjectModel projectModel, String fileName) {
        CodeData[] matchingClasses = projectModel.getFilteredClasses(fileName, className);
        if (matchingClasses == null || matchingClasses.length == 0) {
            matchingClasses = projectModel.getClass(className);
        }
        return matchingClasses;
    }

    private CodeData[] filterExact(CodeData[] result, String searchName) {
        ArrayList<CodeData> filtered = new ArrayList<CodeData>();
        if (result != null) {
            int i = 0;
            while (i < result.length) {
                if (searchName.equalsIgnoreCase(result[i].getName())) {
                    filtered.add(result[i]);
                }
                ++i;
            }
        }
        return filtered.toArray(new CodeData[filtered.size()]);
    }

    private String getClassName(PHPProjectModel projectModel, PHPFileData fileData, TextSequence statement, int startPosition, int offset, int line) {
        int propertyEndPosition;
        int lastObjectOperator;
        if (startPosition < 2) {
            return null;
        }
        if ((startPosition = PHPTextSequenceUtilities.readBackwardSpaces(statement, startPosition)) < 2) {
            return null;
        }
        boolean isClassTriger = false;
        String triggerText = statement.subSequence(startPosition - 2, startPosition).toString();
        if (!"->".equals(triggerText)) {
            if ("::".equals(triggerText)) {
                isClassTriger = true;
            } else {
                return null;
            }
        }
        if ((lastObjectOperator = PHPTextSequenceUtilities.getPrivousTriggerIndex(statement, propertyEndPosition = PHPTextSequenceUtilities.readBackwardSpaces(statement, startPosition - 2))) == -1) {
            return this.innerGetClassName(projectModel, fileData, statement, propertyEndPosition, isClassTriger, offset, line);
        }
        int propertyStartPosition = PHPTextSequenceUtilities.readForwardSpaces(statement, lastObjectOperator + 2);
        String propertyName = statement.subSequence(propertyStartPosition, propertyEndPosition).toString();
        String className = this.getClassName(projectModel, fileData, statement, propertyStartPosition, offset, line);
        int bracketIndex = propertyName.indexOf(40);
        if (bracketIndex == -1) {
            return PHPModelUtil.getVarType(projectModel, fileData.getName(), className, propertyName, offset, line, true);
        }
        String functionName = propertyName.substring(0, bracketIndex).trim();
        return PHPModelUtil.getFunctionReturnType(projectModel, fileData.getName(), className, functionName);
    }

    private String innerGetClassName(PHPProjectModel projectModel, PHPFileData fileData, TextSequence statementText, int propertyEndPosition, boolean isClassTriger, int offset, int line) {
        if (fileData == null) {
            return null;
        }
        int classNameStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, propertyEndPosition, true);
        String className = statementText.subSequence(classNameStart, propertyEndPosition).toString();
        if (isClassTriger) {
            PHPClassData classData;
            if (className.equals("self")) {
                PHPClassData classData2 = PHPFileDataUtilities.getContainerClassData(fileData, offset - 6);
                if (classData2 != null) {
                    return classData2.getName();
                }
            } else if (className.equals("parent") && (classData = PHPFileDataUtilities.getContainerClassData(fileData, offset - 8)) != null) {
                return projectModel.getSuperClassName(fileData.getName(), classData.getName());
            }
            return className;
        }
        if (className.length() > 0 && className.charAt(0) == '$') {
            int statementStart = statementText.getOriginalOffset(0);
            return PHPFileDataUtilities.getVariableType(fileData, className, statementStart, line, (IPhpModel)projectModel, true);
        }
        if (statementText.charAt(propertyEndPosition - 1) == ')') {
            PHPFunctionData[] functions;
            int functionNameEnd = this.getFunctionNameEndOffset(statementText, propertyEndPosition - 1);
            int functionNameStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, functionNameEnd, false);
            String functionName = statementText.subSequence(functionNameStart, functionNameEnd).toString();
            PHPClassData classData = PHPFileDataUtilities.getContainerClassData(fileData, offset);
            if (classData != null) {
                return PHPModelUtil.getFunctionReturnType(projectModel, fileData.getName(), classData.getName(), functionName);
            }
            PHPFunctionData[] pHPFunctionDataArray = functions = fileData.getFunctions();
            int n = functions.length;
            int n2 = 0;
            while (n2 < n) {
                PHPFunctionData function = pHPFunctionDataArray[n2];
                if (function.getName().equals(functionName)) {
                    return function.getReturnType();
                }
                ++n2;
            }
        }
        return null;
    }

    private int getFunctionNameEndOffset(TextSequence statementText, int offset) {
        if (statementText.charAt(offset) != ')') {
            return 0;
        }
        int currChar = offset;
        int bracketsNum = 1;
        while (bracketsNum != 0 && currChar >= 0) {
            if (statementText.charAt(--currChar) == ')') {
                ++bracketsNum;
                continue;
            }
            if (statementText.charAt(currChar) != '(') continue;
            --bracketsNum;
        }
        return currChar;
    }

    private CodeData[] toArray(CodeData codeData) {
        if (codeData != null) {
            return new CodeData[]{codeData};
        }
        return EMPTY;
    }
}

