/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.util.ICachable;
import org.eclipse.php.internal.core.util.IncludeCacheManager;
import org.eclipse.php.internal.core.util.SerializationUtil;
import org.eclipse.php.internal.core.util.StreamUtils;

public class DefaultCacheManager {
    private static final String DATA_MODEL_FILE_NAME = ".dataModel";
    private static final String CACHE_DIR_NAME = ".cache";
    public static final int DEFAULT_CACHE_POLICY = 0;
    public static final int VERSION_IDENTIFIER = 181107;
    private HashMap projectToCacheDir;
    private File sharedCacheDir;
    private PreferencesSupport preferencesSupport;
    private IncludeCacheManager includeCacheManager;
    private Object writeLock = new Object();
    public static DefaultCacheManager instance;

    public static DefaultCacheManager instance() {
        if (instance == null) {
            instance = new DefaultCacheManager();
        }
        return instance;
    }

    private DefaultCacheManager() {
        this.projectToCacheDir = new HashMap();
        IPath pluginLocation = PHPCorePlugin.getDefault().getStateLocation();
        this.sharedCacheDir = new File(pluginLocation.toFile(), CACHE_DIR_NAME);
        if (!this.sharedCacheDir.exists()) {
            this.sharedCacheDir.mkdirs();
        }
        this.preferencesSupport = new PreferencesSupport("org.eclipse.php.core", PHPCorePlugin.getDefault().getPreferenceStore());
        this.includeCacheManager = new IncludeCacheManager(this);
    }

    public IncludeCacheManager getIncludeCacheManager() {
        return this.includeCacheManager;
    }

    public void deleteCacheFromDisk(IProject project) {
        File cacheDir = this.getCacheDir(project);
        File toDelete = new File(cacheDir, DATA_MODEL_FILE_NAME);
        if (toDelete.exists()) {
            toDelete.delete();
        }
    }

    protected File getCacheDir(IProject project) {
        File file = (File)this.projectToCacheDir.get(project);
        if (file == null && project != null) {
            IPath location = project.getLocation();
            if (location == null) {
                return null;
            }
            File path = location.toFile();
            if (path != null) {
                file = new File(path, CACHE_DIR_NAME);
                this.projectToCacheDir.put(project, file);
            }
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public long getSharedCacheModificationTime(IProject project, IPhpModel model) {
        File f = this.getSharedCacheFile(project, model);
        return f.lastModified();
    }

    public File getSharedCacheDirectory() {
        return this.sharedCacheDir;
    }

    protected File getSharedCacheFile(IProject project, IPhpModel model) {
        return this.getSharedCacheFile(project, model.getID());
    }

    public File getSharedCacheFile(IProject project, String libraryPath) {
        String phpVersion = this.preferencesSupport.getPreferencesValue("phpVersion", null, project);
        return this.getSharedCacheFile(phpVersion, libraryPath);
    }

    public File getSharedCacheFile(String phpVersion, String libraryPath) {
        String pathHash = String.valueOf(libraryPath.hashCode());
        String fileName = String.valueOf(pathHash) + '_' + (phpVersion != null ? phpVersion : "");
        return new File(this.sharedCacheDir, fileName);
    }

    public boolean load(IProject project, IPhpModel model, boolean isShared) {
        if (project == null || !(model instanceof PHPUserModel)) {
            return false;
        }
        PHPUserModel userModel = (PHPUserModel)model;
        File cacheFile = null;
        cacheFile = isShared ? this.getSharedCacheFile(project, model) : new File(this.getCacheDir(project), DATA_MODEL_FILE_NAME);
        return this.innerLoadModel(userModel, cacheFile);
    }

    /*
     * Unable to fully structure code
     */
    private boolean innerLoadModel(PHPUserModel userModel, File cacheFile) {
        block22: {
            block21: {
                block20: {
                    if (!cacheFile.exists()) {
                        return false;
                    }
                    invalidCache = false;
                    in = null;
                    bufin = null;
                    din = null;
                    in = new FileInputStream(cacheFile);
                    bufin = new BufferedInputStream(in, 2048);
                    din = new DataInputStream(bufin);
                    version = din.readInt();
                    if (version != 181107) ** GOTO lbl33
                    datas = SerializationUtil.deserializePHPFileDataArray(din);
                    if (datas.length <= 0) break block20;
                    path = new Path(datas[0].getName());
                    projectName = cacheFile.getParentFile().getParentFile().getName();
                    if (projectName.equals(path.segment(0))) break block20;
lbl18:
                    // 2 sources

                    return false;
                }
                try {
                    var12_21 = datas;
                    var11_22 = datas.length;
                    var10_12 = 0;
                    while (var10_12 < var11_22) {
                        data = var12_21[var10_12];
                        userModel.insert(data);
                        ++var10_12;
                    }
                    Runtime.getRuntime().gc();
                    break block21;
lbl33:
                    // 1 sources

                    invalidCache = true;
                }
                catch (FileNotFoundException v0) {
                    StreamUtils.closeStream(din);
                    StreamUtils.closeStream(bufin);
                    StreamUtils.closeStream(in);
                    if (invalidCache) {
                        if (cacheFile.delete()) {
                            message = "Invalid cache version. The cache file was deleted.";
                            PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", message, null));
                        } else {
                            message = "Invalid cache version. Could not delete the file: " + cacheFile.getPath();
                            PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", message, null));
                        }
                    }
                    break block22;
                }
                catch (Exception e) {
                    try {
                        PHPCorePlugin.log(e);
                        ** continue;
                    }
                    catch (Throwable var13_23) {
                        throw var13_23;
                    }
                    finally {
                        StreamUtils.closeStream(din);
                        StreamUtils.closeStream(bufin);
                        StreamUtils.closeStream(in);
                        if (invalidCache) {
                            if (cacheFile.delete()) {
                                message = "Invalid cache version. The cache file was deleted.";
                                PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", message, null));
                            } else {
                                message = "Invalid cache version. Could not delete the file: " + cacheFile.getPath();
                                PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", message, null));
                            }
                        }
                    }
                }
            }
            StreamUtils.closeStream(din);
            StreamUtils.closeStream(bufin);
            StreamUtils.closeStream(in);
            if (invalidCache) {
                if (cacheFile.delete()) {
                    message = "Invalid cache version. The cache file was deleted.";
                    PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", message, null));
                } else {
                    message = "Invalid cache version. Could not delete the file: " + cacheFile.getPath();
                    PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", message, null));
                }
            }
        }
        return invalidCache == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(IProject project, IPhpModel model, boolean isShared) {
        if (!(model instanceof PHPUserModel)) {
            return;
        }
        PHPUserModel userModel = (PHPUserModel)model;
        File cacheFile = null;
        if (isShared) {
            cacheFile = this.getSharedCacheFile(project, model);
            Object object = this.writeLock;
            synchronized (object) {
                if (cacheFile.exists()) {
                    if (System.currentTimeMillis() - cacheFile.lastModified() > 60000L) {
                        this.innerSaveModel(userModel, cacheFile);
                    }
                } else {
                    this.innerSaveModel(userModel, cacheFile);
                }
            }
        } else {
            cacheFile = new File(this.getCacheDir(project), DATA_MODEL_FILE_NAME);
            this.innerSaveModel(userModel, cacheFile);
        }
    }

    private void innerSaveModel(PHPUserModel userModel, File cacheFile) {
        block5: {
            FileOutputStream out = null;
            BufferedOutputStream bufout = null;
            DataOutputStream dout = null;
            try {
                try {
                    CodeData[] files = userModel.getFileDatas();
                    ICachable[] toSave = Arrays.asList(files).toArray(new ICachable[files.length]);
                    out = new FileOutputStream(cacheFile);
                    bufout = new BufferedOutputStream(out, 2048);
                    dout = new DataOutputStream(bufout);
                    dout.writeInt(181107);
                    SerializationUtil.serialize(toSave, dout);
                    dout.flush();
                }
                catch (IOException e) {
                    PHPCorePlugin.log(e);
                    StreamUtils.closeStream(dout);
                    StreamUtils.closeStream(out);
                    StreamUtils.closeStream(bufout);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(dout);
                StreamUtils.closeStream(out);
                StreamUtils.closeStream(bufout);
                throw throwable;
            }
            StreamUtils.closeStream(dout);
            StreamUtils.closeStream(out);
            StreamUtils.closeStream(bufout);
        }
        Runtime.getRuntime().gc();
    }
}

