/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.CoreMessages;

public class FileUtils {
    public static boolean resourceExists(String resourcePath) {
        if (resourcePath == null || "".equals(resourcePath)) {
            return false;
        }
        boolean resourceExists = false;
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path path = new Path(resourcePath);
            resourceExists = root.exists((IPath)path);
        }
        catch (Exception exception) {}
        return resourceExists;
    }

    public static String getContents(File file) throws IOException {
        StringBuffer contents;
        block19: {
            contents = new StringBuffer();
            BufferedReader input = null;
            try {
                input = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                if (input != null) {
                    input.close();
                }
                break block19;
            }
            catch (IOException ex) {
                try {
                    ex.printStackTrace();
                    break block19;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            if (input != null) {
                input.close();
            }
        }
        return contents.toString();
    }

    public static void setContents(File file, String contents) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException(CoreMessages.getString("FileUtils_2"));
        }
        if (!file.exists()) {
            throw new FileNotFoundException(String.valueOf(CoreMessages.getString("FileUtils_3")) + file);
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("FileUtils_4")) + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("FileUtils_5")) + file);
        }
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(file));
            output.write(contents);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public static boolean checkIfEqualFilePaths(String filePathStr1, String filePathStr2) {
        Path filePath1 = new Path(filePathStr1.toLowerCase());
        Path filePath2 = new Path(filePathStr2.toLowerCase());
        if (filePath1.segmentCount() != filePath2.segmentCount()) {
            return false;
        }
        if (filePath1.getDevice() == null && filePath2.getDevice() != null || filePath1.getDevice() != null && filePath2.getDevice() == null) {
            return false;
        }
        if (filePath1.getDevice() != null && !filePath1.getDevice().toLowerCase().equals(filePath2.getDevice().toLowerCase())) {
            return false;
        }
        int i = 0;
        while (i < filePath1.segmentCount()) {
            if (!filePath1.segment(i).equals(filePath2.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean checkIfContainerOfFile(String containerPathString, String filePathString) {
        Path containerFilterPath = new Path(containerPathString.toLowerCase());
        Path filePath = new Path(filePathString.toLowerCase());
        if (containerFilterPath.segmentCount() > filePath.segmentCount()) {
            return false;
        }
        if (containerFilterPath.getDevice() == null && filePath.getDevice() != null || containerFilterPath.getDevice() != null && filePath.getDevice() == null) {
            return false;
        }
        if (containerFilterPath.getDevice() != null && !containerFilterPath.getDevice().toLowerCase().equals(filePath.getDevice().toLowerCase())) {
            return false;
        }
        int i = 0;
        while (i < containerFilterPath.segmentCount()) {
            if (!containerFilterPath.segment(i).equals(filePath.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static File toLocalFile(URI uri, IProgressMonitor monitor) throws CoreException {
        IFileStore fileStore = EFS.getStore((URI)uri);
        File localFile = fileStore.toLocalFile(0, monitor);
        if (localFile == null) {
            localFile = fileStore.toLocalFile(4096, monitor);
        }
        return localFile;
    }
}

