/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.projectoutlineview;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.MethodNameMatch;
import org.eclipse.dltk.core.search.MethodNameMatchRequestor;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.ui.Logger;

public class OutlineUtils {
    private static final IModelElement[] EMPTY = new IModelElement[0];
    private static final String WILDCARD = "*";

    public static IType[] getOnlyClasses(IModelElement projectFragment, String prefix, boolean exactName) {
        IModelElement[] classes = OutlineUtils.getGlobalClasses(projectFragment, prefix, exactName);
        LinkedList<IType> onlyClasses = new LinkedList<IType>();
        IModelElement[] iModelElementArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IModelElement c = iModelElementArray[n2];
                IType type = (IType)c;
                try {
                    if ((type.getFlags() & 0x10) == 0) {
                        onlyClasses.add(type);
                    }
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG_COMPLETION) break block4;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return onlyClasses.toArray(new IType[onlyClasses.size()]);
    }

    public static IModelElement[] getGlobalClasses(IModelElement projectFragment, String prefix, boolean exactName) {
        return OutlineUtils.getGlobalElements(projectFragment, prefix, exactName, 0);
    }

    public static IModelElement[] getGlobalFunctions(IModelElement projectFragment, String prefix, boolean exactName) {
        return OutlineUtils.getGlobalElements(projectFragment, prefix, exactName, 1);
    }

    public static IModelElement[] getGlobalConstants(IModelElement projectFragment, String prefix, boolean exactName) {
        IModelElement[] globalElements;
        ArrayList<IModelElement> constantsElements = new ArrayList<IModelElement>();
        IModelElement[] iModelElementArray = globalElements = OutlineUtils.getGlobalElements(projectFragment, prefix, exactName, 2);
        int n = globalElements.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement modelElement = iModelElementArray[n2];
            if (OutlineUtils.isConstant(modelElement)) {
                constantsElements.add(modelElement);
            }
            ++n2;
        }
        return constantsElements.toArray(new IModelElement[constantsElements.size()]);
    }

    protected static boolean isConstant(IModelElement modelElement) {
        if (modelElement instanceof IField && modelElement.getParent() instanceof ISourceModule) {
            int flags = 0;
            try {
                flags = ((IField)modelElement).getFlags();
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
            if ((flags & 4) != 0) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isGlobalClass(IModelElement modelElement) {
        return modelElement instanceof IType && modelElement.getParent() instanceof ISourceModule;
    }

    protected static boolean isGlobalFunction(IModelElement modelElement) {
        return modelElement instanceof IMethod && modelElement.getParent() instanceof ISourceModule;
    }

    private static IModelElement[] getGlobalElements(IModelElement projectFragment, String prefix, boolean exactName, int elementType) {
        return OutlineUtils.getGlobalElements(projectFragment, prefix, exactName, elementType, false);
    }

    private static IModelElement[] getGlobalElements(IModelElement projectFragment, String prefix, boolean exactName, int elementType, boolean currentFileOnly) {
        return OutlineUtils.getGlobalElements(projectFragment, prefix, exactName, elementType, currentFileOnly, false);
    }

    private static IModelElement[] getGlobalElements(IModelElement projectFragment, String prefix, boolean exactName, int elementType, boolean currentFileOnly, boolean caseSensitive) {
        IDLTKLanguageToolkit toolkit = PHPLanguageToolkit.getDefault();
        IDLTKSearchScope scope = projectFragment != null ? SearchEngine.createSearchScope((IModelElement)projectFragment) : SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit);
        return OutlineUtils.getGlobalElements(scope, prefix, exactName, elementType, caseSensitive);
    }

    private static IModelElement[] getGlobalElements(IDLTKSearchScope scope, String prefix, boolean exactName, int elementType, boolean caseSensitive) {
        LinkedList elements;
        block10: {
            int matchRule;
            IDLTKLanguageToolkit toolkit = PHPLanguageToolkit.getDefault();
            if (prefix.length() == 0 && !exactName) {
                prefix = WILDCARD;
                matchRule = 2;
                if (caseSensitive) {
                    matchRule |= 8;
                }
            } else if (caseSensitive) {
                matchRule = exactName ? 0 : 1;
                matchRule |= 8;
            } else {
                matchRule = exactName ? 0 : 129;
            }
            SearchEngine searchEngine = new SearchEngine();
            SearchPattern pattern = SearchPattern.createPattern((String)prefix, (int)elementType, (int)0, (int)matchRule, (IDLTKLanguageToolkit)toolkit);
            elements = new LinkedList();
            if (elementType == 1) {
                try {
                    searchEngine.searchAllMethodNames(new char[]{'*'}, 2, 1, scope, new MethodNameMatchRequestor(){

                        public void acceptMethodNameMatch(MethodNameMatch match) {
                            IMethod element = match.getMethod();
                            if (element instanceof SourceModule) {
                                return;
                            }
                            IModelElement parent = element.getParent();
                            if (element instanceof IField && parent instanceof ISourceModule || !(element instanceof IField) && !(parent instanceof IType)) {
                                elements.add(element);
                            }
                        }
                    }, 1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (ModelException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                    public void acceptSearchMatch(SearchMatch match) throws CoreException {
                        IModelElement element = (IModelElement)match.getElement();
                        if (element instanceof SourceModule) {
                            return;
                        }
                        IModelElement parent = element.getParent();
                        if (element instanceof IField && parent instanceof ISourceModule || !(element instanceof IField) && !(parent instanceof IType)) {
                            elements.add(element);
                        }
                    }
                }, null);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG_COMPLETION) break block10;
                e.printStackTrace();
            }
        }
        return elements.toArray(new IModelElement[elements.size()]);
    }
}

