/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.ui.search.IOccurrencesFinder;
import org.eclipse.php.internal.ui.search.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNameOccurrencesFinder
extends AbstractOccurrencesFinder {
    public static final String ID = "ClassNameOccurrencesFinder";
    private String className;

    @Override
    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        if (node.getType() == 33) {
            this.className = ((Identifier)node).getName();
            return null;
        }
        this.fDescription = "OccurrencesFinder_occurrence_description";
        return this.fDescription;
    }

    @Override
    protected void findOccurrences() {
        this.fDescription = Messages.format(BASE_DESCRIPTION, this.className);
        this.fASTRoot.accept((Visitor)this);
    }

    public boolean visit(StaticConstantAccess staticDispatch) {
        this.checkIdentifier(staticDispatch.getClassName());
        return false;
    }

    public boolean visit(StaticFieldAccess staticDispatch) {
        this.checkIdentifier(staticDispatch.getClassName());
        return false;
    }

    public boolean visit(StaticMethodInvocation staticDispatch) {
        this.checkIdentifier(staticDispatch.getClassName());
        return false;
    }

    public boolean visit(ClassName className) {
        if (className.getName().getType() == 33) {
            Identifier identifier = (Identifier)className.getName();
            this.checkIdentifier(identifier);
        }
        return false;
    }

    public boolean visit(ClassDeclaration classDeclaration) {
        this.checkIdentifier(classDeclaration.getName());
        this.checkSuper(classDeclaration.getSuperClass(), classDeclaration.interfaces());
        return true;
    }

    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        this.checkIdentifier(interfaceDeclaration.getName());
        this.checkSuper(null, interfaceDeclaration.interfaces());
        return true;
    }

    public boolean visit(CatchClause catchStatement) {
        this.checkIdentifier(catchStatement.getClassName());
        return true;
    }

    public boolean visit(FormalParameter formalParameter) {
        this.checkIdentifier(formalParameter.getParameterType());
        return true;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        ASTNode parent = methodDeclaration.getParent();
        if (parent.getType() == 6 && parent.getParent().getType() == 12) {
            ClassDeclaration classDeclaration = (ClassDeclaration)parent.getParent();
            Identifier functionName = methodDeclaration.getFunction().getFunctionName();
            if (this.checkForNameEquality(classDeclaration.getName()) && this.checkForNameEquality(functionName)) {
                this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(functionName.getStart(), functionName.getLength(), this.getOccurrenceType((ASTNode)methodDeclaration), this.fDescription));
            }
        }
        return true;
    }

    private void checkSuper(Identifier superClass, List<Identifier> interfaces) {
        if (superClass != null) {
            this.checkIdentifier(superClass);
        }
        if (interfaces != null) {
            for (Identifier identifier : interfaces) {
                this.checkIdentifier(identifier);
            }
        }
    }

    private void checkIdentifier(Identifier identifier) {
        if (this.checkForNameEquality(identifier)) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(identifier.getStart(), identifier.getLength(), this.getOccurrenceType((ASTNode)identifier), this.fDescription));
        }
    }

    private boolean checkForNameEquality(Identifier identifier) {
        return identifier != null && this.className != null && this.className.equalsIgnoreCase(identifier.getName());
    }

    @Override
    protected int getOccurrenceType(ASTNode node) {
        return 2;
    }

    @Override
    public String getElementName() {
        return this.className;
    }

    @Override
    public String getID() {
        return ID;
    }
}

