/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IStepFilters;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.php.debug.core.debugger.IDebugHandler;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.php.internal.debug.core.IPHPConsoleEventListener;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.core.model.BreakpointSet;
import org.eclipse.php.internal.debug.core.model.DebugOutput;
import org.eclipse.php.internal.debug.core.model.IPHPDebugTarget;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPRunToLineBreakpoint;
import org.eclipse.php.internal.debug.core.pathmapper.DebugSearchEngine;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.zend.communication.DebugConnectionThread;
import org.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugError;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugHandlersRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugParametersInitializersRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.Debugger;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.IRemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.model.ContextManager;
import org.eclipse.php.internal.debug.core.zend.model.PHPResponseHandler;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org.eclipse.php.internal.debug.core.zend.model.ServerDebugHandler;
import org.eclipse.php.internal.debug.core.zend.model.StartLock;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPDebugTarget
extends PHPDebugElement
implements IPHPDebugTarget,
IBreakpointManagerListener,
IStepFilters {
    private ContextManager fContextManager;
    boolean isStepFiltersEnabled;
    protected ILaunch fLaunch;
    protected IProcess fProcess;
    protected String fName;
    protected String fURL;
    protected int fRequestPort;
    protected DebugOutput fOutput = new DebugOutput();
    protected boolean fSuspended = false;
    protected boolean fTerminated = false;
    protected boolean fTermainateCalled = false;
    protected PHPThread fThread;
    protected IThread[] fThreads;
    protected IRemoteDebugger debugger;
    protected String fLastcmd;
    protected boolean fStatus;
    protected int fLastStop;
    protected String fLastFileName;
    protected boolean fIsPHPCGI;
    protected boolean fIsRunAsDebug;
    protected PHPResponseHandler fPHPResponseHandler;
    protected Debugger.StartResponseHandler fStartResponseHandler;
    protected Debugger.BreakpointAddedResponseHandler fBreakpointAddedResponseHandler;
    protected Debugger.BreakpointRemovedResponseHandler fBreakpointRemovedResponseHandler;
    protected Debugger.StepIntoResponseHandler fStepIntoResponseHandler;
    protected Debugger.StepOverResponseHandler fStepOverResponseHandler;
    protected Debugger.StepOutResponseHandler fStepOutResponseHandler;
    protected Debugger.GoResponseHandler fGoResponseHandler;
    protected Debugger.PauseResponseHandler fPauseResponseHandler;
    protected DefaultExpressionsManager expressionsManager;
    protected IProject fProject;
    protected int fSuspendCount;
    protected Vector<IPHPConsoleEventListener> fConsoleEventListeners = new Vector();
    protected Vector<DebugError> fDebugError = new Vector();
    protected StartLock fStartLock = new StartLock();
    protected BreakpointSet fBreakpointSet;
    protected IBreakpointManager fBreakpointManager;
    protected boolean fIsServerWindows = false;
    protected DebugConnectionThread fConnectionThread;

    public PHPDebugTarget(DebugConnectionThread connectionThread, ILaunch launch, String URL2, int requestPort, IProcess process, boolean runAsDebug, boolean stopAtFirstLine, IProject project) throws CoreException {
        super(null);
        this.fConnectionThread = connectionThread;
        this.fURL = URL2;
        this.fIsPHPCGI = false;
        this.initDebugTarget(launch, requestPort, process, runAsDebug, stopAtFirstLine, project);
    }

    public PHPDebugTarget(DebugConnectionThread connectionThread, ILaunch launch, String phpExe, IFile fileToDebug, int requestPort, IProcess process, boolean runAsDebug, boolean stopAtFirstLine, IProject project) throws CoreException {
        this(connectionThread, launch, phpExe, fileToDebug.getName(), requestPort, process, runAsDebug, stopAtFirstLine, project);
    }

    public PHPDebugTarget(DebugConnectionThread connectionThread, ILaunch launch, String phpExe, String fileToDebug, int requestPort, IProcess process, boolean runAsDebug, boolean stopAtFirstLine, IProject project) throws CoreException {
        super(null);
        this.fConnectionThread = connectionThread;
        this.fName = fileToDebug;
        this.fIsPHPCGI = true;
        this.initDebugTarget(launch, requestPort, process, runAsDebug, stopAtFirstLine, project);
    }

    public DebugConnectionThread getConnectionThread() {
        return this.fConnectionThread;
    }

    private void initDebugTarget(ILaunch launch, int requestPort, IProcess process, boolean runAsDebug, boolean stopAtFirstLine, IProject project) throws CoreException {
        String debugHandlerID;
        this.fLaunch = launch;
        this.fProcess = process;
        this.fIsRunAsDebug = runAsDebug;
        this.fProject = project;
        this.fProcess.setAttribute(IProcess.ATTR_PROCESS_TYPE, "org.eclipse.php.debug.core.launching.PHPProcess");
        ((PHPProcess)this.fProcess).setDebugTarget(this);
        this.fRequestPort = requestPort;
        this.fBreakpointSet = new BreakpointSet(project, this.fIsPHPCGI);
        IDebugHandler debugHandler = null;
        IDebugParametersInitializer parametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer(launch);
        if (parametersInitializer != null && (debugHandlerID = parametersInitializer.getDebugHandler()) != null) {
            try {
                debugHandler = DebugHandlersRegistry.getHandler(debugHandlerID);
            }
            catch (Exception e) {
                PHPDebugPlugin.log(e);
            }
        }
        if (debugHandler == null) {
            debugHandler = new ServerDebugHandler();
        }
        debugHandler.setDebugTarget(this);
        this.debugger = debugHandler.getRemoteDebugger();
        this.fThread = new PHPThread(this);
        this.fThreads = new IThread[]{this.fThread};
        this.fTerminated = false;
        this.fPHPResponseHandler = new PHPResponseHandler(this);
        this.fStartResponseHandler = new PHPResponseHandler.StartResponseHandler(this.fPHPResponseHandler);
        this.fBreakpointAddedResponseHandler = new PHPResponseHandler.BreakpointAddedResponseHandler(this.fPHPResponseHandler);
        this.fBreakpointRemovedResponseHandler = new PHPResponseHandler.BreakpointRemovedResponseHandler(this.fPHPResponseHandler);
        this.fStepIntoResponseHandler = new PHPResponseHandler.StepIntoResponseHandler(this.fPHPResponseHandler);
        this.fStepOverResponseHandler = new PHPResponseHandler.StepOverResponseHandler(this.fPHPResponseHandler);
        this.fStepOutResponseHandler = new PHPResponseHandler.StepOutResponseHandler(this.fPHPResponseHandler);
        this.fGoResponseHandler = new PHPResponseHandler.GoResponseHandler(this.fPHPResponseHandler);
        this.fPauseResponseHandler = new PHPResponseHandler.PauseResponseHandler(this.fPHPResponseHandler);
        this.fSuspendCount = 0;
        this.fContextManager = new ContextManager(this, this.debugger);
        this.fBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        this.fBreakpointManager.addBreakpointListener((IBreakpointListener)this);
        this.fBreakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public IRemoteDebugger getRemoteDebugger() {
        return this.debugger;
    }

    public IThread[] getThreads() throws DebugException {
        return this.fThreads;
    }

    public boolean hasThreads() throws DebugException {
        return !this.fTerminated && this.fThreads.length > 0;
    }

    public String getName() throws DebugException {
        if (this.fName == null) {
            this.fName = this.fURL;
        }
        return this.fName;
    }

    public String getURL() {
        return this.fURL;
    }

    int getLastStop() {
        return this.fLastStop;
    }

    String getLastFileName() {
        return this.fLastFileName;
    }

    int getSuspendCount() {
        return this.fSuspendCount;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint.getModelIdentifier().equals("org.eclipse.php.debug.core")) {
            boolean support = this.fBreakpointSet.supportsBreakpoint(breakpoint);
            return support;
        }
        return false;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public boolean canTerminate() {
        return !this.fTerminated;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        StartLock startLock = this.getStartLock();
        if (!startLock.isStarted()) {
            this.terminated();
            this.fTermainateCalled = true;
            return;
        }
        ((PHPThread)this.getThreads()[0]).setStepping(false);
        this.fTerminated = true;
        this.fSuspended = false;
        this.fLastcmd = "terminate";
        Logger.debugMSG("[" + this + "] PHPDebugTarget: Calling closeDebugSession()");
        this.debugger.closeDebugSession();
        this.terminated();
        this.fTermainateCalled = true;
    }

    public void terminated() {
        this.fTerminated = true;
        this.fSuspended = false;
        Logger.debugMSG("[" + this + "] PHPDebugTarget: Calling debugger.closeConnection();");
        if (!this.fTermainateCalled) {
            this.debugger.closeConnection();
        }
        this.completeTerminated();
        PHPSessionLaunchMapper.updateSystemProperty(DebugPlugin.getDefault().getLaunchManager().getLaunches());
    }

    private void completeTerminated() {
        this.fTerminated = true;
        this.fSuspended = false;
        this.fThreads = new IThread[0];
        try {
            this.fProcess.terminate();
        }
        catch (DebugException debugException) {}
        Logger.debugMSG("[" + this + "] PHPDebugTarget: Calling removeBreakpointListener(this);");
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
        Logger.debugMSG("[" + this + "] PHPDebugTarget: Firing terminate");
        this.fireTerminateEvent();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage page = activeWorkbenchWindow.getActivePage();
                if (page == null) {
                    return;
                }
                AbstractDebugView view = (AbstractDebugView)page.findView("org.eclipse.debug.ui.DebugView");
                if (view == null) {
                    return;
                }
                view.getViewer().refresh();
            }
        });
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public void resume() throws DebugException {
        this.fLastcmd = "resume";
        ((PHPThread)this.getThreads()[0]).setStepping(false);
        this.fStatus = this.debugger.go(this.fGoResponseHandler);
        if (!this.fStatus) {
            Logger.log(4, "PHPDebugTarget: debugger.go return false");
        }
        int detail = 32;
        this.resumed(detail);
    }

    private void resumed(int detail) {
        this.fSuspended = false;
        this.fThread.fireResumeEvent(detail);
    }

    public void suspended(int detail) {
        this.fSuspended = true;
        ++this.fSuspendCount;
        System.setProperty("org.eclipse.debugger.variables", "true");
        try {
            ((PHPThread)this.getThreads()[0]).setStepping(false);
        }
        catch (DebugException debugException) {}
        this.fThread.fireSuspendEvent(detail);
    }

    public void suspend() throws DebugException {
        this.fLastcmd = "suspend";
        ((PHPThread)this.getThreads()[0]).setStepping(false);
        this.fStatus = this.debugger.pause(this.fPauseResponseHandler);
        if (!this.fStatus) {
            Logger.log(4, "PHPDebugTarget: debugger.pause return false");
        }
        int detail = 32;
        this.suspended(detail);
    }

    public static IBreakpoint createBreakpoint(IResource resource, int lineNumber) throws CoreException {
        return PHPDebugTarget.createBreakpoint(resource, lineNumber, new HashMap<String, String>(10));
    }

    public static IBreakpoint createBreakpoint(IResource resource, int lineNumber, Map<String, String> attributes) throws CoreException {
        PHPConditionalBreakpoint point = null;
        try {
            point = new PHPConditionalBreakpoint(resource, lineNumber, attributes);
        }
        catch (CoreException e1) {
            Logger.logException("PHPDebugTarget: error creating breakpoint", e1);
            throw e1;
        }
        return point;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled()) {
                    String fileName;
                    this.fLastcmd = "breakpointAdded";
                    PHPLineBreakpoint bp = (PHPLineBreakpoint)breakpoint;
                    IMarker marker = bp.getMarker();
                    IResource resource = null;
                    Breakpoint runtimeBreakpoint = bp.getRuntimeBreakpoint();
                    int lineNumber = runtimeBreakpoint.getLineNumber();
                    if (breakpoint instanceof PHPRunToLineBreakpoint) {
                        PHPRunToLineBreakpoint rtl = (PHPRunToLineBreakpoint)breakpoint;
                        resource = rtl.getSourceFile();
                    } else {
                        resource = marker.getResource();
                        lineNumber = marker.getAttribute("lineNumber", 0);
                        runtimeBreakpoint.setLineNumber(lineNumber);
                    }
                    if (!this.fIsPHPCGI) {
                        if (resource instanceof IWorkspaceRoot) {
                            if ("org.eclipse.php.debug.core.Remote".equals(marker.getAttribute("org.eclipse.php.debug.core.Storage_Type"))) {
                                fileName = (String)marker.getAttribute("org.eclipse.php.debug.core.Storage_File");
                                fileName = marker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path", fileName);
                            } else {
                                String includeFile = (String)marker.getAttribute("org.eclipse.php.debug.core.Storage_File");
                                if ("org.eclipse.php.debug.core.Include".equals(marker.getAttribute("org.eclipse.php.debug.core.Storage_Type"))) {
                                    includeFile = marker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path", includeFile);
                                }
                                fileName = RemoteDebugger.convertToRemoteFilename(includeFile, this);
                            }
                        } else {
                            fileName = RemoteDebugger.convertToRemoteFilename(resource.getFullPath().toString(), this);
                        }
                    } else if (resource instanceof IWorkspaceRoot) {
                        fileName = (String)marker.getAttribute("org.eclipse.php.debug.core.Storage_File");
                        if ("org.eclipse.php.debug.core.Include".equals(marker.getAttribute("org.eclipse.php.debug.core.Storage_Type"))) {
                            fileName = marker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path", fileName);
                        }
                    } else {
                        IPath location = resource.getRawLocation();
                        fileName = location == null ? resource.getFullPath().toOSString() : location.toOSString();
                    }
                    runtimeBreakpoint.setFileName(fileName);
                    Logger.debugMSG("[" + this + "] PHPDebugTarget: Setting Breakpoint - File " + fileName + " Line Number " + lineNumber);
                    this.debugger.addBreakpoint(bp.getRuntimeBreakpoint(), this.fBreakpointAddedResponseHandler);
                }
            }
            catch (CoreException e1) {
                Logger.logException("PHPDebugTarget: Exception Adding Breakpoint", e1);
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            if (breakpoint instanceof PHPRunToLineBreakpoint) {
                return;
            }
            this.fLastcmd = "breakpointRemoved";
            PHPLineBreakpoint bp = (PHPLineBreakpoint)breakpoint;
            Breakpoint runtimeBreakpoint = bp.getRuntimeBreakpoint();
            Logger.debugMSG("[" + this + "] PHPDebugTarget: Removing Breakpoint - File " + runtimeBreakpoint.getFileName() + " Line Number " + runtimeBreakpoint.getLineNumber());
            this.fStatus = this.debugger.removeBreakpoint(runtimeBreakpoint, this.fBreakpointRemovedResponseHandler);
            if (!this.fStatus && this.debugger.isActive()) {
                Logger.log(4, "PHPDebugTarget: debugger.removeBreakpoint return false");
            }
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!this.fBreakpointManager.isEnabled()) {
            return;
        }
        int deltaLNumber = delta.getAttribute("lineNumber", 0);
        IMarker marker = breakpoint.getMarker();
        int lineNumber = marker.getAttribute("lineNumber", 0);
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (((PHPLineBreakpoint)breakpoint).isConditionChanged()) {
                    ((PHPLineBreakpoint)breakpoint).setConditionChanged(false);
                    if (breakpoint.isEnabled()) {
                        this.breakpointRemoved(breakpoint, null);
                    } else {
                        return;
                    }
                }
                if (lineNumber != deltaLNumber) {
                    if (breakpoint.isEnabled()) {
                        this.breakpointRemoved(breakpoint, null);
                    } else {
                        return;
                    }
                }
                if (breakpoint.isEnabled()) {
                    this.breakpointAdded(breakpoint);
                } else {
                    this.breakpointRemoved(breakpoint, null);
                }
            }
            catch (CoreException e) {
                Logger.logException("PHPDebugTarget: Exception Changing Breakpoint", e);
            }
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public void started() {
        this.fSuspended = false;
        this.fireCreationEvent();
    }

    public void installDeferredBreakpoints() throws CoreException {
    }

    protected IStackFrame[] getStackFrames() throws DebugException {
        return this.getStackFrames(false);
    }

    protected IStackFrame[] getStackFrames(boolean fetchVariables) throws DebugException {
        return this.fContextManager.getStackFrames(fetchVariables);
    }

    public DefaultExpressionsManager getExpressionManager() {
        return this.expressionsManager;
    }

    public void setExpressionManager(DefaultExpressionsManager expressionManager) {
        this.expressionsManager = expressionManager;
    }

    public Expression[] getStackVariables(PHPStackFrame stack) {
        return this.fContextManager.getStackVariables(stack);
    }

    protected void stepReturn() throws DebugException {
        this.fLastcmd = "stepReturn";
        Logger.debugMSG("[" + this + "] PHPDebugTarget: stepReturn ");
        int detail = 4;
        this.resumed(detail);
        this.fStatus = this.debugger.stepOut(this.fStepOutResponseHandler);
        if (!this.fStatus) {
            Logger.log(204, "PHPDebugTarget: debugger.stepOut return false");
        }
    }

    protected void stepOver() throws DebugException {
        this.fLastcmd = "stepOver";
        Logger.debugMSG("[" + this + "] PHPDebugTarget: stepOver");
        int detail = 2;
        this.resumed(detail);
        this.fStatus = this.debugger.stepOver(this.fStepOverResponseHandler);
        if (!this.fStatus) {
            Logger.log(204, "PHPDebugTarget: debugger.stepOver return false");
        }
    }

    protected void stepInto() throws DebugException {
        Logger.debugMSG("[" + this + "] PHPDebugTarget: stepInto ");
        this.fLastcmd = "stepInto";
        int detail = 1;
        this.resumed(detail);
        this.fStatus = this.debugger.stepInto(this.fStepIntoResponseHandler);
        if (!this.fStatus) {
            Logger.log(204, "PHPDebugTarget: debugger.stepInto return false");
        }
    }

    public IVariable[] getVariables() {
        return this.fContextManager.getVariables();
    }

    public void breakpointHit(String fileName, int lineNumber) {
        IBreakpoint breakpoint = this.findBreakpoint(fileName, lineNumber);
        if (breakpoint != null) {
            this.fThread.setBreakpoints(new IBreakpoint[]{breakpoint});
        } else {
            this.fThread.setBreakpoints(new IBreakpoint[0]);
        }
        this.suspended(16);
    }

    protected IBreakpoint findBreakpoint(String fileName, int lineNumber) {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.php.debug.core");
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (this.supportsBreakpoint(breakpoint) && breakpoint instanceof PHPLineBreakpoint) {
                PHPLineBreakpoint lineBreakpoint = (PHPLineBreakpoint)breakpoint;
                Breakpoint zBP = lineBreakpoint.getRuntimeBreakpoint();
                String bFileName = zBP.getFileName();
                int bLineNumber = zBP.getLineNumber();
                if (bLineNumber == lineNumber && bFileName.equals(fileName)) {
                    return breakpoint;
                }
            }
            ++n2;
        }
        return null;
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint element = iBreakpointArray[n2];
            if (this.supportsBreakpoint(element)) {
                if (enabled) {
                    ((PHPLineBreakpoint)element).setConditionChanged(false);
                    this.breakpointAdded(element);
                } else {
                    this.breakpointRemoved(element, null);
                }
            }
            ++n2;
        }
    }

    public void addConsoleEventListener(IPHPConsoleEventListener listener) {
        if (!this.fConsoleEventListeners.contains(listener)) {
            this.fConsoleEventListeners.add(listener);
        }
        if (this.fDebugError != null) {
            Enumeration<DebugError> enumObject = this.fDebugError.elements();
            boolean empty = this.fDebugError.isEmpty();
            if (!empty) {
                while (enumObject.hasMoreElements()) {
                    DebugError debugError = enumObject.nextElement();
                    listener.handleEvent(debugError);
                }
            }
        }
    }

    public void removeConsoleEventListener(IPHPConsoleEventListener listener) {
        this.fConsoleEventListeners.remove(listener);
    }

    public List<IPHPConsoleEventListener> getConsoleEventListeners() {
        return this.fConsoleEventListeners;
    }

    @Override
    public DebugOutput getOutputBuffer() {
        return this.fOutput;
    }

    public boolean isRunWithDebug() {
        return this.fIsRunAsDebug;
    }

    public void fireError(String errorMessage, Exception e1) {
        Status status = new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, (Throwable)e1);
        DebugEvent event = new DebugEvent((Object)this, 32);
        event.setData((Object)status);
        this.fireEvent(event);
    }

    public void fireError(IStatus status) {
        DebugEvent event = new DebugEvent((Object)this, 32);
        event.setData((Object)status);
        this.fireEvent(event);
    }

    public void setLastStop(int lineNumber) {
        this.fLastStop = lineNumber;
    }

    public void setLastFileName(String string) {
        this.fLastFileName = string;
    }

    public void setBreakpoints(IBreakpoint[] breakpoints) {
        this.fThread.setBreakpoints(new IBreakpoint[0]);
    }

    public boolean isPHPCGI() {
        return this.fIsPHPCGI;
    }

    public StartLock getStartLock() {
        return this.fStartLock;
    }

    public void setLastCommand(String command) {
        this.fLastcmd = command;
    }

    public String getLastCommand() {
        return this.fLastcmd;
    }

    public int getRequestPort() {
        return this.fRequestPort;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public List<DebugError> getDebugErrors() {
        return this.fDebugError;
    }

    public boolean isServerWindows() {
        return this.fIsServerWindows;
    }

    public void setServerWindows(boolean isServerWindows) {
        this.fIsServerWindows = isServerWindows;
    }

    public Debugger.StartResponseHandler getStartResponseHandler() {
        return this.fStartResponseHandler;
    }

    @Override
    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return String.valueOf(className) + "@" + Integer.toHexString(this.hashCode());
    }

    public ContextManager getContextManager() {
        return this.fContextManager;
    }

    public IBreakpointManager getBreakpointManager() {
        return this.fBreakpointManager;
    }

    public PathEntry mapFirstDebugFile(String remoteFile) {
        block14: {
            if (this.getContextManager().isResolveBlacklisted(remoteFile)) {
                return null;
            }
            try {
                ILaunchConfiguration launchConfiguration = this.getLaunch().getLaunchConfiguration();
                PathMapper pathMapper = PathMapperRegistry.getByLaunchConfiguration(launchConfiguration);
                if (pathMapper == null) break block14;
                PathEntry pathEntry = pathMapper.getLocalFile(remoteFile);
                if (pathEntry == null) {
                    String debugFileName = launchConfiguration.getAttribute("file_name", null);
                    if (debugFileName == null) {
                        debugFileName = launchConfiguration.getAttribute("ATTR_FILE", null);
                    }
                    if (debugFileName != null) {
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(debugFileName);
                        if (resource instanceof IFile) {
                            pathEntry = new PathEntry(debugFileName, PathEntry.Type.WORKSPACE, (Object)resource.getParent());
                        } else if (new File(debugFileName).exists()) {
                            pathEntry = new PathEntry(debugFileName, PathEntry.Type.EXTERNAL, (Object)new File(debugFileName).getParentFile());
                        }
                    }
                    if (pathEntry != null) {
                        pathMapper.addEntry(remoteFile, pathEntry);
                        PathMapperRegistry.storeToPreferences();
                    } else {
                        pathEntry = DebugSearchEngine.find(remoteFile, this);
                    }
                }
                if (this.getProject() == null && pathEntry != null && pathEntry.getType() == PathEntry.Type.WORKSPACE) {
                    IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(pathEntry.getPath());
                    IProject project = resource.getProject();
                    this.setProject(project);
                    try {
                        ILaunchConfigurationWorkingCopy wc = launchConfiguration.getWorkingCopy();
                        wc.getAttribute("org.eclipse.php.debug.core.PHP_Project", project.getName());
                        wc.doSave();
                    }
                    catch (CoreException e) {
                        PHPDebugPlugin.log(e);
                    }
                }
                return pathEntry;
            }
            catch (Exception e) {
                PHPDebugPlugin.log(e);
            }
        }
        return null;
    }

    public boolean isStepFiltersEnabled() {
        return this.isStepFiltersEnabled;
    }

    public void setStepFiltersEnabled(boolean enabled) {
        this.isStepFiltersEnabled = enabled;
    }

    public boolean supportsStepFilters() {
        return true;
    }
}

