/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.ErrorMessages;
import JFlex.GeneratorException;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public final class Out
implements ErrorMessages {
    public static final String NL = System.getProperty("line.separator");
    public static boolean VERBOSE = true;
    public static boolean TIME;
    public static final boolean DUMP = false;
    public static int warnings;
    public static int errors;
    private static TextArea text;
    private static int col;

    public static void setGUIMode(TextArea textArea) {
        text = textArea;
    }

    public static void time(String string) {
        if (!TIME) {
            return;
        }
        if (text == null) {
            System.out.println(string);
            return;
        }
        text.append(string);
        text.append(NL);
        col = 0;
    }

    public static void println(String string) {
        if (!VERBOSE) {
            return;
        }
        if (text == null) {
            System.out.println(string);
            return;
        }
        text.append(string);
        text.append(NL);
        col = 0;
    }

    public static void print(String string) {
        if (!VERBOSE) {
            return;
        }
        if (text == null) {
            System.out.print(string);
            return;
        }
        text.append(string);
        if ((col += string.length()) >= 78) {
            text.append(NL);
            col = 0;
        }
    }

    public static void dump(String string) {
    }

    private static void err(String string) {
        if (text == null) {
            System.out.println(string);
            return;
        }
        text.append(string);
        text.append(NL);
        col = 0;
    }

    public static void checkErrors() {
        if (errors > 0) {
            throw new GeneratorException();
        }
    }

    public static void statistics() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(errors) + " error");
        if (errors != 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(", " + warnings + " warning");
        if (warnings != 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(".");
        Out.err(stringBuffer.toString());
    }

    public static void resetCounters() {
        errors = 0;
        warnings = 0;
    }

    public static void warning(String string) {
        ++warnings;
        Out.err(String.valueOf(NL) + "Warning : " + string);
    }

    public static void warning(int n, int n2) {
        ++warnings;
        String string = String.valueOf(NL) + "Warning";
        if (n2 > 0) {
            string = String.valueOf(string) + " in line " + (n2 + 1);
        }
        Out.err(String.valueOf(string) + ": " + ErrorMessages.messages[n]);
    }

    public static void error(String string) {
        ++errors;
        Out.err(String.valueOf(NL) + string);
    }

    public static void error(int n) {
        ++errors;
        Out.err(String.valueOf(NL) + "Error: " + ErrorMessages.messages[n]);
    }

    public static void error(File file, int n, int n2, int n3) {
        String string = String.valueOf(NL) + "Error";
        if (n2 >= 0) {
            string = String.valueOf(string) + " in line " + (n2 + 1);
        }
        try {
            Out.err(String.valueOf(string) + ": " + ErrorMessages.messages[n]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Out.err(string);
        }
        if (n2 >= 0) {
            if (n3 >= 0) {
                Out.showError(file, n2, n3);
                return;
            }
            Out.showError(file, n2);
            return;
        }
        ++errors;
    }

    public static void showError(File file, int n, int n2) {
        ++errors;
        try {
            String string = Out.getLine(file, n);
            if (string != null) {
                Out.err(string);
                if (n2 < 0) {
                    return;
                }
                String string2 = "^";
                int n3 = 0;
                while (n3 < n2) {
                    string2 = " " + string2;
                    ++n3;
                }
                Out.err(string2);
                return;
            }
        }
        catch (IOException iOException) {}
    }

    public static void showError(File file, int n) {
        ++errors;
        try {
            String string = Out.getLine(file, n);
            if (string != null) {
                Out.err(string);
                return;
            }
        }
        catch (IOException iOException) {}
    }

    private static String getLine(File file, int n) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = "";
        int n2 = 0;
        while (n2 <= n) {
            string = bufferedReader.readLine();
            ++n2;
        }
        bufferedReader.close();
        return string;
    }
}

