/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpBaseVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpBoolValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpContainerValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpNullValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpNumValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpResourceValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStringValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpUnInitValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.w3c.dom.Node;

public class DBGpVariable
extends DBGpBaseVariable
implements IVariable {
    static final String PHP_BOOL = "bool";
    static final String PHP_INT = "int";
    static final String PHP_FLOAT = "float";
    static final String PHP_STRING = "string";
    static final String PHP_NULL = "null";
    static final String PHP_ARRAY = "array";
    static final String PHP_OBJECT = "object";
    static final String PHP_RESOURCE = "resource";
    static final String PHP_UNINIT = "uninitialized";
    private DBGpValue value;
    private String name;
    private String type;

    public DBGpVariable(DBGpTarget target, Node property, String level) {
        super(target, level);
        this.parseProperty(property);
    }

    private void parseProperty(Node property) {
        this.name = DBGpResponse.getAttribute(property, "name");
        this.setFullName(DBGpResponse.getAttribute(property, "fullname"));
        if (this.getFullName().length() > 1 && this.name.equals(this.getFullName().substring(1))) {
            this.name = this.getFullName();
        }
        this.setAddress(DBGpResponse.getAttribute(property, "address"));
        this.type = DBGpResponse.getAttribute(property, "type");
        if (this.type.equals(PHP_BOOL)) {
            this.value = new DBGpBoolValue(this, property);
        } else if (this.type.equals(PHP_INT)) {
            this.value = new DBGpNumValue(this, property, PHP_INT);
        } else if (this.type.equals(PHP_FLOAT)) {
            this.value = new DBGpNumValue(this, property, PHP_FLOAT);
        } else if (this.type.equals(PHP_STRING)) {
            String size = DBGpResponse.getAttribute(property, "size");
            int strByteLen = -1;
            try {
                strByteLen = Integer.parseInt(size);
            }
            catch (NumberFormatException numberFormatException) {}
            this.value = new DBGpStringValue(this, property, strByteLen);
        } else {
            this.value = this.type.equals(PHP_RESOURCE) ? new DBGpResourceValue(this, property) : (this.type.equals(PHP_NULL) ? new DBGpNullValue(this, property) : (this.type.equals(PHP_UNINIT) ? new DBGpUnInitValue(this) : (this.type.equals(PHP_ARRAY) || this.type.equals(PHP_OBJECT) ? new DBGpContainerValue(this, property) : new DBGpUnInitValue(this))));
        }
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.type;
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
        if (!this.verifyValue(expression)) {
            Status stat = new Status(2, "org.eclipse.php.debug.core", "setValue called, but verifyValue failed");
            throw new DebugException((IStatus)stat);
        }
        if (!((DBGpTarget)this.getDebugTarget()).setProperty(this, expression)) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.php.debug.core", 5010, "program under debug rejected value change", null));
        }
        this.value.setValue(expression);
        this.fireChangeEvent(512);
    }

    public void setValue(IValue xvalue) throws DebugException {
        this.setValue(xvalue.getValueString());
    }

    public void replaceValue(IValue value) {
        if (value instanceof DBGpValue) {
            this.value = (DBGpValue)value;
            this.fireChangeEvent(512);
        }
    }

    public boolean supportsValueModification() {
        return this.value.isModifiable() && this.getFullName() != null && this.getFullName().trim().length() != 0;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return this.value.verifyValue(expression);
    }

    public boolean verifyValue(IValue xvalue) throws DebugException {
        return this.verifyValue(xvalue.getValueString());
    }
}

