/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger.parameters;

import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.zend.debugger.parameters.AbstractDebugParametersInitializer;

public class DefaultDebugParametersInitializer
extends AbstractDebugParametersInitializer {
    public Hashtable generateQueryParameters(ILaunch launch) {
        String sessID;
        ILaunchConfiguration launchConfiguration;
        String url;
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        parameters.put("start_debug=", "1");
        String port = launch.getAttribute("port");
        if (port != null) {
            parameters.put("debug_port=", port);
        } else {
            PHPDebugPlugin.logErrorMessage("A port was not defined for the DefaultDebugParametersInitializer.");
        }
        if (this.getBooleanValue(launch.getAttribute("passiveDebug"))) {
            parameters.put("debug_passive=", "1");
        }
        parameters.put("send_sess_end=", "1");
        if (this.getBooleanValue(launch.getAttribute("webServerDebugger"))) {
            parameters.put("debug_host=", PHPDebugPlugin.getDebugHosts());
            parameters.put("debug_no_cache=", Long.toString(System.currentTimeMillis()));
        }
        if ("debug".equals(launch.getLaunchMode()) && this.getBooleanValue(launch.getAttribute("firstLineBreakpoint"))) {
            parameters.put("debug_stop=", "1");
        }
        if ((url = launch.getAttribute("uriginalURL")) != null) {
            parameters.put("original_url=", url);
        }
        if ((launchConfiguration = launch.getLaunchConfiguration()) != null) {
            try {
                String sessionSetting = launchConfiguration.getAttribute("debugPages", "debugAllPages");
                if ("debugAllPages".equals(sessionSetting)) {
                    parameters.put("debug_start_session=", "1");
                } else if ("debugFirstPage".equals(sessionSetting)) {
                    parameters.put("debug_new_session=", "1");
                } else if ("debugFrom".equals(sessionSetting)) {
                    parameters.put("debug_start_url=", launchConfiguration.getAttribute("debugContinue", ""));
                    if (launchConfiguration.getAttribute("debugFromURL", false)) {
                        parameters.put("debug_cont_session=", "1");
                    }
                }
            }
            catch (CoreException ce) {
                Logger.logException(ce);
            }
        }
        if ((sessID = launch.getAttribute("debugSessionID")) != null) {
            parameters.put("debug_session_id=", sessID);
        }
        return parameters;
    }

    public String getRequestURL(ILaunch launch) {
        String url = launch.getAttribute("uriginalURL");
        return url != null ? url.trim() : "";
    }

    public boolean getBooleanValue(String value) {
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }
}

