/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.codeassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.TypeNameRequestor;
import org.eclipse.dltk.internal.core.AbstractSourceModule;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.util.HandleFactory;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.InstanceContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.codeassist.FakeGroupMethod;
import org.eclipse.php.core.codeassist.FakeGroupType;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.mixin.PHPMixinModel;
import org.eclipse.php.internal.core.typeinference.FakeType;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferencer;
import org.eclipse.php.internal.core.typeinference.goals.ClassVariableDeclarationGoal;
import org.eclipse.php.internal.core.typeinference.goals.MethodElementReturnTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocClassVariableGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocMethodReturnTypeGoal;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;

public class CodeAssistUtils {
    public static final int EXACT_NAME = 1;
    public static final int CASE_SENSITIVE = 2;
    public static final int ONLY_CURRENT_FILE = 4;
    public static final int ONLY_CLASSES = 8;
    public static final int ONLY_INTERFACES = 16;
    public static final int ONLY_VARIABLES = 32;
    public static final int USE_PHPDOC = 32;
    private static final String SELF = "self";
    private static final String DOLLAR = "$";
    private static final String WILDCARD = "*";
    private static final String PAAMAYIM_NEKUDOTAIM = "::";
    protected static final String CLASS_FUNCTIONS_TRIGGER = "::";
    protected static final String OBJECT_FUNCTIONS_TRIGGER = "->";
    private static final Pattern globalPattern = Pattern.compile("\\$GLOBALS[\\s]*\\[[\\s]*[\\'\\\"][\\w]+[\\'\\\"][\\s]*\\]");
    private static final IModelElement[] EMPTY = new IModelElement[0];
    private static final IType[] EMPTY_TYPES = new IType[0];

    public static boolean startsWithIgnoreCase(String word, String prefix) {
        return word.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static IMethod[] getSuperClassMethods(IType type, String prefix, int mask) {
        TreeSet<IModelElement> methods;
        block9: {
            methods = new TreeSet<IModelElement>(new AlphabeticComparator());
            try {
                if (type.getSuperClasses() != null) {
                    if (prefix.length() == 0) {
                        IType[] allSuperclasses;
                        ITypeHierarchy superTypeHierarchy = type.newSupertypeHierarchy(null);
                        IType[] iTypeArray = allSuperclasses = superTypeHierarchy.getAllSuperclasses(type);
                        int n = allSuperclasses.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType superClass = iTypeArray[n2];
                            IMethod[] iMethodArray = superClass.getMethods();
                            int n3 = iMethodArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IMethod method = iMethodArray[n4];
                                methods.add((IModelElement)method);
                                ++n4;
                            }
                            ++n2;
                        }
                    } else {
                        int matchRule;
                        boolean exactName;
                        SearchEngine searchEngine = new SearchEngine();
                        IDLTKSearchScope scope = SearchEngine.createSuperHierarchyScope((IType)type);
                        boolean bl = exactName = (mask & 1) != 0;
                        if (prefix.length() == 0 && !exactName) {
                            prefix = WILDCARD;
                            matchRule = 2;
                        } else {
                            matchRule = exactName ? 0 : 129;
                        }
                        SearchPattern pattern = SearchPattern.createPattern((String)prefix, (int)1, (int)0, (int)matchRule, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
                        searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                                methods.add((IMethod)match.getElement());
                            }
                        }, null);
                    }
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG_COMPLETION) break block9;
                e.printStackTrace();
            }
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    public static IMethod[] getClassMethods(IType type, String prefix, int mask) {
        TreeSet<IModelElement> methods;
        block9: {
            methods = new TreeSet<IModelElement>(new AlphabeticComparator());
            HashSet<String> methodNames = new HashSet<String>();
            boolean exactName = (mask & 1) != 0;
            try {
                IMethod[] superClassMethods;
                IMethod[] typeMethods;
                IMethod[] iMethodArray = typeMethods = type.getMethods();
                int n = typeMethods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod typeMethod = iMethodArray[n2];
                    String methodName = typeMethod.getElementName();
                    if (exactName) {
                        if (methodName.equalsIgnoreCase(prefix)) {
                            methods.add((IModelElement)typeMethod);
                            methodNames.add(methodName.toLowerCase());
                            break;
                        }
                    } else if (CodeAssistUtils.startsWithIgnoreCase(methodName, prefix)) {
                        methods.add((IModelElement)typeMethod);
                    }
                    ++n2;
                }
                IMethod[] iMethodArray2 = superClassMethods = CodeAssistUtils.getSuperClassMethods(type, prefix, mask);
                int n3 = superClassMethods.length;
                n = 0;
                while (n < n3) {
                    String methodName;
                    IMethod superClassMethod = iMethodArray2[n];
                    if (!type.equals(superClassMethod.getDeclaringType()) && !methodNames.contains(methodName = superClassMethod.getElementName().toLowerCase())) {
                        methods.add((IModelElement)superClassMethod);
                        methodNames.add(methodName);
                    }
                    ++n;
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG_COMPLETION) break block9;
                e.printStackTrace();
            }
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    public static IField[] getClassFields(IType type, String prefix, int mask) {
        TreeSet<IModelElement> fields;
        block22: {
            boolean exactName = (mask & 1) != 0;
            boolean searchConstants = (mask & 0x20) == 0;
            fields = new TreeSet<IModelElement>(new AlphabeticComparator());
            try {
                LinkedList<IType> searchTypes = new LinkedList<IType>();
                if (prefix.length() == 0) {
                    searchTypes.add(type);
                    ITypeHierarchy superTypeHierarchy = type.newSupertypeHierarchy(null);
                    IType[] allSuperclasses = superTypeHierarchy.getAllSuperclasses(type);
                    searchTypes.addAll((Collection)Arrays.asList(allSuperclasses));
                } else if (type.getSuperClasses() != null) {
                    SearchPattern pattern;
                    int matchRule;
                    SearchEngine searchEngine = new SearchEngine();
                    if (prefix.length() == 0 && !exactName) {
                        prefix = WILDCARD;
                        matchRule = 2;
                    } else {
                        matchRule = exactName ? 0 : 129;
                    }
                    IDLTKSearchScope scope = SearchEngine.createSuperHierarchyScope((IType)type);
                    if (searchConstants) {
                        pattern = SearchPattern.createPattern((String)prefix, (int)2, (int)0, (int)matchRule, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
                        searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                                fields.add((IField)match.getElement());
                            }
                        }, null);
                    }
                    pattern = SearchPattern.createPattern((String)(DOLLAR + prefix), (int)2, (int)0, (int)matchRule, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
                    searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                        public void acceptSearchMatch(SearchMatch match) throws CoreException {
                            fields.add((IField)match.getElement());
                        }
                    }, null);
                } else {
                    searchTypes.add(type);
                }
                block2: for (IType searchType : searchTypes) {
                    IField[] typeFields;
                    IField[] iFieldArray = typeFields = searchType.getFields();
                    int n = typeFields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IField typeField = iFieldArray[n2];
                        String elementName = typeField.getElementName();
                        int flags = typeField.getFlags();
                        if ((flags & 4) != 0) {
                            if (exactName) {
                                if (elementName.equals(prefix)) {
                                    fields.add((IModelElement)typeField);
                                    continue block2;
                                }
                            } else if (elementName.startsWith(prefix)) {
                                fields.add((IModelElement)typeField);
                            }
                        } else {
                            String tmp = prefix;
                            if (!tmp.startsWith(DOLLAR)) {
                                tmp = DOLLAR + tmp;
                            }
                            if (exactName) {
                                if (elementName.equals(tmp)) {
                                    fields.add((IModelElement)typeField);
                                    continue block2;
                                }
                            } else if (elementName.startsWith(tmp)) {
                                fields.add((IModelElement)typeField);
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG_COMPLETION) break block22;
                e.printStackTrace();
            }
        }
        return fields.toArray(new IField[fields.size()]);
    }

    public static IType[] getVariableType(IType[] types, String propertyName, int offset, int line) {
        if (types != null) {
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                PHPClassType classType = new PHPClassType(type.getElementName());
                IField[] fields = CodeAssistUtils.getClassFields(type, propertyName, 34);
                HashSet<String> processedFields = new HashSet<String>();
                IField[] iFieldArray = fields;
                int n3 = fields.length;
                int n4 = 0;
                while (n4 < n3) {
                    IField field = iFieldArray[n4];
                    String variableName = field.getElementName();
                    if (!processedFields.contains(variableName)) {
                        processedFields.add(variableName);
                        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)field.getSourceModule(), null);
                        BasicContext sourceModuleContext = new BasicContext(field.getSourceModule(), moduleDeclaration);
                        InstanceContext instanceContext = new InstanceContext((ISourceModuleContext)sourceModuleContext, (IEvaluatedType)classType);
                        PHPTypeInferencer typeInferencer = new PHPTypeInferencer();
                        PHPDocClassVariableGoal phpDocGoal = new PHPDocClassVariableGoal(instanceContext, variableName);
                        IEvaluatedType evaluatedType = typeInferencer.evaluateTypePHPDoc(phpDocGoal, 3000);
                        IModelElement[] modelElements = PHPTypeInferenceUtils.getModelElements(evaluatedType, (ISourceModuleContext)sourceModuleContext);
                        if (modelElements != null) {
                            return CodeAssistUtils.modelElementsToTypes(modelElements);
                        }
                        ClassVariableDeclarationGoal goal = new ClassVariableDeclarationGoal((IContext)sourceModuleContext, types, variableName);
                        evaluatedType = typeInferencer.evaluateType(goal);
                        modelElements = PHPTypeInferenceUtils.getModelElements(evaluatedType, (ISourceModuleContext)sourceModuleContext);
                        if (modelElements != null) {
                            return CodeAssistUtils.modelElementsToTypes(modelElements);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return EMPTY_TYPES;
    }

    public static IType[] getVariableType(ISourceModule sourceModule, String variableName, int position, int line) {
        VariableReference varReference;
        ExpressionTypeGoal goal;
        PHPTypeInferencer typeInferencer;
        IEvaluatedType evaluatedType;
        IModelElement[] modelElements;
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        IContext context = ASTUtils.findContext(sourceModule, moduleDeclaration, position);
        if (context != null && (modelElements = PHPTypeInferenceUtils.getModelElements(evaluatedType = (typeInferencer = new PHPTypeInferencer()).evaluateType((AbstractTypeGoal)(goal = new ExpressionTypeGoal(context, (ASTNode)(varReference = new VariableReference(position, position + variableName.length(), variableName))))), (ISourceModuleContext)context)) != null) {
            return CodeAssistUtils.modelElementsToTypes(modelElements);
        }
        return EMPTY_TYPES;
    }

    public static IType[] modelElementsToTypes(IModelElement[] elements) {
        ArrayList<IType> types = new ArrayList<IType>(elements.length);
        IModelElement[] iModelElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement element = iModelElementArray[n2];
            types.add((IType)element);
            ++n2;
        }
        return types.toArray(new IType[types.size()]);
    }

    public static IType[] getFunctionReturnType(IType type, String functionName) {
        IMethod[] classMethod = CodeAssistUtils.getClassMethods(type, functionName, 1);
        if (classMethod.length > 0) {
            return CodeAssistUtils.getFunctionReturnType(classMethod[0]);
        }
        return EMPTY_TYPES;
    }

    public static IType[] getFunctionReturnType(IMethod method) {
        return CodeAssistUtils.getFunctionReturnType(method, 32);
    }

    public static IType[] getFunctionReturnType(IMethod method, int mask) {
        PHPDocMethodReturnTypeGoal phpDocGoal;
        IEvaluatedType evaluatedType;
        IModelElement[] modelElements;
        boolean usePhpDoc;
        PHPTypeInferencer typeInferencer = new PHPTypeInferencer();
        PHPClassType classType = null;
        if (method.getDeclaringType() != null) {
            classType = new PHPClassType(method.getDeclaringType().getElementName());
        }
        ISourceModule sourceModule = method.getSourceModule();
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        BasicContext sourceModuleContext = new BasicContext(sourceModule, moduleDeclaration);
        InstanceContext instanceContext = new InstanceContext((ISourceModuleContext)sourceModuleContext, (IEvaluatedType)classType);
        boolean bl = usePhpDoc = (mask & 0x20) != 0;
        if (usePhpDoc && (modelElements = PHPTypeInferenceUtils.getModelElements(evaluatedType = typeInferencer.evaluateTypePHPDoc(phpDocGoal = new PHPDocMethodReturnTypeGoal((IContext)instanceContext, method.getElementName()), 3000), (ISourceModuleContext)sourceModuleContext)) != null) {
            return CodeAssistUtils.modelElementsToTypes(modelElements);
        }
        MethodElementReturnTypeGoal methodGoal = new MethodElementReturnTypeGoal((IContext)instanceContext, method);
        evaluatedType = typeInferencer.evaluateType(methodGoal);
        modelElements = PHPTypeInferenceUtils.getModelElements(evaluatedType, (ISourceModuleContext)sourceModuleContext);
        if (modelElements != null) {
            return CodeAssistUtils.modelElementsToTypes(modelElements);
        }
        return EMPTY_TYPES;
    }

    public static IType getContainerClassData(ISourceModule sourceModule, int offset) {
        IModelElement type;
        block3: {
            type = null;
            try {
                type = sourceModule.getElementAt(offset);
                while (type != null && !(type instanceof IType)) {
                    type = type.getParent();
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG_COMPLETION) break block3;
                e.printStackTrace();
            }
        }
        return (IType)type;
    }

    public static IMethod getContainerMethodData(ISourceModule sourceModule, int offset) {
        block3: {
            try {
                IModelElement method = sourceModule.getElementAt(offset);
                if (method instanceof IMethod) {
                    return (IMethod)method;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG_COMPLETION) break block3;
                e.printStackTrace();
            }
        }
        return null;
    }

    public static int getFunctionNameEndOffset(TextSequence statementText, int offset) {
        if (statementText.charAt(offset) != ')') {
            return 0;
        }
        int currChar = offset;
        int bracketsNum = 1;
        char inStringMode = '\u0000';
        while (bracketsNum != 0 && currChar >= 0) {
            char charAt;
            if ((charAt = statementText.charAt(--currChar)) == '\'' || charAt == '\"') {
                char c = inStringMode == '\u0000' ? charAt : (inStringMode = inStringMode == charAt ? (char)'\u0000' : inStringMode);
            }
            if (inStringMode != '\u0000') continue;
            if (charAt == ')') {
                ++bracketsNum;
                continue;
            }
            if (charAt != '(') continue;
            --bracketsNum;
        }
        return currChar;
    }

    public static IType getSelfClassData(ISourceModule sourceModule, int offset) {
        block4: {
            IType type = CodeAssistUtils.getContainerClassData(sourceModule, offset);
            IMethod method = CodeAssistUtils.getContainerMethodData(sourceModule, offset);
            if (type != null && method != null) {
                try {
                    int modifiers = type.getFlags();
                    if ((modifiers & 1) == 0 && (modifiers & 0x10) == 0) {
                        return type;
                    }
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG_COMPLETION) break block4;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static boolean isFunctionCall(String functionName, IScriptProject scriptProject) {
        IModelElement[] functions;
        IModelElement[] iModelElementArray = functions = scriptProject == null ? PHPMixinModel.getWorkspaceInstance().getFunction(functionName) : PHPMixinModel.getInstance(scriptProject).getFunction(functionName);
        return functions.length > 0;
    }

    public static IType[] getTypesFor(ISourceModule sourceModule, TextSequence statementText, int endPosition, int offset, int line) {
        int propertyEndPosition;
        int lastObjectOperator;
        endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, endPosition);
        boolean isClassTriger = false;
        if (endPosition < 2) {
            return EMPTY_TYPES;
        }
        String triggerText = statementText.subSequence(endPosition - 2, endPosition).toString();
        if (!triggerText.equals(OBJECT_FUNCTIONS_TRIGGER)) {
            if (triggerText.equals("::")) {
                isClassTriger = true;
            } else {
                return EMPTY_TYPES;
            }
        }
        if ((lastObjectOperator = PHPTextSequenceUtilities.getPrivousTriggerIndex(statementText, propertyEndPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, endPosition - 2))) == -1) {
            return CodeAssistUtils.innerGetClassName(sourceModule, statementText, propertyEndPosition, isClassTriger, offset, line);
        }
        int propertyStartPosition = PHPTextSequenceUtilities.readForwardSpaces(statementText, lastObjectOperator + 2);
        String propertyName = statementText.subSequence(propertyStartPosition, propertyEndPosition).toString();
        IType[] types = CodeAssistUtils.getTypesFor(sourceModule, statementText, propertyStartPosition, offset, line);
        int bracketIndex = propertyName.indexOf(40);
        if (bracketIndex == -1) {
            return CodeAssistUtils.getVariableType(types, propertyName, offset, line);
        }
        String functionName = propertyName.substring(0, bracketIndex).trim();
        LinkedHashSet result = new LinkedHashSet();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            IType[] returnTypes = CodeAssistUtils.getFunctionReturnType(type, functionName);
            if (returnTypes != null) {
                result.addAll(Arrays.asList(returnTypes));
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static IType[] innerGetClassName(ISourceModule sourceModule, TextSequence statementText, int propertyEndPosition, boolean isClassTriger, int offset, int line) {
        String testedVar;
        Matcher m;
        int classNameStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, propertyEndPosition, true);
        String className = statementText.subSequence(classNameStart, propertyEndPosition).toString();
        if (isClassTriger) {
            IType classData;
            if (className.equals(SELF) ? (classData = CodeAssistUtils.getContainerClassData(sourceModule, offset - 6)) != null : className.equals("parent") && (classData = CodeAssistUtils.getContainerClassData(sourceModule, offset - 8)) != null) {
                return new IType[]{classData};
            }
            if (className.length() > 0) {
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
                BasicContext context = new BasicContext(sourceModule, moduleDeclaration);
                PHPClassType type = new PHPClassType(className);
                return CodeAssistUtils.modelElementsToTypes(PHPTypeInferenceUtils.getModelElements((IEvaluatedType)type, (ISourceModuleContext)context));
            }
        }
        if (className.length() == 0 && (m = globalPattern.matcher(testedVar = statementText.subSequence(0, propertyEndPosition).toString().trim())).matches()) {
            String quotedVarName = testedVar.substring(testedVar.indexOf(91) + 1, testedVar.indexOf(93)).trim();
            className = DOLLAR + quotedVarName.substring(1, quotedVarName.length() - 1);
        }
        if (className.length() > 0 && className.charAt(0) == '$') {
            int statementStart = offset - statementText.length();
            return CodeAssistUtils.getVariableType(sourceModule, className, statementStart, line);
        }
        if (statementText.charAt(propertyEndPosition - 1) == ')') {
            IModelElement[] functions;
            int functionNameEnd = CodeAssistUtils.getFunctionNameEndOffset(statementText, propertyEndPosition - 1);
            int functionNameStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, functionNameEnd, false);
            String functionName = statementText.subSequence(functionNameStart, functionNameEnd).toString();
            IType classData = CodeAssistUtils.getContainerClassData(sourceModule, offset);
            if (classData != null) {
                return CodeAssistUtils.getFunctionReturnType(classData, functionName);
            }
            LinkedHashSet returnTypes = new LinkedHashSet();
            IModelElement[] iModelElementArray = functions = CodeAssistUtils.getGlobalMethods(sourceModule, functionName, 1);
            int n = functions.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement function = iModelElementArray[n2];
                IType[] types = CodeAssistUtils.getFunctionReturnType((IMethod)function);
                if (types != null) {
                    returnTypes.addAll(Arrays.asList(types));
                }
                ++n2;
            }
            return returnTypes.toArray(new IType[returnTypes.size()]);
        }
        return EMPTY_TYPES;
    }

    public static boolean isClassFunctionCall(ISourceModule sourceModule, IType[] className, String functionName) {
        IType[] iTypeArray = className;
        int n = className.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IType type = iTypeArray[n2];
                try {
                    IMethod[] classMethod = PHPModelUtils.getClassMethod(type, functionName, null);
                    if (classMethod != null) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG_COMPLETION) break block4;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return false;
    }

    public static IType[] getGlobalTypes(ISourceModule sourceModule, String prefix, int mask) {
        IModelElement[] elements = CodeAssistUtils.getGlobalElements(sourceModule, prefix, 0, mask);
        LinkedList<IType> filteredElements = new LinkedList<IType>();
        IModelElement[] iModelElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IModelElement c = iModelElementArray[n2];
                IType type = (IType)c;
                try {
                    if (!((mask & 0x10) != 0 && (type.getFlags() & 0x10) == 0 || (mask & 8) != 0 && (type.getFlags() & 0x10) != 0)) {
                        filteredElements.add(type);
                    }
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG_COMPLETION) break block4;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return filteredElements.toArray(new IType[filteredElements.size()]);
    }

    public static IModelElement[] getGlobalMethods(ISourceModule sourceModule, String prefix, int mask) {
        return CodeAssistUtils.getGlobalElements(sourceModule, prefix, 1, mask);
    }

    public static IModelElement[] getGlobalFields(ISourceModule sourceModule, String prefix, int mask) {
        return CodeAssistUtils.getGlobalElements(sourceModule, prefix, 2, mask);
    }

    public static IModelElement[] getGlobalOrMethodFields(ISourceModule sourceModule, int offset, String prefix, int mask) {
        block4: {
            try {
                IModelElement enclosingElement = sourceModule.getElementAt(offset);
                if (enclosingElement instanceof IField) {
                    enclosingElement = enclosingElement.getParent();
                }
                if (enclosingElement instanceof IMethod) {
                    IMethod method = (IMethod)enclosingElement;
                    return CodeAssistUtils.getMethodFields(method, prefix, mask);
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG_COMPLETION) break block4;
                e.printStackTrace();
            }
        }
        return CodeAssistUtils.getGlobalFields(sourceModule, prefix, mask);
    }

    public static IModelElement[] getMethodFields(IMethod method, String prefix, int mask) {
        TreeSet<IModelElement> elements;
        block4: {
            int matchRule;
            boolean exactName;
            SearchEngine searchEngine = new SearchEngine();
            IDLTKLanguageToolkit toolkit = PHPLanguageToolkit.getDefault();
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement[])new IModelElement[]{method}, (IDLTKLanguageToolkit)toolkit);
            boolean bl = exactName = (mask & 1) != 0;
            if (prefix.length() == 0 && !exactName) {
                prefix = WILDCARD;
                matchRule = 2;
            } else {
                matchRule = exactName ? 0 : 129;
            }
            SearchPattern pattern = SearchPattern.createPattern((String)prefix, (int)2, (int)0, (int)matchRule, (IDLTKLanguageToolkit)toolkit);
            elements = new TreeSet<IModelElement>(new AlphabeticComparator());
            try {
                searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){
                    private Set<String> processedVars = new HashSet<String>();

                    public void acceptSearchMatch(SearchMatch match) throws CoreException {
                        IModelElement element = (IModelElement)match.getElement();
                        String elementName = element.getElementName();
                        if (!this.processedVars.contains(elementName)) {
                            this.processedVars.add(elementName);
                            elements.add(element);
                        }
                    }
                }, null);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG_COMPLETION) break block4;
                e.printStackTrace();
            }
        }
        return elements.toArray(new IModelElement[elements.size()]);
    }

    private static IModelElement[] getGlobalElements(ISourceModule sourceModule, String prefix, int elementType, int mask) {
        IDLTKLanguageToolkit toolkit = PHPLanguageToolkit.getDefault();
        boolean isVariable = elementType == 2 && prefix.startsWith(DOLLAR);
        IScriptProject scriptProject = sourceModule.getScriptProject();
        if (!ScriptProject.hasScriptNature((IProject)scriptProject.getProject())) {
            return CodeAssistUtils.getSourceModuleElements(sourceModule, prefix, elementType, mask);
        }
        IDLTKSearchScope scope = (mask & 4) != 0 ? SearchEngine.createSearchScope((IModelElement)sourceModule) : (scriptProject != null ? SearchEngine.createSearchScope((IModelElement)scriptProject) : SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit));
        if ((mask & 1) == 0 & (mask & 4) == 0 && isVariable) {
            PHPMixinModel mixinModel = scriptProject == null ? PHPMixinModel.getWorkspaceInstance() : PHPMixinModel.getInstance(scriptProject);
            IModelElement[] variables = mixinModel.getVariable(String.valueOf(prefix) + WILDCARD, null, null, scope);
            return variables == null ? EMPTY : CodeAssistUtils.filterOtherFilesElements(sourceModule, variables);
        }
        return CodeAssistUtils.getGlobalElements(sourceModule, scope, prefix, elementType, mask);
    }

    private static IModelElement[] getGlobalElements(ISourceModule sourceModule, final IDLTKSearchScope scope, String prefix, int elementType, int mask) {
        TreeSet<IModelElement> elements;
        boolean showGroupOptions;
        HashSet<String> groups;
        boolean currentFileOnly;
        block38: {
            int matchRule;
            HashSet<String> elementsToSearch;
            boolean caseSensitive;
            boolean exactName;
            SearchPattern pattern;
            SearchEngine searchEngine;
            IDLTKLanguageToolkit toolkit;
            block39: {
                String[] elementNames;
                toolkit = PHPLanguageToolkit.getDefault();
                searchEngine = new SearchEngine();
                pattern = null;
                exactName = (mask & 1) != 0;
                caseSensitive = (mask & 2) != 0;
                currentFileOnly = (mask & 4) != 0;
                elementsToSearch = new HashSet<String>();
                groups = new HashSet<String>();
                showGroupOptions = PHPCorePlugin.getDefault().getPluginPreferences().getBoolean("contentAssistGroupOptions");
                if (prefix.startsWith(DOLLAR) || currentFileOnly || !showGroupOptions || elementType != 0 && elementType != 1 || exactName) break block39;
                MixinModel mixinModel = PHPMixinModel.getInstance(sourceModule.getScriptProject()).getRawModel();
                if (elementType == 0) {
                    if ((mask & 8) != 0) {
                        elementNames = mixinModel.findKeys(prefix + WILDCARD + "%");
                    } else if ((mask & 0x10) != 0) {
                        elementNames = mixinModel.findKeys(prefix + WILDCARD + ">");
                    } else {
                        String[] classNames = mixinModel.findKeys(prefix + WILDCARD + "%");
                        String[] interfaceNames = mixinModel.findKeys(prefix + WILDCARD + ">");
                        elementNames = new String[classNames.length + interfaceNames.length];
                        System.arraycopy(classNames, 0, elementNames, 0, classNames.length);
                        System.arraycopy(interfaceNames, 0, elementNames, classNames.length, interfaceNames.length);
                    }
                } else {
                    elementNames = mixinModel.findKeys(MixinModel.SEPARATOR + prefix + WILDCARD);
                }
                HashSet<String> elementNamesSet = new HashSet<String>();
                String[] stringArray = elementNames;
                int n = elementNames.length;
                int n2 = 0;
                while (n2 < n) {
                    block42: {
                        String elementName;
                        block41: {
                            block40: {
                                elementName = stringArray[n2];
                                if (elementType != 0) break block40;
                                elementName = elementName.substring(0, elementName.length() - 1);
                                break block41;
                            }
                            if (!Character.isJavaIdentifierPart(elementName.substring(elementName.length() - 1).charAt(0)) || (elementName = elementName.substring(1)).indexOf(123) != -1 || elementName.charAt(0) == '$') break block42;
                        }
                        elementNamesSet.add(elementName);
                    }
                    ++n2;
                }
                elementNames = elementNamesSet.toArray(new String[elementNamesSet.size()]);
                int prefixLength = prefix.length();
                String[] stringArray2 = elementNames;
                int n3 = elementNames.length;
                n = 0;
                while (n < n3) {
                    String elementName = stringArray2[n];
                    int nsIdx = elementName.substring(prefixLength).indexOf(95);
                    if ((nsIdx >= 0 && prefixLength > 0 || prefixLength == 0 && nsIdx > 0) && nsIdx < elementName.length() - 1) {
                        groups.add(elementName.substring(0, prefixLength + nsIdx));
                    }
                    ++n;
                }
                LinkedList filteredGroups = new LinkedList();
                for (String group : groups) {
                    LinkedList<String> filteredElements = new LinkedList<String>();
                    String[] stringArray3 = elementNames;
                    int n4 = elementNames.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        String elementName = stringArray3[n5];
                        if (elementName.startsWith(group)) {
                            int underscore = elementName.lastIndexOf(95);
                            if (underscore < group.length()) {
                                elementsToSearch.add(elementName);
                            } else if (elementName.charAt(group.length()) == '_') {
                                filteredElements.add(elementName);
                            }
                        }
                        ++n5;
                    }
                    if (filteredElements.size() != 1) continue;
                    elementsToSearch.add((String)filteredElements.get(0));
                    filteredGroups.add(group);
                }
                Iterator iterator = filteredGroups.iterator();
                while (iterator.hasNext()) {
                    String filteredGroup = (String)iterator.next();
                    groups.remove(filteredGroup);
                }
            }
            if (prefix.length() == 0 && !exactName) {
                prefix = WILDCARD;
                matchRule = 2;
                if (caseSensitive) {
                    matchRule |= 8;
                }
            } else if (caseSensitive) {
                matchRule = exactName ? 0 : 1;
                matchRule |= 8;
            } else {
                int n = matchRule = exactName ? 0 : 129;
            }
            if (groups.size() > 0) {
                if (elementsToSearch.size() > 0) {
                    StringBuilder buf = new StringBuilder();
                    int i = elementsToSearch.size();
                    for (String elementName : elementsToSearch) {
                        buf.append(elementName);
                        if (--i <= 0) continue;
                        buf.append('|');
                    }
                    pattern = SearchPattern.createPattern((String)buf.toString(), (int)elementType, (int)0, (int)4, (IDLTKLanguageToolkit)toolkit);
                }
            } else {
                pattern = SearchPattern.createPattern((String)prefix, (int)elementType, (int)0, (int)matchRule, (IDLTKLanguageToolkit)toolkit);
            }
            elements = new TreeSet<IModelElement>(new AlphabeticComparator(sourceModule));
            if (pattern != null) {
                try {
                    if (elementType == 0) {
                        final HandleFactory handleFactory = new HandleFactory();
                        searchEngine.searchAllTypeNames(null, 0, prefix.toCharArray(), pattern.getMatchRule(), 0, scope, new TypeNameRequestor(){

                            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                                Openable openable = handleFactory.createOpenable(path, scope);
                                elements.add(new FakeType((ModelElement)openable, new String(simpleTypeName), modifiers));
                            }
                        }, 3, null);
                    } else {
                        searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                                IModelElement element = (IModelElement)match.getElement();
                                if (element instanceof SourceModule) {
                                    return;
                                }
                                IModelElement parent = element.getParent();
                                if (element instanceof IField && parent instanceof ISourceModule || !(element instanceof IField) && !(parent instanceof IType)) {
                                    elements.add(element);
                                }
                            }
                        }, null);
                    }
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG_COMPLETION) break block38;
                    e.printStackTrace();
                }
            }
        }
        if (showGroupOptions) {
            for (String group : groups) {
                String fakeElementName = group + "_*";
                if (elementType == 0) {
                    elements.add((IModelElement)new FakeGroupType((ModelElement)sourceModule, fakeElementName));
                    continue;
                }
                if (elementType != 1) continue;
                elements.add((IModelElement)new FakeGroupMethod((ModelElement)sourceModule, fakeElementName));
            }
        }
        IModelElement[] result = elements.toArray(new IModelElement[elements.size()]);
        return currentFileOnly ? result : PHPModelUtils.filterElements(sourceModule, result);
    }

    private static IModelElement[] filterOtherFilesElements(ISourceModule currentFile, IModelElement[] modelElements) {
        ArrayList<IModelElement> elements = new ArrayList<IModelElement>(modelElements.length);
        String lastName = null;
        IModelElement[] iModelElementArray = modelElements;
        int n = modelElements.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement element = iModelElementArray[n2];
            if (!element.getElementName().equals(lastName)) {
                lastName = null;
                if (currentFile.equals(element.getOpenable())) {
                    lastName = element.getElementName();
                }
                elements.add(element);
            }
            ++n2;
        }
        return elements.toArray(new IModelElement[elements.size()]);
    }

    public static IModelElement[] getSourceModuleElements(ISourceModule sourceModule, String prefix, int elementType, int mask) {
        LinkedList<Object> elements;
        block22: {
            elements = new LinkedList<Object>();
            try {
                block1 : switch (elementType) {
                    case 0: {
                        IType[] types;
                        IType[] iTypeArray = types = sourceModule.getTypes();
                        int n = types.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType type = iTypeArray[n2];
                            String typeName = type.getElementName();
                            if ((mask & 1) != 0) {
                                if (typeName.equalsIgnoreCase(prefix)) {
                                    elements.add(type);
                                    break block1;
                                }
                            } else if (CodeAssistUtils.startsWithIgnoreCase(typeName, prefix)) {
                                elements.add(type);
                            }
                            ++n2;
                        }
                        break;
                    }
                    case 1: {
                        IMethod[] methods;
                        IMethod[] iMethodArray = methods = ((AbstractSourceModule)sourceModule).getMethods();
                        int n = methods.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IMethod method = iMethodArray[n3];
                            String methodName = method.getElementName();
                            if ((mask & 1) != 0) {
                                if (methodName.equalsIgnoreCase(prefix)) {
                                    elements.add(method);
                                    break block1;
                                }
                            } else if (CodeAssistUtils.startsWithIgnoreCase(methodName, prefix)) {
                                elements.add(method);
                            }
                            ++n3;
                        }
                        break;
                    }
                    case 2: {
                        IField[] fields;
                        IField[] iFieldArray = fields = sourceModule.getFields();
                        int n = fields.length;
                        int n4 = 0;
                        while (n4 < n) {
                            IField field = iFieldArray[n4];
                            String fieldName = field.getElementName();
                            if ((mask & 1) != 0) {
                                if (fieldName.equals(prefix)) {
                                    elements.add(field);
                                    break block1;
                                }
                            } else if (fieldName.startsWith(prefix)) {
                                elements.add(field);
                            }
                            ++n4;
                        }
                        break block1;
                    }
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG_COMPLETION) break block22;
                e.printStackTrace();
            }
        }
        return elements.toArray(new IModelElement[elements.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AlphabeticComparator
    implements Comparator<IModelElement> {
        private ISourceModule currentFile;

        public AlphabeticComparator() {
        }

        public AlphabeticComparator(ISourceModule currentFile) {
            this.currentFile = currentFile;
        }

        @Override
        public int compare(IModelElement o1, IModelElement o2) {
            if (o1 instanceof FakeGroupType) {
                return -1;
            }
            int r = o1.getElementName().compareTo(o2.getElementName());
            if (r == 0) {
                block7: {
                    IType t1;
                    if (this.currentFile != null && this.currentFile.equals(o1.getOpenable())) {
                        return -1;
                    }
                    if (o1 instanceof IMember && (t1 = ((IMember)o1).getDeclaringType()) != null) {
                        try {
                            if ((t1.getFlags() & 0x10) != 0) {
                                return -1;
                            }
                        }
                        catch (Exception e) {
                            if (!DLTKCore.DEBUG_COMPLETION) break block7;
                            e.printStackTrace();
                        }
                    }
                }
                return 1;
            }
            return r;
        }
    }
}

