/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.codeassist;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.codeassist.CodeAssistUtils;
import org.eclipse.php.core.codeassist.FakeGroupMethod;
import org.eclipse.php.core.codeassist.FakeGroupType;
import org.eclipse.php.core.codeassist.IPHPCompletionRequestor;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.phpModel.PHPKeywords;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.internal.core.typeinference.FakeField;
import org.eclipse.php.internal.core.typeinference.FakeMethod;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PHPCompletionEngine
extends ScriptCompletionEngine {
    private static final char TAG_SIGN = '@';
    private static final String NEW = "new";
    private static final String INSTANCEOF = "instanceof";
    private static final String SELF = "self";
    private static final String IMPLEMENTS = "implements";
    private static final String EXTENDS = "extends";
    private static final String PAAMAYIM_NEKUDOTAIM = "::";
    private static final String CLASS = "class";
    private static final String FUNCTION = "function";
    private static final String DESTRUCTOR = "__destruct";
    private static final String CONSTRUCTOR = "__construct";
    private static final String DOLLAR = "$";
    private static final String BRACKETS_SUFFIX = "()";
    private static final String WHITESPACE_SUFFIX = " ";
    private static final String EMPTY = "";
    private static final String OPEN_BRACE = "(";
    private static final int RELEVANCE_KEYWORD = 10000000;
    private static final int RELEVANCE_METHOD = 1000000;
    private static final int RELEVANCE_CLASS = 100000;
    private static final int RELEVANCE_VAR = 10000;
    private static final int RELEVANCE_CONST = 1000;
    protected static final String[] phpVariables = new String[]{"$_COOKIE", "$_ENV", "$_FILES", "$_GET", "$_POST", "$_REQUEST", "$_SERVER", "$_SESSION", "$GLOBALS", "$HTTP_COOKIE_VARS", "$HTTP_ENV_VARS", "$HTTP_GET_VARS", "$HTTP_POST_FILES", "$HTTP_POST_VARS", "$HTTP_SERVER_VARS", "$HTTP_SESSION_VARS"};
    protected static final String[] serverVaraibles = new String[]{"$DOCUMENT_ROOT", "$GATEWAY_INTERFACE", "$HTTP_ACCEPT", "$HTTP_ACCEPT_ENCODING", "$HTTP_ACCEPT_LANGUAGE", "$HTTP_CONNECTION", "$HTTP_HOST", "$HTTP_USER_AGENT", "$PATH", "$PATH_TRANSLATED", "$PHP_SELF", "$QUERY_STRING", "$REMOTE_ADDR", "$REMOTE_PORT", "$REQUEST_METHOD", "$REQUEST_URI", "$SCRIPT_FILENAME", "$SCRIPT_NAME", "$SERVER_ADDR", "$SERVER_ADMIN", "$SERVER_NAME", "$SERVER_PORT", "$SERVER_PROTOCOL", "$SERVER_SIGNATURE", "$SERVER_SOFTWARE"};
    protected static final String[] classVariables = new String[]{"$this"};
    protected static final String[] sessionVariables = new String[]{"SID"};
    protected static final String[] allVariables = new String[phpVariables.length + serverVaraibles.length];
    protected static final String[] magicFunctions;
    protected static final String[] magicFunctionsPhp5;
    protected static final String[] phpDocTags;
    protected static final char[] phpDelimiters;
    protected static final String CLASS_FUNCTIONS_TRIGGER = "::";
    protected static final String OBJECT_FUNCTIONS_TRIGGER = "->";
    private static final Pattern extendsPattern;
    private static final Pattern implementsPattern;
    private static final Pattern catchPattern;
    protected boolean isPHP5;
    protected org.eclipse.dltk.core.ISourceModule sourceModule;
    protected boolean explicit;
    private Preferences pluginPreferences = PHPCorePlugin.getDefault().getPluginPreferences();
    private boolean hasWhitespaceAtEnd;
    private boolean hasOpenBraceAtEnd;
    private boolean hasPaamayimNekudotaimAtEnd;
    private int wordEndOffset;
    private String nextWord;
    private IStructuredDocument document;
    private ContextRegion internalPHPRegion;
    private IPhpScriptRegion phpScriptRegion;
    private ITextRegionCollection regionContainer;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$php$core$codeassist$PHPCompletionEngine$States;

    static {
        System.arraycopy(phpVariables, 0, allVariables, 0, phpVariables.length);
        System.arraycopy(serverVaraibles, 0, allVariables, phpVariables.length, serverVaraibles.length);
        Arrays.sort(allVariables);
        magicFunctions = new String[]{"__get", "__set", "__call", "__sleep", "__wakeup"};
        magicFunctionsPhp5 = new String[]{"__isset", "__unset", "__toString", "__set_state", "__clone", "__autoload"};
        phpDocTags = new String[]{"abstract", "access", "author", "category", "copyright", "deprecated", "example", "final", "filesource", "global", "ignore", "internal", "license", "link", "method", "name", "package", "param", "property", "return", "see", "since", "static", "staticvar", "subpackage", "todo", "tutorial", "uses", "var", "version"};
        phpDelimiters = new char[]{'?', ':', ';', '|', '^', '&', '<', '>', '+', '-', '.', '*', '/', '%', '!', '~', '[', ']', '(', ')', '{', '}', '@', '\n', '\t', ' ', ',', '$', '\'', '\"'};
        extendsPattern = Pattern.compile("\\Wextends\\W", 2);
        implementsPattern = Pattern.compile("\\Wimplements", 2);
        catchPattern = Pattern.compile("catch\\s[^{]*", 2);
    }

    protected int getEndOfEmptyToken() {
        return 0;
    }

    protected String processFieldName(IField field, String token) {
        return null;
    }

    protected String processMethodName(IMethod method, String token) {
        return null;
    }

    protected String processTypeName(IType method, String token) {
        return null;
    }

    public IAssistParser getParser() {
        return null;
    }

    public void complete(ISourceModule module, int position, int i) {
        block19: {
            block18: {
                if (this.requestor instanceof IPHPCompletionRequestor) {
                    IPHPCompletionRequestor phpCompletionRequestor = (IPHPCompletionRequestor)this.requestor;
                    IDocument d = phpCompletionRequestor.getDocument();
                    if (d instanceof IStructuredDocument) {
                        this.document = (IStructuredDocument)d;
                    }
                    this.explicit = phpCompletionRequestor.isExplicit();
                }
                if (this.document == null) {
                    IStructuredModel structuredModel = null;
                    try {
                        try {
                            IFile file = (IFile)module.getModelElement().getResource();
                            if (file != null) {
                                if (file.exists()) {
                                    structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                                    this.document = structuredModel != null ? structuredModel.getStructuredDocument() : StructuredModelManager.getModelManager().createStructuredDocumentFor(file);
                                } else {
                                    this.document = StructuredModelManager.getModelManager().createNewStructuredDocumentFor(file);
                                    this.document.set(module.getSourceContents());
                                }
                            }
                        }
                        catch (Exception e) {
                            if (DLTKCore.DEBUG_COMPLETION) {
                                e.printStackTrace();
                            }
                            if (structuredModel != null) {
                                structuredModel.releaseFromRead();
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        if (structuredModel != null) {
                            structuredModel.releaseFromRead();
                        }
                        throw throwable;
                    }
                    if (structuredModel != null) {
                        structuredModel.releaseFromRead();
                    }
                }
            }
            if (this.document != null) {
                try {
                    this.calcCompletionOption(this.document, position, (org.eclipse.dltk.core.ISourceModule)module.getModelElement());
                }
                catch (BadLocationException e) {
                    if (!DLTKCore.DEBUG_COMPLETION) break block19;
                    e.printStackTrace();
                }
            }
        }
    }

    protected void calcCompletionOption(IStructuredDocument document, int offset, org.eclipse.dltk.core.ISourceModule sourceModule) throws BadLocationException {
        int startOffset;
        this.sourceModule = sourceModule;
        String phpVersion = PhpVersionProjectPropertyHandler.getVersion(sourceModule.getScriptProject().getProject());
        this.isPHP5 = phpVersion.equals("php5");
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
        int lastOffset = offset;
        while (sdRegion == null && lastOffset >= 0) {
            sdRegion = document.getRegionAtCharacterOffset(--lastOffset);
        }
        if (sdRegion == null) {
            return;
        }
        ITextRegion textRegion = null;
        textRegion = offset == document.getLength() ? sdRegion.getLastRegion() : sdRegion.getRegionAtCharacterOffset(offset);
        if (textRegion == null) {
            return;
        }
        this.regionContainer = sdRegion;
        if (textRegion instanceof ITextRegionContainer) {
            this.regionContainer = (ITextRegionContainer)textRegion;
            textRegion = this.regionContainer.getRegionAtCharacterOffset(offset);
        }
        if (textRegion == null) {
            return;
        }
        if (textRegion.getType() == "PHP_OPEN") {
            return;
        }
        if (textRegion.getType() == "PHP_CLOSE") {
            if (this.regionContainer.getStartOffset(textRegion) == offset) {
                ITextRegion regionBefore = this.regionContainer.getRegionAtCharacterOffset(offset - 1);
                if (regionBefore instanceof IPhpScriptRegion) {
                    textRegion = regionBefore;
                }
            } else {
                return;
            }
        }
        if ((startOffset = this.regionContainer.getStartOffset(textRegion)) == offset) {
            ITextRegion preTextRegion = this.regionContainer.getRegionAtCharacterOffset(offset - 1);
            IStructuredDocumentRegion preSdRegion = null;
            if (preTextRegion != null || (preSdRegion = sdRegion.getPrevious()) != null && (preTextRegion = preSdRegion.getRegionAtCharacterOffset(offset - 1)) != null) {
                preTextRegion.getType();
            }
            startOffset = sdRegion.getStartOffset(textRegion);
        }
        boolean inPHPDoc = false;
        String partitionType = null;
        int internalOffset = 0;
        if (textRegion instanceof IPhpScriptRegion) {
            String regionType;
            this.phpScriptRegion = (IPhpScriptRegion)textRegion;
            internalOffset = offset - this.regionContainer.getStartOffset() - this.phpScriptRegion.getStart() - 1;
            partitionType = this.phpScriptRegion.getPartition(internalOffset);
            if (!(partitionType != "org.eclipse.php.PHP_MULTI_LINE_COMMENT" && partitionType != "org.eclipse.php.PHP_DOC" || (regionType = this.phpScriptRegion.getPhpToken(internalOffset).getType()) != "PHP_COMMENT_START" && regionType != "PHPDOC_COMMENT_START" || this.phpScriptRegion.getPhpToken(internalOffset).getStart() != internalOffset)) {
                partitionType = this.phpScriptRegion.getPartition(internalOffset - 1);
            }
            if (partitionType != "org.eclipse.php.PHP_DEFAULT" && partitionType != "org.eclipse.php.PHP_QUOTED_STRING" && partitionType != "org.eclipse.php.PHP_SINGLE_LINE_COMMENT") {
                if (partitionType == "org.eclipse.php.PHP_DOC") {
                    inPHPDoc = true;
                } else {
                    return;
                }
            }
            this.internalPHPRegion = (ContextRegion)this.phpScriptRegion.getPhpToken(internalOffset);
        }
        if (this.phpScriptRegion == null) {
            return;
        }
        TextSequence statementText = PHPTextSequenceUtilities.getStatement(offset, sdRegion, true);
        String type = this.internalPHPRegion.getType();
        int totalLength = statementText.length();
        int endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, totalLength);
        int startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, endPosition, true);
        String lastWord = statementText.subSequence(startPosition, endPosition).toString();
        boolean bl = this.hasWhitespaceAtEnd = totalLength != endPosition;
        if (inPHPDoc) {
            if (this.isInPhpDocCompletion(statementText, offset, lastWord)) {
                return;
            }
            int tagStart = startPosition - 1;
            while (tagStart > 0 && statementText.charAt(tagStart) != '@') {
                --tagStart;
            }
            if (statementText.charAt(tagStart) == '@') {
                int tagEnd = PHPTextSequenceUtilities.readIdentifierEndIndex(statementText, ++tagStart, false);
                String tagName = statementText.subSequence(tagStart, tagEnd).toString();
                this.wordEndOffset = offset;
                while (!Character.isWhitespace(document.getChar(this.wordEndOffset))) {
                    ++this.wordEndOffset;
                }
                if (this.isVariableCompletion(offset, tagName, tagEnd == endPosition ? EMPTY : lastWord)) {
                    return;
                }
                if (this.isReturnTypeCompletion(offset, tagName, tagEnd == endPosition ? EMPTY : lastWord)) {
                    return;
                }
            }
        } else {
            if (this.isInArrayOptionQuotes(type, offset, statementText)) {
                return;
            }
            if (this.isPHPSingleQuote(this.regionContainer, this.phpScriptRegion, this.internalPHPRegion, document, offset) || this.isLineComment(this.regionContainer, this.phpScriptRegion, offset)) {
                return;
            }
            this.wordEndOffset = this.regionContainer.getStartOffset() + this.phpScriptRegion.getStart() + this.internalPHPRegion.getTextEnd();
            if (this.isInFunctionDeclaration(statementText, offset)) {
                return;
            }
            if (this.isInCatchStatement(statementText, offset)) {
                return;
            }
            if (this.hasWhitespaceAtEnd && this.isNewOrInstanceofStatement(lastWord, EMPTY, offset, type)) {
                return;
            }
            int line = document.getLineOfOffset(offset);
            if (this.isClassFunctionCompletion(statementText, offset, line, lastWord, startPosition)) {
                return;
            }
            endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, startPosition);
            startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, endPosition, true);
            String firstWord = statementText.subSequence(startPosition, endPosition).toString();
            ContextRegion nextRegion = this.internalPHPRegion;
            while ((PHPPartitionTypes.isPHPCommentState((nextRegion = this.phpScriptRegion.getPhpToken(nextRegion.getEnd())).getType()) || nextRegion.getType() == "WHITESPACE") && nextRegion.getEnd() < this.phpScriptRegion.getLength()) {
            }
            this.nextWord = document.get(this.regionContainer.getStartOffset() + this.phpScriptRegion.getStart() + nextRegion.getStart(), nextRegion.getTextLength());
            this.hasPaamayimNekudotaimAtEnd = false;
            this.hasOpenBraceAtEnd = false;
            if (OPEN_BRACE.equals(this.nextWord)) {
                this.hasOpenBraceAtEnd = true;
            } else if ("::".equals(this.nextWord)) {
                this.hasPaamayimNekudotaimAtEnd = true;
            }
            if (!this.hasWhitespaceAtEnd && this.isNewOrInstanceofStatement(firstWord, lastWord, offset, type)) {
                if (lastWord.startsWith(DOLLAR)) {
                    this.getRegularCompletion(lastWord, offset);
                }
                return;
            }
            if (this.hasWhitespaceAtEnd && CodeAssistUtils.isFunctionCall(lastWord, sourceModule.getScriptProject())) {
                return;
            }
            if (this.isInArrayOption(firstWord, lastWord, startPosition, offset, statementText, type)) {
                return;
            }
            if (this.isInClassDeclaration(statementText, offset)) {
                return;
            }
            this.getRegularCompletion(lastWord, offset);
        }
    }

    private boolean isInPhpDocCompletion(CharSequence statementText, int offset, String tagName) {
        if (this.hasWhitespaceAtEnd) {
            return false;
        }
        int startPosition = statementText.length() - tagName.length();
        if (startPosition <= 0 || statementText.charAt(startPosition - 1) != '@') {
            return false;
        }
        --startPosition;
        boolean founeX = false;
        while (startPosition > 0) {
            if (!Character.isWhitespace(statementText.charAt(startPosition - 1))) {
                if (founeX || statementText.charAt(startPosition - 1) != '*') break;
                founeX = true;
            }
            --startPosition;
        }
        if (!founeX) {
            return false;
        }
        this.setSourceRange(offset - tagName.length(), offset);
        int relevanceKeyword = 10000000;
        String[] stringArray = phpDocTags;
        int n = phpDocTags.length;
        int n2 = 0;
        while (n2 < n) {
            String phpDocTag = stringArray[n2];
            if (CodeAssistUtils.startsWithIgnoreCase(phpDocTag, tagName) && (!this.requestor.isContextInformationMode() || phpDocTag.length() == tagName.length())) {
                this.reportKeyword(phpDocTag, EMPTY, relevanceKeyword--);
            }
            ++n2;
        }
        return true;
    }

    private boolean isVariableCompletion(int offset, String tagName, String varName) {
        ModuleDeclaration moduleDeclaration;
        Declaration declaration;
        if (!"param".equals(tagName)) {
            return false;
        }
        if (varName.startsWith(DOLLAR) && (declaration = ASTUtils.findDeclarationAfterPHPdoc(moduleDeclaration = SourceParserUtil.getModuleDeclaration((org.eclipse.dltk.core.ISourceModule)this.sourceModule, null), offset)) instanceof MethodDeclaration) {
            LinkedList<String> variables = new LinkedList<String>();
            List arguments = ((MethodDeclaration)declaration).getArguments();
            for (Argument arg : arguments) {
                variables.add(arg.getName());
            }
            this.setSourceRange(offset - varName.length(), offset);
            int relevanceVar = 10000;
            String[] paramVars = variables.toArray(new String[variables.size()]);
            this.reportVariables(paramVars, varName, relevanceVar, false);
            return true;
        }
        return false;
    }

    private boolean isReturnTypeCompletion(int offset, String tagName, String className) {
        IType[] returnTypes;
        IMethod method;
        if (!"return".equals(tagName)) {
            return false;
        }
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((org.eclipse.dltk.core.ISourceModule)this.sourceModule, null);
        Declaration declaration = ASTUtils.findDeclarationAfterPHPdoc(moduleDeclaration, offset);
        if (declaration instanceof MethodDeclaration && (method = (IMethod)PHPModelUtils.getModelElementByNode(this.sourceModule, moduleDeclaration, (ASTNode)declaration)) != null && (returnTypes = CodeAssistUtils.getFunctionReturnType(method, 0)) != null) {
            int relevanceClass = 100000;
            this.setSourceRange(offset - className.length(), offset);
            IType[] iTypeArray = returnTypes;
            int n = returnTypes.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    IType type = iTypeArray[n2];
                    try {
                        if (CodeAssistUtils.startsWithIgnoreCase(type.getElementName(), className) && (type.getFlags() & 0x80000) == 0) {
                            this.reportType(type, relevanceClass--, EMPTY);
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG_COMPLETION) break block6;
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean isLineComment(ITextRegionCollection sdRegion, IPhpScriptRegion phpScriptRegion, int offset) {
        int relativeOffset = offset - sdRegion.getStartOffset((ITextRegion)phpScriptRegion);
        try {
            return phpScriptRegion.isLineComment(relativeOffset);
        }
        catch (BadLocationException e) {
            if (DLTKCore.DEBUG_COMPLETION) {
                e.printStackTrace();
            }
            return false;
        }
    }

    protected boolean isPHPSingleQuote(ITextRegionCollection sdRegion, IPhpScriptRegion phpScriptRegion, ContextRegion internalRegion, IStructuredDocument document, int documentOffset) {
        if (PHPPartitionTypes.isPHPQuotesState(internalRegion.getType())) {
            char firstChar;
            int endOffset;
            int startOffset;
            try {
                startOffset = internalRegion.getStart() + sdRegion.getStartOffset((ITextRegion)phpScriptRegion);
                endOffset = startOffset + internalRegion.getTextLength();
                firstChar = document.get(startOffset, internalRegion.getTextLength()).charAt(0);
            }
            catch (BadLocationException e) {
                if (DLTKCore.DEBUG_COMPLETION) {
                    e.printStackTrace();
                }
                return false;
            }
            return firstChar == '\'' && documentOffset <= endOffset - 1 && startOffset < documentOffset;
        }
        return false;
    }

    protected void reportVariables(String[] variables, String prefix, int relevance, boolean removeDollar) {
        String[] stringArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            String var = stringArray[n2];
            if (var.startsWith(prefix) && (!this.requestor.isContextInformationMode() || var.length() == prefix.length())) {
                this.reportField((IField)new FakeField((ModelElement)this.sourceModule, var, 0, 0), relevance--, removeDollar);
            }
            ++n2;
        }
    }

    protected boolean reportArrayVariables(String arrayName, int offset, String prefix) {
        this.setSourceRange(offset - prefix.length(), offset);
        int relevanceVar = 10000;
        if (arrayName.equals("$_SERVER") || arrayName.equals("$HTTP_SERVER_VARS")) {
            this.reportVariables(serverVaraibles, prefix, relevanceVar, true);
            return true;
        }
        if (arrayName.equals("$_SESSION") || arrayName.equals("$HTTP_SESSION_VARS")) {
            this.reportVariables(sessionVariables, prefix, relevanceVar, true);
            return true;
        }
        if (arrayName.equals("$GLOBALS")) {
            IModelElement[] elements;
            if (prefix.length() == 0) {
                prefix = DOLLAR;
            }
            int mask = 0;
            if (this.requestor.isContextInformationMode()) {
                mask |= 1;
            }
            IModelElement[] iModelElementArray = elements = CodeAssistUtils.getGlobalFields(this.sourceModule, prefix, mask);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement element = iModelElementArray[n2];
                IField field = (IField)element;
                this.reportField(field, relevanceVar--, true);
                ++n2;
            }
            this.reportVariables(phpVariables, prefix, relevanceVar, true);
            return true;
        }
        return false;
    }

    protected boolean isInArrayOptionQuotes(String type, int offset, TextSequence text) {
        if (!PHPPartitionTypes.isPHPQuotesState(type)) {
            return false;
        }
        int length = text.length();
        int endPosition = PHPTextSequenceUtilities.readBackwardSpaces(text, length);
        int startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(text, endPosition, false);
        if (endPosition != length && startPosition != endPosition) {
            return false;
        }
        String prefix = text.subSequence(startPosition, endPosition).toString();
        endPosition = PHPTextSequenceUtilities.readBackwardSpaces(text, startPosition);
        if (endPosition == 0) {
            return false;
        }
        char c = text.charAt(endPosition - 1);
        if (c != '\"' && c != '\'') {
            return false;
        }
        --endPosition;
        if ((endPosition = PHPTextSequenceUtilities.readBackwardSpaces(text, endPosition)) == 0 || text.charAt(endPosition - 1) != '[') {
            return false;
        }
        --endPosition;
        endPosition = PHPTextSequenceUtilities.readBackwardSpaces(text, endPosition);
        startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(text, endPosition, true);
        String variableName = text.subSequence(startPosition, endPosition).toString();
        this.reportArrayVariables(variableName, offset, prefix);
        return true;
    }

    protected void getRegularCompletion(String prefix, int offset) {
        this.getRegularCompletion(prefix, offset, true);
    }

    protected void getRegularCompletion(String prefix, int offset, boolean showKeywords) {
        int n;
        boolean currentFileOnly;
        boolean inClass;
        block47: {
            this.setSourceRange(offset - prefix.length(), offset);
            inClass = false;
            try {
                IModelElement enclosingElement = this.sourceModule.getElementAt(offset);
                while (enclosingElement instanceof IField) {
                    enclosingElement = enclosingElement.getParent();
                }
                if (enclosingElement instanceof IType) {
                    inClass = true;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG_COMPLETION) break block47;
                e.printStackTrace();
            }
        }
        int relevanceKeyword = 10000000;
        int relevanceVar = 10000;
        int relevanceConst = 1000;
        int relevanceClass = 100000;
        int relevanceMethod = 1000000;
        if (showKeywords) {
            Collection<PHPKeywords.KeywordData> keywordsList = PHPKeywords.findByPrefix(this.sourceModule.getScriptProject().getProject(), prefix);
            for (PHPKeywords.KeywordData k : keywordsList) {
                if (inClass && (!inClass || !k.isClassKeyword)) continue;
                this.reportKeyword(k.name, k.suffix, relevanceKeyword--);
            }
        }
        boolean bl = currentFileOnly = !this.explicit && prefix.length() == 0;
        if (!currentFileOnly && this.internalPHPRegion != null) {
            String type = this.internalPHPRegion.getType();
            if (prefix.startsWith(DOLLAR) && !inClass) {
                TreeSet<IModelElement> variables;
                block49: {
                    block48: {
                        if (PHPPartitionTypes.isPHPQuotesState(type)) {
                            IStructuredDocument doc = this.document;
                            try {
                                char charBefore = doc.get(offset - 2, 1).charAt(0);
                                if (charBefore == '\\') {
                                    return;
                                }
                            }
                            catch (BadLocationException e) {
                                if (!DLTKCore.DEBUG_COMPLETION) break block48;
                                e.printStackTrace();
                            }
                        }
                    }
                    variables = new TreeSet<IModelElement>(new CodeAssistUtils.AlphabeticComparator());
                    try {
                        IModelElement enclosingElement = this.sourceModule.getElementAt(offset);
                        while (enclosingElement instanceof IField) {
                            enclosingElement = enclosingElement.getParent();
                        }
                        if (enclosingElement instanceof IMethod) {
                            IMethod method = (IMethod)enclosingElement;
                            int mask = 0;
                            if (this.requestor.isContextInformationMode()) {
                                mask |= 1;
                            }
                            variables.addAll((Collection<IModelElement>)Arrays.asList(CodeAssistUtils.getMethodFields(method, prefix, mask)));
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG_COMPLETION) break block49;
                        e.printStackTrace();
                    }
                }
                int mask = 0;
                if (this.requestor.isContextInformationMode()) {
                    mask |= 1;
                }
                if (!this.showVarsFromOtherFiles()) {
                    mask |= 4;
                }
                variables.addAll((Collection<IModelElement>)Arrays.asList(CodeAssistUtils.getGlobalFields(this.sourceModule, prefix, mask)));
                for (IModelElement var : variables) {
                    IField field = (IField)var;
                    try {
                        if ((field.getFlags() & 4) != 0) {
                            this.reportField(field, relevanceConst--, false);
                            continue;
                        }
                        this.reportField(field, relevanceVar--, false);
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG_COMPLETION) continue;
                        e.printStackTrace();
                    }
                }
                IMethod containerMethodData = CodeAssistUtils.getContainerMethodData(this.sourceModule, offset);
                if (containerMethodData != null && containerMethodData.getDeclaringType() != null) {
                    this.reportVariables(classVariables, prefix, relevanceVar--, false);
                    relevanceVar -= classVariables.length;
                }
                this.reportVariables(phpVariables, prefix, relevanceVar--, false);
                return;
            }
            if (PHPPartitionTypes.isPHPQuotesState(type) || type.equals("PHP_HEREDOC_TAG") && this.regionContainer.getStartOffset((ITextRegion)this.phpScriptRegion) + this.phpScriptRegion.getLength() <= offset) {
                return;
            }
        }
        if (!inClass) {
            IModelElement[] functions;
            int mask = 0;
            if (this.requestor.isContextInformationMode()) {
                mask |= 1;
            }
            if (currentFileOnly) {
                mask |= 4;
            }
            IModelElement[] iModelElementArray = functions = CodeAssistUtils.getGlobalMethods(this.sourceModule, prefix, mask);
            n = functions.length;
            int containerMethodData = 0;
            while (containerMethodData < n) {
                block50: {
                    IModelElement function = iModelElementArray[containerMethodData];
                    try {
                        if ((((IMethod)function).getFlags() & 0x80000) == 0) {
                            this.reportMethod((IMethod)function, relevanceMethod--);
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG_COMPLETION) break block50;
                        e.printStackTrace();
                    }
                }
                ++containerMethodData;
            }
            if (this.showConstantAssist()) {
                IModelElement[] constants;
                mask = 0;
                if (this.requestor.isContextInformationMode()) {
                    mask |= 1;
                }
                if (currentFileOnly && !this.showVarsFromOtherFiles()) {
                    mask |= 4;
                }
                if (this.constantsCaseSensitive()) {
                    mask |= 2;
                }
                IModelElement[] e = constants = CodeAssistUtils.getGlobalFields(this.sourceModule, prefix, mask);
                int n2 = constants.length;
                n = 0;
                while (n < n2) {
                    block51: {
                        IModelElement constant = e[n];
                        try {
                            if ((((IField)constant).getFlags() & 4) != 0) {
                                this.reportField((IField)constant, relevanceConst--, false);
                            }
                        }
                        catch (ModelException e2) {
                            if (!DLTKCore.DEBUG_COMPLETION) break block51;
                            e2.printStackTrace();
                        }
                    }
                    ++n;
                }
            }
        }
        if (!inClass && this.showClassNamesInGlobalCompletion()) {
            IType[] classes;
            int mask = 0;
            if (this.requestor.isContextInformationMode()) {
                mask |= 1;
            }
            if (currentFileOnly) {
                mask |= 4;
            }
            IType[] iTypeArray = classes = CodeAssistUtils.getGlobalTypes(this.sourceModule, prefix, mask);
            n = classes.length;
            int n3 = 0;
            while (n3 < n) {
                block52: {
                    IType type = iTypeArray[n3];
                    try {
                        if ((type.getFlags() & 0x80000) == 0) {
                            this.reportType(type, relevanceClass--, "::");
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG_COMPLETION) break block52;
                        e.printStackTrace();
                    }
                }
                ++n3;
            }
        }
    }

    protected boolean isClassFunctionCompletion(TextSequence statementText, int offset, int line, String functionName, int startFunctionPosition) {
        IType[] types;
        if ((startFunctionPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, startFunctionPosition)) <= 2) {
            return false;
        }
        boolean isClassTriger = false;
        boolean isParent = false;
        String triggerText = statementText.subSequence(startFunctionPosition - 2, startFunctionPosition).toString();
        if (!triggerText.equals(OBJECT_FUNCTIONS_TRIGGER)) {
            if (triggerText.equals("::")) {
                String parentText;
                isClassTriger = true;
                if (startFunctionPosition >= 8 && (parentText = statementText.subSequence(startFunctionPosition - 8, startFunctionPosition - 2).toString()).equals("parent")) {
                    isParent = true;
                }
            } else {
                return false;
            }
        }
        if (this.internalPHPRegion.getType() == "PHP_OBJECT_OPERATOR" || this.internalPHPRegion.getType() == "PHP_PAAMAYIM_NEKUDOTAYIM") {
            try {
                ITextRegion nextRegion = this.phpScriptRegion.getPhpToken(this.internalPHPRegion.getEnd());
                this.wordEndOffset = this.regionContainer.getStartOffset() + this.phpScriptRegion.getStart() + nextRegion.getTextEnd();
            }
            catch (BadLocationException badLocationException) {}
        }
        if ((types = CodeAssistUtils.getTypesFor(this.sourceModule, statementText, startFunctionPosition, offset, line)) != null) {
            if (this.hasWhitespaceAtEnd && functionName.length() > 0) {
                return CodeAssistUtils.isClassFunctionCall(this.sourceModule, types, functionName);
            }
            if (isClassTriger) {
                if (isParent) {
                    HashSet parents = new HashSet();
                    IType[] iTypeArray = types;
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block18: {
                            IType type = iTypeArray[n2];
                            try {
                                ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
                                parents.addAll(Arrays.asList(hierarchy.getAllSuperclasses(type)));
                            }
                            catch (ModelException e) {
                                if (!DLTKCore.DEBUG_COMPLETION) break block18;
                                e.printStackTrace();
                            }
                        }
                        ++n2;
                    }
                    this.showClassCall(offset, parents.toArray(new IType[parents.size()]), functionName, false, false);
                } else {
                    this.showClassStaticCall(offset, types, functionName);
                }
            } else {
                boolean isThisVar = false;
                String text = statementText.toString();
                String parent = text.substring(0, text.lastIndexOf(OBJECT_FUNCTIONS_TRIGGER)).trim();
                if (parent.length() >= 5) {
                    isThisVar = "$this".equals(parent.substring(Math.max(0, parent.length() - 5)));
                }
                boolean addVariableDollar = false;
                this.showClassCall(offset, types, functionName, isThisVar, addVariableDollar);
            }
        }
        return true;
    }

    protected void showClassCall(int offset, IType[] className, String prefix, boolean isThisVar, boolean addVariableDollar) {
        if (className == null) {
            return;
        }
        this.setSourceRange(offset - prefix.length(), offset);
        int relevanceMethod = 1000000;
        boolean showNonStrictOptions = this.showNonStrictOptions();
        int mask = 0;
        if (this.requestor.isContextInformationMode()) {
            mask |= 1;
        }
        IType[] iTypeArray = className;
        int n = className.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (!prefix.startsWith(DOLLAR)) {
                IMethod[] methods;
                IMethod[] iMethodArray = methods = CodeAssistUtils.getClassMethods(type, prefix, mask);
                int n3 = methods.length;
                int n4 = 0;
                while (n4 < n3) {
                    block15: {
                        IMethod method = iMethodArray[n4];
                        try {
                            if ((method.getFlags() & 0x80000) == 0 && (showNonStrictOptions || isThisVar || (method.getFlags() & 0x20) == 0)) {
                                this.reportMethod(method, relevanceMethod--);
                            }
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG_COMPLETION) break block15;
                            e.printStackTrace();
                        }
                    }
                    ++n4;
                }
            }
            IField[] fields = CodeAssistUtils.getClassFields(type, prefix, mask);
            int relevanceVar = 10000;
            int relevanceConst = 1000;
            IField[] iFieldArray = fields;
            int n5 = fields.length;
            int n6 = 0;
            while (n6 < n5) {
                block16: {
                    IField element;
                    IField field = element = iFieldArray[n6];
                    try {
                        if ((field.getFlags() & 0x100) == 0) {
                            if ((field.getFlags() & 4) != 0) {
                                this.reportField(field, relevanceConst--, true);
                            } else if (showNonStrictOptions || isThisVar || (field.getFlags() & 0x20) == 0) {
                                this.reportField(field, relevanceVar--, true);
                            }
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG_COMPLETION) break block16;
                        e.printStackTrace();
                    }
                }
                ++n6;
            }
            ++n2;
        }
    }

    protected void showClassStaticCall(int offset, IType[] className, String prefix) {
        this.setSourceRange(offset - prefix.length(), offset);
        boolean showNonStrictOptions = this.showNonStrictOptions();
        int mask = 0;
        if (this.requestor.isContextInformationMode()) {
            mask |= 1;
        }
        int relevanceMethod = 1000000;
        if (!prefix.startsWith(DOLLAR)) {
            IType[] iTypeArray = className;
            int n = className.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod[] classMethods;
                IType type = iTypeArray[n2];
                IMethod[] iMethodArray = classMethods = CodeAssistUtils.getClassMethods(type, prefix, mask);
                int n3 = classMethods.length;
                int n4 = 0;
                while (n4 < n3) {
                    block14: {
                        IMethod method = iMethodArray[n4];
                        try {
                            if ((!this.isPHP5 || showNonStrictOptions || (method.getFlags() & 0x100) != 0) && (method.getFlags() & 0x80000) == 0) {
                                this.reportMethod(method, relevanceMethod--);
                            }
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG_COMPLETION) break block14;
                            e.printStackTrace();
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        int relevanceConst = 1000;
        int relevanceVar = 10000;
        IType[] iTypeArray = className;
        int n = className.length;
        int n5 = 0;
        while (n5 < n) {
            IField[] classFields;
            IType type = iTypeArray[n5];
            IField[] iFieldArray = classFields = CodeAssistUtils.getClassFields(type, prefix, mask);
            int n6 = classFields.length;
            int n7 = 0;
            while (n7 < n6) {
                block15: {
                    IField field = iFieldArray[n7];
                    try {
                        boolean isConstant;
                        int flags = field.getFlags();
                        boolean bl = isConstant = (flags & 4) != 0;
                        if (isConstant || !this.isPHP5 || showNonStrictOptions || (flags & 0x100) != 0) {
                            if (isConstant) {
                                this.reportField(field, relevanceConst--, false);
                            } else {
                                this.reportField(field, relevanceVar--, false);
                            }
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG_COMPLETION) break block15;
                        e.printStackTrace();
                    }
                }
                ++n7;
            }
            ++n5;
        }
    }

    protected boolean isInFunctionDeclaration(TextSequence text, int offset) {
        IMethod[] superClassMethods;
        String functionNameStart;
        int functionStart = PHPTextSequenceUtilities.isInFunctionDeclaration(text);
        if (functionStart == -1) {
            return false;
        }
        int i = text.length() - 1;
        while (i >= functionStart) {
            if (text.charAt(i) == '(') {
                boolean showClassCompletion = true;
                boolean showInitializerCompletion = false;
                int j = text.length() - 1;
                while (j > i) {
                    if (text.charAt(j) == '$') {
                        showClassCompletion = false;
                        break;
                    }
                    if (text.charAt(j) == '=') {
                        showInitializerCompletion = true;
                        showClassCompletion = false;
                        break;
                    }
                    if (text.charAt(j) == ',') break;
                    --j;
                }
                if (showClassCompletion) {
                    IType[] classes;
                    String prefix = text.subTextSequence(j + 1, text.length()).toString();
                    int k = 0;
                    while (k < prefix.length()) {
                        if (!Character.isWhitespace(prefix.charAt(k))) break;
                        ++k;
                    }
                    if (k != 0) {
                        prefix = prefix.substring(k);
                    }
                    this.setSourceRange(offset - prefix.length(), offset);
                    int relevanceClass = 100000;
                    int mask = 0;
                    if (this.requestor.isContextInformationMode()) {
                        mask |= 1;
                    }
                    IType[] iTypeArray = classes = CodeAssistUtils.getGlobalTypes(this.sourceModule, prefix, mask);
                    int n = classes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block38: {
                            IType type = iTypeArray[n2];
                            try {
                                if ((type.getFlags() & 0x80000) == 0) {
                                    this.reportType(type, relevanceClass--, WHITESPACE_SUFFIX);
                                }
                            }
                            catch (ModelException e) {
                                if (!DLTKCore.DEBUG_COMPLETION) break block38;
                                e.printStackTrace();
                            }
                        }
                        ++n2;
                    }
                } else if (showInitializerCompletion) {
                    String prefix = text.subTextSequence(j + 1, text.length()).toString().trim();
                    if (this.showConstantAssist()) {
                        this.setSourceRange(offset - prefix.length(), offset);
                        int mask = 0;
                        if (this.requestor.isContextInformationMode()) {
                            mask |= 1;
                        }
                        if (!this.showVarsFromOtherFiles()) {
                            mask |= 4;
                        }
                        if (this.constantsCaseSensitive()) {
                            mask |= 2;
                        }
                        IModelElement[] constants = CodeAssistUtils.getGlobalFields(this.sourceModule, prefix, mask);
                        int relevanceConst = 1000;
                        IModelElement[] iModelElementArray = constants;
                        int n = constants.length;
                        int type = 0;
                        while (type < n) {
                            block39: {
                                IModelElement constant = iModelElementArray[type];
                                IField field = (IField)constant;
                                try {
                                    if ((field.getFlags() & 4) != 0) {
                                        this.reportField(field, relevanceConst--, false);
                                    }
                                }
                                catch (ModelException e) {
                                    if (!DLTKCore.DEBUG_COMPLETION) break block39;
                                    e.printStackTrace();
                                }
                            }
                            ++type;
                        }
                    }
                }
                return true;
            }
            --i;
        }
        IType classData = CodeAssistUtils.getContainerClassData(this.sourceModule, text.getOriginalOffset(functionStart));
        if (classData == null) {
            return true;
        }
        int wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(text, text.length());
        int wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(text, wordEnd, false);
        String word = text.subSequence(wordStart, wordEnd).toString();
        if (word.equals(FUNCTION)) {
            functionNameStart = EMPTY;
        } else if (wordEnd == text.length()) {
            functionNameStart = word;
        } else {
            return true;
        }
        this.setSourceRange(offset - functionNameStart.length(), offset);
        int relevanceMethod = 1000000;
        int mask = 0;
        if (this.requestor.isContextInformationMode()) {
            mask |= 1;
        }
        IMethod[] iMethodArray = superClassMethods = CodeAssistUtils.getSuperClassMethods(classData, functionNameStart, mask);
        int n = superClassMethods.length;
        int type = 0;
        while (type < n) {
            block40: {
                IMethod superMethod = iMethodArray[type];
                if (!classData.getMethod(superMethod.getElementName()).exists()) {
                    try {
                        int flags = superMethod.getFlags();
                        if ((flags & 8) == 0 && (flags & 0x20) == 0 && (flags & 0x100) == 0 && (flags & 0x80000) == 0) {
                            this.reportMethod(superMethod, relevanceMethod--);
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG_COMPLETION) break block40;
                        e.printStackTrace();
                    }
                }
            }
            ++type;
        }
        LinkedList<String> functions = new LinkedList<String>();
        functions.addAll((Collection)Arrays.asList(magicFunctions));
        if (this.isPHP5) {
            functions.addAll((Collection)Arrays.asList(magicFunctionsPhp5));
        }
        functions.add(classData.getElementName());
        if (this.isPHP5) {
            functions.add(CONSTRUCTOR);
            functions.add(DESTRUCTOR);
        }
        for (String function : functions) {
            if (!CodeAssistUtils.startsWithIgnoreCase(function, functionNameStart) || this.requestor.isContextInformationMode() && function.length() != functionNameStart.length()) continue;
            FakeMethod fakeMagicMethod = new FakeMethod((ModelElement)classData, function);
            this.reportMethod((IMethod)fakeMagicMethod, relevanceMethod--);
        }
        return true;
    }

    protected boolean isInClassDeclaration(TextSequence text, int offset) {
        int classEnd = PHPTextSequenceUtilities.isInClassDeclaration(text);
        if (classEnd == -1) {
            return false;
        }
        boolean isClassDeclaration = true;
        if (classEnd >= 6) {
            String classString = text.subSequence(classEnd - 6, classEnd - 1).toString();
            isClassDeclaration = classString.equals(CLASS);
        }
        text = text.subTextSequence(classEnd, text.length());
        int classIdentifierEndPosition = 0;
        while (classIdentifierEndPosition < text.length()) {
            if (!Character.isLetterOrDigit(text.charAt(classIdentifierEndPosition))) break;
            ++classIdentifierEndPosition;
        }
        if (classIdentifierEndPosition == text.length()) {
            return true;
        }
        text = text.subTextSequence(classIdentifierEndPosition, text.length());
        int endPosition = text.length();
        int startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(text, endPosition, false);
        String lastWord = text.subSequence(startPosition, endPosition).toString();
        Matcher extendsMatcher = extendsPattern.matcher(text);
        Matcher implementsMatcher = implementsPattern.matcher(text);
        boolean foundExtends = extendsMatcher.find();
        boolean foundImplements = implementsMatcher.find();
        if (!foundExtends && !foundImplements) {
            if (isClassDeclaration) {
                this.showExtendsImplementsList(lastWord, offset);
            } else {
                this.showExtendsList(lastWord, offset);
            }
            return true;
        }
        endPosition = PHPTextSequenceUtilities.readBackwardSpaces(text, startPosition);
        String firstWord = text.subSequence(startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(text, endPosition, true), endPosition).toString();
        if (firstWord.equalsIgnoreCase(EXTENDS)) {
            this.showBaseClassList(lastWord, offset, isClassDeclaration);
            return true;
        }
        if (firstWord.equalsIgnoreCase(IMPLEMENTS)) {
            this.showInterfaceList(lastWord, offset);
            return true;
        }
        if (foundExtends && foundImplements) {
            if (extendsMatcher.start() < implementsMatcher.start()) {
                this.showInterfaceList(lastWord, offset);
            } else {
                this.showBaseClassList(lastWord, offset, isClassDeclaration);
            }
            return true;
        }
        if (foundImplements || !isClassDeclaration) {
            this.showInterfaceList(lastWord, offset);
            return true;
        }
        if (isClassDeclaration) {
            this.showImplementsList(lastWord, offset);
        }
        return true;
    }

    protected void showInterfaceList(String prefix, int offset) {
        this.setSourceRange(offset - prefix.length(), offset);
        int mask = 16;
        if (this.requestor.isContextInformationMode()) {
            mask |= 1;
        }
        IType[] interfaces = CodeAssistUtils.getGlobalTypes(this.sourceModule, prefix, mask);
        int relevanceClass = 100000;
        IType[] iTypeArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IType i = iTypeArray[n2];
                try {
                    if ((i.getFlags() & 0x80000) == 0) {
                        this.reportType(i, relevanceClass--, EMPTY);
                    }
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG_COMPLETION) break block5;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    protected void showExtendsImplementsList(String prefix, int offset) {
        this.setSourceRange(offset - prefix.length(), offset);
        int relevanceKeyword = 10000000;
        if (this.isPHP5) {
            if (EXTENDS.startsWith(prefix)) {
                this.reportKeyword(EXTENDS, EMPTY, relevanceKeyword--);
            }
            if (IMPLEMENTS.startsWith(prefix)) {
                this.reportKeyword(IMPLEMENTS, EMPTY, relevanceKeyword--);
            }
        } else if (EXTENDS.startsWith(prefix)) {
            this.reportKeyword(EXTENDS, EMPTY, relevanceKeyword--);
        }
    }

    protected void showImplementsList(String prefix, int offset) {
        if (this.isPHP5) {
            this.setSourceRange(offset - prefix.length(), offset);
            int relevanceKeyword = 10000000;
            if (IMPLEMENTS.startsWith(prefix)) {
                this.reportKeyword(IMPLEMENTS, EMPTY, relevanceKeyword--);
            }
        }
    }

    private void showExtendsList(String prefix, int offset) {
        this.setSourceRange(offset - prefix.length(), offset);
        int relevanceKeyword = 10000000;
        if (EXTENDS.startsWith(prefix)) {
            this.reportKeyword(EXTENDS, EMPTY, relevanceKeyword--);
        }
    }

    private void showBaseClassList(String prefix, int offset, boolean isClassDecleration) {
        IType[] classes;
        if (!isClassDecleration) {
            this.showInterfaceList(prefix, offset);
            return;
        }
        this.setSourceRange(offset - prefix.length(), offset);
        int relevanceClass = 100000;
        int mask = 8;
        if (this.requestor.isContextInformationMode()) {
            mask |= 1;
        }
        IType[] iTypeArray = classes = CodeAssistUtils.getGlobalTypes(this.sourceModule, prefix, mask);
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                IType type = iTypeArray[n2];
                try {
                    if ((type.getFlags() & 0x80000) == 0) {
                        this.reportType(type, relevanceClass--, EMPTY);
                    }
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG_COMPLETION) break block6;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    protected boolean isInCatchStatement(TextSequence text, int offset) {
        Matcher matcher = catchPattern.matcher(text);
        int catchStart = text.length();
        while (matcher.find()) {
            if (text.length() != matcher.end()) continue;
            catchStart = matcher.start() + 1;
            break;
        }
        if (catchStart == text.length()) {
            return false;
        }
        int classEnd = catchStart + 5;
        text = text.subTextSequence(classEnd, text.length());
        int startPosition = 0;
        while (startPosition < text.length()) {
            if (text.charAt(startPosition) == '(') break;
            ++startPosition;
        }
        if (startPosition == text.length()) {
            return true;
        }
        startPosition = PHPTextSequenceUtilities.readForwardSpaces(text, startPosition + 1);
        int endPosition = PHPTextSequenceUtilities.readIdentifierEndIndex(text, startPosition, false);
        String className = text.subSequence(startPosition, endPosition).toString();
        if (endPosition == text.length()) {
            this.showClassList(className, offset, States.CATCH);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void showClassList(String prefix, int offset, States state) {
        this.setSourceRange(offset - prefix.length(), offset);
        relevanceClass = 100000;
        switch (PHPCompletionEngine.$SWITCH_TABLE$org$eclipse$php$core$codeassist$PHPCompletionEngine$States()[state.ordinal()]) {
            case 2: {
                mask = 8;
                if (this.requestor.isContextInformationMode()) {
                    mask |= 1;
                }
                types = CodeAssistUtils.getGlobalTypes(this.sourceModule, prefix, mask);
                enclosingClass = null;
                try {
                    enclosingElement = this.sourceModule.getElementAt(offset);
                    while (enclosingElement instanceof IField) {
                        enclosingElement = enclosingElement.getParent();
                    }
                    if (enclosingElement instanceof IMethod && (parent = ((IMethod)enclosingElement).getParent()) instanceof IType) {
                        enclosingClass = (IType)parent;
                    }
                }
                catch (ModelException e) {
                    if (!PHPCompletionEngine.DEBUG) ** GOTO lbl21
                    e.printStackTrace();
                }
lbl21:
                // 3 sources

                var11_18 = types;
                var10_21 = types.length;
                parent = 0;
                while (parent < var10_21) {
                    type = var11_18[parent];
                    ctor = null;
                    if (!this.requestor.isContextInformationMode()) ** GOTO lbl43
                    try {
                        var16_34 = type.getMethods();
                        var15_33 = var16_34.length;
                        var14_32 = 0;
                        while (var14_32 < var15_33) {
                            method = var16_34[var14_32];
                            if (!method.isConstructor()) ** GOTO lbl37
                            ctor = method;
                            break;
lbl37:
                            // 1 sources

                            ++var14_32;
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG_COMPLETION) ** GOTO lbl43
                        e.printStackTrace();
                    }
lbl43:
                    // 5 sources

                    try {
                        if (ctor != null) {
                            if ((ctor.getFlags() & 32) == 0 || type.equals(enclosingClass)) {
                                ctorMethod = new FakeMethod((ModelElement)type, type.getElementName()){

                                    public boolean isConstructor() throws ModelException {
                                        return true;
                                    }
                                };
                                ctorMethod.setParameters(ctor.getParameters());
                                this.reportMethod((IMethod)ctorMethod, relevanceClass--);
                            }
                        } else if ((type.getFlags() & 524288) == 0) {
                            this.reportType(type, relevanceClass--, this.hasOpenBraceAtEnd != false ? "" : "()");
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG_COMPLETION) ** GOTO lbl56
                        e.printStackTrace();
                    }
lbl56:
                    // 4 sources

                    ++parent;
                }
                if (!CodeAssistUtils.startsWithIgnoreCase("self", prefix) || this.requestor.isContextInformationMode() && prefix.length() != "self".length() || (selfClassData = CodeAssistUtils.getSelfClassData(this.sourceModule, offset)) == null) break;
                this.addSelfFunctionToProposals(selfClassData);
                break;
            }
            case 3: {
                mask = 0;
                if (this.requestor.isContextInformationMode()) {
                    mask |= 1;
                }
                var12_25 = typeElements = CodeAssistUtils.getGlobalTypes(this.sourceModule, prefix, mask);
                var11_19 = typeElements.length;
                var10_22 = 0;
                while (var10_22 < var11_19) {
                    typeElement = var12_25[var10_22];
                    try {
                        if ((typeElement.getFlags() & 524288) == 0) {
                            this.reportType(typeElement, relevanceClass--, "");
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG_COMPLETION) ** GOTO lbl77
                        e.printStackTrace();
                    }
lbl77:
                    // 3 sources

                    ++var10_22;
                }
                if (!CodeAssistUtils.startsWithIgnoreCase("self", prefix) || this.requestor.isContextInformationMode() && prefix.length() != "self".length() || (selfClassData = CodeAssistUtils.getSelfClassData(this.sourceModule, offset)) == null) break;
                this.addSelfFunctionToProposals(selfClassData);
                break;
            }
            case 1: {
                mask = 0;
                if (this.requestor.isContextInformationMode()) {
                    mask |= 1;
                }
                var12_26 = typeElements = CodeAssistUtils.getGlobalTypes(this.sourceModule, prefix, mask);
                var11_20 = typeElements.length;
                var10_23 = 0;
                while (var10_23 < var11_20) {
                    typeElement = var12_26[var10_23];
                    try {
                        if ((typeElement.getFlags() & 524288) == 0) {
                            this.reportType(typeElement, relevanceClass--, "");
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG_COMPLETION) ** GOTO lbl98
                        e.printStackTrace();
                    }
lbl98:
                    // 3 sources

                    ++var10_23;
                }
                break;
            }
        }
    }

    private void addSelfFunctionToProposals(IType type) {
        block6: {
            try {
                IMethod ctor = null;
                IMethod[] iMethodArray = type.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    if (method.isConstructor()) {
                        ctor = method;
                        break;
                    }
                    ++n2;
                }
                if (ctor != null) {
                    FakeMethod ctorMethod = new FakeMethod((ModelElement)type, SELF){

                        public boolean isConstructor() throws ModelException {
                            return true;
                        }
                    };
                    ctorMethod.setParameters(ctor.getParameters());
                    this.reportMethod((IMethod)ctorMethod, 1000000);
                } else {
                    this.reportMethod((IMethod)new FakeMethod((ModelElement)type, SELF), 1000000);
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG_COMPLETION) break block6;
                e.printStackTrace();
            }
        }
    }

    protected boolean isNewOrInstanceofStatement(String keyword, String prefix, int offset, String type) {
        if (PHPPartitionTypes.isPHPQuotesState(type)) {
            return false;
        }
        if (keyword.equalsIgnoreCase(INSTANCEOF)) {
            this.setSourceRange(offset - prefix.length(), offset);
            this.showClassList(prefix, offset, States.INSTANCEOF);
            return true;
        }
        if (keyword.equalsIgnoreCase(NEW)) {
            this.setSourceRange(offset - prefix.length(), offset);
            this.showClassList(prefix, offset, States.NEW);
            return true;
        }
        return false;
    }

    protected boolean isInArrayOption(String firstWord, String lastWord, int startPosition, int offset, TextSequence text, String type) {
        if (PHPPartitionTypes.isPHPQuotesState(type)) {
            return false;
        }
        boolean isArrayOption = false;
        if (startPosition > 0 && !lastWord.startsWith(DOLLAR)) {
            if (this.hasWhitespaceAtEnd) {
                if (lastWord.length() == 0 && firstWord.length() == 0 && text.charAt(startPosition - 1) == '[') {
                    isArrayOption = true;
                }
            } else if (firstWord.length() == 0 && text.charAt(startPosition - 1) == '[') {
                isArrayOption = true;
            }
        }
        if (!isArrayOption) {
            return false;
        }
        int endPosition = startPosition - 1;
        startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(text, endPosition = PHPTextSequenceUtilities.readBackwardSpaces(text, endPosition), true);
        String variableName = text.subSequence(startPosition, endPosition).toString();
        if (!this.reportArrayVariables(variableName, offset, lastWord)) {
            this.getRegularCompletion(lastWord, offset, false);
        }
        return true;
    }

    private void reportMethod(IMethod method, int relevance) {
        if (relevance < 1) {
            relevance = 1;
        }
        String elementName = method.getElementName();
        char[] name = elementName.toCharArray();
        this.noProposal = false;
        if (!this.requestor.isIgnored(6)) {
            CompletionProposal proposal;
            block15: {
                String[] params;
                block14: {
                    proposal = this.createProposal(6, this.actualCompletionPosition);
                    params = null;
                    try {
                        params = method.getParameters();
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG_COMPLETION) break block14;
                        e.printStackTrace();
                    }
                }
                if (params != null && params.length > 0) {
                    char[][] args = new char[params.length][];
                    int i = 0;
                    while (i < params.length) {
                        args[i] = params[i].toCharArray();
                        ++i;
                    }
                    proposal.setParameterNames((char[][])args);
                }
                proposal.setModelElement((IModelElement)method);
                proposal.setName(name);
                if (method instanceof FakeGroupMethod) {
                    proposal.setCompletion(elementName.substring(0, elementName.length() - 1).toCharArray());
                    relevance = 10000001;
                } else if (this.hasOpenBraceAtEnd) {
                    proposal.setCompletion(elementName.toCharArray());
                } else {
                    proposal.setCompletion((String.valueOf(elementName) + BRACKETS_SUFFIX).toCharArray());
                }
                try {
                    proposal.setIsConstructor(elementName.equals(CONSTRUCTOR) || method.isConstructor());
                    proposal.setFlags(method.getFlags());
                }
                catch (ModelException e) {
                    if (!DEBUG) break block15;
                    e.printStackTrace();
                }
            }
            int replaceStart = this.startPosition - this.offset;
            int replaceEnd = this.endPosition - this.offset;
            if (replaceEnd < this.wordEndOffset) {
                replaceEnd = this.wordEndOffset;
            }
            proposal.setReplaceRange(replaceStart, replaceEnd);
            proposal.setRelevance(relevance);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private void reportType(IType type, int relevance, String suffix) {
        if (relevance < 1) {
            relevance = 1;
        }
        String elementName = type.getElementName();
        char[] name = elementName.toCharArray();
        this.noProposal = false;
        if (!this.requestor.isIgnored(7)) {
            CompletionProposal proposal;
            block19: {
                proposal = this.createProposal(7, this.actualCompletionPosition);
                if (this.requestor.isContextInformationMode()) {
                    try {
                        IMethod[] iMethodArray = type.getMethods();
                        int n = iMethodArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethod method = iMethodArray[n2];
                            if (method.isConstructor()) {
                                String[] params = method.getParameters();
                                if (params != null && params.length > 0) {
                                    char[][] args = new char[params.length][];
                                    int i = 0;
                                    while (i < params.length) {
                                        args[i] = params[i].toCharArray();
                                        ++i;
                                    }
                                    proposal.setParameterNames((char[][])args);
                                }
                                break;
                            }
                            ++n2;
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG_COMPLETION) break block19;
                        e.printStackTrace();
                    }
                }
            }
            proposal.setModelElement((IModelElement)type);
            proposal.setName(name);
            if (type instanceof FakeGroupType) {
                proposal.setCompletion(elementName.substring(0, elementName.length() - 1).toCharArray());
                relevance = 10000001;
            } else if (this.hasPaamayimNekudotaimAtEnd && "::" == suffix) {
                proposal.setCompletion(elementName.toCharArray());
            } else {
                proposal.setCompletion((String.valueOf(elementName) + suffix).toCharArray());
            }
            try {
                proposal.setFlags(type.getFlags());
            }
            catch (ModelException modelException) {}
            int replaceStart = this.startPosition - this.offset;
            int replaceEnd = this.endPosition - this.offset;
            if (this.wordEndOffset > replaceStart && replaceEnd < this.wordEndOffset) {
                replaceEnd = this.wordEndOffset - 1;
            } else if (replaceEnd > replaceStart) {
                --replaceEnd;
            }
            proposal.setReplaceRange(replaceStart, replaceEnd);
            proposal.setRelevance(relevance);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private void reportField(IField field, int relevance, boolean removeDollar) {
        if (relevance < 1) {
            relevance = 1;
        }
        String elementName = field.getElementName();
        char[] name = elementName.toCharArray();
        this.noProposal = false;
        if (!this.requestor.isIgnored(1)) {
            CompletionProposal proposal = this.createProposal(1, this.actualCompletionPosition);
            proposal.setModelElement((IModelElement)field);
            proposal.setName(name);
            String completion = elementName;
            if (removeDollar && completion.startsWith(DOLLAR)) {
                completion = completion.substring(1);
            }
            proposal.setCompletion(completion.toCharArray());
            try {
                proposal.setFlags(field.getFlags());
            }
            catch (ModelException modelException) {}
            int replaceStart = this.startPosition - this.offset;
            int replaceEnd = this.endPosition - this.offset;
            if (replaceEnd < this.wordEndOffset) {
                replaceEnd = this.wordEndOffset;
            }
            proposal.setReplaceRange(replaceStart, replaceEnd);
            proposal.setRelevance(relevance);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private void reportKeyword(String name, String suffix, int relevance) {
        if (relevance < 1) {
            relevance = 1;
        }
        this.noProposal = false;
        if (!this.requestor.isIgnored(1)) {
            CompletionProposal proposal = this.createProposal(2, this.actualCompletionPosition);
            proposal.setName(name.toCharArray());
            if (this.nextWord != null && this.nextWord.equals(suffix)) {
                proposal.setCompletion(name.toCharArray());
            } else {
                proposal.setCompletion((String.valueOf(name) + suffix).toCharArray());
            }
            proposal.setRelevance(relevance);
            int replaceStart = this.startPosition - this.offset;
            int replaceEnd = this.endPosition - this.offset;
            if (replaceEnd < this.wordEndOffset) {
                replaceEnd = this.wordEndOffset;
            }
            proposal.setReplaceRange(replaceStart, replaceEnd);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private boolean showClassNamesInGlobalCompletion() {
        if (this.pluginPreferences.contains("contentAssistShowClassNamesInGlobalCompletion")) {
            return this.pluginPreferences.getBoolean("contentAssistShowClassNamesInGlobalCompletion");
        }
        return true;
    }

    private boolean showVarsFromOtherFiles() {
        if (this.pluginPreferences.contains("contentAssistShowVariablesFromOtherFiles")) {
            return this.pluginPreferences.getBoolean("contentAssistShowVariablesFromOtherFiles");
        }
        return true;
    }

    private boolean showConstantAssist() {
        if (this.pluginPreferences.contains("contentAssistShowConstantsAssist")) {
            return this.pluginPreferences.getBoolean("contentAssistShowConstantsAssist");
        }
        return true;
    }

    private boolean showNonStrictOptions() {
        if (this.pluginPreferences.contains("contentAssistShowNonStrictOptions")) {
            return this.pluginPreferences.getBoolean("contentAssistShowNonStrictOptions");
        }
        return false;
    }

    private boolean constantsCaseSensitive() {
        if (this.pluginPreferences.contains("contentAssistConstantsCaseSensitive")) {
            return this.pluginPreferences.getBoolean("contentAssistConstantsCaseSensitive");
        }
        return false;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$php$core$codeassist$PHPCompletionEngine$States() {
        if ($SWITCH_TABLE$org$eclipse$php$core$codeassist$PHPCompletionEngine$States != null) {
            return $SWITCH_TABLE$org$eclipse$php$core$codeassist$PHPCompletionEngine$States;
        }
        int[] nArray = new int[States.values().length];
        try {
            nArray[States.CATCH.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[States.INSTANCEOF.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[States.NEW.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$php$core$codeassist$PHPCompletionEngine$States = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum States {
        CATCH,
        NEW,
        INSTANCEOF;

    }
}

