/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.codeassist;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.AbstractSourceModule;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticDispatch;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PHPSelectionEngine
extends ScriptSelectionEngine {
    private static final String OPEN_BRACE = "(";
    private static final String PROTECTED = "protected";
    private static final String PUBLIC = "public";
    private static final String PAAMAYIM_NEKUDOTAIM = "::";
    private static final String CONST = "const";
    private static final String THIS = "this";
    private static final String STATIC = "static";
    private static final String PRIVATE = "private";
    private static final String VAR = "var";
    private static final String IMPLEMENTS = "implements";
    private static final String EXTENDS = "extends";
    private static final String NEW = "new";
    private static final String INTERFACE = "interface";
    private static final String CLASS = "class";
    private static final String FUNCTION = "function";
    private static final IModelElement[] EMPTY = new IModelElement[0];

    public IAssistParser getParser() {
        return null;
    }

    public IModelElement[] select(ISourceModule sourceUnit, int offset, int end) {
        IStructuredDocument document;
        org.eclipse.dltk.core.ISourceModule sourceModule;
        block18: {
            block16: {
                if (end < offset) {
                    end = offset + 1;
                }
                sourceModule = (org.eclipse.dltk.core.ISourceModule)sourceUnit.getModelElement();
                try {
                    IModelElement[] elements = this.internalASTResolve(sourceModule, offset, end);
                    if (elements != null) {
                        return elements;
                    }
                }
                catch (Exception e) {
                    if (!DLTKCore.DEBUG_SELECTION) break block16;
                    e.printStackTrace();
                }
            }
            document = null;
            IStructuredModel structuredModel = null;
            try {
                try {
                    IFile file = (IFile)sourceUnit.getModelElement().getResource();
                    if (file != null) {
                        if (file.exists()) {
                            structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                            document = structuredModel != null ? structuredModel.getStructuredDocument() : StructuredModelManager.getModelManager().createStructuredDocumentFor(file);
                        } else {
                            document = StructuredModelManager.getModelManager().createNewStructuredDocumentFor(file);
                            document.set(sourceUnit.getSourceContents());
                        }
                    }
                }
                catch (Exception e) {
                    if (DLTKCore.DEBUG_SELECTION) {
                        e.printStackTrace();
                    }
                    if (structuredModel != null) {
                        structuredModel.releaseFromRead();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
                throw throwable;
            }
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
        if (document != null) {
            return this.internalResolve(document, sourceModule, offset, end);
        }
        return EMPTY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IModelElement[] internalASTResolve(org.eclipse.dltk.core.ISourceModule sourceModule, int offset, int end) throws ModelException {
        ClassInstanceCreation newNode;
        Expression className;
        IContext context;
        ModuleDeclaration parsedUnit;
        ASTNode node;
        String source = sourceModule.getSource();
        offset = PHPTextSequenceUtilities.readIdentifierStartIndex(source, offset, true);
        int methodEnd = PHPTextSequenceUtilities.getMethodEndIndex(source, end = PHPTextSequenceUtilities.readIdentifierEndIndex(source, end, true));
        if (methodEnd != -1) {
            end = methodEnd;
        }
        if ((node = ASTUtils.findMinimalNode(parsedUnit = SourceParserUtil.getModuleDeclaration((org.eclipse.dltk.core.ISourceModule)sourceModule, null), offset, end)) == null || (context = ASTUtils.findContext(sourceModule, parsedUnit, node)) == null) return null;
        if (node instanceof PHPCallExpression) {
            PHPCallExpression callExpression = (PHPCallExpression)node;
            if (callExpression.getReceiver() == null) return PHPModelUtils.filterElements(sourceModule, CodeAssistUtils.getGlobalMethods(sourceModule, callExpression.getName(), 1));
            IEvaluatedType receiverType = PHPTypeInferenceUtils.resolveExpression(sourceModule, parsedUnit, context, callExpression.getReceiver());
            if (receiverType == null) return null;
            IModelElement[] elements = PHPTypeInferenceUtils.getModelElements(receiverType, (ISourceModuleContext)context);
            LinkedList methods = new LinkedList();
            if (elements == null) return methods.toArray(new IModelElement[methods.size()]);
            IModelElement[] iModelElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement element = iModelElementArray[n2];
                if (element instanceof IType) {
                    IType type = (IType)element;
                    methods.addAll(Arrays.asList(CodeAssistUtils.getClassMethods(type, callExpression.getName(), 1)));
                }
                ++n2;
            }
            return methods.toArray(new IModelElement[methods.size()]);
        }
        if (node instanceof StaticDispatch) {
            IEvaluatedType dispatcherType;
            Expression field;
            StaticDispatch dispatch = (StaticDispatch)node;
            String fieldName = null;
            if (dispatch instanceof StaticConstantAccess) {
                fieldName = ((StaticConstantAccess)dispatch).getConstant().getName();
            } else if (dispatch instanceof StaticFieldAccess && (field = ((StaticFieldAccess)dispatch).getField()) instanceof VariableReference) {
                fieldName = ((VariableReference)field).getName();
            }
            if (fieldName == null || dispatch.getDispatcher() == null || (dispatcherType = PHPTypeInferenceUtils.resolveExpression(sourceModule, parsedUnit, context, (ASTNode)dispatch.getDispatcher())) == null) return null;
            IModelElement[] elements = PHPTypeInferenceUtils.getModelElements(dispatcherType, (ISourceModuleContext)context);
            LinkedList fields = new LinkedList();
            if (elements == null) return fields.toArray(new IModelElement[fields.size()]);
            IModelElement[] iModelElementArray = elements;
            int n = elements.length;
            int n3 = 0;
            while (n3 < n) {
                block19: {
                    IModelElement element = iModelElementArray[n3];
                    if (element instanceof IType) {
                        IType type = (IType)element;
                        try {
                            fields.addAll(Arrays.asList(PHPSelectionEngine.getClassField(type, fieldName)));
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG_SELECTION) break block19;
                            e.printStackTrace();
                        }
                    }
                }
                ++n3;
            }
            return fields.toArray(new IModelElement[fields.size()]);
        }
        if (node instanceof FieldAccess) {
            IEvaluatedType dispatcherType;
            FieldAccess fieldAccess = (FieldAccess)node;
            Expression field = fieldAccess.getField();
            String fieldName = null;
            if (field instanceof SimpleReference) {
                fieldName = ((SimpleReference)field).getName();
            }
            if (fieldName == null || fieldAccess.getDispatcher() == null || (dispatcherType = PHPTypeInferenceUtils.resolveExpression(sourceModule, parsedUnit, context, (ASTNode)fieldAccess.getDispatcher())) == null) return null;
            IModelElement[] elements = PHPTypeInferenceUtils.getModelElements(dispatcherType, (ISourceModuleContext)context);
            LinkedList fields = new LinkedList();
            if (elements == null) return fields.toArray(new IModelElement[fields.size()]);
            IModelElement[] iModelElementArray = elements;
            int n = elements.length;
            int n4 = 0;
            while (n4 < n) {
                block20: {
                    IModelElement element = iModelElementArray[n4];
                    if (element instanceof IType) {
                        IType type = (IType)element;
                        try {
                            fields.addAll(Arrays.asList(PHPSelectionEngine.getClassField(type, fieldName)));
                            fields.addAll(Arrays.asList(PHPSelectionEngine.getClassField(type, String.valueOf('$') + fieldName)));
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG_SELECTION) break block20;
                            e.printStackTrace();
                        }
                    }
                }
                ++n4;
            }
            return fields.toArray(new IModelElement[fields.size()]);
        }
        if (node instanceof TypeReference) {
            return PHPTypeInferenceUtils.getModelElements((IEvaluatedType)new PHPClassType(((TypeReference)node).getName()), (ISourceModuleContext)context);
        }
        if (!(node instanceof ClassInstanceCreation) || !((className = (newNode = (ClassInstanceCreation)node).getClassName()) instanceof SimpleReference)) return null;
        return PHPTypeInferenceUtils.getModelElements((IEvaluatedType)new PHPClassType(((SimpleReference)className).getName()), (ISourceModuleContext)context);
    }

    private IModelElement[] internalResolve(IStructuredDocument sDoc, org.eclipse.dltk.core.ISourceModule sourceModule, int offset, int end) {
        block34: {
            try {
                IType containerClass;
                String nextWord;
                String prevWord;
                String elementName;
                int startPosition;
                TextSequence statement;
                int elementStart;
                ITextRegion tRegion;
                block35: {
                    IModelElement[] generalizationTypes;
                    boolean isClassDeclaration;
                    int endPosition;
                    block37: {
                        block36: {
                            IStructuredDocumentRegion sRegion = sDoc.getRegionAtCharacterOffset(offset);
                            if (sRegion == null) break block34;
                            tRegion = sRegion.getRegionAtCharacterOffset(offset);
                            IStructuredDocumentRegion container = sRegion;
                            if (tRegion instanceof ITextRegionContainer) {
                                container = (ITextRegionContainer)tRegion;
                                tRegion = container.getRegionAtCharacterOffset(offset);
                            }
                            if (tRegion.getType() != "PHP_CONTENT") break block34;
                            IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)tRegion;
                            tRegion = phpScriptRegion.getPhpToken(offset - container.getStartOffset() - phpScriptRegion.getStart());
                            elementStart = container.getStartOffset() + phpScriptRegion.getStart() + tRegion.getStart();
                            statement = PHPTextSequenceUtilities.getStatement(elementStart + tRegion.getLength(), sRegion, true);
                            endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statement, statement.length());
                            startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(statement, endPosition, true);
                            elementName = statement.subSequence(startPosition, endPosition).toString();
                            int prevWordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statement, startPosition);
                            int prevWordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statement, prevWordEnd, false);
                            prevWord = statement.subSequence(prevWordStart, prevWordEnd).toString();
                            ITextRegion nextRegion = tRegion;
                            while ((PHPPartitionTypes.isPHPCommentState((nextRegion = phpScriptRegion.getPhpToken(nextRegion.getEnd())).getType()) || nextRegion.getType() == "WHITESPACE") && nextRegion.getEnd() < phpScriptRegion.getLength()) {
                            }
                            nextWord = sDoc.get(container.getStartOffset() + phpScriptRegion.getStart() + nextRegion.getStart(), nextRegion.getTextLength());
                            if (elementName.length() <= 0) break block34;
                            containerClass = CodeAssistUtils.getContainerClassData(sourceModule, offset);
                            if (FUNCTION.equalsIgnoreCase(prevWord)) {
                                if (containerClass != null) {
                                    return PHPSelectionEngine.getClassMethod(containerClass, elementName);
                                }
                                return PHPSelectionEngine.getFunction(sourceModule, elementName);
                            }
                            if (CLASS.equalsIgnoreCase(prevWord) || INTERFACE.equalsIgnoreCase(prevWord)) {
                                return PHPSelectionEngine.getClass(sourceModule, elementName);
                            }
                            if (NEW.equalsIgnoreCase(prevWord)) {
                                return CodeAssistUtils.getGlobalTypes(sourceModule, elementName, 9);
                            }
                            isClassDeclaration = false;
                            if (statement.length() <= 6) break block35;
                            if (!CLASS.equals(statement.subSequence(0, 5).toString())) break block36;
                            isClassDeclaration = true;
                            if (true) break block37;
                        }
                        if (statement.length() <= 10 || !INTERFACE.equals(statement.subSequence(0, 9).toString())) break block35;
                    }
                    if ((generalizationTypes = PHPSelectionEngine.getGeneralizationTypes(sourceModule, isClassDeclaration, prevWord, elementName)) != null) {
                        return generalizationTypes;
                    }
                    int listStartPosition = PHPTextSequenceUtilities.readIdentifierListStartIndex(statement, endPosition);
                    int preListWordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statement, listStartPosition);
                    int preListWordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statement, preListWordEnd, false);
                    String preListWord = statement.subSequence(preListWordStart, preListWordEnd).toString();
                    generalizationTypes = PHPSelectionEngine.getGeneralizationTypes(sourceModule, isClassDeclaration, preListWord, elementName);
                    if (generalizationTypes != null) {
                        return generalizationTypes;
                    }
                }
                String trigger = null;
                if (startPosition > 2) {
                    trigger = statement.subSequence(startPosition - 2, startPosition).toString();
                }
                if (elementName.charAt(0) == '$' && !PAAMAYIM_NEKUDOTAIM.equals(trigger)) {
                    if (PHPPartitionTypes.isPHPQuotesState(tRegion.getType())) {
                        try {
                            char charBefore = sDoc.get(elementStart - 2, 1).charAt(0);
                            if (charBefore == '\\') {
                                return EMPTY;
                            }
                        }
                        catch (BadLocationException e) {
                            PHPCorePlugin.log(e);
                        }
                    }
                    if (containerClass != null) {
                        if (VAR.equalsIgnoreCase(prevWord) || PRIVATE.equalsIgnoreCase(prevWord) || STATIC.equalsIgnoreCase(prevWord) || PUBLIC.equalsIgnoreCase(prevWord) || PROTECTED.equalsIgnoreCase(prevWord)) {
                            return PHPSelectionEngine.getClassField(containerClass, elementName);
                        }
                        if (THIS.equalsIgnoreCase(elementName)) {
                            return new IModelElement[]{containerClass};
                        }
                    }
                    IModelElement[] elements = CodeAssistUtils.getGlobalOrMethodFields(sourceModule, offset, elementName, 1);
                    return PHPModelUtils.filterElements(sourceModule, elements);
                }
                if (containerClass != null && CONST.equalsIgnoreCase(prevWord)) {
                    return PHPSelectionEngine.getClassField(containerClass, elementName);
                }
                if (PAAMAYIM_NEKUDOTAIM.equals(nextWord)) {
                    return PHPModelUtils.filterElements(sourceModule, (IModelElement[])CodeAssistUtils.getGlobalTypes(sourceModule, elementName, 1));
                }
                IType[] types = CodeAssistUtils.getTypesFor(sourceModule, statement, startPosition, offset, sDoc.getLineOfOffset(offset));
                if (OPEN_BRACE.equals(nextWord) || PHPPartitionTypes.isPHPDocState(tRegion.getType())) {
                    if (types != null && types.length > 0) {
                        LinkedList methods = new LinkedList();
                        IType[] iTypeArray = types;
                        int n = types.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType t = iTypeArray[n2];
                            methods.addAll(Arrays.asList(CodeAssistUtils.getClassMethods(t, elementName, 1)));
                            ++n2;
                        }
                        return (IModelElement[])methods.toArray(new IMethod[methods.size()]);
                    }
                    return PHPModelUtils.filterElements(sourceModule, CodeAssistUtils.getGlobalMethods(sourceModule, elementName, 1));
                }
                if (types != null && types.length > 0) {
                    if (startPosition > 0 && PAAMAYIM_NEKUDOTAIM.equals(trigger) && elementName.charAt(0) != '$') {
                        LinkedList fields = new LinkedList();
                        IType[] iTypeArray = types;
                        int n = types.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IType t = iTypeArray[n3];
                            fields.addAll(Arrays.asList(PHPSelectionEngine.getClassField(t, elementName)));
                            ++n3;
                        }
                        return fields.toArray(new IModelElement[fields.size()]);
                    }
                    TreeSet<IModelElement> fields = new TreeSet<IModelElement>(new Comparator<IModelElement>(){

                        @Override
                        public int compare(IModelElement o1, IModelElement o2) {
                            try {
                                ISourceRange r1 = ((SourceRefElement)o1).getSourceRange();
                                ISourceRange r2 = ((SourceRefElement)o2).getSourceRange();
                                return (int)Math.signum(r1.getOffset() - r2.getOffset());
                            }
                            catch (ModelException e) {
                                if (DLTKCore.DEBUG_SELECTION) {
                                    e.printStackTrace();
                                }
                                return 0;
                            }
                        }
                    });
                    IType[] iTypeArray = types;
                    int n = types.length;
                    int n4 = 0;
                    while (n4 < n) {
                        IType t = iTypeArray[n4];
                        fields.addAll((Collection<IModelElement>)Arrays.asList(CodeAssistUtils.getClassFields(t, elementName, 1)));
                        ++n4;
                    }
                    return fields.toArray(new IModelElement[fields.size()]);
                }
                IModelElement[] constants = PHPModelUtils.filterElements(sourceModule, CodeAssistUtils.getGlobalFields(sourceModule, elementName, 1));
                if (constants.length > 0) {
                    return constants;
                }
                IType[] elements = CodeAssistUtils.getGlobalTypes(sourceModule, elementName, 1);
                return PHPModelUtils.filterElements(sourceModule, (IModelElement[])elements);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG_SELECTION) break block34;
                e.printStackTrace();
            }
        }
        return EMPTY;
    }

    private static IModelElement[] getGeneralizationTypes(org.eclipse.dltk.core.ISourceModule sourceModule, boolean isClassDeclaration, String generalization, String elementName) {
        if (EXTENDS.equalsIgnoreCase(generalization)) {
            if (isClassDeclaration) {
                return CodeAssistUtils.getGlobalTypes(sourceModule, elementName, 9);
            }
            return CodeAssistUtils.getGlobalTypes(sourceModule, elementName, 17);
        }
        if (IMPLEMENTS.equalsIgnoreCase(generalization)) {
            return CodeAssistUtils.getGlobalTypes(sourceModule, elementName, 17);
        }
        return null;
    }

    private static IModelElement[] getClassField(IType type, String elementName) throws ModelException {
        IField[] fields;
        IField[] iFieldArray = fields = type.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if (field.getElementName().equalsIgnoreCase(elementName)) {
                return new IModelElement[]{field};
            }
            ++n2;
        }
        return EMPTY;
    }

    private static IModelElement[] getClassMethod(IType type, String elementName) throws ModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equalsIgnoreCase(elementName)) {
                return new IModelElement[]{method};
            }
            ++n2;
        }
        return EMPTY;
    }

    private static IModelElement[] getFunction(org.eclipse.dltk.core.ISourceModule sourceModule, String elementName) throws ModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = ((AbstractSourceModule)sourceModule).getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equalsIgnoreCase(elementName)) {
                return new IModelElement[]{method};
            }
            ++n2;
        }
        return EMPTY;
    }

    private static IModelElement[] getClass(org.eclipse.dltk.core.ISourceModule sourceModule, String elementName) throws ModelException {
        IType[] types;
        IType[] iTypeArray = types = sourceModule.getTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (type.getElementName().equalsIgnoreCase(elementName)) {
                return new IModelElement[]{type};
            }
            ++n2;
        }
        return EMPTY;
    }
}

