/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IShutdownListener;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.project.PHPNature;
import org.eclipse.php.internal.core.util.ProjectBackwardCompatibilityUtil;
import org.osgi.framework.BundleContext;

public class PHPCorePlugin
extends Plugin {
    private ProjectConversionListener fProjectConvertListener = new ProjectConversionListener();
    public static final String ID = "org.eclipse.php.core";
    public static final int INTERNAL_ERROR = 10001;
    private static PHPCorePlugin plugin;
    private final ListenerList shutdownListeners = new ListenerList();
    public static final boolean isDebugMode;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.php.core/debug");
        isDebugMode = value != null && value.equalsIgnoreCase("true");
    }

    public PHPCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IncludePathManager.getInstance();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fProjectConvertListener, 8);
        this.convertProjects();
    }

    private void convertProjects() throws CoreException, ModelException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.processProjects(projects);
    }

    private void processProjects(IProject[] projects) throws CoreException, ModelException {
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && PHPModelUtil.isPhpProject(project)) {
                    IProjectDescription projectDescription = project.getDescription();
                    ICommand[] commands = projectDescription.getBuildSpec();
                    int i = 0;
                    while (i < commands.length) {
                        if (!commands[i].getBuilderName().equals("org.eclipse.dltk.core.scriptbuilder")) {
                            ++i;
                            continue;
                        }
                        break block4;
                    }
                    this.modifyProject(project);
                }
            }
            ++n2;
        }
    }

    private void modifyProject(IProject project) throws CoreException, ModelException {
        IBuildpathEntry[] oldIncludePath;
        PHPNature phpNature = new PHPNature();
        phpNature.setProject(project);
        phpNature.configure();
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        IBuildpathEntry[] existingPath = scriptProject.getRawBuildpath();
        ArrayList newPath = new ArrayList();
        if (existingPath != null) {
            newPath.addAll(Arrays.asList(existingPath));
        }
        if ((oldIncludePath = ProjectBackwardCompatibilityUtil.convertIncludePathForProject(project)) != null) {
            newPath.addAll(Arrays.asList(oldIncludePath));
        }
        scriptProject.setRawBuildpath(newPath.toArray(new IBuildpathEntry[newPath.size()]), (IProgressMonitor)new NullProgressMonitor());
    }

    public void addShutdownListener(IShutdownListener listener) {
        this.shutdownListeners.add((Object)listener);
    }

    public void stop(BundleContext context) throws Exception {
        Object[] listeners = this.shutdownListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IShutdownListener)listeners[i]).shutdown();
            ++i;
        }
        this.shutdownListeners.clear();
        super.stop(context);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fProjectConvertListener);
        plugin = null;
    }

    public static PHPCorePlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        PHPCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        PHPCorePlugin.log((IStatus)new Status(4, ID, 10001, "PHPCore plugin internal error", e));
    }

    public static void logErrorMessage(String message) {
        PHPCorePlugin.log((IStatus)new Status(4, ID, 10001, message, null));
    }

    public static String getPluginId() {
        return ID;
    }

    public static String getOption(String optionName) {
        return ModelManager.getModelManager().getOption(optionName);
    }

    public static Hashtable getOptions() {
        return ModelManager.getModelManager().getOptions();
    }

    private class ProjectConversionListener
    implements IResourceChangeListener {
        private ProjectConversionListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            IResourceDelta[] affectedChildren = delta.getAffectedChildren();
            IProject[] projects = new IProject[affectedChildren.length];
            int i = 0;
            while (i < affectedChildren.length) {
                projects[i] = affectedChildren[i].getResource().getProject();
                ++i;
            }
            try {
                PHPCorePlugin.this.processProjects(projects);
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }
}

