/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import java_cup.runtime.lr_parser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.DefaultBindingResolver;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.scanner.AstLexer;
import org.eclipse.php.internal.core.ast.scanner.PhpAstLexer4;
import org.eclipse.php.internal.core.ast.scanner.PhpAstLexer5;
import org.eclipse.php.internal.core.ast.scanner.PhpAstParser4;
import org.eclipse.php.internal.core.ast.scanner.PhpAstParser5;

public class ASTParser {
    public static final String VERSION_PHP4 = "php4";
    public static final String VERSION_PHP5 = "php5";
    private static final Reader EMPTY_STRING_READER = new StringReader("");
    private final AST ast;
    private final ISourceModule sourceModule;
    private static final PhpAstLexer5 PHP_AST_LEXER5 = new PhpAstLexer5(EMPTY_STRING_READER);
    private static final PhpAstParser5 PHP_AST_PARSER5 = new PhpAstParser5(PHP_AST_LEXER5);
    private static final PhpAstLexer4 PHP_AST_LEXER4 = new PhpAstLexer4(EMPTY_STRING_READER);
    private static final PhpAstParser4 PHP_AST_PARSER4 = new PhpAstParser4(PHP_AST_LEXER4);

    private ASTParser(Reader reader, String version, boolean useASPTags) throws IOException {
        this(reader, version, useASPTags, null);
    }

    private ASTParser(Reader reader, String version, boolean useASPTags, ISourceModule sourceModule) throws IOException {
        this.sourceModule = sourceModule;
        if (!VERSION_PHP4.equals(version) && !VERSION_PHP5.equals(version)) {
            throw new IllegalArgumentException("Invalid PHP version in ASTParser: " + version);
        }
        this.ast = new AST(reader, version, useASPTags);
        this.ast.setDefaultNodeFlag(2);
        if (sourceModule != null) {
            this.ast.setFlag(Integer.MIN_VALUE);
            this.ast.setBindingResolver(new DefaultBindingResolver(sourceModule, sourceModule.getOwner()));
        }
    }

    public static ASTParser newParser(String version) {
        try {
            return new ASTParser(new StringReader(""), version, false);
        }
        catch (IOException iOException) {
            assert (false);
            return null;
        }
    }

    public static ASTParser newParser(String version, ISourceModule sourceModule) {
        if (sourceModule == null) {
            throw new IllegalStateException("ASTParser - Can't parser with null ISourceModule");
        }
        try {
            ASTParser parser = new ASTParser(new StringReader(""), version, false, sourceModule);
            parser.setSource(sourceModule.getSourceAsCharArray());
            return parser;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    public static ASTParser newParser(Reader reader, String version) throws IOException {
        return new ASTParser(reader, version, false);
    }

    public static ASTParser newParser(Reader reader, String version, boolean useASPTags) throws IOException {
        return new ASTParser(reader, version, useASPTags);
    }

    public static ASTParser newParser(Reader reader, String version, boolean useASPTags, ISourceModule sourceModule) throws IOException {
        return new ASTParser(reader, version, useASPTags, sourceModule);
    }

    public void setSource(char[] source) throws IOException {
        CharArrayReader charArrayReader = new CharArrayReader(source);
        this.setSource(charArrayReader);
    }

    public void setSource(Reader source) throws IOException {
        this.ast.setSource(source);
    }

    public Program createAST(IProgressMonitor progressMonitor) throws Exception {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        progressMonitor.beginTask("Creating Abstract Syntax Tree for source...", 3);
        AstLexer lexer = this.ast.lexer();
        lr_parser phpParser = this.ast.parser();
        progressMonitor.worked(1);
        phpParser.setScanner((Scanner)lexer);
        progressMonitor.worked(2);
        Symbol symbol = phpParser.parse();
        progressMonitor.done();
        if (symbol == null || !(symbol.value instanceof Program)) {
            return null;
        }
        Program p = (Program)symbol.value;
        AST ast = p.getAST();
        p.setSourceModule(this.sourceModule);
        ast.setDefaultNodeFlag(0);
        ast.setOriginalModificationCount(ast.modificationCount());
        return p;
    }

    public static final Program parse(String phpCode, boolean aspTagsAsPhp) throws Exception {
        StringReader reader = new StringReader(phpCode);
        return ASTParser.parse(reader, aspTagsAsPhp, VERSION_PHP5);
    }

    public static final Program parse(File phpFile, boolean aspTagsAsPhp) throws Exception {
        FileReader reader = new FileReader(phpFile);
        return ASTParser.parse(reader, aspTagsAsPhp, VERSION_PHP5);
    }

    public static final Program parse(IDocument phpDocument, boolean aspTagsAsPhp, String phpVersion) throws Exception {
        return ASTParser.parse(phpDocument, aspTagsAsPhp, phpVersion, 0, phpDocument.getLength());
    }

    public static final Program parse(final IDocument phpDocument, boolean aspTagsAsPhp, String phpVersion, int offset, int length) throws Exception {
        InputStreamReader reader = new InputStreamReader(new InputStream(offset, length){
            private int index;
            private final int size;
            {
                this.index = n;
                this.size = n + n2;
            }

            public int read() throws IOException {
                try {
                    if (this.index < this.size) {
                        return phpDocument.getChar(this.index++);
                    }
                    return -1;
                }
                catch (BadLocationException e) {
                    throw new IOException(e.getMessage());
                }
            }
        });
        return ASTParser.parse(reader, aspTagsAsPhp, phpVersion);
    }

    public static final Program parse(IDocument phpDocument, boolean aspTagsAsPhp) throws Exception {
        return ASTParser.parse(phpDocument, aspTagsAsPhp, VERSION_PHP5);
    }

    public static final Program parse(String phpCode) throws Exception {
        return ASTParser.parse(phpCode, true);
    }

    public static final Program parse(File phpFile) throws Exception {
        return ASTParser.parse(phpFile, true);
    }

    public static final Program parse(Reader reader) throws Exception {
        return ASTParser.parse(reader, true, VERSION_PHP5);
    }

    public static synchronized Program parse(Reader reader, boolean aspTagsAsPhp, String phpVersion) throws Exception {
        AST ast = new AST(EMPTY_STRING_READER, VERSION_PHP5, false);
        Scanner lexer = ASTParser.getLexer(ast, reader, phpVersion, aspTagsAsPhp);
        lr_parser phpParser = ASTParser.getParser(phpVersion, ast);
        phpParser.setScanner(lexer);
        Symbol symbol = phpParser.parse();
        return symbol == null ? null : (Program)symbol.value;
    }

    private static Scanner getLexer(AST ast, Reader reader, String phpVersion, boolean aspTagsAsPhp) throws IOException {
        if (VERSION_PHP4.equals(phpVersion)) {
            PhpAstLexer4 lexer4 = ASTParser.getLexer4(reader);
            lexer4.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer4.setAST(ast);
            return lexer4;
        }
        if (VERSION_PHP5.equals(phpVersion)) {
            PhpAstLexer5 lexer5 = ASTParser.getLexer5(reader);
            lexer5.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer5.setAST(ast);
            return lexer5;
        }
        throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("ASTParser_1")) + phpVersion);
    }

    private static lr_parser getParser(String phpVersion, AST ast) throws IOException {
        if (VERSION_PHP4.equals(phpVersion)) {
            PHP_AST_PARSER4.setAST(ast);
            return PHP_AST_PARSER4;
        }
        if (VERSION_PHP5.equals(phpVersion)) {
            PHP_AST_PARSER5.setAST(ast);
            return PHP_AST_PARSER5;
        }
        throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("ASTParser_1")) + phpVersion);
    }

    private static PhpAstLexer5 getLexer5(Reader reader) throws IOException {
        PhpAstLexer5 phpAstLexer5 = PHP_AST_LEXER5;
        phpAstLexer5.yyreset(reader);
        phpAstLexer5.resetCommentList();
        return phpAstLexer5;
    }

    private static PhpAstLexer4 getLexer4(Reader reader) throws IOException {
        PhpAstLexer4 phpAstLexer4 = PHP_AST_LEXER4;
        phpAstLexer4.yyreset(reader);
        phpAstLexer4.resetCommentList();
        return phpAstLexer4;
    }
}

