/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.IOperationNode;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assignment
extends Expression
implements IOperationNode {
    public static final int OP_EQUAL = 0;
    public static final int OP_PLUS_EQUAL = 1;
    public static final int OP_MINUS_EQUAL = 2;
    public static final int OP_MUL_EQUAL = 3;
    public static final int OP_DIV_EQUAL = 4;
    public static final int OP_CONCAT_EQUAL = 5;
    public static final int OP_MOD_EQUAL = 6;
    public static final int OP_AND_EQUAL = 7;
    public static final int OP_OR_EQUAL = 8;
    public static final int OP_XOR_EQUAL = 9;
    public static final int OP_SL_EQUAL = 10;
    public static final int OP_SR_EQUAL = 11;
    private VariableBase leftHandSide;
    private int operator;
    private Expression rightHandSide;
    public static final ChildPropertyDescriptor LEFT_HAND_SIDE_PROPERTY = new ChildPropertyDescriptor(Assignment.class, "variable", VariableBase.class, true, true);
    public static final SimplePropertyDescriptor OPERATOR_PROPERTY = new SimplePropertyDescriptor(Assignment.class, "operator", Integer.class, true);
    public static final ChildPropertyDescriptor RIGHT_HAND_SIDE_PROPERTY = new ChildPropertyDescriptor(Assignment.class, "value", Expression.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(3);
        properyList.add(LEFT_HAND_SIDE_PROPERTY);
        properyList.add(OPERATOR_PROPERTY);
        properyList.add(RIGHT_HAND_SIDE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public Assignment(int start, int end, AST ast, VariableBase leftHandSide, int operator, Expression rightHandSide) {
        super(start, end, ast);
        if (leftHandSide == null || rightHandSide == null || Assignment.getOperator(operator) == null) {
            throw new IllegalArgumentException();
        }
        this.setLeftHandSide(leftHandSide);
        this.setOperator(operator);
        this.setRightHandSide(rightHandSide);
    }

    public Assignment(AST ast) {
        super(ast);
    }

    public static String getOperator(int operator) {
        switch (operator) {
            case 0: {
                return "=";
            }
            case 1: {
                return "+=";
            }
            case 2: {
                return "-=";
            }
            case 3: {
                return "*=";
            }
            case 4: {
                return "/=";
            }
            case 6: {
                return "%=";
            }
            case 5: {
                return ".=";
            }
            case 7: {
                return "&=";
            }
            case 8: {
                return "|=";
            }
            case 9: {
                return "^=";
            }
            case 10: {
                return "<<=";
            }
            case 11: {
                return ">>=";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.leftHandSide.accept(visitor);
        this.rightHandSide.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.leftHandSide.traverseTopDown(visitor);
        this.rightHandSide.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.leftHandSide.traverseBottomUp(visitor);
        this.rightHandSide.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<Assignment");
        this.appendInterval(buffer);
        buffer.append(" operator='").append(Assignment.getXmlStringValue(Assignment.getOperator(this.operator))).append("'>\n");
        this.leftHandSide.toString(buffer, "\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("<Value>\n");
        this.rightHandSide.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Value>\n");
        buffer.append(tab).append("</Assignment>");
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public int getType() {
        return 3;
    }

    public Expression getValue() {
        return this.rightHandSide;
    }

    public VariableBase getVariable() {
        return this.leftHandSide;
    }

    public int getOperator() {
        return this.operator;
    }

    @Override
    public String getOperationString() {
        return Assignment.getOperator(this.getOperator());
    }

    @Override
    public String getOperationString(int op) {
        return Assignment.getOperator(op);
    }

    public void setOperator(int assignmentOperator) {
        if (Assignment.getOperator(assignmentOperator) == null) {
            throw new IllegalArgumentException("Invalid operator");
        }
        this.preValueChange(OPERATOR_PROPERTY);
        this.operator = assignmentOperator;
        this.postValueChange(OPERATOR_PROPERTY);
    }

    public VariableBase getLeftHandSide() {
        return this.leftHandSide;
    }

    public void setLeftHandSide(VariableBase leftHandSide) {
        if (leftHandSide == null) {
            throw new IllegalArgumentException();
        }
        VariableBase oldChild = this.leftHandSide;
        this.preReplaceChild(oldChild, leftHandSide, LEFT_HAND_SIDE_PROPERTY);
        this.leftHandSide = leftHandSide;
        this.postReplaceChild(oldChild, leftHandSide, LEFT_HAND_SIDE_PROPERTY);
    }

    public Expression getRightHandSide() {
        return this.rightHandSide;
    }

    public void setRightHandSide(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.rightHandSide;
        this.preReplaceChild(oldChild, expression, RIGHT_HAND_SIDE_PROPERTY);
        this.rightHandSide = expression;
        this.postReplaceChild(oldChild, expression, RIGHT_HAND_SIDE_PROPERTY);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        VariableBase left = ASTNode.copySubtree(target, this.getLeftHandSide());
        Expression right = ASTNode.copySubtree(target, this.getRightHandSide());
        Assignment result = new Assignment(this.getStart(), this.getEnd(), target, left, this.getOperator(), right);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(String apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == OPERATOR_PROPERTY) {
            if (get) {
                return this.getOperator();
            }
            this.setOperator(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == LEFT_HAND_SIDE_PROPERTY) {
            if (get) {
                return this.getLeftHandSide();
            }
            this.setLeftHandSide((VariableBase)child);
            return null;
        }
        if (property == RIGHT_HAND_SIDE_PROPERTY) {
            if (get) {
                return this.getRightHandSide();
            }
            this.setRightHandSide((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }
}

