/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Statement;

public abstract class BodyDeclaration
extends Statement {
    private int modifier;

    abstract SimplePropertyDescriptor getModifierProperty();

    public BodyDeclaration(int start, int end, AST ast, int modifier, boolean shouldComplete) {
        super(start, end, ast);
        this.setModifier(shouldComplete ? BodyDeclaration.completeModifier(modifier) : modifier);
    }

    public BodyDeclaration(int start, int end, AST ast, int modifier) {
        this(start, end, ast, modifier, false);
    }

    public BodyDeclaration(AST ast) {
        super(ast);
    }

    private static int completeModifier(int mod) {
        if (!Modifier.isPrivate(mod) && !Modifier.isProtected(mod)) {
            mod |= 1;
        }
        return mod;
    }

    public String getModifierString() {
        return Modifier.toString(this.modifier);
    }

    public int getModifier() {
        return this.modifier;
    }

    public void setModifier(int modifier) {
        if (Modifier.toString(modifier) == null) {
            throw new IllegalArgumentException("Invalid modifier");
        }
        this.preValueChange(this.getModifierProperty());
        this.modifier = modifier;
        this.postValueChange(this.getModifierProperty());
    }

    int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == this.getModifierProperty()) {
            if (get) {
                return this.getModifier();
            }
            this.setModifier(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    public static class Modifier {
        public static final int PUBLIC = 1;
        public static final int PRIVATE = 2;
        public static final int PROTECTED = 4;
        public static final int STATIC = 8;
        public static final int FINAL = 16;
        public static final int ABSTRACT = 1024;

        public static boolean isPublic(int mod) {
            return (mod & 1) != 0;
        }

        public static boolean isPrivate(int mod) {
            return (mod & 2) != 0;
        }

        public static boolean isProtected(int mod) {
            return (mod & 4) != 0;
        }

        public static boolean isStatic(int mod) {
            return (mod & 8) != 0;
        }

        public static boolean isFinal(int mod) {
            return (mod & 0x10) != 0;
        }

        public static boolean isAbstract(int mod) {
            return (mod & 0x400) != 0;
        }

        public static String toString(int mod) {
            int len;
            StringBuffer sb = new StringBuffer();
            if ((mod & 1) != 0) {
                sb.append("public ");
            }
            if ((mod & 4) != 0) {
                sb.append("protected ");
            }
            if ((mod & 2) != 0) {
                sb.append("private ");
            }
            if ((mod & 0x400) != 0) {
                sb.append("abstract ");
            }
            if ((mod & 8) != 0) {
                sb.append("static ");
            }
            if ((mod & 0x10) != 0) {
                sb.append("final ");
            }
            if ((len = sb.length()) > 0) {
                return sb.toString().substring(0, len - 1);
            }
            return "";
        }
    }
}

